"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.wait = wait;
exports.error = error;
exports.warn = warn;
exports.ready = ready;
exports.info = info;
exports.event = event;
exports.trace = trace;
exports.prefixes = void 0;
var _chalk = _interopRequireDefault(require("chalk"));
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const prefixes = {
    wait: _chalk.default.cyan('wait') + '  -',
    error: _chalk.default.red('error') + ' -',
    warn: _chalk.default.yellow('warn') + '  -',
    ready: _chalk.default.green('ready') + ' -',
    info: _chalk.default.cyan('info') + '  -',
    event: _chalk.default.magenta('event') + ' -',
    trace: _chalk.default.magenta('trace') + ' -'
};
exports.prefixes = prefixes;
function wait(...message) {
    console.log(prefixes.wait, ...message);
}
function error(...message) {
    console.error(prefixes.error, ...message);
}
function warn(...message) {
    console.warn(prefixes.warn, ...message);
}
function ready(...message) {
    console.log(prefixes.ready, ...message);
}
function info(...message) {
    console.log(prefixes.info, ...message);
}
function event(...message) {
    console.log(prefixes.event, ...message);
}
function trace(...message) {
    console.log(prefixes.trace, ...message);
}

//# sourceMappingURL=log.js.map