module.exports=(()=>{var r={64:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.AsnConvert=void 0;const n=t(528);const s=t(317);const o=t(594);const i=t(558);class AsnConvert{static serialize(r){return i.AsnSerializer.serialize(r)}static parse(r,e){return o.AsnParser.parse(r,e)}static toString(r){const e=s.BufferSourceConverter.isBufferSource(r)?s.BufferSourceConverter.toArrayBuffer(r):AsnConvert.serialize(r);const t=n.fromBER(e);if(t.offset===-1){throw new Error(`Cannot decode ASN.1 data. ${t.result.error}`)}return t.result.toString()}}e.AsnConvert=AsnConvert},98:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.defaultConverter=e.AsnNullConverter=e.AsnGeneralizedTimeConverter=e.AsnUTCTimeConverter=e.AsnCharacterStringConverter=e.AsnGeneralStringConverter=e.AsnVisibleStringConverter=e.AsnGraphicStringConverter=e.AsnIA5StringConverter=e.AsnVideotexStringConverter=e.AsnTeletexStringConverter=e.AsnPrintableStringConverter=e.AsnNumericStringConverter=e.AsnUniversalStringConverter=e.AsnBmpStringConverter=e.AsnUtf8StringConverter=e.AsnOctetStringConverter=e.AsnBooleanConverter=e.AsnObjectIdentifierConverter=e.AsnBitStringConverter=e.AsnIntegerArrayBufferConverter=e.AsnEnumeratedConverter=e.AsnIntegerConverter=e.AsnAnyConverter=void 0;const n=t(528);const s=t(139);e.AsnAnyConverter={fromASN:r=>r instanceof n.Null?null:r.valueBeforeDecode,toASN:r=>{if(r===null){return new n.Null}const e=n.fromBER(r);if(e.result.error){throw new Error(e.result.error)}return e.result}};e.AsnIntegerConverter={fromASN:r=>r.valueBlock.valueHex.byteLength>4?r.valueBlock.toString():r.valueBlock.valueDec,toASN:r=>new n.Integer({value:r})};e.AsnEnumeratedConverter={fromASN:r=>r.valueBlock.valueDec,toASN:r=>new n.Enumerated({value:r})};e.AsnIntegerArrayBufferConverter={fromASN:r=>r.valueBlock.valueHex,toASN:r=>new n.Integer({valueHex:r})};e.AsnBitStringConverter={fromASN:r=>r.valueBlock.valueHex,toASN:r=>new n.BitString({valueHex:r})};e.AsnObjectIdentifierConverter={fromASN:r=>r.valueBlock.toString(),toASN:r=>new n.ObjectIdentifier({value:r})};e.AsnBooleanConverter={fromASN:r=>r.valueBlock.value,toASN:r=>new n.Boolean({value:r})};e.AsnOctetStringConverter={fromASN:r=>r.valueBlock.valueHex,toASN:r=>new n.OctetString({valueHex:r})};function createStringConverter(r){return{fromASN:r=>r.valueBlock.value,toASN:e=>new r({value:e})}}e.AsnUtf8StringConverter=createStringConverter(n.Utf8String);e.AsnBmpStringConverter=createStringConverter(n.BmpString);e.AsnUniversalStringConverter=createStringConverter(n.UniversalString);e.AsnNumericStringConverter=createStringConverter(n.NumericString);e.AsnPrintableStringConverter=createStringConverter(n.PrintableString);e.AsnTeletexStringConverter=createStringConverter(n.TeletexString);e.AsnVideotexStringConverter=createStringConverter(n.VideotexString);e.AsnIA5StringConverter=createStringConverter(n.IA5String);e.AsnGraphicStringConverter=createStringConverter(n.GraphicString);e.AsnVisibleStringConverter=createStringConverter(n.VisibleString);e.AsnGeneralStringConverter=createStringConverter(n.GeneralString);e.AsnCharacterStringConverter=createStringConverter(n.CharacterString);e.AsnUTCTimeConverter={fromASN:r=>r.toDate(),toASN:r=>new n.UTCTime({valueDate:r})};e.AsnGeneralizedTimeConverter={fromASN:r=>r.toDate(),toASN:r=>new n.GeneralizedTime({valueDate:r})};e.AsnNullConverter={fromASN:r=>null,toASN:r=>{return new n.Null}};function defaultConverter(r){switch(r){case s.AsnPropTypes.Any:return e.AsnAnyConverter;case s.AsnPropTypes.BitString:return e.AsnBitStringConverter;case s.AsnPropTypes.BmpString:return e.AsnBmpStringConverter;case s.AsnPropTypes.Boolean:return e.AsnBooleanConverter;case s.AsnPropTypes.CharacterString:return e.AsnCharacterStringConverter;case s.AsnPropTypes.Enumerated:return e.AsnEnumeratedConverter;case s.AsnPropTypes.GeneralString:return e.AsnGeneralStringConverter;case s.AsnPropTypes.GeneralizedTime:return e.AsnGeneralizedTimeConverter;case s.AsnPropTypes.GraphicString:return e.AsnGraphicStringConverter;case s.AsnPropTypes.IA5String:return e.AsnIA5StringConverter;case s.AsnPropTypes.Integer:return e.AsnIntegerConverter;case s.AsnPropTypes.Null:return e.AsnNullConverter;case s.AsnPropTypes.NumericString:return e.AsnNumericStringConverter;case s.AsnPropTypes.ObjectIdentifier:return e.AsnObjectIdentifierConverter;case s.AsnPropTypes.OctetString:return e.AsnOctetStringConverter;case s.AsnPropTypes.PrintableString:return e.AsnPrintableStringConverter;case s.AsnPropTypes.TeletexString:return e.AsnTeletexStringConverter;case s.AsnPropTypes.UTCTime:return e.AsnUTCTimeConverter;case s.AsnPropTypes.UniversalString:return e.AsnUniversalStringConverter;case s.AsnPropTypes.Utf8String:return e.AsnUtf8StringConverter;case s.AsnPropTypes.VideotexString:return e.AsnVideotexStringConverter;case s.AsnPropTypes.VisibleString:return e.AsnVisibleStringConverter;default:return null}}e.defaultConverter=defaultConverter},667:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.AsnProp=e.AsnType=void 0;const n=t(98);const s=t(173);const o=r=>e=>{let t;if(!s.schemaStorage.has(e)){t=s.schemaStorage.createDefault(e);s.schemaStorage.set(e,t)}else{t=s.schemaStorage.get(e)}Object.assign(t,r)};e.AsnType=o;const i=r=>(e,t)=>{let o;if(!s.schemaStorage.has(e.constructor)){o=s.schemaStorage.createDefault(e.constructor);s.schemaStorage.set(e.constructor,o)}else{o=s.schemaStorage.get(e.constructor)}const i=Object.assign({},r);if(typeof i.type==="number"&&!i.converter){const s=n.defaultConverter(r.type);if(!s){throw new Error(`Cannot get default converter for property '${t}' of ${e.constructor.name}`)}i.converter=s}o.items[t]=i};e.AsnProp=i},139:(r,e)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.AsnPropTypes=e.AsnTypeTypes=void 0;var t;(function(r){r[r["Sequence"]=0]="Sequence";r[r["Set"]=1]="Set";r[r["Choice"]=2]="Choice"})(t=e.AsnTypeTypes||(e.AsnTypeTypes={}));var n;(function(r){r[r["Any"]=1]="Any";r[r["Boolean"]=2]="Boolean";r[r["OctetString"]=3]="OctetString";r[r["BitString"]=4]="BitString";r[r["Integer"]=5]="Integer";r[r["Enumerated"]=6]="Enumerated";r[r["ObjectIdentifier"]=7]="ObjectIdentifier";r[r["Utf8String"]=8]="Utf8String";r[r["BmpString"]=9]="BmpString";r[r["UniversalString"]=10]="UniversalString";r[r["NumericString"]=11]="NumericString";r[r["PrintableString"]=12]="PrintableString";r[r["TeletexString"]=13]="TeletexString";r[r["VideotexString"]=14]="VideotexString";r[r["IA5String"]=15]="IA5String";r[r["GraphicString"]=16]="GraphicString";r[r["VisibleString"]=17]="VisibleString";r[r["GeneralString"]=18]="GeneralString";r[r["CharacterString"]=19]="CharacterString";r[r["UTCTime"]=20]="UTCTime";r[r["GeneralizedTime"]=21]="GeneralizedTime";r[r["DATE"]=22]="DATE";r[r["TimeOfDay"]=23]="TimeOfDay";r[r["DateTime"]=24]="DateTime";r[r["Duration"]=25]="Duration";r[r["TIME"]=26]="TIME";r[r["Null"]=27]="Null"})(n=e.AsnPropTypes||(e.AsnPropTypes={}))},473:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});const n=t(160);n.__exportStar(t(134),e)},134:(r,e)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.AsnSchemaValidationError=void 0;class AsnSchemaValidationError extends Error{constructor(){super(...arguments);this.schemas=[]}}e.AsnSchemaValidationError=AsnSchemaValidationError},142:(r,e)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.isArrayEqual=e.isTypeOfArray=e.isConvertible=void 0;function isConvertible(r){if(r&&r.prototype){if(r.prototype.toASN&&r.prototype.fromASN){return true}else{return isConvertible(r.prototype)}}else{return!!(r&&r.toASN&&r.fromASN)}}e.isConvertible=isConvertible;function isTypeOfArray(r){var e;if(r){const t=Object.getPrototypeOf(r);if(((e=t===null||t===void 0?void 0:t.prototype)===null||e===void 0?void 0:e.constructor)===Array){return true}return isTypeOfArray(t)}return false}e.isTypeOfArray=isTypeOfArray;function isArrayEqual(r,e){if(!(r&&e)){return false}if(r.byteLength!==e.byteLength){return false}const t=new Uint8Array(r);const n=new Uint8Array(e);for(let e=0;e<r.byteLength;e++){if(t[e]!==n[e]){return false}}return true}e.isArrayEqual=isArrayEqual},870:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.AsnSerializer=e.AsnParser=e.AsnPropTypes=e.AsnTypeTypes=e.AsnType=e.AsnProp=void 0;const n=t(160);n.__exportStar(t(98),e);n.__exportStar(t(466),e);var s=t(667);Object.defineProperty(e,"AsnProp",{enumerable:true,get:function(){return s.AsnProp}});Object.defineProperty(e,"AsnType",{enumerable:true,get:function(){return s.AsnType}});var o=t(139);Object.defineProperty(e,"AsnTypeTypes",{enumerable:true,get:function(){return o.AsnTypeTypes}});Object.defineProperty(e,"AsnPropTypes",{enumerable:true,get:function(){return o.AsnPropTypes}});var i=t(594);Object.defineProperty(e,"AsnParser",{enumerable:true,get:function(){return i.AsnParser}});var a=t(558);Object.defineProperty(e,"AsnSerializer",{enumerable:true,get:function(){return a.AsnSerializer}});n.__exportStar(t(473),e);n.__exportStar(t(995),e);n.__exportStar(t(64),e)},995:(r,e)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.AsnArray=void 0;class AsnArray extends Array{constructor(r=[]){if(typeof r==="number"){super(r)}else{super();for(const e of r){this.push(e)}}}}e.AsnArray=AsnArray},594:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.AsnParser=void 0;const n=t(528);const s=t(139);const o=t(98);const i=t(473);const a=t(142);const c=t(173);class AsnParser{static parse(r,e){let t;if(r instanceof ArrayBuffer){t=r}else if(typeof Buffer!=="undefined"&&Buffer.isBuffer(r)){t=new Uint8Array(r).buffer}else if(ArrayBuffer.isView(r)||r.buffer instanceof ArrayBuffer){t=r.buffer}else{throw new TypeError("Wrong type of 'data' argument")}const s=n.fromBER(t);if(s.result.error){throw new Error(s.result.error)}const o=this.fromASN(s.result,e);return o}static fromASN(r,e){var t;try{if(a.isConvertible(e)){const t=new e;return t.fromASN(r)}const u=c.schemaStorage.get(e);c.schemaStorage.cache(e);let f=u.schema;if(r.constructor===n.Constructed&&u.type!==s.AsnTypeTypes.Choice){f=new n.Constructed({idBlock:{tagClass:3,tagNumber:r.idBlock.tagNumber},value:u.schema.valueBlock.value});for(const e in u.items){delete r[e]}}const l=n.compareSchema(r,r,f);if(!l.verified){throw new i.AsnSchemaValidationError(`Data does not match to ${e.name} ASN1 schema. ${l.result.error}`)}const h=new e;if(a.isTypeOfArray(e)){if(typeof u.itemType==="number"){const t=o.defaultConverter(u.itemType);if(!t){throw new Error(`Cannot get default converter for array item of ${e.name} ASN1 schema`)}return e.from(r.valueBlock.value,r=>t.fromASN(r))}else{return e.from(r.valueBlock.value,r=>this.fromASN(r,u.itemType))}}for(const e in u.items){if(!r[e]){continue}const o=u.items[e];if(typeof o.type==="number"||a.isConvertible(o.type)){const i=(t=o.converter)!==null&&t!==void 0?t:a.isConvertible(o.type)?new o.type:null;if(!i){throw new Error("Converter is empty")}if(o.repeated){if(o.implicit){const t=o.repeated==="sequence"?n.Sequence:n.Set;const s=new t;s.valueBlock=r[e].valueBlock;const a=n.fromBER(s.toBER(false)).result.valueBlock.value;h[e]=Array.from(a,r=>i.fromASN(r))}else{h[e]=Array.from(r[e],r=>i.fromASN(r))}}else{let t=r[e];if(o.implicit){let r;if(a.isConvertible(o.type)){r=(new o.type).toSchema("")}else{const e=s.AsnPropTypes[o.type];const t=n[e];if(!t){throw new Error(`Cannot get '${e}' class from asn1js module`)}r=new t}r.valueBlock=t.valueBlock;t=n.fromBER(r.toBER(false)).result}h[e]=i.fromASN(t)}}else{if(o.repeated){h[e]=Array.from(r[e],r=>this.fromASN(r,o.type))}else{h[e]=this.fromASN(r[e],o.type)}}}return h}catch(r){if(r instanceof i.AsnSchemaValidationError){r.schemas.push(e.name)}throw r}}}e.AsnParser=AsnParser},397:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.AsnSchemaStorage=void 0;const n=t(528);const s=t(139);const o=t(142);class AsnSchemaStorage{constructor(){this.items=new WeakMap}has(r){return this.items.has(r)}get(r){var e,t,n,s;const o=this.items.get(r);if(!o){throw new Error(`Cannot get schema for '${(s=(n=(t=(e=r)===null||e===void 0?void 0:e.prototype)===null||t===void 0?void 0:t.constructor)===null||n===void 0?void 0:n.name)!==null&&s!==void 0?s:r}' target`)}return o}cache(r){const e=this.get(r);if(!e.schema){e.schema=this.create(r,true)}}createDefault(r){const e={type:s.AsnTypeTypes.Sequence,items:{}};const t=this.findParentSchema(r);if(t){Object.assign(e,t);e.items=Object.assign({},e.items,t.items)}return e}create(r,e){const t=this.items.get(r)||this.createDefault(r);const i=[];for(const r in t.items){const a=t.items[r];const c=e?r:"";let u;if(typeof a.type==="number"){const r=s.AsnPropTypes[a.type];const e=n[r];if(!e){throw new Error(`Cannot get ASN1 class by name '${r}'`)}u=new e({name:c})}else if(o.isConvertible(a.type)){const r=new a.type;u=r.toSchema(c)}else if(a.optional){const r=this.get(a.type);if(r.type===s.AsnTypeTypes.Choice){u=new n.Any({name:c})}else{u=this.create(a.type,false);u.name=c}}else{u=new n.Any({name:c})}const f=!!a.optional||a.defaultValue!==undefined;if(a.repeated){u.name="";const r=a.repeated==="set"?n.Set:n.Sequence;u=new r({name:"",value:[new n.Repeated({name:c,value:u})]})}if(a.context!==null&&a.context!==undefined){if(a.implicit){if(typeof a.type==="number"||o.isConvertible(a.type)){const r=a.repeated?n.Constructed:n.Primitive;i.push(new r({name:c,optional:f,idBlock:{tagClass:3,tagNumber:a.context}}))}else{this.cache(a.type);const r=!!a.repeated;let e=!r?this.get(a.type).schema:u;e=e.valueBlock?e.valueBlock.value:e.value;i.push(new n.Constructed({name:!r?c:"",optional:f,idBlock:{tagClass:3,tagNumber:a.context},value:e}))}}else{i.push(new n.Constructed({optional:f,idBlock:{tagClass:3,tagNumber:a.context},value:[u]}))}}else{u.optional=f;i.push(u)}}switch(t.type){case s.AsnTypeTypes.Sequence:return new n.Sequence({value:i,name:""});case s.AsnTypeTypes.Set:return new n.Set({value:i,name:""});case s.AsnTypeTypes.Choice:return new n.Choice({value:i,name:""});default:throw new Error(`Unsupported ASN1 type in use`)}}set(r,e){this.items.set(r,e);return this}findParentSchema(r){const e=r.__proto__;if(e){const r=this.items.get(e);return r||this.findParentSchema(e)}return null}}e.AsnSchemaStorage=AsnSchemaStorage},558:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.AsnSerializer=void 0;const n=t(528);const s=t(98);const o=t(139);const i=t(142);const a=t(173);class AsnSerializer{static serialize(r){if(r instanceof n.BaseBlock){return r.toBER(false)}return this.toASN(r).toBER(false)}static toASN(r){if(r&&i.isConvertible(r.constructor)){return r.toASN()}const e=r.constructor;const t=a.schemaStorage.get(e);a.schemaStorage.cache(e);let c=[];if(t.itemType){if(typeof t.itemType==="number"){const n=s.defaultConverter(t.itemType);if(!n){throw new Error(`Cannot get default converter for array item of ${e.name} ASN1 schema`)}c=r.map(r=>n.toASN(r))}else{c=r.map(r=>this.toAsnItem({type:t.itemType},"[]",e,r))}}else{for(const s in t.items){const o=t.items[s];const a=r[s];if(a===undefined||o.defaultValue===a||typeof o.defaultValue==="object"&&typeof a==="object"&&i.isArrayEqual(this.serialize(o.defaultValue),this.serialize(a))){continue}let u=AsnSerializer.toAsnItem(o,s,e,a);if(typeof o.context==="number"){if(o.implicit){if(!o.repeated&&(typeof o.type==="number"||i.isConvertible(o.type))){const r={};r.valueHex=u instanceof n.Null?u.valueBeforeDecode:u.valueBlock.toBER();c.push(new n.Primitive(Object.assign({optional:o.optional,idBlock:{tagClass:3,tagNumber:o.context}},r)))}else{c.push(new n.Constructed({optional:o.optional,idBlock:{tagClass:3,tagNumber:o.context},value:u.valueBlock.value}))}}else{c.push(new n.Constructed({optional:o.optional,idBlock:{tagClass:3,tagNumber:o.context},value:[u]}))}}else if(o.repeated){c=c.concat(u)}else{c.push(u)}}}let u;switch(t.type){case o.AsnTypeTypes.Sequence:u=new n.Sequence({value:c});break;case o.AsnTypeTypes.Set:u=new n.Set({value:c});break;case o.AsnTypeTypes.Choice:if(!c[0]){throw new Error(`Schema '${e.name}' has wrong data. Choice cannot be empty.`)}u=c[0];break}return u}static toAsnItem(r,e,t,s){let i;if(typeof r.type==="number"){const a=r.converter;if(!a){throw new Error(`Property '${e}' doesn't have converter for type ${o.AsnPropTypes[r.type]} in schema '${t.name}'`)}if(r.repeated){const e=Array.from(s,r=>a.toASN(r));const t=r.repeated==="sequence"?n.Sequence:n.Set;i=new t({value:e})}else{i=a.toASN(s)}}else{if(r.repeated){const e=Array.from(s,r=>this.toASN(r));const t=r.repeated==="sequence"?n.Sequence:n.Set;i=new t({value:e})}else{i=this.toASN(s)}}return i}}e.AsnSerializer=AsnSerializer},173:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.schemaStorage=void 0;const n=t(397);e.schemaStorage=new n.AsnSchemaStorage},799:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.BitString=void 0;const n=t(528);const s=t(317);class BitString{constructor(r,e=0){this.unusedBits=0;this.value=new ArrayBuffer(0);if(r){if(typeof r==="number"){this.fromNumber(r)}else if(s.BufferSourceConverter.isBufferSource(r)){this.unusedBits=e;this.value=s.BufferSourceConverter.toArrayBuffer(r)}else{throw TypeError("Unsupported type of 'params' argument for BitString")}}}fromASN(r){if(!(r instanceof n.BitString)){throw new TypeError("Argument 'asn' is not instance of ASN.1 BitString")}this.unusedBits=r.valueBlock.unusedBits;this.value=r.valueBlock.valueHex;return this}toASN(){return new n.BitString({unusedBits:this.unusedBits,valueHex:this.value})}toSchema(r){return new n.BitString({name:r})}toNumber(){let r="";const e=new Uint8Array(this.value);for(const t of e){r+=t.toString(2).padStart(8,"0")}r=r.split("").reverse().join("");if(this.unusedBits){r=r.slice(this.unusedBits).padStart(this.unusedBits,"0")}return parseInt(r,2)}fromNumber(r){let e=r.toString(2);const t=e.length+7>>3;this.unusedBits=(t<<3)-e.length;const n=new Uint8Array(t);e=e.padStart(t<<3,"0").split("").reverse().join("");let s=0;while(s<t){n[s]=parseInt(e.slice(s<<3,(s<<3)+8),2);s++}this.value=n.buffer}}e.BitString=BitString},466:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});const n=t(160);n.__exportStar(t(799),e);n.__exportStar(t(189),e)},189:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.OctetString=void 0;const n=t(528);const s=t(317);class OctetString{constructor(r){if(typeof r==="number"){this.buffer=new ArrayBuffer(r)}else{if(s.BufferSourceConverter.isBufferSource(r)){this.buffer=s.BufferSourceConverter.toArrayBuffer(r)}else if(Array.isArray(r)){this.buffer=new Uint8Array(r)}else{this.buffer=new ArrayBuffer(0)}}}get byteLength(){return this.buffer.byteLength}get byteOffset(){return 0}fromASN(r){if(!(r instanceof n.OctetString)){throw new TypeError("Argument 'asn' is not instance of ASN.1 OctetString")}this.buffer=r.valueBlock.valueHex;return this}toASN(){return new n.OctetString({valueHex:this.buffer})}toSchema(r){return new n.OctetString({name:r})}}e.OctetString=OctetString},160:(r,e,t)=>{"use strict";t.r(e);t.d(e,{__extends:()=>__extends,__assign:()=>s,__rest:()=>__rest,__decorate:()=>__decorate,__param:()=>__param,__metadata:()=>__metadata,__awaiter:()=>__awaiter,__generator:()=>__generator,__createBinding:()=>o,__exportStar:()=>__exportStar,__values:()=>__values,__read:()=>__read,__spread:()=>__spread,__spreadArrays:()=>__spreadArrays,__spreadArray:()=>__spreadArray,__await:()=>__await,__asyncGenerator:()=>__asyncGenerator,__asyncDelegator:()=>__asyncDelegator,__asyncValues:()=>__asyncValues,__makeTemplateObject:()=>__makeTemplateObject,__importStar:()=>__importStar,__importDefault:()=>__importDefault,__classPrivateFieldGet:()=>__classPrivateFieldGet,__classPrivateFieldSet:()=>__classPrivateFieldSet});var n=function(r,e){n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,e){r.__proto__=e}||function(r,e){for(var t in e)if(Object.prototype.hasOwnProperty.call(e,t))r[t]=e[t]};return n(r,e)};function __extends(r,e){if(typeof e!=="function"&&e!==null)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");n(r,e);function __(){this.constructor=r}r.prototype=e===null?Object.create(e):(__.prototype=e.prototype,new __)}var s=function(){s=Object.assign||function __assign(r){for(var e,t=1,n=arguments.length;t<n;t++){e=arguments[t];for(var s in e)if(Object.prototype.hasOwnProperty.call(e,s))r[s]=e[s]}return r};return s.apply(this,arguments)};function __rest(r,e){var t={};for(var n in r)if(Object.prototype.hasOwnProperty.call(r,n)&&e.indexOf(n)<0)t[n]=r[n];if(r!=null&&typeof Object.getOwnPropertySymbols==="function")for(var s=0,n=Object.getOwnPropertySymbols(r);s<n.length;s++){if(e.indexOf(n[s])<0&&Object.prototype.propertyIsEnumerable.call(r,n[s]))t[n[s]]=r[n[s]]}return t}function __decorate(r,e,t,n){var s=arguments.length,o=s<3?e:n===null?n=Object.getOwnPropertyDescriptor(e,t):n,i;if(typeof Reflect==="object"&&typeof Reflect.decorate==="function")o=Reflect.decorate(r,e,t,n);else for(var a=r.length-1;a>=0;a--)if(i=r[a])o=(s<3?i(o):s>3?i(e,t,o):i(e,t))||o;return s>3&&o&&Object.defineProperty(e,t,o),o}function __param(r,e){return function(t,n){e(t,n,r)}}function __metadata(r,e){if(typeof Reflect==="object"&&typeof Reflect.metadata==="function")return Reflect.metadata(r,e)}function __awaiter(r,e,t,n){function adopt(r){return r instanceof t?r:new t(function(e){e(r)})}return new(t||(t=Promise))(function(t,s){function fulfilled(r){try{step(n.next(r))}catch(r){s(r)}}function rejected(r){try{step(n["throw"](r))}catch(r){s(r)}}function step(r){r.done?t(r.value):adopt(r.value).then(fulfilled,rejected)}step((n=n.apply(r,e||[])).next())})}function __generator(r,e){var t={label:0,sent:function(){if(o[0]&1)throw o[1];return o[1]},trys:[],ops:[]},n,s,o,i;return i={next:verb(0),throw:verb(1),return:verb(2)},typeof Symbol==="function"&&(i[Symbol.iterator]=function(){return this}),i;function verb(r){return function(e){return step([r,e])}}function step(i){if(n)throw new TypeError("Generator is already executing.");while(t)try{if(n=1,s&&(o=i[0]&2?s["return"]:i[0]?s["throw"]||((o=s["return"])&&o.call(s),0):s.next)&&!(o=o.call(s,i[1])).done)return o;if(s=0,o)i=[i[0]&2,o.value];switch(i[0]){case 0:case 1:o=i;break;case 4:t.label++;return{value:i[1],done:false};case 5:t.label++;s=i[1];i=[0];continue;case 7:i=t.ops.pop();t.trys.pop();continue;default:if(!(o=t.trys,o=o.length>0&&o[o.length-1])&&(i[0]===6||i[0]===2)){t=0;continue}if(i[0]===3&&(!o||i[1]>o[0]&&i[1]<o[3])){t.label=i[1];break}if(i[0]===6&&t.label<o[1]){t.label=o[1];o=i;break}if(o&&t.label<o[2]){t.label=o[2];t.ops.push(i);break}if(o[2])t.ops.pop();t.trys.pop();continue}i=e.call(r,t)}catch(r){i=[6,r];s=0}finally{n=o=0}if(i[0]&5)throw i[1];return{value:i[0]?i[1]:void 0,done:true}}}var o=Object.create?function(r,e,t,n){if(n===undefined)n=t;Object.defineProperty(r,n,{enumerable:true,get:function(){return e[t]}})}:function(r,e,t,n){if(n===undefined)n=t;r[n]=e[t]};function __exportStar(r,e){for(var t in r)if(t!=="default"&&!Object.prototype.hasOwnProperty.call(e,t))o(e,r,t)}function __values(r){var e=typeof Symbol==="function"&&Symbol.iterator,t=e&&r[e],n=0;if(t)return t.call(r);if(r&&typeof r.length==="number")return{next:function(){if(r&&n>=r.length)r=void 0;return{value:r&&r[n++],done:!r}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function __read(r,e){var t=typeof Symbol==="function"&&r[Symbol.iterator];if(!t)return r;var n=t.call(r),s,o=[],i;try{while((e===void 0||e-- >0)&&!(s=n.next()).done)o.push(s.value)}catch(r){i={error:r}}finally{try{if(s&&!s.done&&(t=n["return"]))t.call(n)}finally{if(i)throw i.error}}return o}function __spread(){for(var r=[],e=0;e<arguments.length;e++)r=r.concat(__read(arguments[e]));return r}function __spreadArrays(){for(var r=0,e=0,t=arguments.length;e<t;e++)r+=arguments[e].length;for(var n=Array(r),s=0,e=0;e<t;e++)for(var o=arguments[e],i=0,a=o.length;i<a;i++,s++)n[s]=o[i];return n}function __spreadArray(r,e,t){if(t||arguments.length===2)for(var n=0,s=e.length,o;n<s;n++){if(o||!(n in e)){if(!o)o=Array.prototype.slice.call(e,0,n);o[n]=e[n]}}return r.concat(o||Array.prototype.slice.call(e))}function __await(r){return this instanceof __await?(this.v=r,this):new __await(r)}function __asyncGenerator(r,e,t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var n=t.apply(r,e||[]),s,o=[];return s={},verb("next"),verb("throw"),verb("return"),s[Symbol.asyncIterator]=function(){return this},s;function verb(r){if(n[r])s[r]=function(e){return new Promise(function(t,n){o.push([r,e,t,n])>1||resume(r,e)})}}function resume(r,e){try{step(n[r](e))}catch(r){settle(o[0][3],r)}}function step(r){r.value instanceof __await?Promise.resolve(r.value.v).then(fulfill,reject):settle(o[0][2],r)}function fulfill(r){resume("next",r)}function reject(r){resume("throw",r)}function settle(r,e){if(r(e),o.shift(),o.length)resume(o[0][0],o[0][1])}}function __asyncDelegator(r){var e,t;return e={},verb("next"),verb("throw",function(r){throw r}),verb("return"),e[Symbol.iterator]=function(){return this},e;function verb(n,s){e[n]=r[n]?function(e){return(t=!t)?{value:__await(r[n](e)),done:n==="return"}:s?s(e):e}:s}}function __asyncValues(r){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e=r[Symbol.asyncIterator],t;return e?e.call(r):(r=typeof __values==="function"?__values(r):r[Symbol.iterator](),t={},verb("next"),verb("throw"),verb("return"),t[Symbol.asyncIterator]=function(){return this},t);function verb(e){t[e]=r[e]&&function(t){return new Promise(function(n,s){t=r[e](t),settle(n,s,t.done,t.value)})}}function settle(r,e,t,n){Promise.resolve(n).then(function(e){r({value:e,done:t})},e)}}function __makeTemplateObject(r,e){if(Object.defineProperty){Object.defineProperty(r,"raw",{value:e})}else{r.raw=e}return r}var i=Object.create?function(r,e){Object.defineProperty(r,"default",{enumerable:true,value:e})}:function(r,e){r["default"]=e};function __importStar(r){if(r&&r.__esModule)return r;var e={};if(r!=null)for(var t in r)if(t!=="default"&&Object.prototype.hasOwnProperty.call(r,t))o(e,r,t);i(e,r);return e}function __importDefault(r){return r&&r.__esModule?r:{default:r}}function __classPrivateFieldGet(r,e,t,n){if(t==="a"&&!n)throw new TypeError("Private accessor was defined without a getter");if(typeof e==="function"?r!==e||!n:!e.has(r))throw new TypeError("Cannot read private member from an object whose class did not declare it");return t==="m"?n:t==="a"?n.call(r):n?n.value:e.get(r)}function __classPrivateFieldSet(r,e,t,n,s){if(n==="m")throw new TypeError("Private method is not writable");if(n==="a"&&!s)throw new TypeError("Private accessor was defined without a setter");if(typeof e==="function"?r!==e||!s:!e.has(r))throw new TypeError("Cannot write private member to an object whose class did not declare it");return n==="a"?s.call(r,t):s?s.value=t:e.set(r,t),t}},895:(r,e)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});class JsonError extends Error{constructor(r,e){super(e?`${r}. See the inner exception for more details.`:r);this.message=r;this.innerError=e}}class TransformError extends JsonError{constructor(r,e,t){super(e,t);this.schema=r}}class ParserError extends TransformError{constructor(r,e,t){super(r,`JSON doesn't match to '${r.target.name}' schema. ${e}`,t)}}class ValidationError extends JsonError{}class SerializerError extends JsonError{constructor(r,e,t){super(`Cannot serialize by '${r}' schema. ${e}`,t);this.schemaName=r}}class KeyError extends ParserError{constructor(r,e,t={}){super(r,"Some keys doesn't match to schema");this.keys=e;this.errors=t}}(function(r){r[r["Any"]=0]="Any";r[r["Boolean"]=1]="Boolean";r[r["Number"]=2]="Number";r[r["String"]=3]="String"})(e.JsonPropTypes||(e.JsonPropTypes={}));function checkType(r,t){switch(t){case e.JsonPropTypes.Boolean:return typeof r==="boolean";case e.JsonPropTypes.Number:return typeof r==="number";case e.JsonPropTypes.String:return typeof r==="string"}return true}function throwIfTypeIsWrong(r,t){if(!checkType(r,t)){throw new TypeError(`Value must be ${e.JsonPropTypes[t]}`)}}function isConvertible(r){if(r&&r.prototype){if(r.prototype.toJSON&&r.prototype.fromJSON){return true}else{return isConvertible(r.prototype)}}else{return!!(r&&r.toJSON&&r.fromJSON)}}class JsonSchemaStorage{constructor(){this.items=new Map}has(r){return this.items.has(r)||!!this.findParentSchema(r)}get(r){const e=this.items.get(r)||this.findParentSchema(r);if(!e){throw new Error("Cannot get schema for current target")}return e}create(r){const e={names:{}};const t=this.findParentSchema(r);if(t){Object.assign(e,t);e.names={};for(const r in t.names){e.names[r]=Object.assign({},t.names[r])}}e.target=r;return e}set(r,e){this.items.set(r,e);return this}findParentSchema(r){const e=r.__proto__;if(e){const r=this.items.get(e);return r||this.findParentSchema(e)}return null}}const t="default";const n=new JsonSchemaStorage;class PatternValidation{constructor(r){this.pattern=new RegExp(r)}validate(r){const e=new RegExp(this.pattern.source,this.pattern.flags);if(typeof r!=="string"){throw new ValidationError("Incoming value must be string")}if(!e.exec(r)){throw new ValidationError(`Value doesn't match to pattern '${e.toString()}'`)}}}class InclusiveValidation{constructor(r=Number.MIN_VALUE,e=Number.MAX_VALUE){this.min=r;this.max=e}validate(r){throwIfTypeIsWrong(r,e.JsonPropTypes.Number);if(!(this.min<=r&&r<=this.max)){const r=this.min===Number.MIN_VALUE?"MIN":this.min;const e=this.max===Number.MAX_VALUE?"MAX":this.max;throw new ValidationError(`Value doesn't match to diapason [${r},${e}]`)}}}class ExclusiveValidation{constructor(r=Number.MIN_VALUE,e=Number.MAX_VALUE){this.min=r;this.max=e}validate(r){throwIfTypeIsWrong(r,e.JsonPropTypes.Number);if(!(this.min<r&&r<this.max)){const r=this.min===Number.MIN_VALUE?"MIN":this.min;const e=this.max===Number.MAX_VALUE?"MAX":this.max;throw new ValidationError(`Value doesn't match to diapason (${r},${e})`)}}}class LengthValidation{constructor(r,e,t){this.length=r;this.minLength=e;this.maxLength=t}validate(r){if(this.length!==undefined){if(r.length!==this.length){throw new ValidationError(`Value length must be exactly ${this.length}.`)}return}if(this.minLength!==undefined){if(r.length<this.minLength){throw new ValidationError(`Value length must be more than ${this.minLength}.`)}}if(this.maxLength!==undefined){if(r.length>this.maxLength){throw new ValidationError(`Value length must be less than ${this.maxLength}.`)}}}}class EnumerationValidation{constructor(r){this.enumeration=r}validate(r){throwIfTypeIsWrong(r,e.JsonPropTypes.String);if(!this.enumeration.includes(r)){throw new ValidationError(`Value must be one of ${this.enumeration.map(r=>`'${r}'`).join(", ")}`)}}}class JsonTransform{static checkValues(r,e){const t=Array.isArray(r)?r:[r];for(const n of t){for(const t of e.validations){if(t instanceof LengthValidation&&e.repeated){t.validate(r)}else{t.validate(n)}}}}static checkTypes(r,e){if(e.repeated&&!Array.isArray(r)){throw new TypeError("Value must be Array")}if(typeof e.type==="number"){const t=Array.isArray(r)?r:[r];for(const r of t){throwIfTypeIsWrong(r,e.type)}}}static getSchemaByName(r,e=t){return{...r.names[t],...r.names[e]}}}class JsonSerializer extends JsonTransform{static serialize(r,e,t,n){const s=this.toJSON(r,e);return JSON.stringify(s,t,n)}static toJSON(r,e={}){let s;let o=e.targetSchema;const i=e.schemaName||t;if(isConvertible(r)){return r.toJSON()}if(Array.isArray(r)){s=[];for(const t of r){s.push(this.toJSON(t,e))}}else if(typeof r==="object"){if(o&&!n.has(o)){throw new JsonError("Cannot get schema for `targetSchema` param")}o=o||r.constructor;if(n.has(o)){const e=n.get(o);s={};const t=this.getSchemaByName(e,i);for(const n in t){try{const a=t[n];const c=r[n];let u;if(a.optional&&c===undefined||a.defaultValue!==undefined&&c===a.defaultValue){continue}if(!a.optional&&c===undefined){throw new SerializerError(o.name,`Property '${n}' is required.`)}if(typeof a.type==="number"){if(a.converter){if(a.repeated){u=c.map(e=>a.converter.toJSON(e,r))}else{u=a.converter.toJSON(c,r)}}else{u=c}}else{if(a.repeated){u=c.map(r=>this.toJSON(r,{schemaName:i}))}else{u=this.toJSON(c,{schemaName:i})}}this.checkTypes(u,a);this.checkValues(u,a);s[a.name||n]=u}catch(r){if(r instanceof SerializerError){throw r}else{throw new SerializerError(e.target.name,`Property '${n}' is wrong. ${r.message}`,r)}}}}else{s={};for(const e in r){s[e]=this.toJSON(r[e],{schemaName:i})}}}else{s=r}return s}}class JsonParser extends JsonTransform{static parse(r,e){const t=JSON.parse(r);return this.fromJSON(t,e)}static fromJSON(r,e){const s=e.targetSchema;const o=e.schemaName||t;const i=new s;if(isConvertible(i)){return i.fromJSON(r)}const a=n.get(s);const c=this.getSchemaByName(a,o);const u={};if(e.strictProperty&&!Array.isArray(r)){JsonParser.checkStrictProperty(r,c,a)}for(const t in c){try{const n=c[t];const s=n.name||t;const f=r[s];if(f===undefined&&(n.optional||n.defaultValue!==undefined)){continue}if(!n.optional&&f===undefined){throw new ParserError(a,`Property '${s}' is required.`)}this.checkTypes(f,n);this.checkValues(f,n);if(typeof n.type==="number"){if(n.converter){if(n.repeated){i[t]=f.map(r=>n.converter.fromJSON(r,i))}else{i[t]=n.converter.fromJSON(f,i)}}else{i[t]=f}}else{const r={...e,targetSchema:n.type,schemaName:o};if(n.repeated){i[t]=f.map(e=>this.fromJSON(e,r))}else{i[t]=this.fromJSON(f,r)}}}catch(r){if(!(r instanceof ParserError)){r=new ParserError(a,`Property '${t}' is wrong. ${r.message}`,r)}if(e.strictAllKeys){u[t]=r}else{throw r}}}const f=Object.keys(u);if(f.length){throw new KeyError(a,f,u)}return i}static checkStrictProperty(r,e,t){const n=Object.keys(r);const s=Object.keys(e);const o=[];for(const r of n){if(s.indexOf(r)===-1){o.push(r)}}if(o.length){throw new KeyError(t,o)}}}function getValidations(r){const t=[];if(r.pattern){t.push(new PatternValidation(r.pattern))}if(r.type===e.JsonPropTypes.Number||r.type===e.JsonPropTypes.Any){if(r.minInclusive!==undefined||r.maxInclusive!==undefined){t.push(new InclusiveValidation(r.minInclusive,r.maxInclusive))}if(r.minExclusive!==undefined||r.maxExclusive!==undefined){t.push(new ExclusiveValidation(r.minExclusive,r.maxExclusive))}if(r.enumeration!==undefined){t.push(new EnumerationValidation(r.enumeration))}}if(r.type===e.JsonPropTypes.String||r.repeated||r.type===e.JsonPropTypes.Any){if(r.length!==undefined||r.minLength!==undefined||r.maxLength!==undefined){t.push(new LengthValidation(r.length,r.minLength,r.maxLength))}}return t}const s=(r={})=>(s,o)=>{const i=`Cannot set type for ${o} property of ${s.constructor.name} schema`;let a;if(!n.has(s.constructor)){a=n.create(s.constructor);n.set(s.constructor,a)}else{a=n.get(s.constructor);if(a.target!==s.constructor){a=n.create(s.constructor);n.set(s.constructor,a)}}const c={type:e.JsonPropTypes.Any,validations:[]};const u=Object.assign(c,r);u.validations=getValidations(u);if(typeof u.type!=="number"){if(!n.has(u.type)&&!isConvertible(u.type)){throw new Error(`${i}. Assigning type doesn't have schema.`)}}let f;if(Array.isArray(r.schema)){f=r.schema}else{f=[r.schema||t]}for(const r of f){if(!a.names[r]){a.names[r]={}}const e=a.names[r];e[o]=u}};e.JsonError=JsonError;e.JsonParser=JsonParser;e.JsonProp=s;e.JsonSerializer=JsonSerializer;e.KeyError=KeyError;e.ParserError=ParserError;e.SerializerError=SerializerError;e.TransformError=TransformError;e.ValidationError=ValidationError},25:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});var n=t(389);var s=t(417);var o=t(765);var i=t(950);var a=t(895);var c=t(317);var u=t(870);function _interopDefaultLegacy(r){return r&&typeof r==="object"&&"default"in r?r:{default:r}}function _interopNamespace(r){if(r&&r.__esModule)return r;var e=Object.create(null);if(r){Object.keys(r).forEach(function(t){if(t!=="default"){var n=Object.getOwnPropertyDescriptor(r,t);Object.defineProperty(e,t,n.get?n:{enumerable:true,get:function(){return r[t]}})}})}e["default"]=r;return Object.freeze(e)}var f=_interopNamespace(n);var l=_interopDefaultLegacy(s);var h=_interopNamespace(s);var y=_interopNamespace(o);const p={fromJSON:r=>Buffer.from(c.Convert.FromBase64Url(r)),toJSON:r=>c.Convert.ToBase64Url(r)};class CryptoKey extends f.CryptoKey{constructor(){super(...arguments);this.data=Buffer.alloc(0);this.algorithm={name:""};this.extractable=false;this.type="secret";this.usages=[];this.kty="oct";this.alg=""}}i.__decorate([a.JsonProp({name:"ext",type:a.JsonPropTypes.Boolean,optional:true})],CryptoKey.prototype,"extractable",void 0);i.__decorate([a.JsonProp({name:"key_ops",type:a.JsonPropTypes.String,repeated:true,optional:true})],CryptoKey.prototype,"usages",void 0);i.__decorate([a.JsonProp({type:a.JsonPropTypes.String})],CryptoKey.prototype,"kty",void 0);i.__decorate([a.JsonProp({type:a.JsonPropTypes.String})],CryptoKey.prototype,"alg",void 0);class SymmetricKey extends CryptoKey{constructor(){super(...arguments);this.kty="oct";this.type="secret"}}class AsymmetricKey extends CryptoKey{}class AesCryptoKey extends SymmetricKey{get alg(){switch(this.algorithm.name.toUpperCase()){case"AES-CBC":return`A${this.algorithm.length}CBC`;case"AES-CTR":return`A${this.algorithm.length}CTR`;case"AES-GCM":return`A${this.algorithm.length}GCM`;case"AES-KW":return`A${this.algorithm.length}KW`;case"AES-CMAC":return`A${this.algorithm.length}CMAC`;case"AES-ECB":return`A${this.algorithm.length}ECB`;default:throw new f.AlgorithmError("Unsupported algorithm name")}}set alg(r){}}i.__decorate([a.JsonProp({name:"k",converter:p})],AesCryptoKey.prototype,"data",void 0);const d=new WeakMap;function getCryptoKey(r){const e=d.get(r);if(!e){throw new f.OperationError("Cannot get CryptoKey from secure storage")}return e}function setCryptoKey(r){const e=f.CryptoKey.create(r.algorithm,r.type,r.extractable,r.usages);Object.freeze(e);d.set(e,r);return e}class AesCrypto{static async generateKey(r,e,t){const n=new AesCryptoKey;n.algorithm=r;n.extractable=e;n.usages=t;n.data=l["default"].randomBytes(r.length>>3);return n}static async exportKey(r,e){if(!(e instanceof AesCryptoKey)){throw new Error("key: Is not AesCryptoKey")}switch(r.toLowerCase()){case"jwk":return a.JsonSerializer.toJSON(e);case"raw":return new Uint8Array(e.data).buffer;default:throw new f.OperationError("format: Must be 'jwk' or 'raw'")}}static async importKey(r,e,t,n,s){let o;switch(r.toLowerCase()){case"jwk":o=a.JsonParser.fromJSON(e,{targetSchema:AesCryptoKey});break;case"raw":o=new AesCryptoKey;o.data=Buffer.from(e);break;default:throw new f.OperationError("format: Must be 'jwk' or 'raw'")}o.algorithm=t;o.algorithm.length=o.data.length<<3;o.extractable=n;o.usages=s;switch(o.algorithm.length){case 128:case 192:case 256:break;default:throw new f.OperationError("keyData: Is wrong key length")}return o}static async encrypt(r,e,t){switch(r.name.toUpperCase()){case"AES-CBC":return this.encryptAesCBC(r,e,Buffer.from(t));case"AES-CTR":return this.encryptAesCTR(r,e,Buffer.from(t));case"AES-GCM":return this.encryptAesGCM(r,e,Buffer.from(t));case"AES-KW":return this.encryptAesKW(r,e,Buffer.from(t));case"AES-ECB":return this.encryptAesECB(r,e,Buffer.from(t));default:throw new f.OperationError("algorithm: Is not recognized")}}static async decrypt(r,e,t){if(!(e instanceof AesCryptoKey)){throw new Error("key: Is not AesCryptoKey")}switch(r.name.toUpperCase()){case"AES-CBC":return this.decryptAesCBC(r,e,Buffer.from(t));case"AES-CTR":return this.decryptAesCTR(r,e,Buffer.from(t));case"AES-GCM":return this.decryptAesGCM(r,e,Buffer.from(t));case"AES-KW":return this.decryptAesKW(r,e,Buffer.from(t));case"AES-ECB":return this.decryptAesECB(r,e,Buffer.from(t));default:throw new f.OperationError("algorithm: Is not recognized")}}static async encryptAesCBC(r,e,t){const n=l["default"].createCipheriv(`aes-${e.algorithm.length}-cbc`,e.data,new Uint8Array(r.iv));let s=n.update(t);s=Buffer.concat([s,n.final()]);const o=new Uint8Array(s).buffer;return o}static async decryptAesCBC(r,e,t){const n=l["default"].createDecipheriv(`aes-${e.algorithm.length}-cbc`,e.data,new Uint8Array(r.iv));let s=n.update(t);s=Buffer.concat([s,n.final()]);return new Uint8Array(s).buffer}static async encryptAesCTR(r,e,t){const n=l["default"].createCipheriv(`aes-${e.algorithm.length}-ctr`,e.data,Buffer.from(r.counter));let s=n.update(t);s=Buffer.concat([s,n.final()]);const o=new Uint8Array(s).buffer;return o}static async decryptAesCTR(r,e,t){const n=l["default"].createDecipheriv(`aes-${e.algorithm.length}-ctr`,e.data,new Uint8Array(r.counter));let s=n.update(t);s=Buffer.concat([s,n.final()]);return new Uint8Array(s).buffer}static async encryptAesGCM(r,e,t){const n=l["default"].createCipheriv(`aes-${e.algorithm.length}-gcm`,e.data,Buffer.from(r.iv),{authTagLength:(r.tagLength||128)>>3});if(r.additionalData){n.setAAD(Buffer.from(r.additionalData))}let s=n.update(t);s=Buffer.concat([s,n.final(),n.getAuthTag()]);const o=new Uint8Array(s).buffer;return o}static async decryptAesGCM(r,e,t){const n=l["default"].createDecipheriv(`aes-${e.algorithm.length}-gcm`,e.data,new Uint8Array(r.iv));const s=(r.tagLength||128)>>3;const o=t.slice(0,t.length-s);const i=t.slice(t.length-s);if(r.additionalData){n.setAAD(Buffer.from(r.additionalData))}n.setAuthTag(i);let a=n.update(o);a=Buffer.concat([a,n.final()]);return new Uint8Array(a).buffer}static async encryptAesKW(r,e,t){const n=l["default"].createCipheriv(`id-aes${e.algorithm.length}-wrap`,e.data,this.AES_KW_IV);let s=n.update(t);s=Buffer.concat([s,n.final()]);return new Uint8Array(s).buffer}static async decryptAesKW(r,e,t){const n=l["default"].createDecipheriv(`id-aes${e.algorithm.length}-wrap`,e.data,this.AES_KW_IV);let s=n.update(t);s=Buffer.concat([s,n.final()]);return new Uint8Array(s).buffer}static async encryptAesECB(r,e,t){const n=l["default"].createCipheriv(`aes-${e.algorithm.length}-ecb`,e.data,new Uint8Array(0));let s=n.update(t);s=Buffer.concat([s,n.final()]);const o=new Uint8Array(s).buffer;return o}static async decryptAesECB(r,e,t){const n=l["default"].createDecipheriv(`aes-${e.algorithm.length}-ecb`,e.data,new Uint8Array(0));let s=n.update(t);s=Buffer.concat([s,n.final()]);return new Uint8Array(s).buffer}}AesCrypto.AES_KW_IV=Buffer.from("A6A6A6A6A6A6A6A6","hex");class AesCbcProvider extends f.AesCbcProvider{async onGenerateKey(r,e,t){const n=await AesCrypto.generateKey({name:this.name,length:r.length},e,t);return setCryptoKey(n)}async onEncrypt(r,e,t){return AesCrypto.encrypt(r,getCryptoKey(e),new Uint8Array(t))}async onDecrypt(r,e,t){return AesCrypto.decrypt(r,getCryptoKey(e),new Uint8Array(t))}async onExportKey(r,e){return AesCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await AesCrypto.importKey(r,e,{name:t.name},n,s);return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);if(!(getCryptoKey(r)instanceof AesCryptoKey)){throw new TypeError("key: Is not a AesCryptoKey")}}}const g=Buffer.from([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]);const A=Buffer.from([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135]);const w=16;function bitShiftLeft(r){const e=Buffer.alloc(r.length);const t=r.length-1;for(let n=0;n<t;n++){e[n]=r[n]<<1;if(r[n+1]&128){e[n]+=1}}e[t]=r[t]<<1;return e}function xor(r,e){const t=Math.min(r.length,e.length);const n=Buffer.alloc(t);for(let s=0;s<t;s++){n[s]=r[s]^e[s]}return n}function aes(r,e){const t=h.createCipheriv(`aes${r.length<<3}`,r,g);const n=t.update(e);t.final();return n}function getMessageBlock(r,e){const t=Buffer.alloc(w);const n=e*w;const s=n+w;r.copy(t,0,n,s);return t}function getPaddedMessageBlock(r,e){const t=Buffer.alloc(w);const n=e*w;const s=r.length;t.fill(0);r.copy(t,0,n,s);t[s-n]=128;return t}function generateSubkeys(r){const e=aes(r,g);let t=bitShiftLeft(e);if(e[0]&128){t=xor(t,A)}let n=bitShiftLeft(t);if(t[0]&128){n=xor(n,A)}return{subkey1:t,subkey2:n}}function aesCmac(r,e){const t=generateSubkeys(r);let n=Math.ceil(e.length/w);let s;let o;if(n===0){n=1;s=false}else{s=e.length%w===0}const i=n-1;if(s){o=xor(getMessageBlock(e,i),t.subkey1)}else{o=xor(getPaddedMessageBlock(e,i),t.subkey2)}let a=g;let c;for(let t=0;t<i;t++){c=xor(a,getMessageBlock(e,t));a=aes(r,c)}c=xor(o,a);return aes(r,c)}class AesCmacProvider extends f.AesCmacProvider{async onGenerateKey(r,e,t){const n=await AesCrypto.generateKey({name:this.name,length:r.length},e,t);return setCryptoKey(n)}async onSign(r,e,t){const n=aesCmac(getCryptoKey(e).data,Buffer.from(t));return new Uint8Array(n).buffer}async onVerify(r,e,t,n){const s=await this.sign(r,e,n);return Buffer.from(t).compare(Buffer.from(s))===0}async onExportKey(r,e){return AesCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await AesCrypto.importKey(r,e,{name:t.name},n,s);return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);if(!(getCryptoKey(r)instanceof AesCryptoKey)){throw new TypeError("key: Is not a AesCryptoKey")}}}class AesCtrProvider extends f.AesCtrProvider{async onGenerateKey(r,e,t){const n=await AesCrypto.generateKey({name:this.name,length:r.length},e,t);return setCryptoKey(n)}async onEncrypt(r,e,t){return AesCrypto.encrypt(r,getCryptoKey(e),new Uint8Array(t))}async onDecrypt(r,e,t){return AesCrypto.decrypt(r,getCryptoKey(e),new Uint8Array(t))}async onExportKey(r,e){return AesCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await AesCrypto.importKey(r,e,{name:t.name},n,s);return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);if(!(getCryptoKey(r)instanceof AesCryptoKey)){throw new TypeError("key: Is not a AesCryptoKey")}}}class AesGcmProvider extends f.AesGcmProvider{async onGenerateKey(r,e,t){const n=await AesCrypto.generateKey({name:this.name,length:r.length},e,t);return setCryptoKey(n)}async onEncrypt(r,e,t){return AesCrypto.encrypt(r,getCryptoKey(e),new Uint8Array(t))}async onDecrypt(r,e,t){return AesCrypto.decrypt(r,getCryptoKey(e),new Uint8Array(t))}async onExportKey(r,e){return AesCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await AesCrypto.importKey(r,e,{name:t.name},n,s);return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);if(!(getCryptoKey(r)instanceof AesCryptoKey)){throw new TypeError("key: Is not a AesCryptoKey")}}}class AesKwProvider extends f.AesKwProvider{async onGenerateKey(r,e,t){const n=await AesCrypto.generateKey({name:this.name,length:r.length},e,t);return setCryptoKey(n)}async onExportKey(r,e){return AesCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await AesCrypto.importKey(r,e,{name:t.name},n,s);return setCryptoKey(o)}async onEncrypt(r,e,t){return AesCrypto.encrypt(r,getCryptoKey(e),new Uint8Array(t))}async onDecrypt(r,e,t){return AesCrypto.decrypt(r,getCryptoKey(e),new Uint8Array(t))}checkCryptoKey(r,e){super.checkCryptoKey(r,e);if(!(getCryptoKey(r)instanceof AesCryptoKey)){throw new TypeError("key: Is not a AesCryptoKey")}}}class AesEcbProvider extends f.AesEcbProvider{async onGenerateKey(r,e,t){const n=await AesCrypto.generateKey({name:this.name,length:r.length},e,t);return setCryptoKey(n)}async onEncrypt(r,e,t){return AesCrypto.encrypt(r,getCryptoKey(e),new Uint8Array(t))}async onDecrypt(r,e,t){return AesCrypto.decrypt(r,getCryptoKey(e),new Uint8Array(t))}async onExportKey(r,e){return AesCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await AesCrypto.importKey(r,e,{name:t.name},n,s);return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);if(!(getCryptoKey(r)instanceof AesCryptoKey)){throw new TypeError("key: Is not a AesCryptoKey")}}}class DesCryptoKey extends SymmetricKey{get alg(){switch(this.algorithm.name.toUpperCase()){case"DES-CBC":return`DES-CBC`;case"DES-EDE3-CBC":return`3DES-CBC`;default:throw new f.AlgorithmError("Unsupported algorithm name")}}set alg(r){}}i.__decorate([a.JsonProp({name:"k",converter:p})],DesCryptoKey.prototype,"data",void 0);class DesCrypto{static async generateKey(r,e,t){const n=new DesCryptoKey;n.algorithm=r;n.extractable=e;n.usages=t;n.data=l["default"].randomBytes(r.length>>3);return n}static async exportKey(r,e){switch(r.toLowerCase()){case"jwk":return a.JsonSerializer.toJSON(e);case"raw":return new Uint8Array(e.data).buffer;default:throw new f.OperationError("format: Must be 'jwk' or 'raw'")}}static async importKey(r,e,t,n,s){let o;switch(r.toLowerCase()){case"jwk":o=a.JsonParser.fromJSON(e,{targetSchema:DesCryptoKey});break;case"raw":o=new DesCryptoKey;o.data=Buffer.from(e);break;default:throw new f.OperationError("format: Must be 'jwk' or 'raw'")}o.algorithm=t;o.extractable=n;o.usages=s;return o}static async encrypt(r,e,t){switch(r.name.toUpperCase()){case"DES-CBC":return this.encryptDesCBC(r,e,Buffer.from(t));case"DES-EDE3-CBC":return this.encryptDesEDE3CBC(r,e,Buffer.from(t));default:throw new f.OperationError("algorithm: Is not recognized")}}static async decrypt(r,e,t){if(!(e instanceof DesCryptoKey)){throw new Error("key: Is not DesCryptoKey")}switch(r.name.toUpperCase()){case"DES-CBC":return this.decryptDesCBC(r,e,Buffer.from(t));case"DES-EDE3-CBC":return this.decryptDesEDE3CBC(r,e,Buffer.from(t));default:throw new f.OperationError("algorithm: Is not recognized")}}static async encryptDesCBC(r,e,t){const n=l["default"].createCipheriv(`des-cbc`,e.data,new Uint8Array(r.iv));let s=n.update(t);s=Buffer.concat([s,n.final()]);const o=new Uint8Array(s).buffer;return o}static async decryptDesCBC(r,e,t){const n=l["default"].createDecipheriv(`des-cbc`,e.data,new Uint8Array(r.iv));let s=n.update(t);s=Buffer.concat([s,n.final()]);return new Uint8Array(s).buffer}static async encryptDesEDE3CBC(r,e,t){const n=l["default"].createCipheriv(`des-ede3-cbc`,e.data,Buffer.from(r.iv));let s=n.update(t);s=Buffer.concat([s,n.final()]);const o=new Uint8Array(s).buffer;return o}static async decryptDesEDE3CBC(r,e,t){const n=l["default"].createDecipheriv(`des-ede3-cbc`,e.data,new Uint8Array(r.iv));let s=n.update(t);s=Buffer.concat([s,n.final()]);return new Uint8Array(s).buffer}}class DesCbcProvider extends f.DesProvider{constructor(){super(...arguments);this.keySizeBits=64;this.ivSize=8;this.name="DES-CBC"}async onGenerateKey(r,e,t){const n=await DesCrypto.generateKey({name:this.name,length:this.keySizeBits},e,t);return setCryptoKey(n)}async onEncrypt(r,e,t){return DesCrypto.encrypt(r,getCryptoKey(e),new Uint8Array(t))}async onDecrypt(r,e,t){return DesCrypto.decrypt(r,getCryptoKey(e),new Uint8Array(t))}async onExportKey(r,e){return DesCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await DesCrypto.importKey(r,e,{name:this.name,length:this.keySizeBits},n,s);if(o.data.length!==this.keySizeBits>>3){throw new f.OperationError("keyData: Wrong key size")}return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);if(!(getCryptoKey(r)instanceof DesCryptoKey)){throw new TypeError("key: Is not a DesCryptoKey")}}}class DesEde3CbcProvider extends f.DesProvider{constructor(){super(...arguments);this.keySizeBits=192;this.ivSize=8;this.name="DES-EDE3-CBC"}async onGenerateKey(r,e,t){const n=await DesCrypto.generateKey({name:this.name,length:this.keySizeBits},e,t);return setCryptoKey(n)}async onEncrypt(r,e,t){return DesCrypto.encrypt(r,getCryptoKey(e),new Uint8Array(t))}async onDecrypt(r,e,t){return DesCrypto.decrypt(r,getCryptoKey(e),new Uint8Array(t))}async onExportKey(r,e){return DesCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await DesCrypto.importKey(r,e,{name:this.name,length:this.keySizeBits},n,s);if(o.data.length!==this.keySizeBits>>3){throw new f.OperationError("keyData: Wrong key size")}return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);if(!(getCryptoKey(r)instanceof DesCryptoKey)){throw new TypeError("key: Is not a DesCryptoKey")}}}function getJwkAlgorithm(r){switch(r.name.toUpperCase()){case"RSA-OAEP":{const e=/(\d+)$/.exec(r.hash.name)[1];return`RSA-OAEP${e!=="1"?`-${e}`:""}`}case"RSASSA-PKCS1-V1_5":return`RS${/(\d+)$/.exec(r.hash.name)[1]}`;case"RSA-PSS":return`PS${/(\d+)$/.exec(r.hash.name)[1]}`;case"RSA-PKCS1":return`RS1`;default:throw new f.OperationError("algorithm: Is not recognized")}}class RsaPrivateKey extends AsymmetricKey{constructor(){super(...arguments);this.type="private"}getKey(){const r=u.AsnParser.parse(this.data,f.asn1.PrivateKeyInfo);return u.AsnParser.parse(r.privateKey,f.asn1.RsaPrivateKey)}toJSON(){const r=this.getKey();const e={kty:"RSA",alg:getJwkAlgorithm(this.algorithm),key_ops:this.usages,ext:this.extractable};return Object.assign(e,a.JsonSerializer.toJSON(r))}fromJSON(r){const e=a.JsonParser.fromJSON(r,{targetSchema:f.asn1.RsaPrivateKey});const t=new f.asn1.PrivateKeyInfo;t.privateKeyAlgorithm.algorithm="1.2.840.113549.1.1.1";t.privateKeyAlgorithm.parameters=null;t.privateKey=u.AsnSerializer.serialize(e);this.data=Buffer.from(u.AsnSerializer.serialize(t))}}class RsaPublicKey extends AsymmetricKey{constructor(){super(...arguments);this.type="public"}getKey(){const r=u.AsnParser.parse(this.data,f.asn1.PublicKeyInfo);return u.AsnParser.parse(r.publicKey,f.asn1.RsaPublicKey)}toJSON(){const r=this.getKey();const e={kty:"RSA",alg:getJwkAlgorithm(this.algorithm),key_ops:this.usages,ext:this.extractable};return Object.assign(e,a.JsonSerializer.toJSON(r))}fromJSON(r){const e=a.JsonParser.fromJSON(r,{targetSchema:f.asn1.RsaPublicKey});const t=new f.asn1.PublicKeyInfo;t.publicKeyAlgorithm.algorithm="1.2.840.113549.1.1.1";t.publicKeyAlgorithm.parameters=null;t.publicKey=u.AsnSerializer.serialize(e);this.data=Buffer.from(u.AsnSerializer.serialize(t))}}class RsaCrypto{static async generateKey(r,e,t){const n=new RsaPrivateKey;n.algorithm=r;n.extractable=e;n.usages=t.filter(r=>this.privateKeyUsages.indexOf(r)!==-1);const s=new RsaPublicKey;s.algorithm=r;s.extractable=true;s.usages=t.filter(r=>this.publicKeyUsages.indexOf(r)!==-1);const o=Buffer.concat([Buffer.alloc(4-r.publicExponent.byteLength,0),Buffer.from(r.publicExponent)]).readInt32BE(0);const i=l["default"].generateKeyPairSync("rsa",{modulusLength:r.modulusLength,publicExponent:o,publicKeyEncoding:{format:"der",type:"spki"},privateKeyEncoding:{format:"der",type:"pkcs8"}});n.data=i.privateKey;s.data=i.publicKey;const a={privateKey:n,publicKey:s};return a}static async exportKey(r,e){switch(r.toLowerCase()){case"jwk":return a.JsonSerializer.toJSON(e);case"pkcs8":case"spki":return new Uint8Array(e.data).buffer;default:throw new f.OperationError("format: Must be 'jwk', 'pkcs8' or 'spki'")}}static async importKey(r,e,t,n,s){switch(r.toLowerCase()){case"jwk":{const r=e;if(r.d){const r=a.JsonParser.fromJSON(e,{targetSchema:f.asn1.RsaPrivateKey});return this.importPrivateKey(r,t,n,s)}else{const r=a.JsonParser.fromJSON(e,{targetSchema:f.asn1.RsaPublicKey});return this.importPublicKey(r,t,n,s)}}case"spki":{const r=u.AsnParser.parse(new Uint8Array(e),f.asn1.PublicKeyInfo);const o=u.AsnParser.parse(r.publicKey,f.asn1.RsaPublicKey);return this.importPublicKey(o,t,n,s)}case"pkcs8":{const r=u.AsnParser.parse(new Uint8Array(e),f.asn1.PrivateKeyInfo);const o=u.AsnParser.parse(r.privateKey,f.asn1.RsaPrivateKey);return this.importPrivateKey(o,t,n,s)}default:throw new f.OperationError("format: Must be 'jwk', 'pkcs8' or 'spki'")}}static async sign(r,e,t){switch(r.name.toUpperCase()){case"RSA-PSS":case"RSASSA-PKCS1-V1_5":return this.signRsa(r,e,t);default:throw new f.OperationError("algorithm: Is not recognized")}}static async verify(r,e,t,n){switch(r.name.toUpperCase()){case"RSA-PSS":case"RSASSA-PKCS1-V1_5":return this.verifySSA(r,e,n,t);default:throw new f.OperationError("algorithm: Is not recognized")}}static async encrypt(r,e,t){switch(r.name.toUpperCase()){case"RSA-OAEP":return this.encryptOAEP(r,e,t);default:throw new f.OperationError("algorithm: Is not recognized")}}static async decrypt(r,e,t){switch(r.name.toUpperCase()){case"RSA-OAEP":return this.decryptOAEP(r,e,t);default:throw new f.OperationError("algorithm: Is not recognized")}}static importPrivateKey(r,e,t,n){const s=new f.asn1.PrivateKeyInfo;s.privateKeyAlgorithm.algorithm="1.2.840.113549.1.1.1";s.privateKeyAlgorithm.parameters=null;s.privateKey=u.AsnSerializer.serialize(r);const o=new RsaPrivateKey;o.data=Buffer.from(u.AsnSerializer.serialize(s));o.algorithm=Object.assign({},e);o.algorithm.publicExponent=new Uint8Array(r.publicExponent);o.algorithm.modulusLength=r.modulus.byteLength<<3;o.extractable=t;o.usages=n;return o}static importPublicKey(r,e,t,n){const s=new f.asn1.PublicKeyInfo;s.publicKeyAlgorithm.algorithm="1.2.840.113549.1.1.1";s.publicKeyAlgorithm.parameters=null;s.publicKey=u.AsnSerializer.serialize(r);const o=new RsaPublicKey;o.data=Buffer.from(u.AsnSerializer.serialize(s));o.algorithm=Object.assign({},e);o.algorithm.publicExponent=new Uint8Array(r.publicExponent);o.algorithm.modulusLength=r.modulus.byteLength<<3;o.extractable=t;o.usages=n;return o}static getCryptoAlgorithm(r){switch(r.hash.name.toUpperCase()){case"SHA-1":return"RSA-SHA1";case"SHA-256":return"RSA-SHA256";case"SHA-384":return"RSA-SHA384";case"SHA-512":return"RSA-SHA512";default:throw new f.OperationError("algorithm.hash: Is not recognized")}}static signRsa(r,e,t){const n=this.getCryptoAlgorithm(e.algorithm);const s=l["default"].createSign(n);s.update(Buffer.from(t));if(!e.pem){e.pem=`-----BEGIN PRIVATE KEY-----\n${e.data.toString("base64")}\n-----END PRIVATE KEY-----`}const o={key:e.pem};if(r.name.toUpperCase()==="RSA-PSS"){o.padding=l["default"].constants.RSA_PKCS1_PSS_PADDING;o.saltLength=r.saltLength}const i=s.sign(o);return new Uint8Array(i).buffer}static verifySSA(r,e,t,n){const s=this.getCryptoAlgorithm(e.algorithm);const o=l["default"].createVerify(s);o.update(Buffer.from(t));if(!e.pem){e.pem=`-----BEGIN PUBLIC KEY-----\n${e.data.toString("base64")}\n-----END PUBLIC KEY-----`}const i={key:e.pem};if(r.name.toUpperCase()==="RSA-PSS"){i.padding=l["default"].constants.RSA_PKCS1_PSS_PADDING;i.saltLength=r.saltLength}const a=o.verify(i,n);return a}static encryptOAEP(r,e,t){const n={key:`-----BEGIN PUBLIC KEY-----\n${e.data.toString("base64")}\n-----END PUBLIC KEY-----`,padding:l["default"].constants.RSA_PKCS1_OAEP_PADDING};if(r.label);return new Uint8Array(l["default"].publicEncrypt(n,t)).buffer}static decryptOAEP(r,e,t){const n={key:`-----BEGIN PRIVATE KEY-----\n${e.data.toString("base64")}\n-----END PRIVATE KEY-----`,padding:l["default"].constants.RSA_PKCS1_OAEP_PADDING};if(r.label);return new Uint8Array(l["default"].privateDecrypt(n,t)).buffer}}RsaCrypto.publicKeyUsages=["verify","encrypt","wrapKey"];RsaCrypto.privateKeyUsages=["sign","decrypt","unwrapKey"];class RsaSsaProvider extends f.RsaSsaProvider{async onGenerateKey(r,e,t){const n=await RsaCrypto.generateKey({...r,name:this.name},e,t);return{privateKey:setCryptoKey(n.privateKey),publicKey:setCryptoKey(n.publicKey)}}async onSign(r,e,t){return RsaCrypto.sign(r,getCryptoKey(e),new Uint8Array(t))}async onVerify(r,e,t,n){return RsaCrypto.verify(r,getCryptoKey(e),new Uint8Array(t),new Uint8Array(n))}async onExportKey(r,e){return RsaCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await RsaCrypto.importKey(r,e,{...t,name:this.name},n,s);return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);const t=getCryptoKey(r);if(!(t instanceof RsaPrivateKey||t instanceof RsaPublicKey)){throw new TypeError("key: Is not RSA CryptoKey")}}}class RsaPssProvider extends f.RsaPssProvider{async onGenerateKey(r,e,t){const n=await RsaCrypto.generateKey({...r,name:this.name},e,t);return{privateKey:setCryptoKey(n.privateKey),publicKey:setCryptoKey(n.publicKey)}}async onSign(r,e,t){return RsaCrypto.sign(r,getCryptoKey(e),new Uint8Array(t))}async onVerify(r,e,t,n){return RsaCrypto.verify(r,getCryptoKey(e),new Uint8Array(t),new Uint8Array(n))}async onExportKey(r,e){return RsaCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await RsaCrypto.importKey(r,e,{...t,name:this.name},n,s);return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);const t=getCryptoKey(r);if(!(t instanceof RsaPrivateKey||t instanceof RsaPublicKey)){throw new TypeError("key: Is not RSA CryptoKey")}}}class ShaCrypto{static size(r){switch(r.name.toUpperCase()){case"SHA-1":return 160;case"SHA-256":return 256;case"SHA-384":return 384;case"SHA-512":return 512;default:throw new Error("Unrecognized name")}}static digest(r,e){const t=l["default"].createHash(r.name.replace("-","")).update(Buffer.from(e)).digest();return new Uint8Array(t).buffer}}class RsaOaepProvider extends f.RsaOaepProvider{async onGenerateKey(r,e,t){const n=await RsaCrypto.generateKey({...r,name:this.name},e,t);return{privateKey:setCryptoKey(n.privateKey),publicKey:setCryptoKey(n.publicKey)}}async onEncrypt(r,e,t){const n=getCryptoKey(e);const s=new Uint8Array(t);const o=Math.ceil(n.algorithm.modulusLength>>3);const i=ShaCrypto.size(n.algorithm.hash)>>3;const a=s.byteLength;const c=o-a-2*i-2;if(a>o-2*i-2){throw new Error("Data too large")}const u=new Uint8Array(o);const h=u.subarray(1,i+1);const y=u.subarray(i+1);y.set(s,i+c+1);const p=l["default"].createHash(n.algorithm.hash.name.replace("-","")).update(f.BufferSourceConverter.toUint8Array(r.label||new Uint8Array(0))).digest();y.set(p,0);y[i+c]=1;l["default"].randomFillSync(h);const d=this.mgf1(n.algorithm.hash,h,y.length);for(let r=0;r<y.length;r++){y[r]^=d[r]}const g=this.mgf1(n.algorithm.hash,y,h.length);for(let r=0;r<h.length;r++){h[r]^=g[r]}if(!n.pem){n.pem=`-----BEGIN PUBLIC KEY-----\n${n.data.toString("base64")}\n-----END PUBLIC KEY-----`}const A=l["default"].publicEncrypt({key:n.pem,padding:l["default"].constants.RSA_NO_PADDING},Buffer.from(u));return new Uint8Array(A).buffer}async onDecrypt(r,e,t){const n=getCryptoKey(e);const s=Math.ceil(n.algorithm.modulusLength>>3);const o=ShaCrypto.size(n.algorithm.hash)>>3;const i=t.byteLength;if(i!==s){throw new Error("Bad data")}if(!n.pem){n.pem=`-----BEGIN PRIVATE KEY-----\n${n.data.toString("base64")}\n-----END PRIVATE KEY-----`}let a=l["default"].privateDecrypt({key:n.pem,padding:l["default"].constants.RSA_NO_PADDING},Buffer.from(t));const c=a[0];const u=a.subarray(1,o+1);const h=a.subarray(o+1);if(c!==0){throw new Error("Decryption failed")}const y=this.mgf1(n.algorithm.hash,h,u.length);for(let r=0;r<u.length;r++){u[r]^=y[r]}const p=this.mgf1(n.algorithm.hash,u,h.length);for(let r=0;r<h.length;r++){h[r]^=p[r]}const d=l["default"].createHash(n.algorithm.hash.name.replace("-","")).update(f.BufferSourceConverter.toUint8Array(r.label||new Uint8Array(0))).digest();for(let r=0;r<o;r++){if(d[r]!==h[r]){throw new Error("Decryption failed")}}let g=o;for(;g<h.length;g++){const r=h[g];if(r===1){break}if(r!==0){throw new Error("Decryption failed")}}if(g===h.length){throw new Error("Decryption failed")}a=h.subarray(g+1);return new Uint8Array(a).buffer}async onExportKey(r,e){return RsaCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await RsaCrypto.importKey(r,e,{...t,name:this.name},n,s);return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);const t=getCryptoKey(r);if(!(t instanceof RsaPrivateKey||t instanceof RsaPublicKey)){throw new TypeError("key: Is not RSA CryptoKey")}}mgf1(r,e,t=0){const n=ShaCrypto.size(r)>>3;const s=new Uint8Array(t);const o=new Uint8Array(4);const i=Math.ceil(t/n);for(let t=0;t<i;t++){o[0]=t>>>24;o[1]=t>>>16&255;o[2]=t>>>8&255;o[3]=t&255;const i=s.subarray(t*n);let a=l["default"].createHash(r.name.replace("-","")).update(e).update(o).digest();if(a.length>i.length){a=a.subarray(0,i.length)}i.set(a)}return s}}class RsaEsProvider extends f.ProviderCrypto{constructor(){super(...arguments);this.name="RSAES-PKCS1-v1_5";this.usages={publicKey:["encrypt","wrapKey"],privateKey:["decrypt","unwrapKey"]}}async onGenerateKey(r,e,t){const n=await RsaCrypto.generateKey({...r,name:this.name},e,t);return{privateKey:setCryptoKey(n.privateKey),publicKey:setCryptoKey(n.publicKey)}}checkGenerateKeyParams(r){this.checkRequiredProperty(r,"publicExponent");if(!(r.publicExponent&&r.publicExponent instanceof Uint8Array)){throw new TypeError("publicExponent: Missing or not a Uint8Array")}const e=c.Convert.ToBase64(r.publicExponent);if(!(e==="Aw=="||e==="AQAB")){throw new TypeError("publicExponent: Must be [3] or [1,0,1]")}this.checkRequiredProperty(r,"modulusLength");switch(r.modulusLength){case 1024:case 2048:case 4096:break;default:throw new TypeError("modulusLength: Must be 1024, 2048, or 4096")}}async onEncrypt(r,e,t){const n=this.toCryptoOptions(e);const s=h.publicEncrypt(n,new Uint8Array(t));return new Uint8Array(s).buffer}async onDecrypt(r,e,t){const n=this.toCryptoOptions(e);const s=h.privateDecrypt(n,new Uint8Array(t));return new Uint8Array(s).buffer}async onExportKey(r,e){return RsaCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await RsaCrypto.importKey(r,e,{...t,name:this.name},n,s);return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);const t=getCryptoKey(r);if(!(t instanceof RsaPrivateKey||t instanceof RsaPublicKey)){throw new TypeError("key: Is not RSA CryptoKey")}}toCryptoOptions(r){const e=r.type.toUpperCase();return{key:`-----BEGIN ${e} KEY-----\n${getCryptoKey(r).data.toString("base64")}\n-----END ${e} KEY-----`,padding:h.constants.RSA_PKCS1_PADDING}}}const B={"1.2.840.10045.3.1.7":"P-256","P-256":"1.2.840.10045.3.1.7","1.3.132.0.34":"P-384","P-384":"1.3.132.0.34","1.3.132.0.35":"P-521","P-521":"1.3.132.0.35","1.3.132.0.10":"K-256","K-256":"1.3.132.0.10"};function getOidByNamedCurve$1(r){const e=B[r];if(!e){throw new f.OperationError(`Cannot convert WebCrypto named curve '${r}' to OID`)}return e}class EcPrivateKey extends AsymmetricKey{constructor(){super(...arguments);this.type="private"}getKey(){const r=u.AsnParser.parse(this.data,f.asn1.PrivateKeyInfo);return u.AsnParser.parse(r.privateKey,f.asn1.EcPrivateKey)}toJSON(){const r=this.getKey();const e={kty:"EC",crv:this.algorithm.namedCurve,key_ops:this.usages,ext:this.extractable};return Object.assign(e,a.JsonSerializer.toJSON(r))}fromJSON(r){if(!r.crv){throw new f.OperationError(`Cannot get named curve from JWK. Property 'crv' is required`)}const e=new f.asn1.PrivateKeyInfo;e.privateKeyAlgorithm.algorithm="1.2.840.10045.2.1";e.privateKeyAlgorithm.parameters=u.AsnSerializer.serialize(new f.asn1.ObjectIdentifier(getOidByNamedCurve$1(r.crv)));const t=a.JsonParser.fromJSON(r,{targetSchema:f.asn1.EcPrivateKey});e.privateKey=u.AsnSerializer.serialize(t);this.data=Buffer.from(u.AsnSerializer.serialize(e));return this}}class EcPublicKey extends AsymmetricKey{constructor(){super(...arguments);this.type="public"}getKey(){const r=u.AsnParser.parse(this.data,f.asn1.PublicKeyInfo);return new f.asn1.EcPublicKey(r.publicKey)}toJSON(){const r=this.getKey();const e={kty:"EC",crv:this.algorithm.namedCurve,key_ops:this.usages,ext:this.extractable};return Object.assign(e,a.JsonSerializer.toJSON(r))}fromJSON(r){if(!r.crv){throw new f.OperationError(`Cannot get named curve from JWK. Property 'crv' is required`)}const e=a.JsonParser.fromJSON(r,{targetSchema:f.asn1.EcPublicKey});const t=new f.asn1.PublicKeyInfo;t.publicKeyAlgorithm.algorithm="1.2.840.10045.2.1";t.publicKeyAlgorithm.parameters=u.AsnSerializer.serialize(new f.asn1.ObjectIdentifier(getOidByNamedCurve$1(r.crv)));t.publicKey=u.AsnSerializer.toASN(e).valueHex;this.data=Buffer.from(u.AsnSerializer.serialize(t));return this}}class EcCrypto{static async generateKey(r,e,t){const n=new EcPrivateKey;n.algorithm=r;n.extractable=e;n.usages=t.filter(r=>this.privateKeyUsages.indexOf(r)!==-1);const s=new EcPublicKey;s.algorithm=r;s.extractable=true;s.usages=t.filter(r=>this.publicKeyUsages.indexOf(r)!==-1);const o=l["default"].generateKeyPairSync("ec",{namedCurve:this.getOpenSSLNamedCurve(r.namedCurve),publicKeyEncoding:{format:"der",type:"spki"},privateKeyEncoding:{format:"der",type:"pkcs8"}});n.data=o.privateKey;s.data=o.publicKey;const i={privateKey:n,publicKey:s};return i}static async sign(r,e,t){const n=r.hash.name.replace("-","");const s=l["default"].createSign(n);s.update(Buffer.from(t));if(!e.pem){e.pem=`-----BEGIN PRIVATE KEY-----\n${e.data.toString("base64")}\n-----END PRIVATE KEY-----`}const o={key:e.pem};const i=s.sign(o);const a=u.AsnParser.parse(i,f.asn1.EcDsaSignature);const c=this.getPointSize(e.algorithm.namedCurve);const h=this.addPadding(c,Buffer.from(a.r));const y=this.addPadding(c,Buffer.from(a.s));const p=new Uint8Array(Buffer.concat([h,y])).buffer;return p}static async verify(r,e,t,n){const s=r.hash.name.replace("-","");const o=l["default"].createVerify(s);o.update(Buffer.from(n));if(!e.pem){e.pem=`-----BEGIN PUBLIC KEY-----\n${e.data.toString("base64")}\n-----END PUBLIC KEY-----`}const i={key:e.pem};const a=new f.asn1.EcDsaSignature;const c=this.getPointSize(e.algorithm.namedCurve);a.r=this.removePadding(t.slice(0,c));a.s=this.removePadding(t.slice(c,c+c));const h=Buffer.from(u.AsnSerializer.serialize(a));const y=o.verify(i,h);return y}static async deriveBits(r,e,t){const n=this.getOpenSSLNamedCurve(e.algorithm.namedCurve);const s=l["default"].createECDH(n);const o=u.AsnParser.parse(e.data,f.asn1.PrivateKeyInfo);const i=u.AsnParser.parse(o.privateKey,f.asn1.EcPrivateKey);s.setPrivateKey(Buffer.from(i.privateKey));const a=u.AsnParser.parse(r.public.data,f.asn1.PublicKeyInfo);const c=s.computeSecret(Buffer.from(a.publicKey));return new Uint8Array(c).buffer.slice(0,t>>3)}static async exportKey(r,e){switch(r.toLowerCase()){case"jwk":return a.JsonSerializer.toJSON(e);case"pkcs8":case"spki":return new Uint8Array(e.data).buffer;case"raw":{const r=u.AsnParser.parse(e.data,f.asn1.PublicKeyInfo);return r.publicKey}default:throw new f.OperationError("format: Must be 'jwk', 'raw', pkcs8' or 'spki'")}}static async importKey(r,e,t,n,s){switch(r.toLowerCase()){case"jwk":{const r=e;if(r.d){const r=a.JsonParser.fromJSON(e,{targetSchema:f.asn1.EcPrivateKey});return this.importPrivateKey(r,t,n,s)}else{const r=a.JsonParser.fromJSON(e,{targetSchema:f.asn1.EcPublicKey});return this.importPublicKey(r,t,n,s)}}case"raw":{const r=new f.asn1.EcPublicKey(e);return this.importPublicKey(r,t,n,s)}case"spki":{const r=u.AsnParser.parse(new Uint8Array(e),f.asn1.PublicKeyInfo);const o=new f.asn1.EcPublicKey(r.publicKey);this.assertKeyParameters(r.publicKeyAlgorithm.parameters,t.namedCurve);return this.importPublicKey(o,t,n,s)}case"pkcs8":{const r=u.AsnParser.parse(new Uint8Array(e),f.asn1.PrivateKeyInfo);const o=u.AsnParser.parse(r.privateKey,f.asn1.EcPrivateKey);this.assertKeyParameters(r.privateKeyAlgorithm.parameters,t.namedCurve);return this.importPrivateKey(o,t,n,s)}default:throw new f.OperationError("format: Must be 'jwk', 'raw', 'pkcs8' or 'spki'")}}static assertKeyParameters(r,e){if(!r){throw new f.CryptoError("Key info doesn't have required parameters")}let t="";try{t=u.AsnParser.parse(r,f.asn1.ObjectIdentifier).value}catch(r){throw new f.CryptoError("Cannot read key info parameters")}if(getOidByNamedCurve$1(e)!==t){throw new f.CryptoError("Key info parameter doesn't match to named curve")}}static async importPrivateKey(r,e,t,n){const s=new f.asn1.PrivateKeyInfo;s.privateKeyAlgorithm.algorithm="1.2.840.10045.2.1";s.privateKeyAlgorithm.parameters=u.AsnSerializer.serialize(new f.asn1.ObjectIdentifier(getOidByNamedCurve$1(e.namedCurve)));s.privateKey=u.AsnSerializer.serialize(r);const o=new EcPrivateKey;o.data=Buffer.from(u.AsnSerializer.serialize(s));o.algorithm=Object.assign({},e);o.extractable=t;o.usages=n;return o}static async importPublicKey(r,e,t,n){const s=new f.asn1.PublicKeyInfo;s.publicKeyAlgorithm.algorithm="1.2.840.10045.2.1";const o=getOidByNamedCurve$1(e.namedCurve);s.publicKeyAlgorithm.parameters=u.AsnSerializer.serialize(new f.asn1.ObjectIdentifier(o));s.publicKey=r.value;const i=new EcPublicKey;i.data=Buffer.from(u.AsnSerializer.serialize(s));i.algorithm=Object.assign({},e);i.extractable=t;i.usages=n;return i}static getOpenSSLNamedCurve(r){switch(r.toUpperCase()){case"P-256":return"prime256v1";case"K-256":return"secp256k1";case"P-384":return"secp384r1";case"P-521":return"secp521r1";default:throw new f.OperationError(`Cannot convert WebCrypto named curve to NodeJs. Unknown name '${r}'`)}}static getPointSize(r){switch(r){case"P-256":case"K-256":return 32;case"P-384":return 48;case"P-521":return 66;default:throw new Error(`Cannot get size for the named curve '${r}'`)}}static addPadding(r,e){const t=Buffer.alloc(r);t.set(Buffer.from(e),r-e.length);return t}static removePadding(r){for(let e=0;e<r.length;e++){if(!r[e]){continue}return r.slice(e).buffer}return new ArrayBuffer(0)}}EcCrypto.publicKeyUsages=["verify"];EcCrypto.privateKeyUsages=["sign","deriveKey","deriveBits"];class EcdsaProvider extends f.EcdsaProvider{constructor(){super(...arguments);this.namedCurves=["P-256","P-384","P-521","K-256"]}async onGenerateKey(r,e,t){const n=await EcCrypto.generateKey({...r,name:this.name},e,t);return{privateKey:setCryptoKey(n.privateKey),publicKey:setCryptoKey(n.publicKey)}}async onSign(r,e,t){return EcCrypto.sign(r,getCryptoKey(e),new Uint8Array(t))}async onVerify(r,e,t,n){return EcCrypto.verify(r,getCryptoKey(e),new Uint8Array(t),new Uint8Array(n))}async onExportKey(r,e){return EcCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await EcCrypto.importKey(r,e,{...t,name:this.name},n,s);return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);const t=getCryptoKey(r);if(!(t instanceof EcPrivateKey||t instanceof EcPublicKey)){throw new TypeError("key: Is not EC CryptoKey")}}}class EcdhProvider extends f.EcdhProvider{async onGenerateKey(r,e,t){const n=await EcCrypto.generateKey({...r,name:this.name},e,t);return{privateKey:setCryptoKey(n.privateKey),publicKey:setCryptoKey(n.publicKey)}}async onExportKey(r,e){return EcCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await EcCrypto.importKey(r,e,{...t,name:this.name},n,s);return setCryptoKey(o)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);const t=getCryptoKey(r);if(!(t instanceof EcPrivateKey||t instanceof EcPublicKey)){throw new TypeError("key: Is not EC CryptoKey")}}async onDeriveBits(r,e,t){const n=await EcCrypto.deriveBits({...r,public:getCryptoKey(r.public)},getCryptoKey(e),t);return n}}const v={[f.asn1.idEd448]:"Ed448",ed448:f.asn1.idEd448,[f.asn1.idX448]:"X448",x448:f.asn1.idX448,[f.asn1.idEd25519]:"Ed25519",ed25519:f.asn1.idEd25519,[f.asn1.idX25519]:"X25519",x25519:f.asn1.idX25519};function getOidByNamedCurve(r){const e=v[r.toLowerCase()];if(!e){throw new f.OperationError(`Cannot convert WebCrypto named curve '${r}' to OID`)}return e}class EdPrivateKey extends AsymmetricKey{constructor(){super(...arguments);this.type="private"}getKey(){const r=u.AsnParser.parse(this.data,f.asn1.PrivateKeyInfo);return u.AsnParser.parse(r.privateKey,f.asn1.CurvePrivateKey)}toJSON(){const r=this.getKey();const e={kty:"OKP",crv:this.algorithm.namedCurve,key_ops:this.usages,ext:this.extractable};return Object.assign(e,a.JsonSerializer.toJSON(r))}fromJSON(r){if(!r.crv){throw new f.OperationError(`Cannot get named curve from JWK. Property 'crv' is required`)}const e=new f.asn1.PrivateKeyInfo;e.privateKeyAlgorithm.algorithm=getOidByNamedCurve(r.crv);const t=a.JsonParser.fromJSON(r,{targetSchema:f.asn1.CurvePrivateKey});e.privateKey=u.AsnSerializer.serialize(t);this.data=Buffer.from(u.AsnSerializer.serialize(e));return this}}class EdPublicKey extends AsymmetricKey{constructor(){super(...arguments);this.type="public"}getKey(){const r=u.AsnParser.parse(this.data,f.asn1.PublicKeyInfo);return r.publicKey}toJSON(){const r=this.getKey();const e={kty:"OKP",crv:this.algorithm.namedCurve,key_ops:this.usages,ext:this.extractable};return Object.assign(e,{x:c.Convert.ToBase64Url(r)})}fromJSON(r){if(!r.crv){throw new f.OperationError(`Cannot get named curve from JWK. Property 'crv' is required`)}if(!r.x){throw new f.OperationError(`Cannot get property from JWK. Property 'x' is required`)}const e=new f.asn1.PublicKeyInfo;e.publicKeyAlgorithm.algorithm=getOidByNamedCurve(r.crv);e.publicKey=c.Convert.FromBase64Url(r.x);this.data=Buffer.from(u.AsnSerializer.serialize(e));return this}}class EdCrypto{static async generateKey(r,e,t){const n=new EdPrivateKey;n.algorithm=r;n.extractable=e;n.usages=t.filter(r=>this.privateKeyUsages.indexOf(r)!==-1);const s=new EdPublicKey;s.algorithm=r;s.extractable=true;s.usages=t.filter(r=>this.publicKeyUsages.indexOf(r)!==-1);const o=r.namedCurve.toLowerCase();const i=l["default"].generateKeyPairSync(o,{publicKeyEncoding:{format:"der",type:"spki"},privateKeyEncoding:{format:"der",type:"pkcs8"}});n.data=i.privateKey;s.data=i.publicKey;const a={privateKey:n,publicKey:s};return a}static async sign(r,e,t){if(!e.pem){e.pem=`-----BEGIN PRIVATE KEY-----\n${e.data.toString("base64")}\n-----END PRIVATE KEY-----`}const n={key:e.pem};const s=l["default"].sign(null,Buffer.from(t),n);return f.BufferSourceConverter.toArrayBuffer(s)}static async verify(r,e,t,n){if(!e.pem){e.pem=`-----BEGIN PUBLIC KEY-----\n${e.data.toString("base64")}\n-----END PUBLIC KEY-----`}const s={key:e.pem};const o=l["default"].verify(null,Buffer.from(n),s,Buffer.from(t));return o}static async deriveBits(r,e,t){const n=l["default"].createPublicKey({key:r.public.data,format:"der",type:"spki"});const s=l["default"].createPrivateKey({key:e.data,format:"der",type:"pkcs8"});const o=l["default"].diffieHellman({publicKey:n,privateKey:s});return new Uint8Array(o).buffer.slice(0,t>>3)}static async exportKey(r,e){switch(r.toLowerCase()){case"jwk":return a.JsonSerializer.toJSON(e);case"pkcs8":case"spki":return new Uint8Array(e.data).buffer;case"raw":{const r=u.AsnParser.parse(e.data,f.asn1.PublicKeyInfo);return r.publicKey}default:throw new f.OperationError("format: Must be 'jwk', 'raw', pkcs8' or 'spki'")}}static async importKey(r,e,t,n,s){switch(r.toLowerCase()){case"jwk":{const r=e;if(r.d){const r=a.JsonParser.fromJSON(e,{targetSchema:f.asn1.CurvePrivateKey});return this.importPrivateKey(r,t,n,s)}else{if(!r.x){throw new TypeError("keyData: Cannot get required 'x' filed")}return this.importPublicKey(c.Convert.FromBase64Url(r.x),t,n,s)}}case"raw":{return this.importPublicKey(e,t,n,s)}case"spki":{const r=u.AsnParser.parse(new Uint8Array(e),f.asn1.PublicKeyInfo);return this.importPublicKey(r.publicKey,t,n,s)}case"pkcs8":{const r=u.AsnParser.parse(new Uint8Array(e),f.asn1.PrivateKeyInfo);const o=u.AsnParser.parse(r.privateKey,f.asn1.CurvePrivateKey);return this.importPrivateKey(o,t,n,s)}default:throw new f.OperationError("format: Must be 'jwk', 'raw', 'pkcs8' or 'spki'")}}static importPrivateKey(r,e,t,n){const s=new EdPrivateKey;s.fromJSON({crv:e.namedCurve,d:c.Convert.ToBase64Url(r.d)});s.algorithm=Object.assign({},e);s.extractable=t;s.usages=n;return s}static async importPublicKey(r,e,t,n){const s=new EdPublicKey;s.fromJSON({crv:e.namedCurve,x:c.Convert.ToBase64Url(r)});s.algorithm=Object.assign({},e);s.extractable=t;s.usages=n;return s}}EdCrypto.publicKeyUsages=["verify"];EdCrypto.privateKeyUsages=["sign","deriveKey","deriveBits"];class EdDsaProvider extends f.EdDsaProvider{async onGenerateKey(r,e,t){const n=await EdCrypto.generateKey({name:this.name,namedCurve:r.namedCurve.replace(/^ed/i,"Ed")},e,t);return{privateKey:setCryptoKey(n.privateKey),publicKey:setCryptoKey(n.publicKey)}}async onSign(r,e,t){return EdCrypto.sign(r,getCryptoKey(e),new Uint8Array(t))}async onVerify(r,e,t,n){return EdCrypto.verify(r,getCryptoKey(e),new Uint8Array(t),new Uint8Array(n))}async onExportKey(r,e){return EdCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await EdCrypto.importKey(r,e,{...t,name:this.name},n,s);return setCryptoKey(o)}}class EcdhEsProvider extends f.EcdhEsProvider{async onGenerateKey(r,e,t){const n=await EdCrypto.generateKey({name:this.name,namedCurve:r.namedCurve.toUpperCase()},e,t);return{privateKey:setCryptoKey(n.privateKey),publicKey:setCryptoKey(n.publicKey)}}async onDeriveBits(r,e,t){const n=await EdCrypto.deriveBits({...r,public:getCryptoKey(r.public)},getCryptoKey(e),t);return n}async onExportKey(r,e){return EdCrypto.exportKey(r,getCryptoKey(e))}async onImportKey(r,e,t,n,s){const o=await EdCrypto.importKey(r,e,{...t,name:this.name},n,s);return setCryptoKey(o)}}class Sha1Provider extends f.ProviderCrypto{constructor(){super(...arguments);this.name="SHA-1";this.usages=[]}async onDigest(r,e){return ShaCrypto.digest(r,e)}}class Sha256Provider extends f.ProviderCrypto{constructor(){super(...arguments);this.name="SHA-256";this.usages=[]}async onDigest(r,e){return ShaCrypto.digest(r,e)}}class Sha384Provider extends f.ProviderCrypto{constructor(){super(...arguments);this.name="SHA-384";this.usages=[]}async onDigest(r,e){return ShaCrypto.digest(r,e)}}class Sha512Provider extends f.ProviderCrypto{constructor(){super(...arguments);this.name="SHA-512";this.usages=[]}async onDigest(r,e){return ShaCrypto.digest(r,e)}}class PbkdfCryptoKey extends CryptoKey{}class Pbkdf2Provider extends f.Pbkdf2Provider{async onDeriveBits(r,e,t){return new Promise((n,s)=>{const o=f.BufferSourceConverter.toArrayBuffer(r.salt);const i=r.hash.name.replace("-","");l["default"].pbkdf2(getCryptoKey(e).data,Buffer.from(o),r.iterations,t>>3,i,(r,e)=>{if(r){s(r)}else{n(new Uint8Array(e).buffer)}})})}async onImportKey(r,e,t,n,s){if(r==="raw"){const r=new PbkdfCryptoKey;r.data=Buffer.from(e);r.algorithm={name:this.name};r.extractable=false;r.usages=s;return setCryptoKey(r)}throw new f.OperationError("format: Must be 'raw'")}checkCryptoKey(r,e){super.checkCryptoKey(r,e);if(!(getCryptoKey(r)instanceof PbkdfCryptoKey)){throw new TypeError("key: Is not PBKDF CryptoKey")}}}class HmacCryptoKey extends CryptoKey{get alg(){const r=this.algorithm.hash.name.toUpperCase();return`HS${r.replace("SHA-","")}`}set alg(r){}}i.__decorate([a.JsonProp({name:"k",converter:p})],HmacCryptoKey.prototype,"data",void 0);class HmacProvider extends f.HmacProvider{async onGenerateKey(r,e,t){const n=(r.length||this.getDefaultLength(r.hash.name))>>3<<3;const s=new HmacCryptoKey;s.algorithm={...r,length:n,name:this.name};s.extractable=e;s.usages=t;s.data=l["default"].randomBytes(n>>3);return setCryptoKey(s)}async onSign(r,e,t){const n=e.algorithm.hash.name.replace("-","");const s=l["default"].createHmac(n,getCryptoKey(e).data).update(Buffer.from(t)).digest();return new Uint8Array(s).buffer}async onVerify(r,e,t,n){const s=e.algorithm.hash.name.replace("-","");const o=l["default"].createHmac(s,getCryptoKey(e).data).update(Buffer.from(n)).digest();return o.compare(Buffer.from(t))===0}async onImportKey(r,e,t,n,s){let o;switch(r.toLowerCase()){case"jwk":o=a.JsonParser.fromJSON(e,{targetSchema:HmacCryptoKey});break;case"raw":o=new HmacCryptoKey;o.data=Buffer.from(e);break;default:throw new f.OperationError("format: Must be 'jwk' or 'raw'")}o.algorithm={hash:{name:t.hash.name},name:this.name,length:o.data.length<<3};o.extractable=n;o.usages=s;return setCryptoKey(o)}async onExportKey(r,e){switch(r.toLowerCase()){case"jwk":return a.JsonSerializer.toJSON(getCryptoKey(e));case"raw":return new Uint8Array(getCryptoKey(e).data).buffer;default:throw new f.OperationError("format: Must be 'jwk' or 'raw'")}}checkCryptoKey(r,e){super.checkCryptoKey(r,e);if(!(getCryptoKey(r)instanceof HmacCryptoKey)){throw new TypeError("key: Is not HMAC CryptoKey")}}}class HkdfCryptoKey extends CryptoKey{}class HkdfProvider extends f.HkdfProvider{async onImportKey(r,e,t,n,s){if(r.toLowerCase()!=="raw"){throw new f.OperationError("Operation not supported")}const o=new HkdfCryptoKey;o.data=Buffer.from(e);o.algorithm={name:this.name};o.extractable=n;o.usages=s;return setCryptoKey(o)}async onDeriveBits(r,e,t){const s=r.hash.name.replace("-","");const o=l["default"].createHash(s).digest().length;const i=t/8;const a=n.BufferSourceConverter.toUint8Array(r.info);const c=l["default"].createHmac(s,n.BufferSourceConverter.toUint8Array(r.salt)).update(n.BufferSourceConverter.toUint8Array(getCryptoKey(e).data)).digest();const u=[Buffer.alloc(0)];const f=Math.ceil(i/o)+1;for(let r=1;r<f;++r){u.push(l["default"].createHmac(s,c).update(Buffer.concat([u[r-1],a,Buffer.from([r])])).digest())}return Buffer.concat(u).slice(0,i)}checkCryptoKey(r,e){super.checkCryptoKey(r,e);if(!(getCryptoKey(r)instanceof HkdfCryptoKey)){throw new TypeError("key: Is not HKDF CryptoKey")}}}class SubtleCrypto extends f.SubtleCrypto{constructor(){var r;super();this.providers.set(new AesCbcProvider);this.providers.set(new AesCtrProvider);this.providers.set(new AesGcmProvider);this.providers.set(new AesCmacProvider);this.providers.set(new AesKwProvider);this.providers.set(new AesEcbProvider);this.providers.set(new DesCbcProvider);this.providers.set(new DesEde3CbcProvider);this.providers.set(new RsaSsaProvider);this.providers.set(new RsaPssProvider);this.providers.set(new RsaOaepProvider);this.providers.set(new RsaEsProvider);this.providers.set(new EcdsaProvider);this.providers.set(new EcdhProvider);this.providers.set(new Sha1Provider);this.providers.set(new Sha256Provider);this.providers.set(new Sha384Provider);this.providers.set(new Sha512Provider);this.providers.set(new Pbkdf2Provider);this.providers.set(new HmacProvider);this.providers.set(new HkdfProvider);const e=(r=/^v(\d+)/.exec(y.version))===null||r===void 0?void 0:r[1];if(e&&parseInt(e,10)>=14){this.providers.set(new EdDsaProvider);this.providers.set(new EcdhEsProvider)}}}class Crypto extends f.Crypto{constructor(){super(...arguments);this.subtle=new SubtleCrypto}getRandomValues(r){const e=Buffer.from(r.buffer);l["default"].randomFillSync(e);return r}}Object.defineProperty(e,"CryptoKey",{enumerable:true,get:function(){return n.CryptoKey}});e.Crypto=Crypto},950:(r,e,t)=>{"use strict";t.r(e);t.d(e,{__extends:()=>__extends,__assign:()=>s,__rest:()=>__rest,__decorate:()=>__decorate,__param:()=>__param,__metadata:()=>__metadata,__awaiter:()=>__awaiter,__generator:()=>__generator,__createBinding:()=>o,__exportStar:()=>__exportStar,__values:()=>__values,__read:()=>__read,__spread:()=>__spread,__spreadArrays:()=>__spreadArrays,__spreadArray:()=>__spreadArray,__await:()=>__await,__asyncGenerator:()=>__asyncGenerator,__asyncDelegator:()=>__asyncDelegator,__asyncValues:()=>__asyncValues,__makeTemplateObject:()=>__makeTemplateObject,__importStar:()=>__importStar,__importDefault:()=>__importDefault,__classPrivateFieldGet:()=>__classPrivateFieldGet,__classPrivateFieldSet:()=>__classPrivateFieldSet});var n=function(r,e){n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,e){r.__proto__=e}||function(r,e){for(var t in e)if(Object.prototype.hasOwnProperty.call(e,t))r[t]=e[t]};return n(r,e)};function __extends(r,e){if(typeof e!=="function"&&e!==null)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");n(r,e);function __(){this.constructor=r}r.prototype=e===null?Object.create(e):(__.prototype=e.prototype,new __)}var s=function(){s=Object.assign||function __assign(r){for(var e,t=1,n=arguments.length;t<n;t++){e=arguments[t];for(var s in e)if(Object.prototype.hasOwnProperty.call(e,s))r[s]=e[s]}return r};return s.apply(this,arguments)};function __rest(r,e){var t={};for(var n in r)if(Object.prototype.hasOwnProperty.call(r,n)&&e.indexOf(n)<0)t[n]=r[n];if(r!=null&&typeof Object.getOwnPropertySymbols==="function")for(var s=0,n=Object.getOwnPropertySymbols(r);s<n.length;s++){if(e.indexOf(n[s])<0&&Object.prototype.propertyIsEnumerable.call(r,n[s]))t[n[s]]=r[n[s]]}return t}function __decorate(r,e,t,n){var s=arguments.length,o=s<3?e:n===null?n=Object.getOwnPropertyDescriptor(e,t):n,i;if(typeof Reflect==="object"&&typeof Reflect.decorate==="function")o=Reflect.decorate(r,e,t,n);else for(var a=r.length-1;a>=0;a--)if(i=r[a])o=(s<3?i(o):s>3?i(e,t,o):i(e,t))||o;return s>3&&o&&Object.defineProperty(e,t,o),o}function __param(r,e){return function(t,n){e(t,n,r)}}function __metadata(r,e){if(typeof Reflect==="object"&&typeof Reflect.metadata==="function")return Reflect.metadata(r,e)}function __awaiter(r,e,t,n){function adopt(r){return r instanceof t?r:new t(function(e){e(r)})}return new(t||(t=Promise))(function(t,s){function fulfilled(r){try{step(n.next(r))}catch(r){s(r)}}function rejected(r){try{step(n["throw"](r))}catch(r){s(r)}}function step(r){r.done?t(r.value):adopt(r.value).then(fulfilled,rejected)}step((n=n.apply(r,e||[])).next())})}function __generator(r,e){var t={label:0,sent:function(){if(o[0]&1)throw o[1];return o[1]},trys:[],ops:[]},n,s,o,i;return i={next:verb(0),throw:verb(1),return:verb(2)},typeof Symbol==="function"&&(i[Symbol.iterator]=function(){return this}),i;function verb(r){return function(e){return step([r,e])}}function step(i){if(n)throw new TypeError("Generator is already executing.");while(t)try{if(n=1,s&&(o=i[0]&2?s["return"]:i[0]?s["throw"]||((o=s["return"])&&o.call(s),0):s.next)&&!(o=o.call(s,i[1])).done)return o;if(s=0,o)i=[i[0]&2,o.value];switch(i[0]){case 0:case 1:o=i;break;case 4:t.label++;return{value:i[1],done:false};case 5:t.label++;s=i[1];i=[0];continue;case 7:i=t.ops.pop();t.trys.pop();continue;default:if(!(o=t.trys,o=o.length>0&&o[o.length-1])&&(i[0]===6||i[0]===2)){t=0;continue}if(i[0]===3&&(!o||i[1]>o[0]&&i[1]<o[3])){t.label=i[1];break}if(i[0]===6&&t.label<o[1]){t.label=o[1];o=i;break}if(o&&t.label<o[2]){t.label=o[2];t.ops.push(i);break}if(o[2])t.ops.pop();t.trys.pop();continue}i=e.call(r,t)}catch(r){i=[6,r];s=0}finally{n=o=0}if(i[0]&5)throw i[1];return{value:i[0]?i[1]:void 0,done:true}}}var o=Object.create?function(r,e,t,n){if(n===undefined)n=t;Object.defineProperty(r,n,{enumerable:true,get:function(){return e[t]}})}:function(r,e,t,n){if(n===undefined)n=t;r[n]=e[t]};function __exportStar(r,e){for(var t in r)if(t!=="default"&&!Object.prototype.hasOwnProperty.call(e,t))o(e,r,t)}function __values(r){var e=typeof Symbol==="function"&&Symbol.iterator,t=e&&r[e],n=0;if(t)return t.call(r);if(r&&typeof r.length==="number")return{next:function(){if(r&&n>=r.length)r=void 0;return{value:r&&r[n++],done:!r}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function __read(r,e){var t=typeof Symbol==="function"&&r[Symbol.iterator];if(!t)return r;var n=t.call(r),s,o=[],i;try{while((e===void 0||e-- >0)&&!(s=n.next()).done)o.push(s.value)}catch(r){i={error:r}}finally{try{if(s&&!s.done&&(t=n["return"]))t.call(n)}finally{if(i)throw i.error}}return o}function __spread(){for(var r=[],e=0;e<arguments.length;e++)r=r.concat(__read(arguments[e]));return r}function __spreadArrays(){for(var r=0,e=0,t=arguments.length;e<t;e++)r+=arguments[e].length;for(var n=Array(r),s=0,e=0;e<t;e++)for(var o=arguments[e],i=0,a=o.length;i<a;i++,s++)n[s]=o[i];return n}function __spreadArray(r,e){for(var t=0,n=e.length,s=r.length;t<n;t++,s++)r[s]=e[t];return r}function __await(r){return this instanceof __await?(this.v=r,this):new __await(r)}function __asyncGenerator(r,e,t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var n=t.apply(r,e||[]),s,o=[];return s={},verb("next"),verb("throw"),verb("return"),s[Symbol.asyncIterator]=function(){return this},s;function verb(r){if(n[r])s[r]=function(e){return new Promise(function(t,n){o.push([r,e,t,n])>1||resume(r,e)})}}function resume(r,e){try{step(n[r](e))}catch(r){settle(o[0][3],r)}}function step(r){r.value instanceof __await?Promise.resolve(r.value.v).then(fulfill,reject):settle(o[0][2],r)}function fulfill(r){resume("next",r)}function reject(r){resume("throw",r)}function settle(r,e){if(r(e),o.shift(),o.length)resume(o[0][0],o[0][1])}}function __asyncDelegator(r){var e,t;return e={},verb("next"),verb("throw",function(r){throw r}),verb("return"),e[Symbol.iterator]=function(){return this},e;function verb(n,s){e[n]=r[n]?function(e){return(t=!t)?{value:__await(r[n](e)),done:n==="return"}:s?s(e):e}:s}}function __asyncValues(r){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e=r[Symbol.asyncIterator],t;return e?e.call(r):(r=typeof __values==="function"?__values(r):r[Symbol.iterator](),t={},verb("next"),verb("throw"),verb("return"),t[Symbol.asyncIterator]=function(){return this},t);function verb(e){t[e]=r[e]&&function(t){return new Promise(function(n,s){t=r[e](t),settle(n,s,t.done,t.value)})}}function settle(r,e,t,n){Promise.resolve(n).then(function(e){r({value:e,done:t})},e)}}function __makeTemplateObject(r,e){if(Object.defineProperty){Object.defineProperty(r,"raw",{value:e})}else{r.raw=e}return r}var i=Object.create?function(r,e){Object.defineProperty(r,"default",{enumerable:true,value:e})}:function(r,e){r["default"]=e};function __importStar(r){if(r&&r.__esModule)return r;var e={};if(r!=null)for(var t in r)if(t!=="default"&&Object.prototype.hasOwnProperty.call(r,t))o(e,r,t);i(e,r);return e}function __importDefault(r){return r&&r.__esModule?r:{default:r}}function __classPrivateFieldGet(r,e,t,n){if(t==="a"&&!n)throw new TypeError("Private accessor was defined without a getter");if(typeof e==="function"?r!==e||!n:!e.has(r))throw new TypeError("Cannot read private member from an object whose class did not declare it");return t==="m"?n:t==="a"?n.call(r):n?n.value:e.get(r)}function __classPrivateFieldSet(r,e,t,n,s){if(n==="m")throw new TypeError("Private method is not writable");if(n==="a"&&!s)throw new TypeError("Private accessor was defined without a setter");if(typeof e==="function"?r!==e||!s:!e.has(r))throw new TypeError("Cannot write private member to an object whose class did not declare it");return n==="a"?s.call(r,t):s?s.value=t:e.set(r,t),t}},528:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.fromBER=fromBER;e.compareSchema=compareSchema;e.verifySchema=verifySchema;e.fromJSON=fromJSON;e.RawData=e.Repeated=e.Any=e.Choice=e.TIME=e.Duration=e.DateTime=e.TimeOfDay=e.DATE=e.GeneralizedTime=e.UTCTime=e.CharacterString=e.GeneralString=e.VisibleString=e.GraphicString=e.IA5String=e.VideotexString=e.TeletexString=e.PrintableString=e.NumericString=e.UniversalString=e.BmpString=e.RelativeObjectIdentifier=e.Utf8String=e.ObjectIdentifier=e.Enumerated=e.Integer=e.BitString=e.OctetString=e.Null=e.Set=e.Sequence=e.Boolean=e.EndOfContent=e.Constructed=e.Primitive=e.BaseBlock=e.ValueBlock=e.HexBlock=void 0;var n=t(209);function _createForOfIteratorHelper(r,t){var o;if(typeof Symbol==="undefined"||r[Symbol.iterator]==null){if(Array.isArray(r)||(o=_unsupportedIterableToArray(r))||t&&r&&typeof r.length==="number"){if(o)r=o;var i=0;var a=function F(){};return{s:a,n:function n(){if(i>=r.length)return{done:true};return{done:false,value:r[i++]}},e:function e(r){throw r},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var c=true,u=false,l;return{s:function s(){o=r[Symbol.iterator]()},n:function n(){var r=o.next();c=r.done;return r},e:function e(r){u=true;l=r},f:function f(){try{if(!c&&o.return!=null)o.return()}finally{if(u)throw l}}}}function _unsupportedIterableToArray(r,e){if(!r)return;if(typeof r==="string")return _arrayLikeToArray(r,e);var t=Object.prototype.toString.call(r).slice(8,-1);if(t==="Object"&&r.constructor)t=r.constructor.name;if(t==="Map"||t==="Set")return Array.from(r);if(t==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t))return _arrayLikeToArray(r,e)}function _arrayLikeToArray(r,e){if(e==null||e>r.length)e=r.length;for(var t=0,n=new Array(e);t<e;t++)n[t]=r[t];return n}const s=[new Uint8Array([1])];const o="0123456789";class LocalBaseBlock{constructor(r={}){this.blockLength=(0,n.getParametersValue)(r,"blockLength",0);this.error=(0,n.getParametersValue)(r,"error","");this.warnings=(0,n.getParametersValue)(r,"warnings",[]);if("valueBeforeDecode"in r)this.valueBeforeDecode=r.valueBeforeDecode.slice(0);else this.valueBeforeDecode=new ArrayBuffer(0)}static blockName(){return"baseBlock"}toJSON(){return{blockName:this.constructor.blockName(),blockLength:this.blockLength,error:this.error,warnings:this.warnings,valueBeforeDecode:(0,n.bufferToHexCodes)(this.valueBeforeDecode,0,this.valueBeforeDecode.byteLength)}}}const i=r=>(class LocalHexBlockMixin extends r{constructor(r={}){super(r);this.isHexOnly=(0,n.getParametersValue)(r,"isHexOnly",false);if("valueHex"in r)this.valueHex=r.valueHex.slice(0);else this.valueHex=new ArrayBuffer(0)}static blockName(){return"hexBlock"}fromBER(r,e,t){if((0,n.checkBufferParams)(this,r,e,t)===false)return-1;const s=new Uint8Array(r,e,t);if(s.length===0){this.warnings.push("Zero buffer length");return e}this.valueHex=r.slice(e,e+t);this.blockLength=t;return e+t}toBER(r=false){if(this.isHexOnly!==true){this.error='Flag "isHexOnly" is not set, abort';return new ArrayBuffer(0)}if(r===true)return new ArrayBuffer(this.valueHex.byteLength);return this.valueHex.slice(0)}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.blockName=this.constructor.blockName();r.isHexOnly=this.isHexOnly;r.valueHex=(0,n.bufferToHexCodes)(this.valueHex,0,this.valueHex.byteLength);return r}});e.HexBlock=i;class LocalIdentificationBlock extends(i(LocalBaseBlock)){constructor(r={}){super();if("idBlock"in r){this.isHexOnly=(0,n.getParametersValue)(r.idBlock,"isHexOnly",false);this.valueHex=(0,n.getParametersValue)(r.idBlock,"valueHex",new ArrayBuffer(0));this.tagClass=(0,n.getParametersValue)(r.idBlock,"tagClass",-1);this.tagNumber=(0,n.getParametersValue)(r.idBlock,"tagNumber",-1);this.isConstructed=(0,n.getParametersValue)(r.idBlock,"isConstructed",false)}else{this.tagClass=-1;this.tagNumber=-1;this.isConstructed=false}}static blockName(){return"identificationBlock"}toBER(r=false){let e=0;let t;let s;switch(this.tagClass){case 1:e|=0;break;case 2:e|=64;break;case 3:e|=128;break;case 4:e|=192;break;default:this.error="Unknown tag class";return new ArrayBuffer(0)}if(this.isConstructed)e|=32;if(this.tagNumber<31&&!this.isHexOnly){t=new ArrayBuffer(1);s=new Uint8Array(t);if(!r){let r=this.tagNumber;r&=31;e|=r;s[0]=e}return t}if(this.isHexOnly===false){const o=(0,n.utilToBase)(this.tagNumber,7);const i=new Uint8Array(o);const a=o.byteLength;t=new ArrayBuffer(a+1);s=new Uint8Array(t);s[0]=e|31;if(!r){for(let r=0;r<a-1;r++)s[r+1]=i[r]|128;s[a]=i[a-1]}return t}t=new ArrayBuffer(this.valueHex.byteLength+1);s=new Uint8Array(t);s[0]=e|31;if(r===false){const r=new Uint8Array(this.valueHex);for(let e=0;e<r.length-1;e++)s[e+1]=r[e]|128;s[this.valueHex.byteLength]=r[r.length-1]}return t}fromBER(r,e,t){if((0,n.checkBufferParams)(this,r,e,t)===false)return-1;const s=new Uint8Array(r,e,t);if(s.length===0){this.error="Zero buffer length";return-1}const o=s[0]&192;switch(o){case 0:this.tagClass=1;break;case 64:this.tagClass=2;break;case 128:this.tagClass=3;break;case 192:this.tagClass=4;break;default:this.error="Unknown tag class";return-1}this.isConstructed=(s[0]&32)===32;this.isHexOnly=false;const i=s[0]&31;if(i!==31){this.tagNumber=i;this.blockLength=1}else{let r=1;this.valueHex=new ArrayBuffer(255);let e=255;let t=new Uint8Array(this.valueHex);while(s[r]&128){t[r-1]=s[r]&127;r++;if(r>=s.length){this.error="End of input reached before message was fully decoded";return-1}if(r===e){e+=255;const r=new ArrayBuffer(e);const n=new Uint8Array(r);for(let r=0;r<t.length;r++)n[r]=t[r];this.valueHex=new ArrayBuffer(e);t=new Uint8Array(this.valueHex)}}this.blockLength=r+1;t[r-1]=s[r]&127;const o=new ArrayBuffer(r);const i=new Uint8Array(o);for(let e=0;e<r;e++)i[e]=t[e];this.valueHex=new ArrayBuffer(r);t=new Uint8Array(this.valueHex);t.set(i);if(this.blockLength<=9)this.tagNumber=(0,n.utilFromBase)(t,7);else{this.isHexOnly=true;this.warnings.push("Tag too long, represented as hex-coded")}}if(this.tagClass===1&&this.isConstructed){switch(this.tagNumber){case 1:case 2:case 5:case 6:case 9:case 13:case 14:case 23:case 24:case 31:case 32:case 33:case 34:this.error="Constructed encoding used for primitive type";return-1;default:}}return e+this.blockLength}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.blockName=this.constructor.blockName();r.tagClass=this.tagClass;r.tagNumber=this.tagNumber;r.isConstructed=this.isConstructed;return r}}class LocalLengthBlock extends LocalBaseBlock{constructor(r={}){super();if("lenBlock"in r){this.isIndefiniteForm=(0,n.getParametersValue)(r.lenBlock,"isIndefiniteForm",false);this.longFormUsed=(0,n.getParametersValue)(r.lenBlock,"longFormUsed",false);this.length=(0,n.getParametersValue)(r.lenBlock,"length",0)}else{this.isIndefiniteForm=false;this.longFormUsed=false;this.length=0}}static blockName(){return"lengthBlock"}fromBER(r,e,t){if((0,n.checkBufferParams)(this,r,e,t)===false)return-1;const s=new Uint8Array(r,e,t);if(s.length===0){this.error="Zero buffer length";return-1}if(s[0]===255){this.error="Length block 0xFF is reserved by standard";return-1}this.isIndefiniteForm=s[0]===128;if(this.isIndefiniteForm===true){this.blockLength=1;return e+this.blockLength}this.longFormUsed=!!(s[0]&128);if(this.longFormUsed===false){this.length=s[0];this.blockLength=1;return e+this.blockLength}const o=s[0]&127;if(o>8){this.error="Too big integer";return-1}if(o+1>s.length){this.error="End of input reached before message was fully decoded";return-1}const i=new Uint8Array(o);for(let r=0;r<o;r++)i[r]=s[r+1];if(i[o-1]===0)this.warnings.push("Needlessly long encoded length");this.length=(0,n.utilFromBase)(i,8);if(this.longFormUsed&&this.length<=127)this.warnings.push("Unnecessary usage of long length form");this.blockLength=o+1;return e+this.blockLength}toBER(r=false){let e;let t;if(this.length>127)this.longFormUsed=true;if(this.isIndefiniteForm){e=new ArrayBuffer(1);if(r===false){t=new Uint8Array(e);t[0]=128}return e}if(this.longFormUsed===true){const s=(0,n.utilToBase)(this.length,8);if(s.byteLength>127){this.error="Too big length";return new ArrayBuffer(0)}e=new ArrayBuffer(s.byteLength+1);if(r===true)return e;const o=new Uint8Array(s);t=new Uint8Array(e);t[0]=s.byteLength|128;for(let r=0;r<s.byteLength;r++)t[r+1]=o[r];return e}e=new ArrayBuffer(1);if(r===false){t=new Uint8Array(e);t[0]=this.length}return e}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.blockName=this.constructor.blockName();r.isIndefiniteForm=this.isIndefiniteForm;r.longFormUsed=this.longFormUsed;r.length=this.length;return r}}class ValueBlock extends LocalBaseBlock{constructor(r={}){super(r)}static blockName(){return"valueBlock"}fromBER(r,e,t){throw TypeError('User need to make a specific function in a class which extends "ValueBlock"')}toBER(r=false){throw TypeError('User need to make a specific function in a class which extends "ValueBlock"')}}e.ValueBlock=ValueBlock;class BaseBlock extends LocalBaseBlock{constructor(r={},e=ValueBlock){super(r);if("name"in r)this.name=r.name;if("optional"in r)this.optional=r.optional;if("primitiveSchema"in r)this.primitiveSchema=r.primitiveSchema;this.idBlock=new LocalIdentificationBlock(r);this.lenBlock=new LocalLengthBlock(r);this.valueBlock=new e(r)}static blockName(){return"BaseBlock"}fromBER(r,e,t){const n=this.valueBlock.fromBER(r,e,this.lenBlock.isIndefiniteForm===true?t:this.lenBlock.length);if(n===-1){this.error=this.valueBlock.error;return n}if(this.idBlock.error.length===0)this.blockLength+=this.idBlock.blockLength;if(this.lenBlock.error.length===0)this.blockLength+=this.lenBlock.blockLength;if(this.valueBlock.error.length===0)this.blockLength+=this.valueBlock.blockLength;return n}toBER(r=false){let e;const t=this.idBlock.toBER(r);const s=this.valueBlock.toBER(true);this.lenBlock.length=s.byteLength;const o=this.lenBlock.toBER(r);e=(0,n.utilConcatBuf)(t,o);let i;if(r===false)i=this.valueBlock.toBER(r);else i=new ArrayBuffer(this.lenBlock.length);e=(0,n.utilConcatBuf)(e,i);if(this.lenBlock.isIndefiniteForm===true){const t=new ArrayBuffer(2);if(r===false){const r=new Uint8Array(t);r[0]=0;r[1]=0}e=(0,n.utilConcatBuf)(e,t)}return e}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.idBlock=this.idBlock.toJSON();r.lenBlock=this.lenBlock.toJSON();r.valueBlock=this.valueBlock.toJSON();if("name"in this)r.name=this.name;if("optional"in this)r.optional=this.optional;if("primitiveSchema"in this)r.primitiveSchema=this.primitiveSchema.toJSON();return r}toString(){return`${this.constructor.blockName()} : ${(0,n.bufferToHexCodes)(this.valueBlock.valueHex)}`}}e.BaseBlock=BaseBlock;class LocalPrimitiveValueBlock extends ValueBlock{constructor(r={}){super(r);if("valueHex"in r)this.valueHex=r.valueHex.slice(0);else this.valueHex=new ArrayBuffer(0);this.isHexOnly=(0,n.getParametersValue)(r,"isHexOnly",true)}fromBER(r,e,t){if((0,n.checkBufferParams)(this,r,e,t)===false)return-1;const s=new Uint8Array(r,e,t);if(s.length===0){this.warnings.push("Zero buffer length");return e}this.valueHex=new ArrayBuffer(s.length);const o=new Uint8Array(this.valueHex);for(let r=0;r<s.length;r++)o[r]=s[r];this.blockLength=t;return e+t}toBER(r=false){return this.valueHex.slice(0)}static blockName(){return"PrimitiveValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.valueHex=(0,n.bufferToHexCodes)(this.valueHex,0,this.valueHex.byteLength);r.isHexOnly=this.isHexOnly;return r}}class Primitive extends BaseBlock{constructor(r={}){super(r,LocalPrimitiveValueBlock);this.idBlock.isConstructed=false}static blockName(){return"PRIMITIVE"}}e.Primitive=Primitive;class LocalConstructedValueBlock extends ValueBlock{constructor(r={}){super(r);this.value=(0,n.getParametersValue)(r,"value",[]);this.isIndefiniteForm=(0,n.getParametersValue)(r,"isIndefiniteForm",false)}fromBER(r,e,t){const s=e;const o=t;if((0,n.checkBufferParams)(this,r,e,t)===false)return-1;const i=new Uint8Array(r,e,t);if(i.length===0){this.warnings.push("Zero buffer length");return e}function checkLen(r,e){if(r===true)return 1;return e}let a=e;while(checkLen(this.isIndefiniteForm,t)>0){const e=LocalFromBER(r,a,t);if(e.offset===-1){this.error=e.result.error;this.warnings.concat(e.result.warnings);return-1}a=e.offset;this.blockLength+=e.result.blockLength;t-=e.result.blockLength;this.value.push(e.result);if(this.isIndefiniteForm===true&&e.result.constructor.blockName()===EndOfContent.blockName())break}if(this.isIndefiniteForm===true){if(this.value[this.value.length-1].constructor.blockName()===EndOfContent.blockName())this.value.pop();else this.warnings.push("No EndOfContent block encoded")}this.valueBeforeDecode=r.slice(s,s+o);return a}toBER(r=false){let e=new ArrayBuffer(0);for(let t=0;t<this.value.length;t++){const s=this.value[t].toBER(r);e=(0,n.utilConcatBuf)(e,s)}return e}static blockName(){return"ConstructedValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.isIndefiniteForm=this.isIndefiniteForm;r.value=[];for(let e=0;e<this.value.length;e++)r.value.push(this.value[e].toJSON());return r}}class Constructed extends BaseBlock{constructor(r={}){super(r,LocalConstructedValueBlock);this.idBlock.isConstructed=true}static blockName(){return"CONSTRUCTED"}fromBER(r,e,t){this.valueBlock.isIndefiniteForm=this.lenBlock.isIndefiniteForm;const n=this.valueBlock.fromBER(r,e,this.lenBlock.isIndefiniteForm===true?t:this.lenBlock.length);if(n===-1){this.error=this.valueBlock.error;return n}if(this.idBlock.error.length===0)this.blockLength+=this.idBlock.blockLength;if(this.lenBlock.error.length===0)this.blockLength+=this.lenBlock.blockLength;if(this.valueBlock.error.length===0)this.blockLength+=this.valueBlock.blockLength;return n}toString(){const r=[];var e=_createForOfIteratorHelper(this.valueBlock.value),t;try{for(e.s();!(t=e.n()).done;){const e=t.value;r.push(e.toString().split("\n").map(r=>`  ${r}`).join("\n"))}}catch(r){e.e(r)}finally{e.f()}const n=this.idBlock.tagClass===3?`[${this.idBlock.tagNumber}]`:this.constructor.blockName();return r.length?`${n} :\n${r.join("\n")}`:`${n} :`}}e.Constructed=Constructed;class LocalEndOfContentValueBlock extends ValueBlock{constructor(r={}){super(r)}fromBER(r,e,t){return e}toBER(r=false){return new ArrayBuffer(0)}static blockName(){return"EndOfContentValueBlock"}}class EndOfContent extends BaseBlock{constructor(r={}){super(r,LocalEndOfContentValueBlock);this.idBlock.tagClass=1;this.idBlock.tagNumber=0}static blockName(){return"EndOfContent"}}e.EndOfContent=EndOfContent;class LocalBooleanValueBlock extends ValueBlock{constructor(r={}){super(r);this.value=(0,n.getParametersValue)(r,"value",false);this.isHexOnly=(0,n.getParametersValue)(r,"isHexOnly",false);if("valueHex"in r)this.valueHex=r.valueHex.slice(0);else{this.valueHex=new ArrayBuffer(1);if(this.value===true){const r=new Uint8Array(this.valueHex);r[0]=255}}}fromBER(r,e,t){if((0,n.checkBufferParams)(this,r,e,t)===false)return-1;const s=new Uint8Array(r,e,t);if(t>1)this.warnings.push("Boolean value encoded in more then 1 octet");this.isHexOnly=true;this.valueHex=new ArrayBuffer(s.length);const o=new Uint8Array(this.valueHex);for(let r=0;r<s.length;r++)o[r]=s[r];if(n.utilDecodeTC.call(this)!==0)this.value=true;else this.value=false;this.blockLength=t;return e+t}toBER(r=false){return this.valueHex}static blockName(){return"BooleanValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.value=this.value;r.isHexOnly=this.isHexOnly;r.valueHex=(0,n.bufferToHexCodes)(this.valueHex,0,this.valueHex.byteLength);return r}}class Boolean extends BaseBlock{constructor(r={}){super(r,LocalBooleanValueBlock);this.idBlock.tagClass=1;this.idBlock.tagNumber=1}static blockName(){return"BOOLEAN"}toString(){return`${this.constructor.blockName()} : ${this.valueBlock.value}`}}e.Boolean=Boolean;class Sequence extends Constructed{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=16}static blockName(){return"SEQUENCE"}}e.Sequence=Sequence;class Set extends Constructed{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=17}static blockName(){return"SET"}}e.Set=Set;class Null extends BaseBlock{constructor(r={}){super(r,LocalBaseBlock);this.idBlock.tagClass=1;this.idBlock.tagNumber=5}static blockName(){return"NULL"}fromBER(r,e,t){if(this.lenBlock.length>0)this.warnings.push("Non-zero length of value block for Null type");if(this.idBlock.error.length===0)this.blockLength+=this.idBlock.blockLength;if(this.lenBlock.error.length===0)this.blockLength+=this.lenBlock.blockLength;this.blockLength+=t;if(e+t>r.byteLength){this.error="End of input reached before message was fully decoded (inconsistent offset and length values)";return-1}return e+t}toBER(r=false){const e=new ArrayBuffer(2);if(r===true)return e;const t=new Uint8Array(e);t[0]=5;t[1]=0;return e}toString(){return`${this.constructor.blockName()}`}}e.Null=Null;class LocalOctetStringValueBlock extends(i(LocalConstructedValueBlock)){constructor(r={}){super(r);this.isConstructed=(0,n.getParametersValue)(r,"isConstructed",false)}fromBER(r,e,t){let n=0;if(this.isConstructed===true){this.isHexOnly=false;n=LocalConstructedValueBlock.prototype.fromBER.call(this,r,e,t);if(n===-1)return n;for(let r=0;r<this.value.length;r++){const e=this.value[r].constructor.blockName();if(e===EndOfContent.blockName()){if(this.isIndefiniteForm===true)break;else{this.error="EndOfContent is unexpected, OCTET STRING may consists of OCTET STRINGs only";return-1}}if(e!==OctetString.blockName()){this.error="OCTET STRING may consists of OCTET STRINGs only";return-1}}}else{this.isHexOnly=true;n=super.fromBER(r,e,t);this.blockLength=t}return n}toBER(r=false){if(this.isConstructed===true)return LocalConstructedValueBlock.prototype.toBER.call(this,r);let e=new ArrayBuffer(this.valueHex.byteLength);if(r===true)return e;if(this.valueHex.byteLength===0)return e;e=this.valueHex.slice(0);return e}static blockName(){return"OctetStringValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.isConstructed=this.isConstructed;r.isHexOnly=this.isHexOnly;r.valueHex=(0,n.bufferToHexCodes)(this.valueHex,0,this.valueHex.byteLength);return r}}class OctetString extends BaseBlock{constructor(r={}){super(r,LocalOctetStringValueBlock);this.idBlock.tagClass=1;this.idBlock.tagNumber=4}fromBER(r,e,t){this.valueBlock.isConstructed=this.idBlock.isConstructed;this.valueBlock.isIndefiniteForm=this.lenBlock.isIndefiniteForm;if(t===0){if(this.idBlock.error.length===0)this.blockLength+=this.idBlock.blockLength;if(this.lenBlock.error.length===0)this.blockLength+=this.lenBlock.blockLength;return e}if(!this.valueBlock.isConstructed){const n=r.slice(e,e+t);try{const r=fromBER(n);if(r.offset!==-1&&r.offset===t){this.valueBlock.value=[r.result]}}catch(r){}}return super.fromBER(r,e,t)}static blockName(){return"OCTET STRING"}isEqual(r){if(r instanceof OctetString===false)return false;if(JSON.stringify(this)!==JSON.stringify(r))return false;return true}toString(){if(this.valueBlock.isConstructed||this.valueBlock.value&&this.valueBlock.value.length){return Constructed.prototype.toString.call(this)}else{return`${this.constructor.blockName()} : ${(0,n.bufferToHexCodes)(this.valueBlock.valueHex)}`}}}e.OctetString=OctetString;class LocalBitStringValueBlock extends(i(LocalConstructedValueBlock)){constructor(r={}){super(r);this.unusedBits=(0,n.getParametersValue)(r,"unusedBits",0);this.isConstructed=(0,n.getParametersValue)(r,"isConstructed",false);this.blockLength=this.valueHex.byteLength}fromBER(r,e,t){if(t===0)return e;let s=-1;if(this.isConstructed===true){s=LocalConstructedValueBlock.prototype.fromBER.call(this,r,e,t);if(s===-1)return s;for(let r=0;r<this.value.length;r++){const e=this.value[r].constructor.blockName();if(e===EndOfContent.blockName()){if(this.isIndefiniteForm===true)break;else{this.error="EndOfContent is unexpected, BIT STRING may consists of BIT STRINGs only";return-1}}if(e!==BitString.blockName()){this.error="BIT STRING may consists of BIT STRINGs only";return-1}if(this.unusedBits>0&&this.value[r].valueBlock.unusedBits>0){this.error='Using of "unused bits" inside constructive BIT STRING allowed for least one only';return-1}this.unusedBits=this.value[r].valueBlock.unusedBits;if(this.unusedBits>7){this.error="Unused bits for BitString must be in range 0-7";return-1}}return s}if((0,n.checkBufferParams)(this,r,e,t)===false)return-1;const o=new Uint8Array(r,e,t);this.unusedBits=o[0];if(this.unusedBits>7){this.error="Unused bits for BitString must be in range 0-7";return-1}if(!this.unusedBits){const n=r.slice(e+1,e+t);try{const r=fromBER(n);if(r.offset!==-1&&r.offset===t-1){this.value=[r.result]}}catch(r){}}this.valueHex=new ArrayBuffer(o.length-1);const i=new Uint8Array(this.valueHex);for(let r=0;r<t-1;r++)i[r]=o[r+1];this.blockLength=o.length;return e+t}toBER(r=false){if(this.isConstructed===true)return LocalConstructedValueBlock.prototype.toBER.call(this,r);if(r===true)return new ArrayBuffer(this.valueHex.byteLength+1);if(this.valueHex.byteLength===0)return new ArrayBuffer(0);const e=new Uint8Array(this.valueHex);const t=new ArrayBuffer(this.valueHex.byteLength+1);const n=new Uint8Array(t);n[0]=this.unusedBits;for(let r=0;r<this.valueHex.byteLength;r++)n[r+1]=e[r];return t}static blockName(){return"BitStringValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.unusedBits=this.unusedBits;r.isConstructed=this.isConstructed;r.isHexOnly=this.isHexOnly;r.valueHex=(0,n.bufferToHexCodes)(this.valueHex,0,this.valueHex.byteLength);return r}}class BitString extends BaseBlock{constructor(r={}){super(r,LocalBitStringValueBlock);this.idBlock.tagClass=1;this.idBlock.tagNumber=3}static blockName(){return"BIT STRING"}fromBER(r,e,t){if(t===0)return e;this.valueBlock.isConstructed=this.idBlock.isConstructed;this.valueBlock.isIndefiniteForm=this.lenBlock.isIndefiniteForm;return super.fromBER(r,e,t)}isEqual(r){if(r instanceof BitString===false)return false;if(JSON.stringify(this)!==JSON.stringify(r))return false;return true}toString(){if(this.valueBlock.isConstructed||this.valueBlock.value&&this.valueBlock.value.length){return Constructed.prototype.toString.call(this)}else{const t=[];const n=new Uint8Array(this.valueBlock.valueHex);var r=_createForOfIteratorHelper(n),e;try{for(r.s();!(e=r.n()).done;){const r=e.value;t.push(r.toString(2).padStart(8,"0"))}}catch(e){r.e(e)}finally{r.f()}return`${this.constructor.blockName()} : ${t.join("")}`}}}e.BitString=BitString;class LocalIntegerValueBlock extends(i(ValueBlock)){constructor(r={}){super(r);if("value"in r)this.valueDec=r.value}set valueHex(r){this._valueHex=r.slice(0);if(r.byteLength>=4){this.warnings.push("Too big Integer for decoding, hex only");this.isHexOnly=true;this._valueDec=0}else{this.isHexOnly=false;if(r.byteLength>0)this._valueDec=n.utilDecodeTC.call(this)}}get valueHex(){return this._valueHex}set valueDec(r){this._valueDec=r;this.isHexOnly=false;this._valueHex=(0,n.utilEncodeTC)(r)}get valueDec(){return this._valueDec}fromDER(r,e,t,n=0){const s=this.fromBER(r,e,t);if(s===-1)return s;const o=new Uint8Array(this._valueHex);if(o[0]===0&&(o[1]&128)!==0){const r=new ArrayBuffer(this._valueHex.byteLength-1);const e=new Uint8Array(r);e.set(new Uint8Array(this._valueHex,1,this._valueHex.byteLength-1));this._valueHex=r.slice(0)}else{if(n!==0){if(this._valueHex.byteLength<n){if(n-this._valueHex.byteLength>1)n=this._valueHex.byteLength+1;const r=new ArrayBuffer(n);const e=new Uint8Array(r);e.set(o,n-this._valueHex.byteLength);this._valueHex=r.slice(0)}}}return s}toDER(r=false){const e=new Uint8Array(this._valueHex);switch(true){case(e[0]&128)!==0:{const r=new ArrayBuffer(this._valueHex.byteLength+1);const t=new Uint8Array(r);t[0]=0;t.set(e,1);this._valueHex=r.slice(0)}break;case e[0]===0&&(e[1]&128)===0:{const r=new ArrayBuffer(this._valueHex.byteLength-1);const e=new Uint8Array(r);e.set(new Uint8Array(this._valueHex,1,this._valueHex.byteLength-1));this._valueHex=r.slice(0)}break;default:}return this.toBER(r)}fromBER(r,e,t){const n=super.fromBER(r,e,t);if(n===-1)return n;this.blockLength=t;return e+t}toBER(r=false){return this.valueHex.slice(0)}static blockName(){return"IntegerValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.valueDec=this.valueDec;return r}toString(){function viewAdd(r,e){const t=new Uint8Array([0]);let s=new Uint8Array(r);let o=new Uint8Array(e);let i=s.slice(0);const a=i.length-1;let c=o.slice(0);const u=c.length-1;let f=0;const l=u<a?a:u;let h=0;for(let r=l;r>=0;r--,h++){switch(true){case h<c.length:f=i[a-h]+c[u-h]+t[0];break;default:f=i[a-h]+t[0]}t[0]=f/10;switch(true){case h>=i.length:i=(0,n.utilConcatView)(new Uint8Array([f%10]),i);break;default:i[a-h]=f%10}}if(t[0]>0)i=(0,n.utilConcatView)(t,i);return i.slice(0)}function power2(r){if(r>=s.length){for(let e=s.length;e<=r;e++){const r=new Uint8Array([0]);let t=s[e-1].slice(0);for(let e=t.length-1;e>=0;e--){const n=new Uint8Array([(t[e]<<1)+r[0]]);r[0]=n[0]/10;t[e]=n[0]%10}if(r[0]>0)t=(0,n.utilConcatView)(r,t);s.push(t)}}return s[r]}function viewSub(r,e){let t=0;let n=new Uint8Array(r);let s=new Uint8Array(e);let o=n.slice(0);const i=o.length-1;let a=s.slice(0);const c=a.length-1;let u;let f=0;for(let r=c;r>=0;r--,f++){u=o[i-f]-a[c-f]-t;switch(true){case u<0:t=1;o[i-f]=u+10;break;default:t=0;o[i-f]=u}}if(t>0){for(let r=i-c+1;r>=0;r--,f++){u=o[i-f]-t;if(u<0){t=1;o[i-f]=u+10}else{t=0;o[i-f]=u;break}}}return o.slice()}const r=this._valueHex.byteLength*8-1;let e=new Uint8Array(this._valueHex.byteLength*8/3);let t=0;let i;const a=new Uint8Array(this._valueHex);let c="";let u=false;for(let n=this._valueHex.byteLength-1;n>=0;n--){i=a[n];for(let n=0;n<8;n++){if((i&1)===1){switch(t){case r:e=viewSub(power2(t),e);c="-";break;default:e=viewAdd(e,power2(t))}}t++;i>>=1}}for(let r=0;r<e.length;r++){if(e[r])u=true;if(u)c+=o.charAt(e[r])}if(u===false)c+=o.charAt(0);return c}}class Integer extends BaseBlock{constructor(r={}){super(r,LocalIntegerValueBlock);this.idBlock.tagClass=1;this.idBlock.tagNumber=2}static blockName(){return"INTEGER"}isEqual(r){if(r instanceof Integer){if(this.valueBlock.isHexOnly&&r.valueBlock.isHexOnly)return(0,n.isEqualBuffer)(this.valueBlock.valueHex,r.valueBlock.valueHex);if(this.valueBlock.isHexOnly===r.valueBlock.isHexOnly)return this.valueBlock.valueDec===r.valueBlock.valueDec;return false}if(r instanceof ArrayBuffer)return(0,n.isEqualBuffer)(this.valueBlock.valueHex,r);return false}convertToDER(){const r=new Integer({valueHex:this.valueBlock.valueHex});r.valueBlock.toDER();return r}convertFromDER(){const r=this.valueBlock.valueHex.byteLength%2?this.valueBlock.valueHex.byteLength+1:this.valueBlock.valueHex.byteLength;const e=new Integer({valueHex:this.valueBlock.valueHex});e.valueBlock.fromDER(e.valueBlock.valueHex,0,e.valueBlock.valueHex.byteLength,r);return e}toString(){const r=(0,n.bufferToHexCodes)(this.valueBlock.valueHex);const e=BigInt(`0x${r}`);return`${this.constructor.blockName()} : ${e.toString()}`}}e.Integer=Integer;class Enumerated extends Integer{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=10}static blockName(){return"ENUMERATED"}}e.Enumerated=Enumerated;class LocalSidValueBlock extends(i(LocalBaseBlock)){constructor(r={}){super(r);this.valueDec=(0,n.getParametersValue)(r,"valueDec",-1);this.isFirstSid=(0,n.getParametersValue)(r,"isFirstSid",false)}static blockName(){return"sidBlock"}fromBER(r,e,t){if(t===0)return e;if((0,n.checkBufferParams)(this,r,e,t)===false)return-1;const s=new Uint8Array(r,e,t);this.valueHex=new ArrayBuffer(t);let o=new Uint8Array(this.valueHex);for(let r=0;r<t;r++){o[r]=s[r]&127;this.blockLength++;if((s[r]&128)===0)break}const i=new ArrayBuffer(this.blockLength);const a=new Uint8Array(i);for(let r=0;r<this.blockLength;r++)a[r]=o[r];this.valueHex=i.slice(0);o=new Uint8Array(this.valueHex);if((s[this.blockLength-1]&128)!==0){this.error="End of input reached before message was fully decoded";return-1}if(o[0]===0)this.warnings.push("Needlessly long format of SID encoding");if(this.blockLength<=8)this.valueDec=(0,n.utilFromBase)(o,7);else{this.isHexOnly=true;this.warnings.push("Too big SID for decoding, hex only")}return e+this.blockLength}toBER(r=false){let e;let t;if(this.isHexOnly){if(r===true)return new ArrayBuffer(this.valueHex.byteLength);const n=new Uint8Array(this.valueHex);e=new ArrayBuffer(this.blockLength);t=new Uint8Array(e);for(let r=0;r<this.blockLength-1;r++)t[r]=n[r]|128;t[this.blockLength-1]=n[this.blockLength-1];return e}const s=(0,n.utilToBase)(this.valueDec,7);if(s.byteLength===0){this.error="Error during encoding SID value";return new ArrayBuffer(0)}e=new ArrayBuffer(s.byteLength);if(r===false){const r=new Uint8Array(s);t=new Uint8Array(e);for(let e=0;e<s.byteLength-1;e++)t[e]=r[e]|128;t[s.byteLength-1]=r[s.byteLength-1]}return e}toString(){let r="";if(this.isHexOnly===true)r=(0,n.bufferToHexCodes)(this.valueHex,0,this.valueHex.byteLength);else{if(this.isFirstSid){let e=this.valueDec;if(this.valueDec<=39)r="0.";else{if(this.valueDec<=79){r="1.";e-=40}else{r="2.";e-=80}}r+=e.toString()}else r=this.valueDec.toString()}return r}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.valueDec=this.valueDec;r.isFirstSid=this.isFirstSid;return r}}class LocalObjectIdentifierValueBlock extends ValueBlock{constructor(r={}){super(r);this.fromString((0,n.getParametersValue)(r,"value",""))}fromBER(r,e,t){let n=e;while(t>0){const e=new LocalSidValueBlock;n=e.fromBER(r,n,t);if(n===-1){this.blockLength=0;this.error=e.error;return n}if(this.value.length===0)e.isFirstSid=true;this.blockLength+=e.blockLength;t-=e.blockLength;this.value.push(e)}return n}toBER(r=false){let e=new ArrayBuffer(0);for(let t=0;t<this.value.length;t++){const s=this.value[t].toBER(r);if(s.byteLength===0){this.error=this.value[t].error;return new ArrayBuffer(0)}e=(0,n.utilConcatBuf)(e,s)}return e}fromString(r){this.value=[];let e=0;let t=0;let n="";let s=false;do{t=r.indexOf(".",e);if(t===-1)n=r.substr(e);else n=r.substr(e,t-e);e=t+1;if(s){const r=this.value[0];let e=0;switch(r.valueDec){case 0:break;case 1:e=40;break;case 2:e=80;break;default:this.value=[];return false}const t=parseInt(n,10);if(isNaN(t))return true;r.valueDec=t+e;s=false}else{const r=new LocalSidValueBlock;r.valueDec=parseInt(n,10);if(isNaN(r.valueDec))return true;if(this.value.length===0){r.isFirstSid=true;s=true}this.value.push(r)}}while(t!==-1);return true}toString(){let r="";let e=false;for(let t=0;t<this.value.length;t++){e=this.value[t].isHexOnly;let n=this.value[t].toString();if(t!==0)r=`${r}.`;if(e){n=`{${n}}`;if(this.value[t].isFirstSid)r=`2.{${n} - 80}`;else r+=n}else r+=n}return r}static blockName(){return"ObjectIdentifierValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.value=this.toString();r.sidArray=[];for(let e=0;e<this.value.length;e++)r.sidArray.push(this.value[e].toJSON());return r}}class ObjectIdentifier extends BaseBlock{constructor(r={}){super(r,LocalObjectIdentifierValueBlock);this.idBlock.tagClass=1;this.idBlock.tagNumber=6}static blockName(){return"OBJECT IDENTIFIER"}toString(){return`${this.constructor.blockName()} : ${this.valueBlock.toString()}`}}e.ObjectIdentifier=ObjectIdentifier;class LocalUtf8StringValueBlock extends(i(LocalBaseBlock)){constructor(r={}){super(r);this.isHexOnly=true;this.value=""}static blockName(){return"Utf8StringValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.value=this.value;return r}}class Utf8String extends BaseBlock{constructor(r={}){super(r,LocalUtf8StringValueBlock);if("value"in r)this.fromString(r.value);this.idBlock.tagClass=1;this.idBlock.tagNumber=12}static blockName(){return"UTF8String"}fromBER(r,e,t){const n=this.valueBlock.fromBER(r,e,this.lenBlock.isIndefiniteForm===true?t:this.lenBlock.length);if(n===-1){this.error=this.valueBlock.error;return n}this.fromBuffer(this.valueBlock.valueHex);if(this.idBlock.error.length===0)this.blockLength+=this.idBlock.blockLength;if(this.lenBlock.error.length===0)this.blockLength+=this.lenBlock.blockLength;if(this.valueBlock.error.length===0)this.blockLength+=this.valueBlock.blockLength;return n}fromBuffer(r){this.valueBlock.value=String.fromCharCode.apply(null,new Uint8Array(r));try{this.valueBlock.value=decodeURIComponent(escape(this.valueBlock.value))}catch(r){this.warnings.push(`Error during "decodeURIComponent": ${r}, using raw string`)}}fromString(r){const e=unescape(encodeURIComponent(r));const t=e.length;this.valueBlock.valueHex=new ArrayBuffer(t);const n=new Uint8Array(this.valueBlock.valueHex);for(let r=0;r<t;r++)n[r]=e.charCodeAt(r);this.valueBlock.value=r}toString(){return`${this.constructor.blockName()} : ${this.valueBlock.value}`}}e.Utf8String=Utf8String;class LocalRelativeSidValueBlock extends(i(LocalBaseBlock)){constructor(r={}){super(r);this.valueDec=(0,n.getParametersValue)(r,"valueDec",-1)}static blockName(){return"relativeSidBlock"}fromBER(r,e,t){if(t===0)return e;if((0,n.checkBufferParams)(this,r,e,t)===false)return-1;const s=new Uint8Array(r,e,t);this.valueHex=new ArrayBuffer(t);let o=new Uint8Array(this.valueHex);for(let r=0;r<t;r++){o[r]=s[r]&127;this.blockLength++;if((s[r]&128)===0)break}const i=new ArrayBuffer(this.blockLength);const a=new Uint8Array(i);for(let r=0;r<this.blockLength;r++)a[r]=o[r];this.valueHex=i.slice(0);o=new Uint8Array(this.valueHex);if((s[this.blockLength-1]&128)!==0){this.error="End of input reached before message was fully decoded";return-1}if(o[0]===0)this.warnings.push("Needlessly long format of SID encoding");if(this.blockLength<=8)this.valueDec=(0,n.utilFromBase)(o,7);else{this.isHexOnly=true;this.warnings.push("Too big SID for decoding, hex only")}return e+this.blockLength}toBER(r=false){let e;let t;if(this.isHexOnly){if(r===true)return new ArrayBuffer(this.valueHex.byteLength);const n=new Uint8Array(this.valueHex);e=new ArrayBuffer(this.blockLength);t=new Uint8Array(e);for(let r=0;r<this.blockLength-1;r++)t[r]=n[r]|128;t[this.blockLength-1]=n[this.blockLength-1];return e}const s=(0,n.utilToBase)(this.valueDec,7);if(s.byteLength===0){this.error="Error during encoding SID value";return new ArrayBuffer(0)}e=new ArrayBuffer(s.byteLength);if(r===false){const r=new Uint8Array(s);t=new Uint8Array(e);for(let e=0;e<s.byteLength-1;e++)t[e]=r[e]|128;t[s.byteLength-1]=r[s.byteLength-1]}return e}toString(){let r="";if(this.isHexOnly===true)r=(0,n.bufferToHexCodes)(this.valueHex,0,this.valueHex.byteLength);else{r=this.valueDec.toString()}return r}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.valueDec=this.valueDec;return r}}class LocalRelativeObjectIdentifierValueBlock extends ValueBlock{constructor(r={}){super(r);this.fromString((0,n.getParametersValue)(r,"value",""))}fromBER(r,e,t){let n=e;while(t>0){const e=new LocalRelativeSidValueBlock;n=e.fromBER(r,n,t);if(n===-1){this.blockLength=0;this.error=e.error;return n}this.blockLength+=e.blockLength;t-=e.blockLength;this.value.push(e)}return n}toBER(r=false){let e=new ArrayBuffer(0);for(let t=0;t<this.value.length;t++){const s=this.value[t].toBER(r);if(s.byteLength===0){this.error=this.value[t].error;return new ArrayBuffer(0)}e=(0,n.utilConcatBuf)(e,s)}return e}fromString(r){this.value=[];let e=0;let t=0;let n="";do{t=r.indexOf(".",e);if(t===-1)n=r.substr(e);else n=r.substr(e,t-e);e=t+1;const s=new LocalRelativeSidValueBlock;s.valueDec=parseInt(n,10);if(isNaN(s.valueDec))return true;this.value.push(s)}while(t!==-1);return true}toString(){let r="";let e=false;for(let t=0;t<this.value.length;t++){e=this.value[t].isHexOnly;let n=this.value[t].toString();if(t!==0)r=`${r}.`;if(e){n=`{${n}}`;r+=n}else r+=n}return r}static blockName(){return"RelativeObjectIdentifierValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.value=this.toString();r.sidArray=[];for(let e=0;e<this.value.length;e++)r.sidArray.push(this.value[e].toJSON());return r}}class RelativeObjectIdentifier extends BaseBlock{constructor(r={}){super(r,LocalRelativeObjectIdentifierValueBlock);this.idBlock.tagClass=1;this.idBlock.tagNumber=13}static blockName(){return"RelativeObjectIdentifier"}}e.RelativeObjectIdentifier=RelativeObjectIdentifier;class LocalBmpStringValueBlock extends(i(LocalBaseBlock)){constructor(r={}){super(r);this.isHexOnly=true;this.value=""}static blockName(){return"BmpStringValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.value=this.value;return r}}class BmpString extends BaseBlock{constructor(r={}){super(r,LocalBmpStringValueBlock);if("value"in r)this.fromString(r.value);this.idBlock.tagClass=1;this.idBlock.tagNumber=30}static blockName(){return"BMPString"}fromBER(r,e,t){const n=this.valueBlock.fromBER(r,e,this.lenBlock.isIndefiniteForm===true?t:this.lenBlock.length);if(n===-1){this.error=this.valueBlock.error;return n}this.fromBuffer(this.valueBlock.valueHex);if(this.idBlock.error.length===0)this.blockLength+=this.idBlock.blockLength;if(this.lenBlock.error.length===0)this.blockLength+=this.lenBlock.blockLength;if(this.valueBlock.error.length===0)this.blockLength+=this.valueBlock.blockLength;return n}fromBuffer(r){const e=r.slice(0);const t=new Uint8Array(e);for(let r=0;r<t.length;r+=2){const e=t[r];t[r]=t[r+1];t[r+1]=e}this.valueBlock.value=String.fromCharCode.apply(null,new Uint16Array(e))}fromString(r){const e=r.length;this.valueBlock.valueHex=new ArrayBuffer(e*2);const t=new Uint8Array(this.valueBlock.valueHex);for(let s=0;s<e;s++){const e=(0,n.utilToBase)(r.charCodeAt(s),8);const o=new Uint8Array(e);if(o.length>2)continue;const i=2-o.length;for(let r=o.length-1;r>=0;r--)t[s*2+r+i]=o[r]}this.valueBlock.value=r}toString(){return`${this.constructor.blockName()} : ${this.valueBlock.value}`}}e.BmpString=BmpString;class LocalUniversalStringValueBlock extends(i(LocalBaseBlock)){constructor(r={}){super(r);this.isHexOnly=true;this.value=""}static blockName(){return"UniversalStringValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.value=this.value;return r}}class UniversalString extends BaseBlock{constructor(r={}){super(r,LocalUniversalStringValueBlock);if("value"in r)this.fromString(r.value);this.idBlock.tagClass=1;this.idBlock.tagNumber=28}static blockName(){return"UniversalString"}fromBER(r,e,t){const n=this.valueBlock.fromBER(r,e,this.lenBlock.isIndefiniteForm===true?t:this.lenBlock.length);if(n===-1){this.error=this.valueBlock.error;return n}this.fromBuffer(this.valueBlock.valueHex);if(this.idBlock.error.length===0)this.blockLength+=this.idBlock.blockLength;if(this.lenBlock.error.length===0)this.blockLength+=this.lenBlock.blockLength;if(this.valueBlock.error.length===0)this.blockLength+=this.valueBlock.blockLength;return n}fromBuffer(r){const e=r.slice(0);const t=new Uint8Array(e);for(let r=0;r<t.length;r+=4){t[r]=t[r+3];t[r+1]=t[r+2];t[r+2]=0;t[r+3]=0}this.valueBlock.value=String.fromCharCode.apply(null,new Uint32Array(e))}fromString(r){const e=r.length;this.valueBlock.valueHex=new ArrayBuffer(e*4);const t=new Uint8Array(this.valueBlock.valueHex);for(let s=0;s<e;s++){const e=(0,n.utilToBase)(r.charCodeAt(s),8);const o=new Uint8Array(e);if(o.length>4)continue;const i=4-o.length;for(let r=o.length-1;r>=0;r--)t[s*4+r+i]=o[r]}this.valueBlock.value=r}toString(){return`${this.constructor.blockName()} : ${this.valueBlock.value}`}}e.UniversalString=UniversalString;class LocalSimpleStringValueBlock extends(i(LocalBaseBlock)){constructor(r={}){super(r);this.value="";this.isHexOnly=true}static blockName(){return"SimpleStringValueBlock"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.value=this.value;return r}}class LocalSimpleStringBlock extends BaseBlock{constructor(r={}){super(r,LocalSimpleStringValueBlock);if("value"in r)this.fromString(r.value)}static blockName(){return"SIMPLESTRING"}fromBER(r,e,t){const n=this.valueBlock.fromBER(r,e,this.lenBlock.isIndefiniteForm===true?t:this.lenBlock.length);if(n===-1){this.error=this.valueBlock.error;return n}this.fromBuffer(this.valueBlock.valueHex);if(this.idBlock.error.length===0)this.blockLength+=this.idBlock.blockLength;if(this.lenBlock.error.length===0)this.blockLength+=this.lenBlock.blockLength;if(this.valueBlock.error.length===0)this.blockLength+=this.valueBlock.blockLength;return n}fromBuffer(r){this.valueBlock.value=String.fromCharCode.apply(null,new Uint8Array(r))}fromString(r){const e=r.length;this.valueBlock.valueHex=new ArrayBuffer(e);const t=new Uint8Array(this.valueBlock.valueHex);for(let n=0;n<e;n++)t[n]=r.charCodeAt(n);this.valueBlock.value=r}toString(){return`${this.constructor.blockName()} : ${this.valueBlock.value}`}}class NumericString extends LocalSimpleStringBlock{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=18}static blockName(){return"NumericString"}}e.NumericString=NumericString;class PrintableString extends LocalSimpleStringBlock{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=19}static blockName(){return"PrintableString"}}e.PrintableString=PrintableString;class TeletexString extends LocalSimpleStringBlock{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=20}static blockName(){return"TeletexString"}}e.TeletexString=TeletexString;class VideotexString extends LocalSimpleStringBlock{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=21}static blockName(){return"VideotexString"}}e.VideotexString=VideotexString;class IA5String extends LocalSimpleStringBlock{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=22}static blockName(){return"IA5String"}}e.IA5String=IA5String;class GraphicString extends LocalSimpleStringBlock{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=25}static blockName(){return"GraphicString"}}e.GraphicString=GraphicString;class VisibleString extends LocalSimpleStringBlock{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=26}static blockName(){return"VisibleString"}}e.VisibleString=VisibleString;class GeneralString extends LocalSimpleStringBlock{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=27}static blockName(){return"GeneralString"}}e.GeneralString=GeneralString;class CharacterString extends LocalSimpleStringBlock{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=29}static blockName(){return"CharacterString"}}e.CharacterString=CharacterString;class UTCTime extends VisibleString{constructor(r={}){super(r);this.year=0;this.month=0;this.day=0;this.hour=0;this.minute=0;this.second=0;if("value"in r){this.fromString(r.value);this.valueBlock.valueHex=new ArrayBuffer(r.value.length);const e=new Uint8Array(this.valueBlock.valueHex);for(let t=0;t<r.value.length;t++)e[t]=r.value.charCodeAt(t)}if("valueDate"in r){this.fromDate(r.valueDate);this.valueBlock.valueHex=this.toBuffer()}this.idBlock.tagClass=1;this.idBlock.tagNumber=23}fromBER(r,e,t){const n=this.valueBlock.fromBER(r,e,this.lenBlock.isIndefiniteForm===true?t:this.lenBlock.length);if(n===-1){this.error=this.valueBlock.error;return n}this.fromBuffer(this.valueBlock.valueHex);if(this.idBlock.error.length===0)this.blockLength+=this.idBlock.blockLength;if(this.lenBlock.error.length===0)this.blockLength+=this.lenBlock.blockLength;if(this.valueBlock.error.length===0)this.blockLength+=this.valueBlock.blockLength;return n}fromBuffer(r){this.fromString(String.fromCharCode.apply(null,new Uint8Array(r)))}toBuffer(){const r=this.toString();const e=new ArrayBuffer(r.length);const t=new Uint8Array(e);for(let e=0;e<r.length;e++)t[e]=r.charCodeAt(e);return e}fromDate(r){this.year=r.getUTCFullYear();this.month=r.getUTCMonth()+1;this.day=r.getUTCDate();this.hour=r.getUTCHours();this.minute=r.getUTCMinutes();this.second=r.getUTCSeconds()}toDate(){return new Date(Date.UTC(this.year,this.month-1,this.day,this.hour,this.minute,this.second))}fromString(r){const e=/(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})Z/gi;const t=e.exec(r);if(t===null){this.error="Wrong input string for convertion";return}const n=parseInt(t[1],10);if(n>=50)this.year=1900+n;else this.year=2e3+n;this.month=parseInt(t[2],10);this.day=parseInt(t[3],10);this.hour=parseInt(t[4],10);this.minute=parseInt(t[5],10);this.second=parseInt(t[6],10)}toString(){const r=new Array(7);r[0]=(0,n.padNumber)(this.year<2e3?this.year-1900:this.year-2e3,2);r[1]=(0,n.padNumber)(this.month,2);r[2]=(0,n.padNumber)(this.day,2);r[3]=(0,n.padNumber)(this.hour,2);r[4]=(0,n.padNumber)(this.minute,2);r[5]=(0,n.padNumber)(this.second,2);r[6]="Z";return r.join("")}static blockName(){return"UTCTime"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.year=this.year;r.month=this.month;r.day=this.day;r.hour=this.hour;r.minute=this.minute;r.second=this.second;return r}}e.UTCTime=UTCTime;class GeneralizedTime extends VisibleString{constructor(r={}){super(r);this.year=0;this.month=0;this.day=0;this.hour=0;this.minute=0;this.second=0;this.millisecond=0;if("value"in r){this.fromString(r.value);this.valueBlock.valueHex=new ArrayBuffer(r.value.length);const e=new Uint8Array(this.valueBlock.valueHex);for(let t=0;t<r.value.length;t++)e[t]=r.value.charCodeAt(t)}if("valueDate"in r){this.fromDate(r.valueDate);this.valueBlock.valueHex=this.toBuffer()}this.idBlock.tagClass=1;this.idBlock.tagNumber=24}fromBER(r,e,t){const n=this.valueBlock.fromBER(r,e,this.lenBlock.isIndefiniteForm===true?t:this.lenBlock.length);if(n===-1){this.error=this.valueBlock.error;return n}this.fromBuffer(this.valueBlock.valueHex);if(this.idBlock.error.length===0)this.blockLength+=this.idBlock.blockLength;if(this.lenBlock.error.length===0)this.blockLength+=this.lenBlock.blockLength;if(this.valueBlock.error.length===0)this.blockLength+=this.valueBlock.blockLength;return n}fromBuffer(r){this.fromString(String.fromCharCode.apply(null,new Uint8Array(r)))}toBuffer(){const r=this.toString();const e=new ArrayBuffer(r.length);const t=new Uint8Array(e);for(let e=0;e<r.length;e++)t[e]=r.charCodeAt(e);return e}fromDate(r){this.year=r.getUTCFullYear();this.month=r.getUTCMonth()+1;this.day=r.getUTCDate();this.hour=r.getUTCHours();this.minute=r.getUTCMinutes();this.second=r.getUTCSeconds();this.millisecond=r.getUTCMilliseconds()}toDate(){return new Date(Date.UTC(this.year,this.month-1,this.day,this.hour,this.minute,this.second,this.millisecond))}fromString(r){let e=false;let t="";let n="";let s=0;let o;let i=0;let a=0;if(r[r.length-1]==="Z"){t=r.substr(0,r.length-1);e=true}else{const e=new Number(r[r.length-1]);if(isNaN(e.valueOf()))throw new Error("Wrong input string for convertion");t=r}if(e){if(t.indexOf("+")!==-1)throw new Error("Wrong input string for convertion");if(t.indexOf("-")!==-1)throw new Error("Wrong input string for convertion")}else{let r=1;let e=t.indexOf("+");let n="";if(e===-1){e=t.indexOf("-");r=-1}if(e!==-1){n=t.substr(e+1);t=t.substr(0,e);if(n.length!==2&&n.length!==4)throw new Error("Wrong input string for convertion");let s=new Number(n.substr(0,2));if(isNaN(s.valueOf()))throw new Error("Wrong input string for convertion");i=r*s;if(n.length===4){s=new Number(n.substr(2,2));if(isNaN(s.valueOf()))throw new Error("Wrong input string for convertion");a=r*s}}}let c=t.indexOf(".");if(c===-1)c=t.indexOf(",");if(c!==-1){const r=new Number(`0${t.substr(c)}`);if(isNaN(r.valueOf()))throw new Error("Wrong input string for convertion");s=r.valueOf();n=t.substr(0,c)}else n=t;switch(true){case n.length===8:o=/(\d{4})(\d{2})(\d{2})/gi;if(c!==-1)throw new Error("Wrong input string for convertion");break;case n.length===10:o=/(\d{4})(\d{2})(\d{2})(\d{2})/gi;if(c!==-1){let r=60*s;this.minute=Math.floor(r);r=60*(r-this.minute);this.second=Math.floor(r);r=1e3*(r-this.second);this.millisecond=Math.floor(r)}break;case n.length===12:o=/(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})/gi;if(c!==-1){let r=60*s;this.second=Math.floor(r);r=1e3*(r-this.second);this.millisecond=Math.floor(r)}break;case n.length===14:o=/(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/gi;if(c!==-1){const r=1e3*s;this.millisecond=Math.floor(r)}break;default:throw new Error("Wrong input string for convertion")}const u=o.exec(n);if(u===null)throw new Error("Wrong input string for convertion");for(let r=1;r<u.length;r++){switch(r){case 1:this.year=parseInt(u[r],10);break;case 2:this.month=parseInt(u[r],10);break;case 3:this.day=parseInt(u[r],10);break;case 4:this.hour=parseInt(u[r],10)+i;break;case 5:this.minute=parseInt(u[r],10)+a;break;case 6:this.second=parseInt(u[r],10);break;default:throw new Error("Wrong input string for convertion")}}if(e===false){const r=new Date(this.year,this.month,this.day,this.hour,this.minute,this.second,this.millisecond);this.year=r.getUTCFullYear();this.month=r.getUTCMonth();this.day=r.getUTCDay();this.hour=r.getUTCHours();this.minute=r.getUTCMinutes();this.second=r.getUTCSeconds();this.millisecond=r.getUTCMilliseconds()}}toString(){const r=[];r.push((0,n.padNumber)(this.year,4));r.push((0,n.padNumber)(this.month,2));r.push((0,n.padNumber)(this.day,2));r.push((0,n.padNumber)(this.hour,2));r.push((0,n.padNumber)(this.minute,2));r.push((0,n.padNumber)(this.second,2));if(this.millisecond!==0){r.push(".");r.push((0,n.padNumber)(this.millisecond,3))}r.push("Z");return r.join("")}static blockName(){return"GeneralizedTime"}toJSON(){let r={};try{r=super.toJSON()}catch(r){}r.year=this.year;r.month=this.month;r.day=this.day;r.hour=this.hour;r.minute=this.minute;r.second=this.second;r.millisecond=this.millisecond;return r}}e.GeneralizedTime=GeneralizedTime;class DATE extends Utf8String{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=31}static blockName(){return"DATE"}}e.DATE=DATE;class TimeOfDay extends Utf8String{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=32}static blockName(){return"TimeOfDay"}}e.TimeOfDay=TimeOfDay;class DateTime extends Utf8String{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=33}static blockName(){return"DateTime"}}e.DateTime=DateTime;class Duration extends Utf8String{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=34}static blockName(){return"Duration"}}e.Duration=Duration;class TIME extends Utf8String{constructor(r={}){super(r);this.idBlock.tagClass=1;this.idBlock.tagNumber=14}static blockName(){return"TIME"}}e.TIME=TIME;class Choice{constructor(r={}){this.value=(0,n.getParametersValue)(r,"value",[]);this.optional=(0,n.getParametersValue)(r,"optional",false)}}e.Choice=Choice;class Any{constructor(r={}){this.name=(0,n.getParametersValue)(r,"name","");this.optional=(0,n.getParametersValue)(r,"optional",false)}}e.Any=Any;class Repeated{constructor(r={}){this.name=(0,n.getParametersValue)(r,"name","");this.optional=(0,n.getParametersValue)(r,"optional",false);this.value=(0,n.getParametersValue)(r,"value",new Any);this.local=(0,n.getParametersValue)(r,"local",false)}}e.Repeated=Repeated;class RawData{constructor(r={}){this.data=(0,n.getParametersValue)(r,"data",new ArrayBuffer(0))}fromBER(r,e,t){this.data=r.slice(e,t);return e+t}toBER(r=false){return this.data}}e.RawData=RawData;function LocalFromBER(r,e,t){const s=e;function localChangeType(r,e){if(r instanceof e)return r;const t=new e;t.idBlock=r.idBlock;t.lenBlock=r.lenBlock;t.warnings=r.warnings;t.valueBeforeDecode=r.valueBeforeDecode.slice(0);return t}let o=new BaseBlock({},Object);const i=new LocalBaseBlock;if((0,n.checkBufferParams)(i,r,e,t)===false){o.error=i.error;return{offset:-1,result:o}}const a=new Uint8Array(r,e,t);if(a.length===0){o.error="Zero buffer length";return{offset:-1,result:o}}let c=o.idBlock.fromBER(r,e,t);o.warnings.concat(o.idBlock.warnings);if(c===-1){o.error=o.idBlock.error;return{offset:-1,result:o}}e=c;t-=o.idBlock.blockLength;c=o.lenBlock.fromBER(r,e,t);o.warnings.concat(o.lenBlock.warnings);if(c===-1){o.error=o.lenBlock.error;return{offset:-1,result:o}}e=c;t-=o.lenBlock.blockLength;if(o.idBlock.isConstructed===false&&o.lenBlock.isIndefiniteForm===true){o.error="Indefinite length form used for primitive encoding form";return{offset:-1,result:o}}let u=BaseBlock;switch(o.idBlock.tagClass){case 1:if(o.idBlock.tagNumber>=37&&o.idBlock.isHexOnly===false){o.error="UNIVERSAL 37 and upper tags are reserved by ASN.1 standard";return{offset:-1,result:o}}switch(o.idBlock.tagNumber){case 0:if(o.idBlock.isConstructed===true&&o.lenBlock.length>0){o.error="Type [UNIVERSAL 0] is reserved";return{offset:-1,result:o}}u=EndOfContent;break;case 1:u=Boolean;break;case 2:u=Integer;break;case 3:u=BitString;break;case 4:u=OctetString;break;case 5:u=Null;break;case 6:u=ObjectIdentifier;break;case 10:u=Enumerated;break;case 12:u=Utf8String;break;case 13:u=RelativeObjectIdentifier;break;case 14:u=TIME;break;case 15:o.error="[UNIVERSAL 15] is reserved by ASN.1 standard";return{offset:-1,result:o};case 16:u=Sequence;break;case 17:u=Set;break;case 18:u=NumericString;break;case 19:u=PrintableString;break;case 20:u=TeletexString;break;case 21:u=VideotexString;break;case 22:u=IA5String;break;case 23:u=UTCTime;break;case 24:u=GeneralizedTime;break;case 25:u=GraphicString;break;case 26:u=VisibleString;break;case 27:u=GeneralString;break;case 28:u=UniversalString;break;case 29:u=CharacterString;break;case 30:u=BmpString;break;case 31:u=DATE;break;case 32:u=TimeOfDay;break;case 33:u=DateTime;break;case 34:u=Duration;break;default:{let r;if(o.idBlock.isConstructed===true)r=new Constructed;else r=new Primitive;r.idBlock=o.idBlock;r.lenBlock=o.lenBlock;r.warnings=o.warnings;o=r}}break;case 2:case 3:case 4:default:{if(o.idBlock.isConstructed===true)u=Constructed;else u=Primitive}}o=localChangeType(o,u);c=o.fromBER(r,e,o.lenBlock.isIndefiniteForm===true?t:o.lenBlock.length);o.valueBeforeDecode=r.slice(s,s+o.blockLength);return{offset:c,result:o}}function fromBER(r){if(r.byteLength===0){const r=new BaseBlock({},Object);r.error="Input buffer has zero length";return{offset:-1,result:r}}return LocalFromBER(r,0,r.byteLength)}function compareSchema(r,e,t){if(t instanceof Choice){const n=false;for(let n=0;n<t.value.length;n++){const s=compareSchema(r,e,t.value[n]);if(s.verified===true){return{verified:true,result:r}}}if(n===false){const r={verified:false,result:{error:"Wrong values for Choice type"}};if(t.hasOwnProperty("name"))r.name=t.name;return r}}if(t instanceof Any){if(t.hasOwnProperty("name"))r[t.name]=e;return{verified:true,result:r}}if(r instanceof Object===false){return{verified:false,result:{error:"Wrong root object"}}}if(e instanceof Object===false){return{verified:false,result:{error:"Wrong ASN.1 data"}}}if(t instanceof Object===false){return{verified:false,result:{error:"Wrong ASN.1 schema"}}}if("idBlock"in t===false){return{verified:false,result:{error:"Wrong ASN.1 schema"}}}if("fromBER"in t.idBlock===false){return{verified:false,result:{error:"Wrong ASN.1 schema"}}}if("toBER"in t.idBlock===false){return{verified:false,result:{error:"Wrong ASN.1 schema"}}}const n=t.idBlock.toBER(false);if(n.byteLength===0){return{verified:false,result:{error:"Error encoding idBlock for ASN.1 schema"}}}const s=t.idBlock.fromBER(n,0,n.byteLength);if(s===-1){return{verified:false,result:{error:"Error decoding idBlock for ASN.1 schema"}}}if(t.idBlock.hasOwnProperty("tagClass")===false){return{verified:false,result:{error:"Wrong ASN.1 schema"}}}if(t.idBlock.tagClass!==e.idBlock.tagClass){return{verified:false,result:r}}if(t.idBlock.hasOwnProperty("tagNumber")===false){return{verified:false,result:{error:"Wrong ASN.1 schema"}}}if(t.idBlock.tagNumber!==e.idBlock.tagNumber){return{verified:false,result:r}}if(t.idBlock.hasOwnProperty("isConstructed")===false){return{verified:false,result:{error:"Wrong ASN.1 schema"}}}if(t.idBlock.isConstructed!==e.idBlock.isConstructed){return{verified:false,result:r}}if("isHexOnly"in t.idBlock===false){return{verified:false,result:{error:"Wrong ASN.1 schema"}}}if(t.idBlock.isHexOnly!==e.idBlock.isHexOnly){return{verified:false,result:r}}if(t.idBlock.isHexOnly===true){if("valueHex"in t.idBlock===false){return{verified:false,result:{error:"Wrong ASN.1 schema"}}}const n=new Uint8Array(t.idBlock.valueHex);const s=new Uint8Array(e.idBlock.valueHex);if(n.length!==s.length){return{verified:false,result:r}}for(let e=0;e<n.length;e++){if(n[e]!==s[1]){return{verified:false,result:r}}}}if(t.hasOwnProperty("name")){t.name=t.name.replace(/^\s+|\s+$/g,"");if(t.name!=="")r[t.name]=e}if(t.idBlock.isConstructed===true){let n=0;let s={verified:false};let o=t.valueBlock.value.length;if(o>0){if(t.valueBlock.value[0]instanceof Repeated)o=e.valueBlock.value.length}if(o===0){return{verified:true,result:r}}if(e.valueBlock.value.length===0&&t.valueBlock.value.length!==0){let e=true;for(let r=0;r<t.valueBlock.value.length;r++)e=e&&(t.valueBlock.value[r].optional||false);if(e===true){return{verified:true,result:r}}if(t.hasOwnProperty("name")){t.name=t.name.replace(/^\s+|\s+$/g,"");if(t.name!=="")delete r[t.name]}r.error="Inconsistent object length";return{verified:false,result:r}}for(let i=0;i<o;i++){if(i-n>=e.valueBlock.value.length){if(t.valueBlock.value[i].optional===false){const e={verified:false,result:r};r.error="Inconsistent length between ASN.1 data and schema";if(t.hasOwnProperty("name")){t.name=t.name.replace(/^\s+|\s+$/g,"");if(t.name!==""){delete r[t.name];e.name=t.name}}return e}}else{if(t.valueBlock.value[0]instanceof Repeated){s=compareSchema(r,e.valueBlock.value[i],t.valueBlock.value[0].value);if(s.verified===false){if(t.valueBlock.value[0].optional===true)n++;else{if(t.hasOwnProperty("name")){t.name=t.name.replace(/^\s+|\s+$/g,"");if(t.name!=="")delete r[t.name]}return s}}if("name"in t.valueBlock.value[0]&&t.valueBlock.value[0].name.length>0){let n={};if("local"in t.valueBlock.value[0]&&t.valueBlock.value[0].local===true)n=e;else n=r;if(typeof n[t.valueBlock.value[0].name]==="undefined")n[t.valueBlock.value[0].name]=[];n[t.valueBlock.value[0].name].push(e.valueBlock.value[i])}}else{s=compareSchema(r,e.valueBlock.value[i-n],t.valueBlock.value[i]);if(s.verified===false){if(t.valueBlock.value[i].optional===true)n++;else{if(t.hasOwnProperty("name")){t.name=t.name.replace(/^\s+|\s+$/g,"");if(t.name!=="")delete r[t.name]}return s}}}}}if(s.verified===false){const e={verified:false,result:r};if(t.hasOwnProperty("name")){t.name=t.name.replace(/^\s+|\s+$/g,"");if(t.name!==""){delete r[t.name];e.name=t.name}}return e}return{verified:true,result:r}}if("primitiveSchema"in t&&"valueHex"in e.valueBlock){const n=fromBER(e.valueBlock.valueHex);if(n.offset===-1){const e={verified:false,result:n.result};if(t.hasOwnProperty("name")){t.name=t.name.replace(/^\s+|\s+$/g,"");if(t.name!==""){delete r[t.name];e.name=t.name}}return e}return compareSchema(r,n.result,t.primitiveSchema)}return{verified:true,result:r}}function verifySchema(r,e){if(e instanceof Object===false){return{verified:false,result:{error:"Wrong ASN.1 schema type"}}}const t=fromBER(r);if(t.offset===-1){return{verified:false,result:t.result}}return compareSchema(t.result,t.result,e)}function fromJSON(r){}},317:function(r,e){(function(r,t){true?t(e):0})(this,function(r){"use strict";class BufferSourceConverter{static isArrayBuffer(r){return Object.prototype.toString.call(r)==="[object ArrayBuffer]"}static toArrayBuffer(r){const e=this.toUint8Array(r);if(e.byteOffset||e.length){return e.buffer.slice(e.byteOffset,e.byteOffset+e.length)}return e.buffer}static toUint8Array(r){return this.toView(r,Uint8Array)}static toView(r,e){if(typeof Buffer!=="undefined"&&Buffer.isBuffer(r)){return new e(r.buffer,r.byteOffset,r.byteLength)}if(this.isArrayBuffer(r)){return new e(r)}if(this.isArrayBufferView(r)){return new e(r.buffer,r.byteOffset,r.byteLength)}throw new TypeError("The provided value is not of type '(ArrayBuffer or ArrayBufferView)'")}static isBufferSource(r){return this.isArrayBufferView(r)||this.isArrayBuffer(r)}static isArrayBufferView(r){return ArrayBuffer.isView(r)||r&&this.isArrayBuffer(r.buffer)}}class Utf8Converter{static fromString(r){const e=unescape(encodeURIComponent(r));const t=new Uint8Array(e.length);for(let r=0;r<e.length;r++){t[r]=e.charCodeAt(r)}return t.buffer}static toString(r){const e=BufferSourceConverter.toUint8Array(r);let t="";for(let r=0;r<e.length;r++){t+=String.fromCharCode(e[r])}const n=decodeURIComponent(escape(t));return n}}class Utf16Converter{static toString(r,e=false){const t=BufferSourceConverter.toArrayBuffer(r);const n=new DataView(t);let s="";for(let r=0;r<t.byteLength;r+=2){const t=n.getUint16(r,e);s+=String.fromCharCode(t)}return s}static fromString(r,e=false){const t=new ArrayBuffer(r.length*2);const n=new DataView(t);for(let t=0;t<r.length;t++){n.setUint16(t*2,r.charCodeAt(t),e)}return t}}class Convert{static isHex(r){return typeof r==="string"&&/^[a-z0-9]+$/i.test(r)}static isBase64(r){return typeof r==="string"&&/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(r)}static isBase64Url(r){return typeof r==="string"&&/^[a-zA-Z0-9-_]+$/i.test(r)}static ToString(r,e="utf8"){const t=BufferSourceConverter.toUint8Array(r);switch(e.toLowerCase()){case"utf8":return this.ToUtf8String(t);case"binary":return this.ToBinary(t);case"hex":return this.ToHex(t);case"base64":return this.ToBase64(t);case"base64url":return this.ToBase64Url(t);case"utf16le":return Utf16Converter.toString(t,true);case"utf16":case"utf16be":return Utf16Converter.toString(t);default:throw new Error(`Unknown type of encoding '${e}'`)}}static FromString(r,e="utf8"){if(!r){return new ArrayBuffer(0)}switch(e.toLowerCase()){case"utf8":return this.FromUtf8String(r);case"binary":return this.FromBinary(r);case"hex":return this.FromHex(r);case"base64":return this.FromBase64(r);case"base64url":return this.FromBase64Url(r);case"utf16le":return Utf16Converter.fromString(r,true);case"utf16":case"utf16be":return Utf16Converter.fromString(r);default:throw new Error(`Unknown type of encoding '${e}'`)}}static ToBase64(r){const e=BufferSourceConverter.toUint8Array(r);if(typeof btoa!=="undefined"){const r=this.ToString(e,"binary");return btoa(r)}else{return Buffer.from(e).toString("base64")}}static FromBase64(r){const e=this.formatString(r);if(!e){return new ArrayBuffer(0)}if(!Convert.isBase64(e)){throw new TypeError("Argument 'base64Text' is not Base64 encoded")}if(typeof atob!=="undefined"){return this.FromBinary(atob(e))}else{return new Uint8Array(Buffer.from(e,"base64")).buffer}}static FromBase64Url(r){const e=this.formatString(r);if(!e){return new ArrayBuffer(0)}if(!Convert.isBase64Url(e)){throw new TypeError("Argument 'base64url' is not Base64Url encoded")}return this.FromBase64(this.Base64Padding(e.replace(/\-/g,"+").replace(/\_/g,"/")))}static ToBase64Url(r){return this.ToBase64(r).replace(/\+/g,"-").replace(/\//g,"_").replace(/\=/g,"")}static FromUtf8String(r,e=Convert.DEFAULT_UTF8_ENCODING){switch(e){case"ascii":return this.FromBinary(r);case"utf8":return Utf8Converter.fromString(r);case"utf16":case"utf16be":return Utf16Converter.fromString(r);case"utf16le":case"usc2":return Utf16Converter.fromString(r,true);default:throw new Error(`Unknown type of encoding '${e}'`)}}static ToUtf8String(r,e=Convert.DEFAULT_UTF8_ENCODING){switch(e){case"ascii":return this.ToBinary(r);case"utf8":return Utf8Converter.toString(r);case"utf16":case"utf16be":return Utf16Converter.toString(r);case"utf16le":case"usc2":return Utf16Converter.toString(r,true);default:throw new Error(`Unknown type of encoding '${e}'`)}}static FromBinary(r){const e=r.length;const t=new Uint8Array(e);for(let n=0;n<e;n++){t[n]=r.charCodeAt(n)}return t.buffer}static ToBinary(r){const e=BufferSourceConverter.toUint8Array(r);let t="";for(let r=0;r<e.length;r++){t+=String.fromCharCode(e[r])}return t}static ToHex(r){const e=BufferSourceConverter.toUint8Array(r);const t="";const n=[];const s=e.length;for(let r=0;r<s;r++){const t=e[r].toString(16).padStart(2,"0");n.push(t)}return n.join(t)}static FromHex(r){let e=this.formatString(r);if(!e){return new ArrayBuffer(0)}if(!Convert.isHex(e)){throw new TypeError("Argument 'hexString' is not HEX encoded")}if(e.length%2){e=`0${e}`}const t=new Uint8Array(e.length/2);for(let r=0;r<e.length;r=r+2){const n=e.slice(r,r+2);t[r/2]=parseInt(n,16)}return t.buffer}static ToUtf16String(r,e=false){return Utf16Converter.toString(r,e)}static FromUtf16String(r,e=false){return Utf16Converter.fromString(r,e)}static Base64Padding(r){const e=4-r.length%4;if(e<4){for(let t=0;t<e;t++){r+="="}}return r}static formatString(r){return(r===null||r===void 0?void 0:r.replace(/[\n\r\t ]/g,""))||""}}Convert.DEFAULT_UTF8_ENCODING="utf8";function assign(r,...e){const t=arguments[0];for(let r=1;r<arguments.length;r++){const e=arguments[r];for(const r in e){t[r]=e[r]}}return t}function combine(...r){const e=r.map(r=>r.byteLength).reduce((r,e)=>r+e);const t=new Uint8Array(e);let n=0;r.map(r=>new Uint8Array(r)).forEach(r=>{for(const e of r){t[n++]=e}});return t.buffer}function isEqual(r,e){if(!(r&&e)){return false}if(r.byteLength!==e.byteLength){return false}const t=new Uint8Array(r);const n=new Uint8Array(e);for(let e=0;e<r.byteLength;e++){if(t[e]!==n[e]){return false}}return true}r.BufferSourceConverter=BufferSourceConverter;r.Convert=Convert;r.assign=assign;r.combine=combine;r.isEqual=isEqual;Object.defineProperty(r,"__esModule",{value:true})})},209:(r,e)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});e.getUTCDate=getUTCDate;e.getParametersValue=getParametersValue;e.bufferToHexCodes=bufferToHexCodes;e.checkBufferParams=checkBufferParams;e.utilFromBase=utilFromBase;e.utilToBase=utilToBase;e.utilConcatBuf=utilConcatBuf;e.utilConcatView=utilConcatView;e.utilDecodeTC=utilDecodeTC;e.utilEncodeTC=utilEncodeTC;e.isEqualBuffer=isEqualBuffer;e.padNumber=padNumber;e.toBase64=toBase64;e.fromBase64=fromBase64;e.arrayBufferToString=arrayBufferToString;e.stringToArrayBuffer=stringToArrayBuffer;e.nearestPowerOf2=nearestPowerOf2;e.clearProps=clearProps;function getUTCDate(r){return new Date(r.getTime()+r.getTimezoneOffset()*6e4)}function getParametersValue(r,e,t){if(r instanceof Object===false)return t;if(e in r)return r[e];return t}function bufferToHexCodes(r,e=0,t=r.byteLength-e,n=false){let s="";var o=true;var i=false;var a=undefined;try{for(var c=new Uint8Array(r,e,t)[Symbol.iterator](),u;!(o=(u=c.next()).done);o=true){const r=u.value;const e=r.toString(16).toUpperCase();if(e.length===1)s+="0";s+=e;if(n)s+=" "}}catch(r){i=true;a=r}finally{try{if(!o&&c.return){c.return()}}finally{if(i){throw a}}}return s.trim()}function checkBufferParams(r,e,t,n){if(e instanceof ArrayBuffer===false){r.error='Wrong parameter: inputBuffer must be "ArrayBuffer"';return false}if(e.byteLength===0){r.error="Wrong parameter: inputBuffer has zero length";return false}if(t<0){r.error="Wrong parameter: inputOffset less than zero";return false}if(n<0){r.error="Wrong parameter: inputLength less than zero";return false}if(e.byteLength-t-n<0){r.error="End of input reached before message was fully decoded (inconsistent offset and length values)";return false}return true}function utilFromBase(r,e){let t=0;if(r.length===1)return r[0];for(let n=r.length-1;n>=0;n--)t+=r[r.length-1-n]*Math.pow(2,e*n);return t}function utilToBase(r,e,t=-1){const n=t;let s=r;let o=0;let i=Math.pow(2,e);for(let t=1;t<8;t++){if(r<i){let r;if(n<0){r=new ArrayBuffer(t);o=t}else{if(n<t)return new ArrayBuffer(0);r=new ArrayBuffer(n);o=n}const i=new Uint8Array(r);for(let r=t-1;r>=0;r--){const t=Math.pow(2,r*e);i[o-r-1]=Math.floor(s/t);s-=i[o-r-1]*t}return r}i*=Math.pow(2,e)}return new ArrayBuffer(0)}function utilConcatBuf(...r){let e=0;let t=0;var n=true;var s=false;var o=undefined;try{for(var i=r[Symbol.iterator](),a;!(n=(a=i.next()).done);n=true){const r=a.value;e+=r.byteLength}}catch(r){s=true;o=r}finally{try{if(!n&&i.return){i.return()}}finally{if(s){throw o}}}const c=new ArrayBuffer(e);const u=new Uint8Array(c);var f=true;var l=false;var h=undefined;try{for(var y=r[Symbol.iterator](),p;!(f=(p=y.next()).done);f=true){const r=p.value;u.set(new Uint8Array(r),t);t+=r.byteLength}}catch(r){l=true;h=r}finally{try{if(!f&&y.return){y.return()}}finally{if(l){throw h}}}return c}function utilConcatView(...r){let e=0;let t=0;var n=true;var s=false;var o=undefined;try{for(var i=r[Symbol.iterator](),a;!(n=(a=i.next()).done);n=true){const r=a.value;e+=r.length}}catch(r){s=true;o=r}finally{try{if(!n&&i.return){i.return()}}finally{if(s){throw o}}}const c=new ArrayBuffer(e);const u=new Uint8Array(c);var f=true;var l=false;var h=undefined;try{for(var y=r[Symbol.iterator](),p;!(f=(p=y.next()).done);f=true){const r=p.value;u.set(r,t);t+=r.length}}catch(r){l=true;h=r}finally{try{if(!f&&y.return){y.return()}}finally{if(l){throw h}}}return u}function utilDecodeTC(){const r=new Uint8Array(this.valueHex);if(this.valueHex.byteLength>=2){const e=r[0]===255&&r[1]&128;const t=r[0]===0&&(r[1]&128)===0;if(e||t)this.warnings.push("Needlessly long format")}const e=new ArrayBuffer(this.valueHex.byteLength);const t=new Uint8Array(e);for(let r=0;r<this.valueHex.byteLength;r++)t[r]=0;t[0]=r[0]&128;const n=utilFromBase(t,8);const s=new ArrayBuffer(this.valueHex.byteLength);const o=new Uint8Array(s);for(let e=0;e<this.valueHex.byteLength;e++)o[e]=r[e];o[0]&=127;const i=utilFromBase(o,8);return i-n}function utilEncodeTC(r){const e=r<0?r*-1:r;let t=128;for(let n=1;n<8;n++){if(e<=t){if(r<0){const r=t-e;const s=utilToBase(r,8,n);const o=new Uint8Array(s);o[0]|=128;return s}let s=utilToBase(e,8,n);let o=new Uint8Array(s);if(o[0]&128){const r=s.slice(0);const e=new Uint8Array(r);s=new ArrayBuffer(s.byteLength+1);o=new Uint8Array(s);for(let t=0;t<r.byteLength;t++)o[t+1]=e[t];o[0]=0}return s}t*=Math.pow(2,8)}return new ArrayBuffer(0)}function isEqualBuffer(r,e){if(r.byteLength!==e.byteLength)return false;const t=new Uint8Array(r);const n=new Uint8Array(e);for(let r=0;r<t.length;r++){if(t[r]!==n[r])return false}return true}function padNumber(r,e){const t=r.toString(10);if(e<t.length)return"";const n=e-t.length;const s=new Array(n);for(let r=0;r<n;r++)s[r]="0";const o=s.join("");return o.concat(t)}const t="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";const n="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_=";function toBase64(r,e=false,s=false,o=false){let i=0;let a=0;let c=0;let u="";const f=e?n:t;if(o){let e=0;for(let t=0;t<r.length;t++){if(r.charCodeAt(t)!==0){e=t;break}}r=r.slice(e)}while(i<r.length){const e=r.charCodeAt(i++);if(i>=r.length)a=1;const t=r.charCodeAt(i++);if(i>=r.length)c=1;const n=r.charCodeAt(i++);const o=e>>2;const l=(e&3)<<4|t>>4;let h=(t&15)<<2|n>>6;let y=n&63;if(a===1){h=y=64}else{if(c===1){y=64}}if(s){if(h===64)u+=`${f.charAt(o)}${f.charAt(l)}`;else{if(y===64)u+=`${f.charAt(o)}${f.charAt(l)}${f.charAt(h)}`;else u+=`${f.charAt(o)}${f.charAt(l)}${f.charAt(h)}${f.charAt(y)}`}}else u+=`${f.charAt(o)}${f.charAt(l)}${f.charAt(h)}${f.charAt(y)}`}return u}function fromBase64(r,e=false,s=false){const o=e?n:t;function indexof(r){for(let e=0;e<64;e++){if(o.charAt(e)===r)return e}return 64}function test(r){return r===64?0:r}let i=0;let a="";while(i<r.length){const e=indexof(r.charAt(i++));const t=i>=r.length?0:indexof(r.charAt(i++));const n=i>=r.length?0:indexof(r.charAt(i++));const s=i>=r.length?0:indexof(r.charAt(i++));const o=test(e)<<2|test(t)>>4;const c=(test(t)&15)<<4|test(n)>>2;const u=(test(n)&3)<<6|test(s);a+=String.fromCharCode(o);if(n!==64)a+=String.fromCharCode(c);if(s!==64)a+=String.fromCharCode(u)}if(s){const r=a.length;let e=-1;for(let t=r-1;t>=0;t--){if(a.charCodeAt(t)!==0){e=t;break}}if(e!==-1)a=a.slice(0,e+1);else a=""}return a}function arrayBufferToString(r){let e="";const t=new Uint8Array(r);var n=true;var s=false;var o=undefined;try{for(var i=t[Symbol.iterator](),a;!(n=(a=i.next()).done);n=true){const r=a.value;e+=String.fromCharCode(r)}}catch(r){s=true;o=r}finally{try{if(!n&&i.return){i.return()}}finally{if(s){throw o}}}return e}function stringToArrayBuffer(r){const e=r.length;const t=new ArrayBuffer(e);const n=new Uint8Array(t);for(let t=0;t<e;t++)n[t]=r.charCodeAt(t);return t}const s=Math.log(2);function nearestPowerOf2(r){const e=Math.log(r)/s;const t=Math.floor(e);const n=Math.round(e);return t===n?t:n}function clearProps(r,e){var t=true;var n=false;var s=undefined;try{for(var o=e[Symbol.iterator](),i;!(t=(i=o.next()).done);t=true){const e=i.value;delete r[e]}}catch(r){n=true;s=r}finally{try{if(!t&&o.return){o.return()}}finally{if(n){throw s}}}}},389:(r,e,t)=>{"use strict";Object.defineProperty(e,"__esModule",{value:true});var n=t(317);var s=t(610);var o=t(870);var i=t(895);var a=t(528);function _interopNamespace(r){if(r&&r.__esModule)return r;var e=Object.create(null);if(r){Object.keys(r).forEach(function(t){if(t!=="default"){var n=Object.getOwnPropertyDescriptor(r,t);Object.defineProperty(e,t,n.get?n:{enumerable:true,get:function(){return r[t]}})}})}e["default"]=r;return Object.freeze(e)}var c=_interopNamespace(a);class CryptoError extends Error{}class AlgorithmError extends CryptoError{}class UnsupportedOperationError extends CryptoError{constructor(r){super(`Unsupported operation: ${r?`${r}`:""}`)}}class OperationError extends CryptoError{}class RequiredPropertyError extends CryptoError{constructor(r){super(`${r}: Missing required property`)}}class PemConverter{static toArrayBuffer(r){const e=r.replace(/-{5}(BEGIN|END) .*-{5}/g,"").replace("\r","").replace("\n","");return n.Convert.FromBase64(e)}static toUint8Array(r){const e=this.toArrayBuffer(r);return new Uint8Array(e)}static fromBufferSource(r,e){const t=n.Convert.ToBase64(r);let s;let o=0;const i=[];while(true){s=t.slice(o,o=o+64);if(s.length){i.push(s);if(s.length<64){break}}else{break}}const a=e.toUpperCase();return`-----BEGIN ${a}-----\n${i.join("\n")}\n-----END ${a}-----`}static isPEM(r){return/-----BEGIN .+-----[A-Za-z0-9+\/\+\=\s\n]+-----END .+-----/i.test(r)}static getTagName(r){if(!this.isPEM(r)){throw new Error("Bad parameter. Incoming data is not right PEM")}const e=/-----BEGIN (.+)-----/.exec(r);if(!e){throw new Error("Cannot get tag from PEM")}return e[1]}static hasTagName(r,e){const t=this.getTagName(r);return e.toLowerCase()===t.toLowerCase()}static isCertificate(r){return this.hasTagName(r,"certificate")}static isCertificateRequest(r){return this.hasTagName(r,"certificate request")}static isCRL(r){return this.hasTagName(r,"x509 crl")}static isPublicKey(r){return this.hasTagName(r,"public key")}}function isJWK(r){return typeof r==="object"&&"kty"in r}class ProviderCrypto{async digest(...r){this.checkDigest.apply(this,r);return this.onDigest.apply(this,r)}checkDigest(r,e){this.checkAlgorithmName(r)}async onDigest(r,e){throw new UnsupportedOperationError("digest")}async generateKey(...r){this.checkGenerateKey.apply(this,r);return this.onGenerateKey.apply(this,r)}checkGenerateKey(r,e,t,...n){this.checkAlgorithmName(r);this.checkGenerateKeyParams(r);if(!(t&&t.length)){throw new TypeError(`Usages cannot be empty when creating a key.`)}let s;if(Array.isArray(this.usages)){s=this.usages}else{s=this.usages.privateKey.concat(this.usages.publicKey)}this.checkKeyUsages(t,s)}checkGenerateKeyParams(r){}async onGenerateKey(r,e,t,...n){throw new UnsupportedOperationError("generateKey")}async sign(...r){this.checkSign.apply(this,r);return this.onSign.apply(this,r)}checkSign(r,e,t,...n){this.checkAlgorithmName(r);this.checkAlgorithmParams(r);this.checkCryptoKey(e,"sign")}async onSign(r,e,t,...n){throw new UnsupportedOperationError("sign")}async verify(...r){this.checkVerify.apply(this,r);return this.onVerify.apply(this,r)}checkVerify(r,e,t,n,...s){this.checkAlgorithmName(r);this.checkAlgorithmParams(r);this.checkCryptoKey(e,"verify")}async onVerify(r,e,t,n,...s){throw new UnsupportedOperationError("verify")}async encrypt(...r){this.checkEncrypt.apply(this,r);return this.onEncrypt.apply(this,r)}checkEncrypt(r,e,t,n={},...s){this.checkAlgorithmName(r);this.checkAlgorithmParams(r);this.checkCryptoKey(e,n.keyUsage?"encrypt":void 0)}async onEncrypt(r,e,t,...n){throw new UnsupportedOperationError("encrypt")}async decrypt(...r){this.checkDecrypt.apply(this,r);return this.onDecrypt.apply(this,r)}checkDecrypt(r,e,t,n={},...s){this.checkAlgorithmName(r);this.checkAlgorithmParams(r);this.checkCryptoKey(e,n.keyUsage?"decrypt":void 0)}async onDecrypt(r,e,t,...n){throw new UnsupportedOperationError("decrypt")}async deriveBits(...r){this.checkDeriveBits.apply(this,r);return this.onDeriveBits.apply(this,r)}checkDeriveBits(r,e,t,n={},...s){this.checkAlgorithmName(r);this.checkAlgorithmParams(r);this.checkCryptoKey(e,n.keyUsage?"deriveBits":void 0);if(t%8!==0){throw new OperationError("length: Is not multiple of 8")}}async onDeriveBits(r,e,t,...n){throw new UnsupportedOperationError("deriveBits")}async exportKey(...r){this.checkExportKey.apply(this,r);return this.onExportKey.apply(this,r)}checkExportKey(r,e,...t){this.checkKeyFormat(r);this.checkCryptoKey(e);if(!e.extractable){throw new CryptoError("key: Is not extractable")}}async onExportKey(r,e,...t){throw new UnsupportedOperationError("exportKey")}async importKey(...r){this.checkImportKey.apply(this,r);return this.onImportKey.apply(this,r)}checkImportKey(r,e,t,n,s,...o){this.checkKeyFormat(r);this.checkKeyData(r,e);this.checkAlgorithmName(t);this.checkImportParams(t);if(Array.isArray(this.usages)){this.checkKeyUsages(s,this.usages)}}async onImportKey(r,e,t,n,s,...o){throw new UnsupportedOperationError("importKey")}checkAlgorithmName(r){if(r.name.toLowerCase()!==this.name.toLowerCase()){throw new AlgorithmError("Unrecognized name")}}checkAlgorithmParams(r){}checkDerivedKeyParams(r){}checkKeyUsages(r,e){for(const t of r){if(e.indexOf(t)===-1){throw new TypeError("Cannot create a key using the specified key usages")}}}checkCryptoKey(r,e){this.checkAlgorithmName(r.algorithm);if(e&&r.usages.indexOf(e)===-1){throw new CryptoError(`key does not match that of operation`)}}checkRequiredProperty(r,e){if(!(e in r)){throw new RequiredPropertyError(e)}}checkHashAlgorithm(r,e){for(const t of e){if(t.toLowerCase()===r.name.toLowerCase()){return}}throw new OperationError(`hash: Must be one of ${e.join(", ")}`)}checkImportParams(r){}checkKeyFormat(r){switch(r){case"raw":case"pkcs8":case"spki":case"jwk":break;default:throw new TypeError("format: Is invalid value. Must be 'jwk', 'raw', 'spki', or 'pkcs8'")}}checkKeyData(r,e){if(!e){throw new TypeError("keyData: Cannot be empty on empty on key importing")}if(r==="jwk"){if(!isJWK(e)){throw new TypeError("keyData: Is not JsonWebToken")}}else if(!n.BufferSourceConverter.isBufferSource(e)){throw new TypeError("keyData: Is not ArrayBufferView or ArrayBuffer")}}prepareData(r){return n.BufferSourceConverter.toArrayBuffer(r)}}class AesProvider extends ProviderCrypto{checkGenerateKeyParams(r){this.checkRequiredProperty(r,"length");if(typeof r.length!=="number"){throw new TypeError("length: Is not of type Number")}switch(r.length){case 128:case 192:case 256:break;default:throw new TypeError("length: Must be 128, 192, or 256")}}checkDerivedKeyParams(r){this.checkGenerateKeyParams(r)}}class AesCbcProvider extends AesProvider{constructor(){super(...arguments);this.name="AES-CBC";this.usages=["encrypt","decrypt","wrapKey","unwrapKey"]}checkAlgorithmParams(r){this.checkRequiredProperty(r,"iv");if(!(r.iv instanceof ArrayBuffer||ArrayBuffer.isView(r.iv))){throw new TypeError("iv: Is not of type '(ArrayBuffer or ArrayBufferView)'")}if(r.iv.byteLength!==16){throw new TypeError("iv: Must have length 16 bytes")}}}class AesCmacProvider extends AesProvider{constructor(){super(...arguments);this.name="AES-CMAC";this.usages=["sign","verify"]}checkAlgorithmParams(r){this.checkRequiredProperty(r,"length");if(typeof r.length!=="number"){throw new TypeError("length: Is not a Number")}if(r.length<1){throw new OperationError("length: Must be more than 0")}}}class AesCtrProvider extends AesProvider{constructor(){super(...arguments);this.name="AES-CTR";this.usages=["encrypt","decrypt","wrapKey","unwrapKey"]}checkAlgorithmParams(r){this.checkRequiredProperty(r,"counter");if(!(r.counter instanceof ArrayBuffer||ArrayBuffer.isView(r.counter))){throw new TypeError("counter: Is not of type '(ArrayBuffer or ArrayBufferView)'")}if(r.counter.byteLength!==16){throw new TypeError("iv: Must have length 16 bytes")}this.checkRequiredProperty(r,"length");if(typeof r.length!=="number"){throw new TypeError("length: Is not a Number")}if(r.length<1){throw new OperationError("length: Must be more than 0")}}}class AesEcbProvider extends AesProvider{constructor(){super(...arguments);this.name="AES-ECB";this.usages=["encrypt","decrypt","wrapKey","unwrapKey"]}}class AesGcmProvider extends AesProvider{constructor(){super(...arguments);this.name="AES-GCM";this.usages=["encrypt","decrypt","wrapKey","unwrapKey"]}checkAlgorithmParams(r){this.checkRequiredProperty(r,"iv");if(!(r.iv instanceof ArrayBuffer||ArrayBuffer.isView(r.iv))){throw new TypeError("iv: Is not of type '(ArrayBuffer or ArrayBufferView)'")}if(r.iv.byteLength<1){throw new OperationError("iv: Must have length more than 0 and less than 2^64 - 1")}if(!("tagLength"in r)){r.tagLength=128}switch(r.tagLength){case 32:case 64:case 96:case 104:case 112:case 120:case 128:break;default:throw new OperationError("tagLength: Must be one of 32, 64, 96, 104, 112, 120 or 128")}}}class AesKwProvider extends AesProvider{constructor(){super(...arguments);this.name="AES-KW";this.usages=["wrapKey","unwrapKey"]}}class DesProvider extends ProviderCrypto{constructor(){super(...arguments);this.usages=["encrypt","decrypt","wrapKey","unwrapKey"]}checkAlgorithmParams(r){if(this.ivSize){this.checkRequiredProperty(r,"iv");if(!(r.iv instanceof ArrayBuffer||ArrayBuffer.isView(r.iv))){throw new TypeError("iv: Is not of type '(ArrayBuffer or ArrayBufferView)'")}if(r.iv.byteLength!==this.ivSize){throw new TypeError(`iv: Must have length ${this.ivSize} bytes`)}}}checkGenerateKeyParams(r){this.checkRequiredProperty(r,"length");if(typeof r.length!=="number"){throw new TypeError("length: Is not of type Number")}if(r.length!==this.keySizeBits){throw new OperationError(`algorith.length: Must be ${this.keySizeBits}`)}}checkDerivedKeyParams(r){this.checkGenerateKeyParams(r)}}class RsaProvider extends ProviderCrypto{constructor(){super(...arguments);this.hashAlgorithms=["SHA-1","SHA-256","SHA-384","SHA-512"]}checkGenerateKeyParams(r){this.checkRequiredProperty(r,"hash");this.checkHashAlgorithm(r.hash,this.hashAlgorithms);this.checkRequiredProperty(r,"publicExponent");if(!(r.publicExponent&&r.publicExponent instanceof Uint8Array)){throw new TypeError("publicExponent: Missing or not a Uint8Array")}const e=n.Convert.ToBase64(r.publicExponent);if(!(e==="Aw=="||e==="AQAB")){throw new TypeError("publicExponent: Must be [3] or [1,0,1]")}this.checkRequiredProperty(r,"modulusLength");switch(r.modulusLength){case 1024:case 2048:case 4096:break;default:throw new TypeError("modulusLength: Must be 1024, 2048, or 4096")}}checkImportParams(r){this.checkRequiredProperty(r,"hash");this.checkHashAlgorithm(r.hash,this.hashAlgorithms)}}class RsaSsaProvider extends RsaProvider{constructor(){super(...arguments);this.name="RSASSA-PKCS1-v1_5";this.usages={privateKey:["sign"],publicKey:["verify"]}}}class RsaPssProvider extends RsaProvider{constructor(){super(...arguments);this.name="RSA-PSS";this.usages={privateKey:["sign"],publicKey:["verify"]}}checkAlgorithmParams(r){this.checkRequiredProperty(r,"saltLength");if(typeof r.saltLength!=="number"){throw new TypeError("saltLength: Is not a Number")}if(r.saltLength<0){throw new RangeError("saltLength: Must be positive number")}}}class RsaOaepProvider extends RsaProvider{constructor(){super(...arguments);this.name="RSA-OAEP";this.usages={privateKey:["decrypt","unwrapKey"],publicKey:["encrypt","wrapKey"]}}checkAlgorithmParams(r){if(r.label&&!(r.label instanceof ArrayBuffer||ArrayBuffer.isView(r.label))){throw new TypeError("label: Is not of type '(ArrayBuffer or ArrayBufferView)'")}}}class EllipticProvider extends ProviderCrypto{checkGenerateKeyParams(r){this.checkRequiredProperty(r,"namedCurve");this.checkNamedCurve(r.namedCurve)}checkNamedCurve(r){for(const e of this.namedCurves){if(e.toLowerCase()===r.toLowerCase()){return}}throw new OperationError(`namedCurve: Must be one of ${this.namedCurves.join(", ")}`)}}class EcdsaProvider extends EllipticProvider{constructor(){super(...arguments);this.name="ECDSA";this.hashAlgorithms=["SHA-1","SHA-256","SHA-384","SHA-512"];this.usages={privateKey:["sign"],publicKey:["verify"]};this.namedCurves=["P-256","P-384","P-521","K-256"]}checkAlgorithmParams(r){this.checkRequiredProperty(r,"hash");this.checkHashAlgorithm(r.hash,this.hashAlgorithms)}}const u=["secret","private","public"];class CryptoKey{static create(r,e,t,n){const s=new this;s.algorithm=r;s.type=e;s.extractable=t;s.usages=n;return s}static isKeyType(r){return u.indexOf(r)!==-1}get[Symbol.toStringTag](){return"CryptoKey"}}class EcdhProvider extends EllipticProvider{constructor(){super(...arguments);this.name="ECDH";this.usages={privateKey:["deriveBits","deriveKey"],publicKey:[]};this.namedCurves=["P-256","P-384","P-521","K-256"]}checkAlgorithmParams(r){this.checkRequiredProperty(r,"public");if(!(r.public instanceof CryptoKey)){throw new TypeError("public: Is not a CryptoKey")}if(r.public.type!=="public"){throw new OperationError("public: Is not a public key")}if(r.public.algorithm.name!==this.name){throw new OperationError(`public: Is not ${this.name} key`)}}}class EcdhEsProvider extends EcdhProvider{constructor(){super(...arguments);this.name="ECDH-ES";this.namedCurves=["X25519","X448"]}}class EdDsaProvider extends EllipticProvider{constructor(){super(...arguments);this.name="EdDSA";this.usages={privateKey:["sign"],publicKey:["verify"]};this.namedCurves=["Ed25519","Ed448"]}}class HmacProvider extends ProviderCrypto{constructor(){super(...arguments);this.name="HMAC";this.hashAlgorithms=["SHA-1","SHA-256","SHA-384","SHA-512"];this.usages=["sign","verify"]}getDefaultLength(r){switch(r.toUpperCase()){case"SHA-1":case"SHA-256":case"SHA-384":case"SHA-512":return 512;default:throw new Error(`Unknown algorithm name '${r}'`)}}checkGenerateKeyParams(r){this.checkRequiredProperty(r,"hash");this.checkHashAlgorithm(r.hash,this.hashAlgorithms);if("length"in r){if(typeof r.length!=="number"){throw new TypeError("length: Is not a Number")}if(r.length<1){throw new RangeError("length: Number is out of range")}}}checkImportParams(r){this.checkRequiredProperty(r,"hash");this.checkHashAlgorithm(r.hash,this.hashAlgorithms)}}class Pbkdf2Provider extends ProviderCrypto{constructor(){super(...arguments);this.name="PBKDF2";this.hashAlgorithms=["SHA-1","SHA-256","SHA-384","SHA-512"];this.usages=["deriveBits","deriveKey"]}checkAlgorithmParams(r){this.checkRequiredProperty(r,"hash");this.checkHashAlgorithm(r.hash,this.hashAlgorithms);this.checkRequiredProperty(r,"salt");if(!(r.salt instanceof ArrayBuffer||ArrayBuffer.isView(r.salt))){throw new TypeError("salt: Is not of type '(ArrayBuffer or ArrayBufferView)'")}this.checkRequiredProperty(r,"iterations");if(typeof r.iterations!=="number"){throw new TypeError("iterations: Is not a Number")}if(r.iterations<1){throw new TypeError("iterations: Is less than 1")}}checkImportKey(r,e,t,n,s,...o){super.checkImportKey(r,e,t,n,s);if(n){throw new SyntaxError("extractable: Must be 'false'")}}}class HkdfProvider extends ProviderCrypto{constructor(){super(...arguments);this.name="HKDF";this.hashAlgorithms=["SHA-1","SHA-256","SHA-384","SHA-512"];this.usages=["deriveKey","deriveBits"]}checkAlgorithmParams(r){this.checkRequiredProperty(r,"hash");this.checkHashAlgorithm(r.hash,this.hashAlgorithms);this.checkRequiredProperty(r,"salt");if(!n.BufferSourceConverter.isBufferSource(r.salt)){throw new TypeError("salt: Is not of type '(ArrayBuffer or ArrayBufferView)'")}this.checkRequiredProperty(r,"info");if(!n.BufferSourceConverter.isBufferSource(r.info)){throw new TypeError("salt: Is not of type '(ArrayBuffer or ArrayBufferView)'")}}checkImportKey(r,e,t,n,s,...o){super.checkImportKey(r,e,t,n,s);if(n){throw new SyntaxError("extractable: Must be 'false'")}}}class Crypto{get[Symbol.toStringTag](){return"Crypto"}}class ProviderStorage{constructor(){this.items={}}get(r){return this.items[r.toLowerCase()]||null}set(r){this.items[r.name.toLowerCase()]=r}removeAt(r){const e=this.get(r.toLowerCase());if(e){delete this.items[r]}return e}has(r){return!!this.get(r)}get length(){return Object.keys(this.items).length}get algorithms(){const r=[];for(const e in this.items){const t=this.items[e];r.push(t.name)}return r.sort()}}class SubtleCrypto{constructor(){this.providers=new ProviderStorage}static isHashedAlgorithm(r){return r&&typeof r==="object"&&"name"in r&&"hash"in r?true:false}get[Symbol.toStringTag](){return"SubtleCrypto"}async digest(...r){this.checkRequiredArguments(r,2,"digest");const[e,t,...s]=r;const o=this.prepareAlgorithm(e);const i=n.BufferSourceConverter.toArrayBuffer(t);const a=this.getProvider(o.name);const c=await a.digest(o,i,...s);return c}async generateKey(...r){this.checkRequiredArguments(r,3,"generateKey");const[e,t,n,...s]=r;const o=this.prepareAlgorithm(e);const i=this.getProvider(o.name);const a=await i.generateKey({...o,name:i.name},t,n,...s);return a}async sign(...r){this.checkRequiredArguments(r,3,"sign");const[e,t,s,...o]=r;this.checkCryptoKey(t);const i=this.prepareAlgorithm(e);const a=n.BufferSourceConverter.toArrayBuffer(s);const c=this.getProvider(i.name);const u=await c.sign({...i,name:c.name},t,a,...o);return u}async verify(...r){this.checkRequiredArguments(r,4,"verify");const[e,t,s,o,...i]=r;this.checkCryptoKey(t);const a=this.prepareAlgorithm(e);const c=n.BufferSourceConverter.toArrayBuffer(o);const u=n.BufferSourceConverter.toArrayBuffer(s);const f=this.getProvider(a.name);const l=await f.verify({...a,name:f.name},t,u,c,...i);return l}async encrypt(...r){this.checkRequiredArguments(r,3,"encrypt");const[e,t,s,...o]=r;this.checkCryptoKey(t);const i=this.prepareAlgorithm(e);const a=n.BufferSourceConverter.toArrayBuffer(s);const c=this.getProvider(i.name);const u=await c.encrypt({...i,name:c.name},t,a,{keyUsage:true},...o);return u}async decrypt(...r){this.checkRequiredArguments(r,3,"decrypt");const[e,t,s,...o]=r;this.checkCryptoKey(t);const i=this.prepareAlgorithm(e);const a=n.BufferSourceConverter.toArrayBuffer(s);const c=this.getProvider(i.name);const u=await c.decrypt({...i,name:c.name},t,a,{keyUsage:true},...o);return u}async deriveBits(...r){this.checkRequiredArguments(r,3,"deriveBits");const[e,t,n,...s]=r;this.checkCryptoKey(t);const o=this.prepareAlgorithm(e);const i=this.getProvider(o.name);const a=await i.deriveBits({...o,name:i.name},t,n,{keyUsage:true},...s);return a}async deriveKey(...r){this.checkRequiredArguments(r,5,"deriveKey");const[e,t,n,s,o,...i]=r;const a=this.prepareAlgorithm(n);const c=this.getProvider(a.name);c.checkDerivedKeyParams(a);const u=this.prepareAlgorithm(e);const f=this.getProvider(u.name);f.checkCryptoKey(t,"deriveKey");const l=await f.deriveBits({...u,name:f.name},t,n.length||512,{keyUsage:false},...i);return this.importKey("raw",l,n,s,o,...i)}async exportKey(...r){this.checkRequiredArguments(r,2,"exportKey");const[e,t,...n]=r;this.checkCryptoKey(t);const s=this.getProvider(t.algorithm.name);const o=await s.exportKey(e,t,...n);return o}async importKey(...r){this.checkRequiredArguments(r,5,"importKey");const[e,t,s,o,i,...a]=r;const c=this.prepareAlgorithm(s);const u=this.getProvider(c.name);if(["pkcs8","spki","raw"].indexOf(e)!==-1){const r=n.BufferSourceConverter.toArrayBuffer(t);return u.importKey(e,r,{...c,name:u.name},o,i,...a)}else{if(!t.kty){throw new TypeError("keyData: Is not JSON")}}return u.importKey(e,t,{...c,name:u.name},o,i,...a)}async wrapKey(r,e,t,s,...o){let i=await this.exportKey(r,e,...o);if(r==="jwk"){const r=JSON.stringify(i);i=n.Convert.FromUtf8String(r)}const a=this.prepareAlgorithm(s);const c=n.BufferSourceConverter.toArrayBuffer(i);const u=this.getProvider(a.name);return u.encrypt({...a,name:u.name},t,c,{keyUsage:false},...o)}async unwrapKey(r,e,t,s,o,i,a,...c){const u=this.prepareAlgorithm(s);const f=n.BufferSourceConverter.toArrayBuffer(e);const l=this.getProvider(u.name);let h=await l.decrypt({...u,name:l.name},t,f,{keyUsage:false},...c);if(r==="jwk"){try{h=JSON.parse(n.Convert.ToUtf8String(h))}catch(r){const e=new TypeError("wrappedKey: Is not a JSON");e.internal=r;throw e}}return this.importKey(r,h,o,i,a,...c)}checkRequiredArguments(r,e,t){if(r.length<e){throw new TypeError(`Failed to execute '${t}' on 'SubtleCrypto': ${e} arguments required, but only ${r.length} present`)}}prepareAlgorithm(r){if(typeof r==="string"){return{name:r}}if(SubtleCrypto.isHashedAlgorithm(r)){const e={...r};e.hash=this.prepareAlgorithm(r.hash);return e}return{...r}}getProvider(r){const e=this.providers.get(r);if(!e){throw new AlgorithmError("Unrecognized name")}return e}checkCryptoKey(r){if(!(r instanceof CryptoKey)){throw new TypeError(`Key is not of type 'CryptoKey'`)}}}let f=class ObjectIdentifier{constructor(r){if(r){this.value=r}}};s.__decorate([o.AsnProp({type:o.AsnPropTypes.ObjectIdentifier})],f.prototype,"value",void 0);f=s.__decorate([o.AsnType({type:o.AsnTypeTypes.Choice})],f);class AlgorithmIdentifier{constructor(r){Object.assign(this,r)}}s.__decorate([o.AsnProp({type:o.AsnPropTypes.ObjectIdentifier})],AlgorithmIdentifier.prototype,"algorithm",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Any,optional:true})],AlgorithmIdentifier.prototype,"parameters",void 0);class PrivateKeyInfo{constructor(){this.version=0;this.privateKeyAlgorithm=new AlgorithmIdentifier;this.privateKey=new ArrayBuffer(0)}}s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer})],PrivateKeyInfo.prototype,"version",void 0);s.__decorate([o.AsnProp({type:AlgorithmIdentifier})],PrivateKeyInfo.prototype,"privateKeyAlgorithm",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.OctetString})],PrivateKeyInfo.prototype,"privateKey",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Any,optional:true})],PrivateKeyInfo.prototype,"attributes",void 0);class PublicKeyInfo{constructor(){this.publicKeyAlgorithm=new AlgorithmIdentifier;this.publicKey=new ArrayBuffer(0)}}s.__decorate([o.AsnProp({type:AlgorithmIdentifier})],PublicKeyInfo.prototype,"publicKeyAlgorithm",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.BitString})],PublicKeyInfo.prototype,"publicKey",void 0);const l={fromJSON:r=>n.Convert.FromBase64Url(r),toJSON:r=>n.Convert.ToBase64Url(new Uint8Array(r))};const h={fromASN:r=>{const e=r.valueBlock.valueHex;return!new Uint8Array(e)[0]?r.valueBlock.valueHex.slice(1):r.valueBlock.valueHex},toASN:r=>{const e=new Uint8Array(r)[0]>127?Buffer.concat([Buffer.from([0]),Buffer.from(r)]):Buffer.from(r);return new c.Integer({valueHex:new Uint8Array(e).buffer})}};var y=Object.freeze({__proto__:null,JsonBase64UrlArrayBufferConverter:l,AsnIntegerArrayBufferConverter:h});class RsaPrivateKey{constructor(){this.version=0;this.modulus=new ArrayBuffer(0);this.publicExponent=new ArrayBuffer(0);this.privateExponent=new ArrayBuffer(0);this.prime1=new ArrayBuffer(0);this.prime2=new ArrayBuffer(0);this.exponent1=new ArrayBuffer(0);this.exponent2=new ArrayBuffer(0);this.coefficient=new ArrayBuffer(0)}}s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:o.AsnIntegerConverter})],RsaPrivateKey.prototype,"version",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:h}),i.JsonProp({name:"n",converter:l})],RsaPrivateKey.prototype,"modulus",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:h}),i.JsonProp({name:"e",converter:l})],RsaPrivateKey.prototype,"publicExponent",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:h}),i.JsonProp({name:"d",converter:l})],RsaPrivateKey.prototype,"privateExponent",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:h}),i.JsonProp({name:"p",converter:l})],RsaPrivateKey.prototype,"prime1",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:h}),i.JsonProp({name:"q",converter:l})],RsaPrivateKey.prototype,"prime2",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:h}),i.JsonProp({name:"dp",converter:l})],RsaPrivateKey.prototype,"exponent1",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:h}),i.JsonProp({name:"dq",converter:l})],RsaPrivateKey.prototype,"exponent2",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:h}),i.JsonProp({name:"qi",converter:l})],RsaPrivateKey.prototype,"coefficient",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Any,optional:true})],RsaPrivateKey.prototype,"otherPrimeInfos",void 0);class RsaPublicKey{constructor(){this.modulus=new ArrayBuffer(0);this.publicExponent=new ArrayBuffer(0)}}s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:h}),i.JsonProp({name:"n",converter:l})],RsaPublicKey.prototype,"modulus",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:h}),i.JsonProp({name:"e",converter:l})],RsaPublicKey.prototype,"publicExponent",void 0);let p=class EcPublicKey{constructor(r){this.value=new ArrayBuffer(0);if(r){this.value=r}}toJSON(){let r=new Uint8Array(this.value);if(r[0]!==4){throw new CryptoError("Wrong ECPoint. Current version supports only Uncompressed (0x04) point")}r=new Uint8Array(this.value.slice(1));const e=r.length/2;const t=0;const s={x:n.Convert.ToBase64Url(r.buffer.slice(t,t+e)),y:n.Convert.ToBase64Url(r.buffer.slice(t+e,t+e+e))};return s}fromJSON(r){if(!("x"in r)){throw new Error("x: Missing required property")}if(!("y"in r)){throw new Error("y: Missing required property")}const e=n.Convert.FromBase64Url(r.x);const t=n.Convert.FromBase64Url(r.y);const s=Buffer.concat([new Uint8Array([4]),new Uint8Array(e),new Uint8Array(t)]);this.value=new Uint8Array(s).buffer;return this}};s.__decorate([o.AsnProp({type:o.AsnPropTypes.OctetString})],p.prototype,"value",void 0);p=s.__decorate([o.AsnType({type:o.AsnTypeTypes.Choice})],p);class EcPrivateKey{constructor(){this.version=1;this.privateKey=new ArrayBuffer(0)}fromJSON(r){if(!("d"in r)){throw new Error("d: Missing required property")}this.privateKey=n.Convert.FromBase64Url(r.d);if("x"in r){const e=new p;e.fromJSON(r);this.publicKey=o.AsnSerializer.toASN(e).valueBlock.valueHex}return this}toJSON(){const r={};r.d=n.Convert.ToBase64Url(this.privateKey);if(this.publicKey){Object.assign(r,new p(this.publicKey).toJSON())}return r}}s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:o.AsnIntegerConverter})],EcPrivateKey.prototype,"version",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.OctetString})],EcPrivateKey.prototype,"privateKey",void 0);s.__decorate([o.AsnProp({context:0,type:o.AsnPropTypes.Any,optional:true})],EcPrivateKey.prototype,"parameters",void 0);s.__decorate([o.AsnProp({context:1,type:o.AsnPropTypes.BitString,optional:true})],EcPrivateKey.prototype,"publicKey",void 0);const d={fromASN:r=>{const e=new Uint8Array(r.valueBlock.valueHex);return e[0]===0?e.buffer.slice(1):e.buffer},toASN:r=>{const e=new Uint8Array(r);if(e[0]>127){const r=new Uint8Array(e.length+1);r.set(e,1);return new c.Integer({valueHex:r.buffer})}return new c.Integer({valueHex:r})}};var g=Object.freeze({__proto__:null,AsnIntegerWithoutPaddingConverter:d});class EcDsaSignature{constructor(){this.r=new ArrayBuffer(0);this.s=new ArrayBuffer(0)}static fromWebCryptoSignature(r){const e=n.BufferSourceConverter.toUint8Array(r);const t=e.byteLength/2;const s=new this;s.r=s.removePadding(e.slice(0,t));s.s=s.removePadding(e.slice(t,t*2));return s}toWebCryptoSignature(r){r=this.getPointSize();const e=this.addPadding(r,n.BufferSourceConverter.toUint8Array(this.r));const t=this.addPadding(r,n.BufferSourceConverter.toUint8Array(this.s));const s=new Uint8Array(e.byteLength+t.byteLength);s.set(e,0);s.set(t,e.length);return s.buffer}getPointSize(){const r=Math.max(this.r.byteLength,this.s.byteLength);switch(r){case 31:case 32:return 32;case 47:case 48:return 48;case 65:case 66:return 66}throw new Error("Unsupported EC point size")}addPadding(r,e){const t=new Uint8Array(r);const s=n.BufferSourceConverter.toUint8Array(e);t.set(s,r-s.length);return t}removePadding(r){const e=n.BufferSourceConverter.toUint8Array(r);for(let r=0;r<e.length;r++){if(!e[r]){continue}return e.slice(r)}return new Uint8Array(0)}}s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:d})],EcDsaSignature.prototype,"r",void 0);s.__decorate([o.AsnProp({type:o.AsnPropTypes.Integer,converter:d})],EcDsaSignature.prototype,"s",void 0);let A=class CurvePrivateKey{};s.__decorate([o.AsnProp({type:o.AsnPropTypes.OctetString}),i.JsonProp({type:i.JsonPropTypes.String,converter:l})],A.prototype,"d",void 0);A=s.__decorate([o.AsnType({type:o.AsnTypeTypes.Choice})],A);const w="1.3.101.110";const B="1.3.101.111";const v="1.3.101.112";const S="1.3.101.113";var C=Object.freeze({__proto__:null,converters:g,get ObjectIdentifier(){return f},AlgorithmIdentifier:AlgorithmIdentifier,PrivateKeyInfo:PrivateKeyInfo,PublicKeyInfo:PublicKeyInfo,RsaPrivateKey:RsaPrivateKey,RsaPublicKey:RsaPublicKey,EcPrivateKey:EcPrivateKey,get EcPublicKey(){return p},EcDsaSignature:EcDsaSignature,get CurvePrivateKey(){return A},idX25519:w,idX448:B,idEd25519:v,idEd448:S});var k=Object.freeze({__proto__:null,converters:y});Object.defineProperty(e,"BufferSourceConverter",{enumerable:true,get:function(){return n.BufferSourceConverter}});e.AesCbcProvider=AesCbcProvider;e.AesCmacProvider=AesCmacProvider;e.AesCtrProvider=AesCtrProvider;e.AesEcbProvider=AesEcbProvider;e.AesGcmProvider=AesGcmProvider;e.AesKwProvider=AesKwProvider;e.AesProvider=AesProvider;e.AlgorithmError=AlgorithmError;e.Crypto=Crypto;e.CryptoError=CryptoError;e.CryptoKey=CryptoKey;e.DesProvider=DesProvider;e.EcdhEsProvider=EcdhEsProvider;e.EcdhProvider=EcdhProvider;e.EcdsaProvider=EcdsaProvider;e.EdDsaProvider=EdDsaProvider;e.EllipticProvider=EllipticProvider;e.HkdfProvider=HkdfProvider;e.HmacProvider=HmacProvider;e.OperationError=OperationError;e.Pbkdf2Provider=Pbkdf2Provider;e.PemConverter=PemConverter;e.ProviderCrypto=ProviderCrypto;e.ProviderStorage=ProviderStorage;e.RequiredPropertyError=RequiredPropertyError;e.RsaOaepProvider=RsaOaepProvider;e.RsaProvider=RsaProvider;e.RsaPssProvider=RsaPssProvider;e.RsaSsaProvider=RsaSsaProvider;e.SubtleCrypto=SubtleCrypto;e.UnsupportedOperationError=UnsupportedOperationError;e.asn1=C;e.isJWK=isJWK;e.json=k},610:(r,e,t)=>{"use strict";t.r(e);t.d(e,{__extends:()=>__extends,__assign:()=>s,__rest:()=>__rest,__decorate:()=>__decorate,__param:()=>__param,__metadata:()=>__metadata,__awaiter:()=>__awaiter,__generator:()=>__generator,__createBinding:()=>o,__exportStar:()=>__exportStar,__values:()=>__values,__read:()=>__read,__spread:()=>__spread,__spreadArrays:()=>__spreadArrays,__spreadArray:()=>__spreadArray,__await:()=>__await,__asyncGenerator:()=>__asyncGenerator,__asyncDelegator:()=>__asyncDelegator,__asyncValues:()=>__asyncValues,__makeTemplateObject:()=>__makeTemplateObject,__importStar:()=>__importStar,__importDefault:()=>__importDefault,__classPrivateFieldGet:()=>__classPrivateFieldGet,__classPrivateFieldSet:()=>__classPrivateFieldSet});var n=function(r,e){n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,e){r.__proto__=e}||function(r,e){for(var t in e)if(Object.prototype.hasOwnProperty.call(e,t))r[t]=e[t]};return n(r,e)};function __extends(r,e){if(typeof e!=="function"&&e!==null)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");n(r,e);function __(){this.constructor=r}r.prototype=e===null?Object.create(e):(__.prototype=e.prototype,new __)}var s=function(){s=Object.assign||function __assign(r){for(var e,t=1,n=arguments.length;t<n;t++){e=arguments[t];for(var s in e)if(Object.prototype.hasOwnProperty.call(e,s))r[s]=e[s]}return r};return s.apply(this,arguments)};function __rest(r,e){var t={};for(var n in r)if(Object.prototype.hasOwnProperty.call(r,n)&&e.indexOf(n)<0)t[n]=r[n];if(r!=null&&typeof Object.getOwnPropertySymbols==="function")for(var s=0,n=Object.getOwnPropertySymbols(r);s<n.length;s++){if(e.indexOf(n[s])<0&&Object.prototype.propertyIsEnumerable.call(r,n[s]))t[n[s]]=r[n[s]]}return t}function __decorate(r,e,t,n){var s=arguments.length,o=s<3?e:n===null?n=Object.getOwnPropertyDescriptor(e,t):n,i;if(typeof Reflect==="object"&&typeof Reflect.decorate==="function")o=Reflect.decorate(r,e,t,n);else for(var a=r.length-1;a>=0;a--)if(i=r[a])o=(s<3?i(o):s>3?i(e,t,o):i(e,t))||o;return s>3&&o&&Object.defineProperty(e,t,o),o}function __param(r,e){return function(t,n){e(t,n,r)}}function __metadata(r,e){if(typeof Reflect==="object"&&typeof Reflect.metadata==="function")return Reflect.metadata(r,e)}function __awaiter(r,e,t,n){function adopt(r){return r instanceof t?r:new t(function(e){e(r)})}return new(t||(t=Promise))(function(t,s){function fulfilled(r){try{step(n.next(r))}catch(r){s(r)}}function rejected(r){try{step(n["throw"](r))}catch(r){s(r)}}function step(r){r.done?t(r.value):adopt(r.value).then(fulfilled,rejected)}step((n=n.apply(r,e||[])).next())})}function __generator(r,e){var t={label:0,sent:function(){if(o[0]&1)throw o[1];return o[1]},trys:[],ops:[]},n,s,o,i;return i={next:verb(0),throw:verb(1),return:verb(2)},typeof Symbol==="function"&&(i[Symbol.iterator]=function(){return this}),i;function verb(r){return function(e){return step([r,e])}}function step(i){if(n)throw new TypeError("Generator is already executing.");while(t)try{if(n=1,s&&(o=i[0]&2?s["return"]:i[0]?s["throw"]||((o=s["return"])&&o.call(s),0):s.next)&&!(o=o.call(s,i[1])).done)return o;if(s=0,o)i=[i[0]&2,o.value];switch(i[0]){case 0:case 1:o=i;break;case 4:t.label++;return{value:i[1],done:false};case 5:t.label++;s=i[1];i=[0];continue;case 7:i=t.ops.pop();t.trys.pop();continue;default:if(!(o=t.trys,o=o.length>0&&o[o.length-1])&&(i[0]===6||i[0]===2)){t=0;continue}if(i[0]===3&&(!o||i[1]>o[0]&&i[1]<o[3])){t.label=i[1];break}if(i[0]===6&&t.label<o[1]){t.label=o[1];o=i;break}if(o&&t.label<o[2]){t.label=o[2];t.ops.push(i);break}if(o[2])t.ops.pop();t.trys.pop();continue}i=e.call(r,t)}catch(r){i=[6,r];s=0}finally{n=o=0}if(i[0]&5)throw i[1];return{value:i[0]?i[1]:void 0,done:true}}}var o=Object.create?function(r,e,t,n){if(n===undefined)n=t;Object.defineProperty(r,n,{enumerable:true,get:function(){return e[t]}})}:function(r,e,t,n){if(n===undefined)n=t;r[n]=e[t]};function __exportStar(r,e){for(var t in r)if(t!=="default"&&!Object.prototype.hasOwnProperty.call(e,t))o(e,r,t)}function __values(r){var e=typeof Symbol==="function"&&Symbol.iterator,t=e&&r[e],n=0;if(t)return t.call(r);if(r&&typeof r.length==="number")return{next:function(){if(r&&n>=r.length)r=void 0;return{value:r&&r[n++],done:!r}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function __read(r,e){var t=typeof Symbol==="function"&&r[Symbol.iterator];if(!t)return r;var n=t.call(r),s,o=[],i;try{while((e===void 0||e-- >0)&&!(s=n.next()).done)o.push(s.value)}catch(r){i={error:r}}finally{try{if(s&&!s.done&&(t=n["return"]))t.call(n)}finally{if(i)throw i.error}}return o}function __spread(){for(var r=[],e=0;e<arguments.length;e++)r=r.concat(__read(arguments[e]));return r}function __spreadArrays(){for(var r=0,e=0,t=arguments.length;e<t;e++)r+=arguments[e].length;for(var n=Array(r),s=0,e=0;e<t;e++)for(var o=arguments[e],i=0,a=o.length;i<a;i++,s++)n[s]=o[i];return n}function __spreadArray(r,e,t){if(t||arguments.length===2)for(var n=0,s=e.length,o;n<s;n++){if(o||!(n in e)){if(!o)o=Array.prototype.slice.call(e,0,n);o[n]=e[n]}}return r.concat(o||Array.prototype.slice.call(e))}function __await(r){return this instanceof __await?(this.v=r,this):new __await(r)}function __asyncGenerator(r,e,t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var n=t.apply(r,e||[]),s,o=[];return s={},verb("next"),verb("throw"),verb("return"),s[Symbol.asyncIterator]=function(){return this},s;function verb(r){if(n[r])s[r]=function(e){return new Promise(function(t,n){o.push([r,e,t,n])>1||resume(r,e)})}}function resume(r,e){try{step(n[r](e))}catch(r){settle(o[0][3],r)}}function step(r){r.value instanceof __await?Promise.resolve(r.value.v).then(fulfill,reject):settle(o[0][2],r)}function fulfill(r){resume("next",r)}function reject(r){resume("throw",r)}function settle(r,e){if(r(e),o.shift(),o.length)resume(o[0][0],o[0][1])}}function __asyncDelegator(r){var e,t;return e={},verb("next"),verb("throw",function(r){throw r}),verb("return"),e[Symbol.iterator]=function(){return this},e;function verb(n,s){e[n]=r[n]?function(e){return(t=!t)?{value:__await(r[n](e)),done:n==="return"}:s?s(e):e}:s}}function __asyncValues(r){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e=r[Symbol.asyncIterator],t;return e?e.call(r):(r=typeof __values==="function"?__values(r):r[Symbol.iterator](),t={},verb("next"),verb("throw"),verb("return"),t[Symbol.asyncIterator]=function(){return this},t);function verb(e){t[e]=r[e]&&function(t){return new Promise(function(n,s){t=r[e](t),settle(n,s,t.done,t.value)})}}function settle(r,e,t,n){Promise.resolve(n).then(function(e){r({value:e,done:t})},e)}}function __makeTemplateObject(r,e){if(Object.defineProperty){Object.defineProperty(r,"raw",{value:e})}else{r.raw=e}return r}var i=Object.create?function(r,e){Object.defineProperty(r,"default",{enumerable:true,value:e})}:function(r,e){r["default"]=e};function __importStar(r){if(r&&r.__esModule)return r;var e={};if(r!=null)for(var t in r)if(t!=="default"&&Object.prototype.hasOwnProperty.call(r,t))o(e,r,t);i(e,r);return e}function __importDefault(r){return r&&r.__esModule?r:{default:r}}function __classPrivateFieldGet(r,e,t,n){if(t==="a"&&!n)throw new TypeError("Private accessor was defined without a getter");if(typeof e==="function"?r!==e||!n:!e.has(r))throw new TypeError("Cannot read private member from an object whose class did not declare it");return t==="m"?n:t==="a"?n.call(r):n?n.value:e.get(r)}function __classPrivateFieldSet(r,e,t,n,s){if(n==="m")throw new TypeError("Private method is not writable");if(n==="a"&&!s)throw new TypeError("Private accessor was defined without a setter");if(typeof e==="function"?r!==e||!s:!e.has(r))throw new TypeError("Cannot write private member to an object whose class did not declare it");return n==="a"?s.call(r,t):s?s.value=t:e.set(r,t),t}},417:r=>{"use strict";r.exports=require("crypto")},765:r=>{"use strict";r.exports=require("process")}};var e={};function __nccwpck_require__(t){if(e[t]){return e[t].exports}var n=e[t]={exports:{}};var s=true;try{r[t].call(n.exports,n,n.exports,__nccwpck_require__);s=false}finally{if(s)delete e[t]}return n.exports}(()=>{__nccwpck_require__.d=((r,e)=>{for(var t in e){if(__nccwpck_require__.o(e,t)&&!__nccwpck_require__.o(r,t)){Object.defineProperty(r,t,{enumerable:true,get:e[t]})}}})})();(()=>{__nccwpck_require__.o=((r,e)=>Object.prototype.hasOwnProperty.call(r,e))})();(()=>{__nccwpck_require__.r=(r=>{if(typeof Symbol!=="undefined"&&Symbol.toStringTag){Object.defineProperty(r,Symbol.toStringTag,{value:"Module"})}Object.defineProperty(r,"__esModule",{value:true})})})();__nccwpck_require__.ab=__dirname+"/";return __nccwpck_require__(25)})();