module.exports=(()=>{var e={3094:e=>{"use strict";e.exports=JSON.parse('[{"id":"all-property","title":"`all` Property","description":"A property for defining the reset of all properties of an element","specification":"https://www.w3.org/TR/css-cascade-3/#all-shorthand","stage":3,"caniuse":"css-all","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/all"},"example":"a {\\n  all: initial;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/maximkoretskiy/postcss-initial"}]},{"id":"any-link-pseudo-class","title":"`:any-link` Hyperlink Pseudo-Class","description":"A pseudo-class for matching anchor elements independent of whether they have been visited","specification":"https://www.w3.org/TR/selectors-4/#any-link-pseudo","stage":2,"caniuse":"css-any-link","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/:any-link"},"example":"nav :any-link > span {\\n  background-color: yellow;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-pseudo-class-any-link"}]},{"id":"blank-pseudo-class","title":"`:blank` Empty-Value Pseudo-Class","description":"A pseudo-class for matching form elements when they are empty","specification":"https://drafts.csswg.org/selectors-4/#blank","stage":1,"example":"input:blank {\\n  background-color: yellow;\\n}","polyfills":[{"type":"JavaScript Library","link":"https://github.com/csstools/css-blank-pseudo"},{"type":"PostCSS Plugin","link":"https://github.com/csstools/css-blank-pseudo"}]},{"id":"break-properties","title":"Break Properties","description":"Properties for defining the break behavior between and within boxes","specification":"https://www.w3.org/TR/css-break-3/#breaking-controls","stage":3,"caniuse":"multicolumn","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/break-after"},"example":"a {\\n  break-inside: avoid;\\n  break-before: avoid-column;\\n  break-after: always;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/shrpne/postcss-page-break"}]},{"id":"case-insensitive-attributes","title":"Case-Insensitive Attributes","description":"An attribute selector matching attribute values case-insensitively","specification":"https://www.w3.org/TR/selectors-4/#attribute-case","stage":2,"caniuse":"css-case-insensitive","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/Attribute_selectors"},"example":"[frame=hsides i] {\\n  border-style: solid none;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/Semigradsky/postcss-attribute-case-insensitive"}]},{"id":"color-adjust","title":"`color-adjust` Property","description":"The color-adjust property is a non-standard CSS extension that can be used to force printing of background colors and images","specification":"https://www.w3.org/TR/css-color-4/#color-adjust","stage":2,"caniuse":"css-color-adjust","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/color-adjust"},"example":".background {\\n  background-color:#ccc;\\n}\\n.background.color-adjust {\\n  color-adjust: economy;\\n}\\n.background.color-adjust-exact {\\n  color-adjust: exact;\\n}"},{"id":"color-functional-notation","title":"Color Functional Notation","description":"A space and slash separated notation for specifying colors","specification":"https://drafts.csswg.org/css-color/#ref-for-funcdef-rgb%E2%91%A1%E2%91%A0","stage":1,"example":"em {\\n  background-color: hsl(120deg 100% 25%);\\n  box-shadow: 0 0 0 10px hwb(120deg 100% 25% / 80%);\\n  color: rgb(0 255 0);\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-color-functional-notation"}]},{"id":"color-mod-function","title":"`color-mod()` Function","description":"A function for modifying colors","specification":"https://www.w3.org/TR/css-color-4/#funcdef-color-mod","stage":-1,"example":"p {\\n  color: color-mod(black alpha(50%));\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-color-mod-function"}]},{"id":"custom-media-queries","title":"Custom Media Queries","description":"An at-rule for defining aliases that represent media queries","specification":"https://drafts.csswg.org/mediaqueries-5/#at-ruledef-custom-media","stage":1,"example":"@custom-media --narrow-window (max-width: 30em);\\n\\n@media (--narrow-window) {}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/postcss-custom-media"}]},{"id":"custom-properties","title":"Custom Properties","description":"A syntax for defining custom values accepted by all CSS properties","specification":"https://www.w3.org/TR/css-variables-1/","stage":3,"caniuse":"css-variables","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/var"},"example":"img {\\n  --some-length: 32px;\\n\\n  height: var(--some-length);\\n  width: var(--some-length);\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/postcss-custom-properties"}]},{"id":"custom-property-sets","title":"Custom Property Sets","description":"A syntax for storing properties in named variables, referenceable in other style rules","specification":"https://tabatkins.github.io/specs/css-apply-rule/","stage":-1,"caniuse":"css-apply-rule","example":"img {\\n  --some-length-styles: {\\n    height: 32px;\\n    width: 32px;\\n  };\\n\\n  @apply --some-length-styles;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/pascalduez/postcss-apply"}]},{"id":"custom-selectors","title":"Custom Selectors","description":"An at-rule for defining aliases that represent selectors","specification":"https://drafts.csswg.org/css-extensions/#custom-selectors","stage":1,"example":"@custom-selector :--heading h1, h2, h3, h4, h5, h6;\\n\\narticle :--heading + p {}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/postcss-custom-selectors"}]},{"id":"dir-pseudo-class","title":"`:dir` Directionality Pseudo-Class","description":"A pseudo-class for matching elements based on their directionality","specification":"https://www.w3.org/TR/selectors-4/#dir-pseudo","stage":2,"caniuse":"css-dir-pseudo","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/:dir"},"example":"blockquote:dir(rtl) {\\n  margin-right: 10px;\\n}\\n\\nblockquote:dir(ltr) {\\n  margin-left: 10px;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-dir-pseudo-class"}]},{"id":"double-position-gradients","title":"Double Position Gradients","description":"A syntax for using two positions in a gradient.","specification":"https://www.w3.org/TR/css-images-4/#color-stop-syntax","stage":2,"caniuse-compat":{"and_chr":{"71":"y"},"chrome":{"71":"y"}},"example":".pie_chart {\\n  background-image: conic-gradient(yellowgreen 40%, gold 0deg 75%, #f06 0deg);\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-double-position-gradients"}]},{"id":"environment-variables","title":"Custom Environment Variables","description":"A syntax for using custom values accepted by CSS globally","specification":"https://drafts.csswg.org/css-env-1/","stage":0,"caniuse-compat":{"and_chr":{"69":"y"},"chrome":{"69":"y"},"ios_saf":{"11.2":"y"},"safari":{"11.2":"y"}},"docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/env"},"example":"@media (max-width: env(--brand-small)) {\\n  body {\\n    padding: env(--brand-spacing);\\n  }\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-env-function"}]},{"id":"focus-visible-pseudo-class","title":"`:focus-visible` Focus-Indicated Pseudo-Class","description":"A pseudo-class for matching focused elements that indicate that focus to a user","specification":"https://www.w3.org/TR/selectors-4/#focus-visible-pseudo","stage":2,"caniuse":"css-focus-visible","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/:focus-visible"},"example":":focus:not(:focus-visible) {\\n  outline: 0;\\n}","polyfills":[{"type":"JavaScript Library","link":"https://github.com/WICG/focus-visible"},{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-focus-visible"}]},{"id":"focus-within-pseudo-class","title":"`:focus-within` Focus Container Pseudo-Class","description":"A pseudo-class for matching elements that are either focused or that have focused descendants","specification":"https://www.w3.org/TR/selectors-4/#focus-within-pseudo","stage":2,"caniuse":"css-focus-within","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/:focus-within"},"example":"form:focus-within {\\n  background: rgba(0, 0, 0, 0.3);\\n}","polyfills":[{"type":"JavaScript Library","link":"https://github.com/jonathantneal/focus-within"},{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-focus-within"}]},{"id":"font-variant-property","title":"`font-variant` Property","description":"A property for defining the usage of alternate glyphs in a font","specification":"https://www.w3.org/TR/css-fonts-3/#propdef-font-variant","stage":3,"caniuse":"font-variant-alternates","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/font-variant"},"example":"h2 {\\n  font-variant: small-caps;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/postcss-font-variant"}]},{"id":"gap-properties","title":"Gap Properties","description":"Properties for defining gutters within a layout","specification":"https://www.w3.org/TR/css-grid-1/#gutters","stage":3,"caniuse-compat":{"chrome":{"66":"y"},"edge":{"16":"y"},"firefox":{"61":"y"},"safari":{"11.2":"y","TP":"y"}},"docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/gap"},"example":".grid-1 {\\n  gap: 20px;\\n}\\n\\n.grid-2 {\\n  column-gap: 40px;\\n  row-gap: 20px;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-gap-properties"}]},{"id":"gray-function","title":"`gray()` Function","description":"A function for specifying fully desaturated colors","specification":"https://www.w3.org/TR/css-color-4/#funcdef-gray","stage":2,"example":"p {\\n  color: gray(50);\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/postcss-color-gray"}]},{"id":"grid-layout","title":"Grid Layout","description":"A syntax for using a grid concept to lay out content","specification":"https://www.w3.org/TR/css-grid-1/","stage":3,"caniuse":"css-grid","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/grid"},"example":"section {\\n  display: grid;\\n  grid-template-columns: 100px 100px 100px;\\n  grid-gap: 10px;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/autoprefixer"}]},{"id":"has-pseudo-class","title":"`:has()` Relational Pseudo-Class","description":"A pseudo-class for matching ancestor and sibling elements","specification":"https://www.w3.org/TR/selectors-4/#has-pseudo","stage":2,"caniuse":"css-has","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/:has"},"example":"a:has(> img) {\\n  display: block;\\n}","polyfills":[{"type":"JavaScript Library","link":"https://github.com/csstools/css-has-pseudo"},{"type":"PostCSS Plugin","link":"https://github.com/csstools/css-has-pseudo"}]},{"id":"hexadecimal-alpha-notation","title":"Hexadecimal Alpha Notation","description":"A 4 & 8 character hex color notation for specifying the opacity level","specification":"https://www.w3.org/TR/css-color-4/#hex-notation","stage":2,"caniuse":"css-rrggbbaa","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Syntax_2"},"example":"section {\\n  background-color: #f3f3f3f3;\\n  color: #0003;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/postcss-color-hex-alpha"}]},{"id":"hwb-function","title":"`hwb()` Function","description":"A function for specifying colors by hue and then a degree of whiteness and blackness to mix into it","specification":"https://www.w3.org/TR/css-color-4/#funcdef-hwb","stage":2,"example":"p {\\n  color: hwb(120 44% 50%);\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/postcss-color-hwb"}]},{"id":"image-set-function","title":"`image-set()` Function","description":"A function for specifying image sources based on the user’s resolution","specification":"https://www.w3.org/TR/css-images-4/#image-set-notation","stage":2,"caniuse":"css-image-set","example":"p {\\n  background-image: image-set(\\n    \\"foo.png\\" 1x,\\n    \\"foo-2x.png\\" 2x,\\n    \\"foo-print.png\\" 600dpi\\n  );\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-image-set-function"}]},{"id":"in-out-of-range-pseudo-class","title":"`:in-range` and `:out-of-range` Pseudo-Classes","description":"A pseudo-class for matching elements that have range limitations","specification":"https://www.w3.org/TR/selectors-4/#range-pseudos","stage":2,"caniuse":"css-in-out-of-range","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/:in-range"},"example":"input:in-range {\\n  background-color: rgba(0, 255, 0, 0.25);\\n}\\ninput:out-of-range {\\n  background-color: rgba(255, 0, 0, 0.25);\\n  border: 2px solid red;\\n}"},{"id":"lab-function","title":"`lab()` Function","description":"A function for specifying colors expressed in the CIE Lab color space","specification":"https://www.w3.org/TR/css-color-4/#funcdef-lab","stage":2,"example":"body {\\n  color: lab(240 50 20);\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-lab-function"}]},{"id":"lch-function","title":"`lch()` Function","description":"A function for specifying colors expressed in the CIE Lab color space with chroma and hue","specification":"https://www.w3.org/TR/css-color-4/#funcdef-lch","stage":2,"example":"body {\\n  color: lch(53 105 40);\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-lab-function"}]},{"id":"logical-properties-and-values","title":"Logical Properties and Values","description":"Flow-relative (left-to-right or right-to-left) properties and values","specification":"https://www.w3.org/TR/css-logical-1/","stage":2,"caniuse":"css-logical-props","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Logical_Properties"},"example":"span:first-child {\\n  float: inline-start;\\n  margin-inline-start: 10px;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-logical-properties"}]},{"id":"matches-pseudo-class","title":"`:matches()` Matches-Any Pseudo-Class","description":"A pseudo-class for matching elements in a selector list","specification":"https://www.w3.org/TR/selectors-4/#matches-pseudo","stage":2,"caniuse":"css-matches-pseudo","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/:matches"},"example":"p:matches(:first-child, .special) {\\n  margin-top: 1em;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/postcss-selector-matches"}]},{"id":"media-query-ranges","title":"Media Query Ranges","description":"A syntax for defining media query ranges using ordinary comparison operators","specification":"https://www.w3.org/TR/mediaqueries-4/#range-context","stage":3,"docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/Media_Queries/Using_media_queries#Syntax_improvements_in_Level_4"},"example":"@media (width < 480px) {}\\n\\n@media (480px <= width < 768px) {}\\n\\n@media (width >= 768px) {}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/postcss-media-minmax"}]},{"id":"nesting-rules","title":"Nesting Rules","description":"A syntax for nesting relative rules within rules","specification":"https://drafts.csswg.org/css-nesting-1/","stage":1,"example":"article {\\n  & p {\\n    color: #333;\\n  }\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-nesting"}]},{"id":"not-pseudo-class","title":"`:not()` Negation List Pseudo-Class","description":"A pseudo-class for ignoring elements in a selector list","specification":"https://www.w3.org/TR/selectors-4/#negation-pseudo","stage":2,"caniuse":"css-not-sel-list","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/:not"},"example":"p:not(:first-child, .special) {\\n  margin-top: 1em;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/postcss-selector-not"}]},{"id":"overflow-property","title":"`overflow` Shorthand Property","description":"A property for defining `overflow-x` and `overflow-y`","specification":"https://www.w3.org/TR/css-overflow-3/#propdef-overflow","stage":2,"caniuse":"css-overflow","caniuse-compat":{"and_chr":{"68":"y"},"and_ff":{"61":"y"},"chrome":{"68":"y"},"firefox":{"61":"y"}},"docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/overflow"},"example":"html {\\n  overflow: hidden auto;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-overflow-shorthand"}]},{"id":"overflow-wrap-property","title":"`overflow-wrap` Property","description":"A property for defining whether to insert line breaks within words to prevent overflowing","specification":"https://www.w3.org/TR/css-text-3/#overflow-wrap-property","stage":2,"caniuse":"wordwrap","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/overflow-wrap"},"example":"p {\\n  overflow-wrap: break-word;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/mattdimu/postcss-replace-overflow-wrap"}]},{"id":"overscroll-behavior-property","title":"`overscroll-behavior` Property","description":"Properties for controlling when the scroll position of a scroll container reaches the edge of a scrollport","specification":"https://drafts.csswg.org/css-overscroll-behavior","stage":1,"caniuse":"css-overscroll-behavior","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/overscroll-behavior"},"example":".messages {\\n  height: 220px;\\n  overflow: auto;\\n  overscroll-behavior-y: contain;\\n}\\n\\nbody {\\n  margin: 0;\\n  overscroll-behavior: none;\\n}"},{"id":"place-properties","title":"Place Properties","description":"Properties for defining alignment within a layout","specification":"https://www.w3.org/TR/css-align-3/#place-items-property","stage":2,"caniuse-compat":{"chrome":{"59":"y"},"firefox":{"45":"y"}},"docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/place-content"},"example":".example {\\n  place-content: flex-end;\\n  place-items: center / space-between;\\n  place-self: flex-start / center;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/jonathantneal/postcss-place"}]},{"id":"prefers-color-scheme-query","title":"`prefers-color-scheme` Media Query","description":"A media query to detect if the user has requested the system use a light or dark color theme","specification":"https://drafts.csswg.org/mediaqueries-5/#prefers-color-scheme","stage":1,"caniuse":"prefers-color-scheme","caniuse-compat":{"ios_saf":{"12.1":"y"},"safari":{"12.1":"y"}},"example":"body {\\n  background-color: white;\\n  color: black;\\n}\\n\\n@media (prefers-color-scheme: dark) {\\n  body {\\n    background-color: black;\\n    color: white;\\n  }\\n}","polyfills":[{"type":"JavaScript Library","link":"https://github.com/csstools/css-prefers-color-scheme"},{"type":"PostCSS Plugin","link":"https://github.com/csstools/css-prefers-color-scheme"}]},{"id":"prefers-reduced-motion-query","title":"`prefers-reduced-motion` Media Query","description":"A media query to detect if the user has requested less animation and general motion on the page","specification":"https://drafts.csswg.org/mediaqueries-5/#prefers-reduced-motion","stage":1,"caniuse":"prefers-reduced-motion","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-reduced-motion"},"example":".animation {\\n  animation: vibrate 0.3s linear infinite both; \\n}\\n\\n@media (prefers-reduced-motion: reduce) {\\n  .animation {\\n    animation: none;\\n  }\\n}"},{"id":"read-only-write-pseudo-class","title":"`:read-only` and `:read-write` selectors","description":"Pseudo-classes to match elements which are considered user-alterable","specification":"https://www.w3.org/TR/selectors-4/#rw-pseudos","stage":2,"caniuse":"css-read-only-write","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/:read-only"},"example":"input:read-only {\\n  background-color: #ccc;\\n}"},{"id":"rebeccapurple-color","title":"`rebeccapurple` Color","description":"A particularly lovely shade of purple in memory of Rebecca Alison Meyer","specification":"https://www.w3.org/TR/css-color-4/#valdef-color-rebeccapurple","stage":2,"caniuse":"css-rebeccapurple","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/color_value"},"example":"html {\\n  color: rebeccapurple;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/postcss/postcss-color-rebeccapurple"}]},{"id":"system-ui-font-family","title":"`system-ui` Font Family","description":"A generic font used to match the user’s interface","specification":"https://www.w3.org/TR/css-fonts-4/#system-ui-def","stage":2,"caniuse":"font-family-system-ui","docs":{"mdn":"https://developer.mozilla.org/en-US/docs/Web/CSS/font-family#Syntax"},"example":"body {\\n  font-family: system-ui;\\n}","polyfills":[{"type":"PostCSS Plugin","link":"https://github.com/JLHwung/postcss-font-family-system-ui"}]},{"id":"when-else-rules","title":"When/Else Rules","description":"At-rules for specifying media queries and support queries in a single grammar","specification":"https://tabatkins.github.io/specs/css-when-else/","stage":0,"example":"@when media(width >= 640px) and (supports(display: flex) or supports(display: grid)) {\\n  /* A */\\n} @else media(pointer: coarse) {\\n  /* B */\\n} @else {\\n  /* C */\\n}"},{"id":"where-pseudo-class","title":"`:where()` Zero-Specificity Pseudo-Class","description":"A pseudo-class for matching elements in a selector list without contributing specificity","specification":"https://drafts.csswg.org/selectors-4/#where-pseudo","stage":1,"example":"a:where(:not(:hover)) {\\n  text-decoration: none;\\n}"}]')},9614:e=>{"use strict";e.exports=JSON.parse('[{"prop":"animation","initial":"${animation-name} ${animation-duration} ${animation-timing-function} ${animation-delay} ${animation-iteration-count} ${animation-direction} ${animation-fill-mode} ${animation-play-state}","combined":true},{"prop":"animation-delay","initial":"0s"},{"prop":"animation-direction","initial":"normal"},{"prop":"animation-duration","initial":"0s"},{"prop":"animation-fill-mode","initial":"none"},{"prop":"animation-iteration-count","initial":"1"},{"prop":"animation-name","initial":"none"},{"prop":"animation-play-state","initial":"running"},{"prop":"animation-timing-function","initial":"ease"},{"prop":"backface-visibility","initial":"visible","basic":true},{"prop":"background","initial":"${background-color} ${background-image} ${background-repeat} ${background-position} / ${background-size} ${background-origin} ${background-clip} ${background-attachment}","combined":true},{"prop":"background-attachment","initial":"scroll"},{"prop":"background-clip","initial":"border-box"},{"prop":"background-color","initial":"transparent"},{"prop":"background-image","initial":"none"},{"prop":"background-origin","initial":"padding-box"},{"prop":"background-position","initial":"0 0"},{"prop":"background-position-x","initial":"0"},{"prop":"background-position-y","initial":"0"},{"prop":"background-repeat","initial":"repeat"},{"prop":"background-size","initial":"auto auto"},{"prop":"border","initial":"${border-width} ${border-style} ${border-color}","combined":true},{"prop":"border-style","initial":"none"},{"prop":"border-width","initial":"medium"},{"prop":"border-color","initial":"currentColor"},{"prop":"border-bottom","initial":"0"},{"prop":"border-bottom-color","initial":"currentColor"},{"prop":"border-bottom-left-radius","initial":"0"},{"prop":"border-bottom-right-radius","initial":"0"},{"prop":"border-bottom-style","initial":"none"},{"prop":"border-bottom-width","initial":"medium"},{"prop":"border-collapse","initial":"separate","basic":true,"inherited":true},{"prop":"border-image","initial":"none","basic":true},{"prop":"border-left","initial":"0"},{"prop":"border-left-color","initial":"currentColor"},{"prop":"border-left-style","initial":"none"},{"prop":"border-left-width","initial":"medium"},{"prop":"border-radius","initial":"0","basic":true},{"prop":"border-right","initial":"0"},{"prop":"border-right-color","initial":"currentColor"},{"prop":"border-right-style","initial":"none"},{"prop":"border-right-width","initial":"medium"},{"prop":"border-spacing","initial":"0","basic":true,"inherited":true},{"prop":"border-top","initial":"0"},{"prop":"border-top-color","initial":"currentColor"},{"prop":"border-top-left-radius","initial":"0"},{"prop":"border-top-right-radius","initial":"0"},{"prop":"border-top-style","initial":"none"},{"prop":"border-top-width","initial":"medium"},{"prop":"bottom","initial":"auto","basic":true},{"prop":"box-shadow","initial":"none","basic":true},{"prop":"box-sizing","initial":"content-box","basic":true},{"prop":"caption-side","initial":"top","basic":true,"inherited":true},{"prop":"clear","initial":"none","basic":true},{"prop":"clip","initial":"auto","basic":true},{"prop":"color","initial":"#000","basic":true},{"prop":"columns","initial":"auto","basic":true},{"prop":"column-count","initial":"auto","basic":true},{"prop":"column-fill","initial":"balance","basic":true},{"prop":"column-gap","initial":"normal","basic":true},{"prop":"column-rule","initial":"${column-rule-width} ${column-rule-style} ${column-rule-color}","combined":true},{"prop":"column-rule-color","initial":"currentColor"},{"prop":"column-rule-style","initial":"none"},{"prop":"column-rule-width","initial":"medium"},{"prop":"column-span","initial":"1","basic":true},{"prop":"column-width","initial":"auto","basic":true},{"prop":"content","initial":"normal","basic":true},{"prop":"counter-increment","initial":"none","basic":true},{"prop":"counter-reset","initial":"none","basic":true},{"prop":"cursor","initial":"auto","basic":true,"inherited":true},{"prop":"direction","initial":"ltr","basic":true,"inherited":true},{"prop":"display","initial":"inline","basic":true},{"prop":"empty-cells","initial":"show","basic":true,"inherited":true},{"prop":"float","initial":"none","basic":true},{"prop":"font","contains":["font-style","font-variant","font-weight","font-stretch","font-size","line-height","font-family"],"basic":true,"inherited":true},{"prop":"font-family","initial":"serif"},{"prop":"font-size","initial":"medium"},{"prop":"font-style","initial":"normal"},{"prop":"font-variant","initial":"normal"},{"prop":"font-weight","initial":"normal"},{"prop":"font-stretch","initial":"normal"},{"prop":"line-height","initial":"normal","inherited":true},{"prop":"height","initial":"auto","basic":true},{"prop":"hyphens","initial":"none","basic":true,"inherited":true},{"prop":"left","initial":"auto","basic":true},{"prop":"letter-spacing","initial":"normal","basic":true,"inherited":true},{"prop":"list-style","initial":"${list-style-type} ${list-style-position} ${list-style-image}","combined":true,"inherited":true},{"prop":"list-style-image","initial":"none"},{"prop":"list-style-position","initial":"outside"},{"prop":"list-style-type","initial":"disc"},{"prop":"margin","initial":"0","basic":true},{"prop":"margin-bottom","initial":"0"},{"prop":"margin-left","initial":"0"},{"prop":"margin-right","initial":"0"},{"prop":"margin-top","initial":"0"},{"prop":"max-height","initial":"none","basic":true},{"prop":"max-width","initial":"none","basic":true},{"prop":"min-height","initial":"0","basic":true},{"prop":"min-width","initial":"0","basic":true},{"prop":"opacity","initial":"1","basic":true},{"prop":"orphans","initial":"2","basic":true},{"prop":"outline","initial":"${outline-width} ${outline-style} ${outline-color}","combined":true},{"prop":"outline-color","initial":"invert"},{"prop":"outline-style","initial":"none"},{"prop":"outline-width","initial":"medium"},{"prop":"overflow","initial":"visible","basic":true},{"prop":"overflow-x","initial":"visible","basic":true},{"prop":"overflow-y","initial":"visible","basic":true},{"prop":"padding","initial":"0","basic":true},{"prop":"padding-bottom","initial":"0"},{"prop":"padding-left","initial":"0"},{"prop":"padding-right","initial":"0"},{"prop":"padding-top","initial":"0"},{"prop":"page-break-after","initial":"auto","basic":true},{"prop":"page-break-before","initial":"auto","basic":true},{"prop":"page-break-inside","initial":"auto","basic":true},{"prop":"perspective","initial":"none","basic":true},{"prop":"perspective-origin","initial":"50% 50%","basic":true},{"prop":"position","initial":"static","basic":true},{"prop":"quotes","initial":"“ ” ‘ ’"},{"prop":"right","initial":"auto","basic":true},{"prop":"tab-size","initial":"8","basic":true,"inherited":true},{"prop":"table-layout","initial":"auto","basic":true},{"prop":"text-align","initial":"left","basic":true,"inherited":true},{"prop":"text-align-last","initial":"auto","basic":true,"inherited":true},{"prop":"text-decoration","initial":"${text-decoration-line}","combined":true},{"prop":"text-decoration-color","initial":"inherited"},{"prop":"text-decoration-color","initial":"currentColor"},{"prop":"text-decoration-line","initial":"none"},{"prop":"text-decoration-style","initial":"solid"},{"prop":"text-indent","initial":"0","basic":true,"inherited":true},{"prop":"text-shadow","initial":"none","basic":true,"inherited":true},{"prop":"text-transform","initial":"none","basic":true,"inherited":true},{"prop":"top","initial":"auto","basic":true},{"prop":"transform","initial":"none","basic":true},{"prop":"transform-origin","initial":"50% 50% 0","basic":true},{"prop":"transform-style","initial":"flat","basic":true},{"prop":"transition","initial":"${transition-property} ${transition-duration} ${transition-timing-function} ${transition-delay}","combined":true},{"prop":"transition-delay","initial":"0s"},{"prop":"transition-duration","initial":"0s"},{"prop":"transition-property","initial":"none"},{"prop":"transition-timing-function","initial":"ease"},{"prop":"unicode-bidi","initial":"normal","basic":true},{"prop":"vertical-align","initial":"baseline","basic":true},{"prop":"visibility","initial":"visible","basic":true,"inherited":true},{"prop":"white-space","initial":"normal","basic":true,"inherited":true},{"prop":"widows","initial":"2","basic":true,"inherited":true},{"prop":"width","initial":"auto","basic":true},{"prop":"word-spacing","initial":"normal","basic":true,"inherited":true},{"prop":"z-index","initial":"auto","basic":true}]')},4567:(e,r)=>{"use strict";Object.defineProperty(r,"__esModule",{value:true});function rgb2hue(e,r,t){var n=arguments.length>3&&arguments[3]!==undefined?arguments[3]:0;var i=rgb2value(e,r,t);var o=rgb2whiteness(e,r,t);var s=i-o;if(s){var a=i===e?(r-t)/s:i===r?(t-e)/s:(e-r)/s;var u=i===e?a<0?360/60:0/60:i===r?120/60:240/60;var c=(a+u)*60;return c}else{return n}}function hue2rgb(e,r,t){var n=t<0?t+360:t>360?t-360:t;var i=n*6<360?e+(r-e)*n/60:n*2<360?r:n*3<720?e+(r-e)*(240-n)/60:e;return i}function rgb2value(e,r,t){var n=Math.max(e,r,t);return n}function rgb2whiteness(e,r,t){var n=Math.min(e,r,t);return n}function matrix(e,r){return r.map(function(r){return r.reduce(function(r,t,n){return r+e[n]*t},0)})}var t=96.42;var n=100;var i=82.49;var o=Math.pow(6,3)/Math.pow(29,3);var s=Math.pow(29,3)/Math.pow(3,3);function rgb2hsl(e,r,t,n){var i=rgb2hue(e,r,t,n);var o=rgb2value(e,r,t);var s=rgb2whiteness(e,r,t);var a=o-s;var u=(o+s)/2;var c=a===0?0:a/(100-Math.abs(2*u-100))*100;return[i,c,u]}function hsl2rgb(e,r,t){var n=t<=50?t*(r+100)/100:t+r-t*r/100;var i=t*2-n;var o=[hue2rgb(i,n,e+120),hue2rgb(i,n,e),hue2rgb(i,n,e-120)],s=o[0],a=o[1],u=o[2];return[s,a,u]}var a=function(){function sliceIterator(e,r){var t=[];var n=true;var i=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){t.push(a.value);if(r&&t.length===r)break}}catch(e){i=true;o=e}finally{try{if(!n&&s["return"])s["return"]()}finally{if(i)throw o}}return t}return function(e,r){if(Array.isArray(e)){return e}else if(Symbol.iterator in Object(e)){return sliceIterator(e,r)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();function rgb2hwb(e,r,t,n){var i=rgb2hue(e,r,t,n);var o=rgb2whiteness(e,r,t);var s=rgb2value(e,r,t);var a=100-s;return[i,o,a]}function hwb2rgb(e,r,t,n){var i=hsl2rgb(e,100,50,n).map(function(e){return e*(100-r-t)/100+r}),o=a(i,3),s=o[0],u=o[1],c=o[2];return[s,u,c]}var u=function(){function sliceIterator(e,r){var t=[];var n=true;var i=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){t.push(a.value);if(r&&t.length===r)break}}catch(e){i=true;o=e}finally{try{if(!n&&s["return"])s["return"]()}finally{if(i)throw o}}return t}return function(e,r){if(Array.isArray(e)){return e}else if(Symbol.iterator in Object(e)){return sliceIterator(e,r)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();function rgb2hsv(e,r,t,n){var i=rgb2value(e,r,t);var o=rgb2whiteness(e,r,t);var s=rgb2hue(e,r,t,n);var a=i===o?0:(i-o)/i*100;return[s,a,i]}function hsv2rgb(e,r,t){var n=Math.floor(e/60);var i=e/60-n&1?e/60-n:1-e/60-n;var o=t*(100-r)/100;var s=t*(100-r*i)/100;var a=n===5?[t,o,s]:n===4?[s,o,t]:n===3?[o,s,t]:n===2?[o,t,s]:n===1?[s,t,o]:[t,s,o],c=u(a,3),l=c[0],B=c[1],f=c[2];return[l,B,f]}var c=function(){function sliceIterator(e,r){var t=[];var n=true;var i=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){t.push(a.value);if(r&&t.length===r)break}}catch(e){i=true;o=e}finally{try{if(!n&&s["return"])s["return"]()}finally{if(i)throw o}}return t}return function(e,r){if(Array.isArray(e)){return e}else if(Symbol.iterator in Object(e)){return sliceIterator(e,r)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();function rgb2xyz(e,r,t){var n=[e,r,t].map(function(e){return e>4.045?Math.pow((e+5.5)/105.5,2.4)*100:e/12.92}),i=c(n,3),o=i[0],s=i[1],a=i[2];var u=matrix([o,s,a],[[.4124564,.3575761,.1804375],[.2126729,.7151522,.072175],[.0193339,.119192,.9503041]]),l=c(u,3),B=l[0],f=l[1],p=l[2];return[B,f,p]}function xyz2rgb(e,r,t){var n=matrix([e,r,t],[[3.2404542,-1.5371385,-.4985314],[-.969266,1.8760108,.041556],[.0556434,-.2040259,1.0572252]]),i=c(n,3),o=i[0],s=i[1],a=i[2];var u=[o,s,a].map(function(e){return e>.31308?1.055*Math.pow(e/100,1/2.4)*100-5.5:12.92*e}),l=c(u,3),B=l[0],f=l[1],p=l[2];return[B,f,p]}function hsl2hsv(e,r,t){var n=r*(t<50?t:100-t)/100;var i=n===0?0:2*n/(t+n)*100;var o=t+n;return[e,i,o]}function hsv2hsl(e,r,t){var n=(200-r)*t/100;var i=n===0||n===200?0:r*t/100/(n<=100?n:200-n)*100,o=n*5/10;return[e,i,o]}function hwb2hsv(e,r,t){var n=e,i=t===100?0:100-r/(100-t)*100,o=100-t;return[n,i,o]}function hsv2hwb(e,r,t){var n=e,i=(100-r)*t/100,o=100-t;return[n,i,o]}var l=function(){function sliceIterator(e,r){var t=[];var n=true;var i=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){t.push(a.value);if(r&&t.length===r)break}}catch(e){i=true;o=e}finally{try{if(!n&&s["return"])s["return"]()}finally{if(i)throw o}}return t}return function(e,r){if(Array.isArray(e)){return e}else if(Symbol.iterator in Object(e)){return sliceIterator(e,r)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();function lab2xyz(e,r,a){var u=(e+16)/116;var c=r/500+u;var B=u-a/200;var f=Math.pow(c,3)>o?Math.pow(c,3):(116*c-16)/s,p=e>s*o?Math.pow((e+16)/116,3):e/s,d=Math.pow(B,3)>o?Math.pow(B,3):(116*B-16)/s;var h=matrix([f*t,p*n,d*i],[[.9555766,-.0230393,.0631636],[-.0282895,1.0099416,.0210077],[.0122982,-.020483,1.3299098]]),v=l(h,3),b=v[0],C=v[1],g=v[2];return[b,C,g]}function xyz2lab(e,r,a){var u=matrix([e,r,a],[[1.0478112,.0228866,-.050127],[.0295424,.9904844,-.0170491],[-.0092345,.0150436,.7521316]]),c=l(u,3),B=c[0],f=c[1],p=c[2];var d=[B/t,f/n,p/i].map(function(e){return e>o?Math.cbrt(e):(s*e+16)/116}),h=l(d,3),v=h[0],b=h[1],C=h[2];var g=116*b-16,m=500*(v-b),y=200*(b-C);return[g,m,y]}function lab2lch(e,r,t){var n=[Math.sqrt(Math.pow(r,2)+Math.pow(t,2)),Math.atan2(t,r)*180/Math.PI],i=n[0],o=n[1];return[e,i,o]}function lch2lab(e,r,t){var n=r*Math.cos(t*Math.PI/180),i=r*Math.sin(t*Math.PI/180);return[e,n,i]}var B=function(){function sliceIterator(e,r){var t=[];var n=true;var i=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){t.push(a.value);if(r&&t.length===r)break}}catch(e){i=true;o=e}finally{try{if(!n&&s["return"])s["return"]()}finally{if(i)throw o}}return t}return function(e,r){if(Array.isArray(e)){return e}else if(Symbol.iterator in Object(e)){return sliceIterator(e,r)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();function rgb2lab(e,r,t){var n=rgb2xyz(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=xyz2lab(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];return[l,f,p]}function lab2rgb(e,r,t){var n=lab2xyz(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=xyz2rgb(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];return[l,f,p]}function rgb2lch(e,r,t){var n=rgb2xyz(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=xyz2lab(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];var d=lab2lch(l,f,p),h=B(d,3),v=h[0],b=h[1],C=h[2];return[v,b,C]}function lch2rgb(e,r,t){var n=lch2lab(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=lab2xyz(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];var d=xyz2rgb(l,f,p),h=B(d,3),v=h[0],b=h[1],C=h[2];return[v,b,C]}function hwb2hsl(e,r,t){var n=hwb2hsv(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=hsv2hsl(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];return[l,f,p]}function hsl2hwb(e,r,t){var n=hsl2hsv(e,r,t),i=B(n,3),o=i[1],s=i[2];var a=hsv2hwb(e,o,s),u=B(a,3),c=u[1],l=u[2];return[e,c,l]}function hsl2lab(e,r,t){var n=hsl2rgb(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=rgb2xyz(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];var d=xyz2lab(l,f,p),h=B(d,3),v=h[0],b=h[1],C=h[2];return[v,b,C]}function lab2hsl(e,r,t,n){var i=lab2xyz(e,r,t),o=B(i,3),s=o[0],a=o[1],u=o[2];var c=xyz2rgb(s,a,u),l=B(c,3),f=l[0],p=l[1],d=l[2];var h=rgb2hsl(f,p,d,n),v=B(h,3),b=v[0],C=v[1],g=v[2];return[b,C,g]}function hsl2lch(e,r,t){var n=hsl2rgb(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=rgb2xyz(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];var d=xyz2lab(l,f,p),h=B(d,3),v=h[0],b=h[1],C=h[2];var g=lab2lch(v,b,C),m=B(g,3),y=m[0],w=m[1],S=m[2];return[y,w,S]}function lch2hsl(e,r,t,n){var i=lch2lab(e,r,t),o=B(i,3),s=o[0],a=o[1],u=o[2];var c=lab2xyz(s,a,u),l=B(c,3),f=l[0],p=l[1],d=l[2];var h=xyz2rgb(f,p,d),v=B(h,3),b=v[0],C=v[1],g=v[2];var m=rgb2hsl(b,C,g,n),y=B(m,3),w=y[0],S=y[1],x=y[2];return[w,S,x]}function hsl2xyz(e,r,t){var n=hsl2rgb(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=rgb2xyz(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];return[l,f,p]}function xyz2hsl(e,r,t,n){var i=xyz2rgb(e,r,t),o=B(i,3),s=o[0],a=o[1],u=o[2];var c=rgb2hsl(s,a,u,n),l=B(c,3),f=l[0],p=l[1],d=l[2];return[f,p,d]}function hwb2lab(e,r,t){var n=hwb2rgb(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=rgb2xyz(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];var d=xyz2lab(l,f,p),h=B(d,3),v=h[0],b=h[1],C=h[2];return[v,b,C]}function lab2hwb(e,r,t,n){var i=lab2xyz(e,r,t),o=B(i,3),s=o[0],a=o[1],u=o[2];var c=xyz2rgb(s,a,u),l=B(c,3),f=l[0],p=l[1],d=l[2];var h=rgb2hwb(f,p,d,n),v=B(h,3),b=v[0],C=v[1],g=v[2];return[b,C,g]}function hwb2lch(e,r,t){var n=hwb2rgb(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=rgb2xyz(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];var d=xyz2lab(l,f,p),h=B(d,3),v=h[0],b=h[1],C=h[2];var g=lab2lch(v,b,C),m=B(g,3),y=m[0],w=m[1],S=m[2];return[y,w,S]}function lch2hwb(e,r,t,n){var i=lch2lab(e,r,t),o=B(i,3),s=o[0],a=o[1],u=o[2];var c=lab2xyz(s,a,u),l=B(c,3),f=l[0],p=l[1],d=l[2];var h=xyz2rgb(f,p,d),v=B(h,3),b=v[0],C=v[1],g=v[2];var m=rgb2hwb(b,C,g,n),y=B(m,3),w=y[0],S=y[1],x=y[2];return[w,S,x]}function hwb2xyz(e,r,t){var n=hwb2rgb(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=rgb2xyz(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];return[l,f,p]}function xyz2hwb(e,r,t,n){var i=xyz2rgb(e,r,t),o=B(i,3),s=o[0],a=o[1],u=o[2];var c=rgb2hwb(s,a,u,n),l=B(c,3),f=l[0],p=l[1],d=l[2];return[f,p,d]}function hsv2lab(e,r,t){var n=hsv2rgb(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=rgb2xyz(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];var d=xyz2lab(l,f,p),h=B(d,3),v=h[0],b=h[1],C=h[2];return[v,b,C]}function lab2hsv(e,r,t,n){var i=lab2xyz(e,r,t),o=B(i,3),s=o[0],a=o[1],u=o[2];var c=xyz2rgb(s,a,u),l=B(c,3),f=l[0],p=l[1],d=l[2];var h=rgb2hsv(f,p,d,n),v=B(h,3),b=v[0],C=v[1],g=v[2];return[b,C,g]}function hsv2lch(e,r,t){var n=hsv2rgb(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=rgb2xyz(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];var d=xyz2lab(l,f,p),h=B(d,3),v=h[0],b=h[1],C=h[2];var g=lab2lch(v,b,C),m=B(g,3),y=m[0],w=m[1],S=m[2];return[y,w,S]}function lch2hsv(e,r,t,n){var i=lch2lab(e,r,t),o=B(i,3),s=o[0],a=o[1],u=o[2];var c=lab2xyz(s,a,u),l=B(c,3),f=l[0],p=l[1],d=l[2];var h=xyz2rgb(f,p,d),v=B(h,3),b=v[0],C=v[1],g=v[2];var m=rgb2hsv(b,C,g,n),y=B(m,3),w=y[0],S=y[1],x=y[2];return[w,S,x]}function hsv2xyz(e,r,t){var n=hsv2rgb(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=rgb2xyz(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];return[l,f,p]}function xyz2hsv(e,r,t,n){var i=xyz2rgb(e,r,t),o=B(i,3),s=o[0],a=o[1],u=o[2];var c=rgb2hsv(s,a,u,n),l=B(c,3),f=l[0],p=l[1],d=l[2];return[f,p,d]}function xyz2lch(e,r,t){var n=xyz2lab(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=lab2lch(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];return[l,f,p]}function lch2xyz(e,r,t){var n=lch2lab(e,r,t),i=B(n,3),o=i[0],s=i[1],a=i[2];var u=lab2xyz(o,s,a),c=B(u,3),l=c[0],f=c[1],p=c[2];return[l,f,p]}var f={rgb2hsl:rgb2hsl,rgb2hwb:rgb2hwb,rgb2lab:rgb2lab,rgb2lch:rgb2lch,rgb2hsv:rgb2hsv,rgb2xyz:rgb2xyz,hsl2rgb:hsl2rgb,hsl2hwb:hsl2hwb,hsl2lab:hsl2lab,hsl2lch:hsl2lch,hsl2hsv:hsl2hsv,hsl2xyz:hsl2xyz,hwb2rgb:hwb2rgb,hwb2hsl:hwb2hsl,hwb2lab:hwb2lab,hwb2lch:hwb2lch,hwb2hsv:hwb2hsv,hwb2xyz:hwb2xyz,lab2rgb:lab2rgb,lab2hsl:lab2hsl,lab2hwb:lab2hwb,lab2lch:lab2lch,lab2hsv:lab2hsv,lab2xyz:lab2xyz,lch2rgb:lch2rgb,lch2hsl:lch2hsl,lch2hwb:lch2hwb,lch2lab:lch2lab,lch2hsv:lch2hsv,lch2xyz:lch2xyz,hsv2rgb:hsv2rgb,hsv2hsl:hsv2hsl,hsv2hwb:hsv2hwb,hsv2lab:hsv2lab,hsv2lch:hsv2lch,hsv2xyz:hsv2xyz,xyz2rgb:xyz2rgb,xyz2hsl:xyz2hsl,xyz2hwb:xyz2hwb,xyz2lab:xyz2lab,xyz2lch:xyz2lch,xyz2hsv:xyz2hsv,rgb2hue:rgb2hue};r.rgb2hsl=rgb2hsl;r.rgb2hwb=rgb2hwb;r.rgb2lab=rgb2lab;r.rgb2lch=rgb2lch;r.rgb2hsv=rgb2hsv;r.rgb2xyz=rgb2xyz;r.hsl2rgb=hsl2rgb;r.hsl2hwb=hsl2hwb;r.hsl2lab=hsl2lab;r.hsl2lch=hsl2lch;r.hsl2hsv=hsl2hsv;r.hsl2xyz=hsl2xyz;r.hwb2rgb=hwb2rgb;r.hwb2hsl=hwb2hsl;r.hwb2lab=hwb2lab;r.hwb2lch=hwb2lch;r.hwb2hsv=hwb2hsv;r.hwb2xyz=hwb2xyz;r.lab2rgb=lab2rgb;r.lab2hsl=lab2hsl;r.lab2hwb=lab2hwb;r.lab2lch=lab2lch;r.lab2hsv=lab2hsv;r.lab2xyz=lab2xyz;r.lch2rgb=lch2rgb;r.lch2hsl=lch2hsl;r.lch2hwb=lch2hwb;r.lch2lab=lch2lab;r.lch2hsv=lch2hsv;r.lch2xyz=lch2xyz;r.hsv2rgb=hsv2rgb;r.hsv2hsl=hsv2hsl;r.hsv2hwb=hsv2hwb;r.hsv2lab=hsv2lab;r.hsv2lch=hsv2lch;r.hsv2xyz=hsv2xyz;r.xyz2rgb=xyz2rgb;r.xyz2hsl=xyz2hsl;r.xyz2hwb=xyz2hwb;r.xyz2lab=xyz2lab;r.xyz2lch=xyz2lch;r.xyz2hsv=xyz2hsv;r.rgb2hue=rgb2hue;r.default=f},4394:(e,r,t)=>{"use strict";var n=t(4338).feature;function browsersSort(e,r){e=e.split(" ");r=r.split(" ");if(e[0]>r[0]){return 1}else if(e[0]<r[0]){return-1}else{return Math.sign(parseFloat(e[1])-parseFloat(r[1]))}}function f(e,r,t){e=n(e);if(!t){var i=[r,{}];t=i[0];r=i[1]}var o=r.match||/\sx($|\s)/;var s=[];for(var a in e.stats){var u=e.stats[a];for(var c in u){var l=u[c];if(l.match(o)){s.push(a+" "+c)}}}t(s.sort(browsersSort))}var i={};function prefix(e,r){for(var t=e,n=Array.isArray(t),o=0,t=n?t:t[Symbol.iterator]();;){var s;if(n){if(o>=t.length)break;s=t[o++]}else{o=t.next();if(o.done)break;s=o.value}var a=s;i[a]=Object.assign({},r)}}function add(e,r){for(var t=e,n=Array.isArray(t),o=0,t=n?t:t[Symbol.iterator]();;){var s;if(n){if(o>=t.length)break;s=t[o++]}else{o=t.next();if(o.done)break;s=o.value}var a=s;i[a].browsers=i[a].browsers.concat(r.browsers).sort(browsersSort)}}e.exports=i;f(t(5543),function(e){return prefix(["border-radius","border-top-left-radius","border-top-right-radius","border-bottom-right-radius","border-bottom-left-radius"],{mistakes:["-khtml-","-ms-","-o-"],feature:"border-radius",browsers:e})});f(t(5861),function(e){return prefix(["box-shadow"],{mistakes:["-khtml-"],feature:"css-boxshadow",browsers:e})});f(t(8252),function(e){return prefix(["animation","animation-name","animation-duration","animation-delay","animation-direction","animation-fill-mode","animation-iteration-count","animation-play-state","animation-timing-function","@keyframes"],{mistakes:["-khtml-","-ms-"],feature:"css-animation",browsers:e})});f(t(5056),function(e){return prefix(["transition","transition-property","transition-duration","transition-delay","transition-timing-function"],{mistakes:["-khtml-","-ms-"],browsers:e,feature:"css-transitions"})});f(t(762),function(e){return prefix(["transform","transform-origin"],{feature:"transforms2d",browsers:e})});var o=t(58);f(o,function(e){prefix(["perspective","perspective-origin"],{feature:"transforms3d",browsers:e});return prefix(["transform-style"],{mistakes:["-ms-","-o-"],browsers:e,feature:"transforms3d"})});f(o,{match:/y\sx|y\s#2/},function(e){return prefix(["backface-visibility"],{mistakes:["-ms-","-o-"],feature:"transforms3d",browsers:e})});var s=t(1407);f(s,{match:/y\sx/},function(e){return prefix(["linear-gradient","repeating-linear-gradient","radial-gradient","repeating-radial-gradient"],{props:["background","background-image","border-image","mask","list-style","list-style-image","content","mask-image"],mistakes:["-ms-"],feature:"css-gradients",browsers:e})});f(s,{match:/a\sx/},function(e){e=e.map(function(e){if(/firefox|op/.test(e)){return e}else{return e+" old"}});return add(["linear-gradient","repeating-linear-gradient","radial-gradient","repeating-radial-gradient"],{feature:"css-gradients",browsers:e})});f(t(7759),function(e){return prefix(["box-sizing"],{feature:"css3-boxsizing",browsers:e})});f(t(9237),function(e){return prefix(["filter"],{feature:"css-filters",browsers:e})});f(t(6192),function(e){return prefix(["filter-function"],{props:["background","background-image","border-image","mask","list-style","list-style-image","content","mask-image"],feature:"css-filter-function",browsers:e})});var a=t(3613);f(a,{match:/y\sx|y\s#2/},function(e){return prefix(["backdrop-filter"],{feature:"css-backdrop-filter",browsers:e})});f(t(9666),function(e){return prefix(["element"],{props:["background","background-image","border-image","mask","list-style","list-style-image","content","mask-image"],feature:"css-element-function",browsers:e})});f(t(1448),function(e){prefix(["columns","column-width","column-gap","column-rule","column-rule-color","column-rule-width","column-count","column-rule-style","column-span","column-fill"],{feature:"multicolumn",browsers:e});var r=e.filter(function(e){return!/firefox/.test(e)});prefix(["break-before","break-after","break-inside"],{feature:"multicolumn",browsers:r})});f(t(7511),function(e){return prefix(["user-select"],{mistakes:["-khtml-"],feature:"user-select-none",browsers:e})});var u=t(3714);f(u,{match:/a\sx/},function(e){e=e.map(function(e){if(/ie|firefox/.test(e)){return e}else{return e+" 2009"}});prefix(["display-flex","inline-flex"],{props:["display"],feature:"flexbox",browsers:e});prefix(["flex","flex-grow","flex-shrink","flex-basis"],{feature:"flexbox",browsers:e});prefix(["flex-direction","flex-wrap","flex-flow","justify-content","order","align-items","align-self","align-content"],{feature:"flexbox",browsers:e})});f(u,{match:/y\sx/},function(e){add(["display-flex","inline-flex"],{feature:"flexbox",browsers:e});add(["flex","flex-grow","flex-shrink","flex-basis"],{feature:"flexbox",browsers:e});add(["flex-direction","flex-wrap","flex-flow","justify-content","order","align-items","align-self","align-content"],{feature:"flexbox",browsers:e})});f(t(3807),function(e){return prefix(["calc"],{props:["*"],feature:"calc",browsers:e})});f(t(2259),function(e){return prefix(["background-origin","background-size"],{feature:"background-img-opts",browsers:e})});f(t(1302),function(e){return prefix(["background-clip"],{feature:"background-clip-text",browsers:e})});f(t(7011),function(e){return prefix(["font-feature-settings","font-variant-ligatures","font-language-override"],{feature:"font-feature",browsers:e})});f(t(9195),function(e){return prefix(["font-kerning"],{feature:"font-kerning",browsers:e})});f(t(9847),function(e){return prefix(["border-image"],{feature:"border-image",browsers:e})});f(t(3347),function(e){return prefix(["::selection"],{selector:true,feature:"css-selection",browsers:e})});f(t(5117),function(e){prefix(["::placeholder"],{selector:true,feature:"css-placeholder",browsers:e.concat(["ie 10 old","ie 11 old","firefox 18 old"])})});f(t(9747),function(e){return prefix(["hyphens"],{feature:"css-hyphens",browsers:e})});var c=t(5833);f(c,function(e){return prefix([":fullscreen"],{selector:true,feature:"fullscreen",browsers:e})});f(c,{match:/x(\s#2|$)/},function(e){return prefix(["::backdrop"],{selector:true,feature:"fullscreen",browsers:e})});f(t(9807),function(e){return prefix(["tab-size"],{feature:"css3-tabsize",browsers:e})});var l=t(3794);var B=["width","min-width","max-width","height","min-height","max-height","inline-size","min-inline-size","max-inline-size","block-size","min-block-size","max-block-size","grid","grid-template","grid-template-rows","grid-template-columns","grid-auto-columns","grid-auto-rows"];f(l,function(e){return prefix(["max-content","min-content"],{props:B,feature:"intrinsic-width",browsers:e})});f(l,{match:/x|\s#4/},function(e){return prefix(["fill","fill-available","stretch"],{props:B,feature:"intrinsic-width",browsers:e})});f(l,{match:/x|\s#5/},function(e){return prefix(["fit-content"],{props:B,feature:"intrinsic-width",browsers:e})});f(t(8546),function(e){return prefix(["zoom-in","zoom-out"],{props:["cursor"],feature:"css3-cursors-newer",browsers:e})});f(t(4528),function(e){return prefix(["grab","grabbing"],{props:["cursor"],feature:"css3-cursors-grab",browsers:e})});f(t(3727),function(e){return prefix(["sticky"],{props:["position"],feature:"css-sticky",browsers:e})});f(t(6714),function(e){return prefix(["touch-action"],{feature:"pointer",browsers:e})});var p=t(6848);f(p,function(e){return prefix(["text-decoration-style","text-decoration-color","text-decoration-line","text-decoration"],{feature:"text-decoration",browsers:e})});f(p,{match:/x.*#[235]/},function(e){return prefix(["text-decoration-skip","text-decoration-skip-ink"],{feature:"text-decoration",browsers:e})});f(t(6421),function(e){return prefix(["text-size-adjust"],{feature:"text-size-adjust",browsers:e})});f(t(4613),function(e){prefix(["mask-clip","mask-composite","mask-image","mask-origin","mask-repeat","mask-border-repeat","mask-border-source"],{feature:"css-masks",browsers:e});prefix(["mask","mask-position","mask-size","mask-border","mask-border-outset","mask-border-width","mask-border-slice"],{feature:"css-masks",browsers:e})});f(t(147),function(e){return prefix(["clip-path"],{feature:"css-clip-path",browsers:e})});f(t(4016),function(e){return prefix(["box-decoration-break"],{feature:"css-boxdecorationbreak",browsers:e})});f(t(5147),function(e){return prefix(["object-fit","object-position"],{feature:"object-fit",browsers:e})});f(t(4298),function(e){return prefix(["shape-margin","shape-outside","shape-image-threshold"],{feature:"css-shapes",browsers:e})});f(t(123),function(e){return prefix(["text-overflow"],{feature:"text-overflow",browsers:e})});f(t(1779),function(e){return prefix(["@viewport"],{feature:"css-deviceadaptation",browsers:e})});var d=t(3588);f(d,{match:/( x($| )|a #2)/},function(e){return prefix(["@resolution"],{feature:"css-media-resolution",browsers:e})});f(t(9533),function(e){return prefix(["text-align-last"],{feature:"css-text-align-last",browsers:e})});var h=t(7794);f(h,{match:/y x|a x #1/},function(e){return prefix(["pixelated"],{props:["image-rendering"],feature:"css-crisp-edges",browsers:e})});f(h,{match:/a x #2/},function(e){return prefix(["image-rendering"],{feature:"css-crisp-edges",browsers:e})});var v=t(471);f(v,function(e){return prefix(["border-inline-start","border-inline-end","margin-inline-start","margin-inline-end","padding-inline-start","padding-inline-end"],{feature:"css-logical-props",browsers:e})});f(v,{match:/x\s#2/},function(e){return prefix(["border-block-start","border-block-end","margin-block-start","margin-block-end","padding-block-start","padding-block-end"],{feature:"css-logical-props",browsers:e})});var b=t(8672);f(b,{match:/#2|x/},function(e){return prefix(["appearance"],{feature:"css-appearance",browsers:e})});f(t(87),function(e){return prefix(["scroll-snap-type","scroll-snap-coordinate","scroll-snap-destination","scroll-snap-points-x","scroll-snap-points-y"],{feature:"css-snappoints",browsers:e})});f(t(5969),function(e){return prefix(["flow-into","flow-from","region-fragment"],{feature:"css-regions",browsers:e})});f(t(4197),function(e){return prefix(["image-set"],{props:["background","background-image","border-image","cursor","mask","mask-image","list-style","list-style-image","content"],feature:"css-image-set",browsers:e})});var C=t(8307);f(C,{match:/a|x/},function(e){return prefix(["writing-mode"],{feature:"css-writing-mode",browsers:e})});f(t(3323),function(e){return prefix(["cross-fade"],{props:["background","background-image","border-image","mask","list-style","list-style-image","content","mask-image"],feature:"css-cross-fade",browsers:e})});f(t(3502),function(e){return prefix([":read-only",":read-write"],{selector:true,feature:"css-read-only-write",browsers:e})});f(t(5802),function(e){return prefix(["text-emphasis","text-emphasis-position","text-emphasis-style","text-emphasis-color"],{feature:"text-emphasis",browsers:e})});var g=t(7776);f(g,function(e){prefix(["display-grid","inline-grid"],{props:["display"],feature:"css-grid",browsers:e});prefix(["grid-template-columns","grid-template-rows","grid-row-start","grid-column-start","grid-row-end","grid-column-end","grid-row","grid-column","grid-area","grid-template","grid-template-areas","place-self"],{feature:"css-grid",browsers:e})});f(g,{match:/a x/},function(e){return prefix(["grid-column-align","grid-row-align"],{feature:"css-grid",browsers:e})});f(t(8422),function(e){return prefix(["text-spacing"],{feature:"css-text-spacing",browsers:e})});f(t(1977),function(e){return prefix([":any-link"],{selector:true,feature:"css-any-link",browsers:e})});var m=t(1456);f(m,function(e){return prefix(["isolate"],{props:["unicode-bidi"],feature:"css-unicode-bidi",browsers:e})});f(m,{match:/y x|a x #2/},function(e){return prefix(["plaintext"],{props:["unicode-bidi"],feature:"css-unicode-bidi",browsers:e})});f(m,{match:/y x/},function(e){return prefix(["isolate-override"],{props:["unicode-bidi"],feature:"css-unicode-bidi",browsers:e})});var y=t(3043);f(y,{match:/a #1/},function(e){return prefix(["overscroll-behavior"],{feature:"css-overscroll-behavior",browsers:e})});f(t(664),function(e){return prefix(["color-adjust"],{feature:"css-color-adjust",browsers:e})});f(t(3100),function(e){return prefix(["text-orientation"],{feature:"css-text-orientation",browsers:e})})},7997:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}var n=t(8428);var i=function(e){_inheritsLoose(AtRule,e);function AtRule(){return e.apply(this,arguments)||this}var r=AtRule.prototype;r.add=function add(e,r){var t=r+e.name;var n=e.parent.some(function(r){return r.name===t&&r.params===e.params});if(n){return undefined}var i=this.clone(e,{name:t});return e.parent.insertBefore(e,i)};r.process=function process(e){var r=this.parentPrefix(e);for(var t=this.prefixes,n=Array.isArray(t),i=0,t=n?t:t[Symbol.iterator]();;){var o;if(n){if(i>=t.length)break;o=t[i++]}else{i=t.next();if(i.done)break;o=i.value}var s=o;if(!r||r===s){this.add(e,s)}}};return AtRule}(n);e.exports=i},3501:(e,r,t)=>{"use strict";var n=t(3561);var i=t(2043);var o=t(4338).agents;var s=t(2242);var a=t(2319);var u=t(811);var c=t(4394);var l=t(6741);var B="\n"+"  Replace Autoprefixer `browsers` option to Browserslist config.\n"+"  Use `browserslist` key in `package.json` or `.browserslistrc` file.\n"+"\n"+"  Using `browsers` option can cause errors. Browserslist config \n"+"  can be used for Babel, Autoprefixer, postcss-normalize and other tools.\n"+"\n"+"  If you really need to use option, rename it to `overrideBrowserslist`.\n"+"\n"+"  Learn more at:\n"+"  https://github.com/browserslist/browserslist#readme\n"+"  https://twitter.com/browserslist\n"+"\n";function isPlainObject(e){return Object.prototype.toString.apply(e)==="[object Object]"}var f={};function timeCapsule(e,r){if(r.browsers.selected.length===0){return}if(r.add.selectors.length>0){return}if(Object.keys(r.add).length>2){return}e.warn("Greetings, time traveller. "+"We are in the golden age of prefix-less CSS, "+"where Autoprefixer is no longer needed for your stylesheet.")}e.exports=i.plugin("autoprefixer",function(){for(var r=arguments.length,t=new Array(r),n=0;n<r;n++){t[n]=arguments[n]}var i;if(t.length===1&&isPlainObject(t[0])){i=t[0];t=undefined}else if(t.length===0||t.length===1&&!t[0]){t=undefined}else if(t.length<=2&&(Array.isArray(t[0])||!t[0])){i=t[1];t=t[0]}else if(typeof t[t.length-1]==="object"){i=t.pop()}if(!i){i={}}if(i.browser){throw new Error("Change `browser` option to `overrideBrowserslist` in Autoprefixer")}else if(i.browserslist){throw new Error("Change `browserslist` option to `overrideBrowserslist` in Autoprefixer")}if(i.overrideBrowserslist){t=i.overrideBrowserslist}else if(i.browsers){if(typeof console!=="undefined"&&console.warn){if(s&&s.red){console.warn(s.red(B.replace(/`[^`]+`/g,function(e){return s.yellow(e.slice(1,-1))})))}else{console.warn(B)}}t=i.browsers}var o={ignoreUnknownVersions:i.ignoreUnknownVersions,stats:i.stats};function loadPrefixes(r){var n=e.exports.data;var s=new a(n.browsers,t,r,o);var c=s.selected.join(", ")+JSON.stringify(i);if(!f[c]){f[c]=new u(n.prefixes,s,i)}return f[c]}function plugin(e,r){var t=loadPrefixes({from:e.source&&e.source.input.file,env:i.env});timeCapsule(r,t);if(i.remove!==false){t.processor.remove(e,r)}if(i.add!==false){t.processor.add(e,r)}}plugin.options=i;plugin.browsers=t;plugin.info=function(e){e=e||{};e.from=e.from||process.cwd();return l(loadPrefixes(e))};return plugin});e.exports.data={browsers:o,prefixes:c};e.exports.defaults=n.defaults;e.exports.info=function(){return e.exports().info()}},6689:e=>{"use strict";function last(e){return e[e.length-1]}var r={parse:function parse(e){var r=[""];var t=[r];for(var n=e,i=Array.isArray(n),o=0,n=i?n:n[Symbol.iterator]();;){var s;if(i){if(o>=n.length)break;s=n[o++]}else{o=n.next();if(o.done)break;s=o.value}var a=s;if(a==="("){r=[""];last(t).push(r);t.push(r);continue}if(a===")"){t.pop();r=last(t);r.push("");continue}r[r.length-1]+=a}return t[0]},stringify:function stringify(e){var t="";for(var n=e,i=Array.isArray(n),o=0,n=i?n:n[Symbol.iterator]();;){var s;if(i){if(o>=n.length)break;s=n[o++]}else{o=n.next();if(o.done)break;s=o.value}var a=s;if(typeof a==="object"){t+="("+r.stringify(a)+")";continue}t+=a}return t}};e.exports=r},2319:(e,r,t)=>{"use strict";var n=t(3561);var i=t(4338).agents;var o=t(772);var s=function(){Browsers.prefixes=function prefixes(){if(this.prefixesCache){return this.prefixesCache}this.prefixesCache=[];for(var e in i){this.prefixesCache.push("-"+i[e].prefix+"-")}this.prefixesCache=o.uniq(this.prefixesCache).sort(function(e,r){return r.length-e.length});return this.prefixesCache};Browsers.withPrefix=function withPrefix(e){if(!this.prefixesRegexp){this.prefixesRegexp=new RegExp(this.prefixes().join("|"))}return this.prefixesRegexp.test(e)};function Browsers(e,r,t,n){this.data=e;this.options=t||{};this.browserslistOpts=n||{};this.selected=this.parse(r)}var e=Browsers.prototype;e.parse=function parse(e){var r={};for(var t in this.browserslistOpts){r[t]=this.browserslistOpts[t]}r.path=this.options.from;r.env=this.options.env;return n(e,r)};e.prefix=function prefix(e){var r=e.split(" "),t=r[0],n=r[1];var i=this.data[t];var prefix=i.prefix_exceptions&&i.prefix_exceptions[n];if(!prefix){prefix=i.prefix}return"-"+prefix+"-"};e.isSelected=function isSelected(e){return this.selected.includes(e)};return Browsers}();e.exports=s},5753:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}var n=t(8428);var i=t(2319);var o=t(772);var s=function(e){_inheritsLoose(Declaration,e);function Declaration(){return e.apply(this,arguments)||this}var r=Declaration.prototype;r.check=function check(){return true};r.prefixed=function prefixed(e,r){return r+e};r.normalize=function normalize(e){return e};r.otherPrefixes=function otherPrefixes(e,r){for(var t=i.prefixes(),n=Array.isArray(t),o=0,t=n?t:t[Symbol.iterator]();;){var s;if(n){if(o>=t.length)break;s=t[o++]}else{o=t.next();if(o.done)break;s=o.value}var a=s;if(a===r){continue}if(e.includes(a)){return true}}return false};r.set=function set(e,r){e.prop=this.prefixed(e.prop,r);return e};r.needCascade=function needCascade(e){if(!e._autoprefixerCascade){e._autoprefixerCascade=this.all.options.cascade!==false&&e.raw("before").includes("\n")}return e._autoprefixerCascade};r.maxPrefixed=function maxPrefixed(e,r){if(r._autoprefixerMax){return r._autoprefixerMax}var t=0;for(var n=e,i=Array.isArray(n),s=0,n=i?n:n[Symbol.iterator]();;){var a;if(i){if(s>=n.length)break;a=n[s++]}else{s=n.next();if(s.done)break;a=s.value}var u=a;u=o.removeNote(u);if(u.length>t){t=u.length}}r._autoprefixerMax=t;return r._autoprefixerMax};r.calcBefore=function calcBefore(e,r,t){if(t===void 0){t=""}var n=this.maxPrefixed(e,r);var i=n-o.removeNote(t).length;var s=r.raw("before");if(i>0){s+=Array(i).fill(" ").join("")}return s};r.restoreBefore=function restoreBefore(e){var r=e.raw("before").split("\n");var t=r[r.length-1];this.all.group(e).up(function(e){var r=e.raw("before").split("\n");var n=r[r.length-1];if(n.length<t.length){t=n}});r[r.length-1]=t;e.raws.before=r.join("\n")};r.insert=function insert(e,r,t){var n=this.set(this.clone(e),r);if(!n)return undefined;var i=e.parent.some(function(e){return e.prop===n.prop&&e.value===n.value});if(i){return undefined}if(this.needCascade(e)){n.raws.before=this.calcBefore(t,e,r)}return e.parent.insertBefore(e,n)};r.isAlready=function isAlready(e,r){var t=this.all.group(e).up(function(e){return e.prop===r});if(!t){t=this.all.group(e).down(function(e){return e.prop===r})}return t};r.add=function add(e,r,t,n){var i=this.prefixed(e.prop,r);if(this.isAlready(e,i)||this.otherPrefixes(e.value,r)){return undefined}return this.insert(e,r,t,n)};r.process=function process(r,t){if(!this.needCascade(r)){e.prototype.process.call(this,r,t);return}var n=e.prototype.process.call(this,r,t);if(!n||!n.length){return}this.restoreBefore(r);r.raws.before=this.calcBefore(n,r)};r.old=function old(e,r){return[this.prefixed(e,r)]};return Declaration}(n);e.exports=s},4802:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(5753);var o=function(e){_inheritsLoose(AlignContent,e);function AlignContent(){return e.apply(this,arguments)||this}var r=AlignContent.prototype;r.prefixed=function prefixed(r,t){var i;var o=n(t);i=o[0];t=o[1];if(i===2012){return t+"flex-line-pack"}return e.prototype.prefixed.call(this,r,t)};r.normalize=function normalize(){return"align-content"};r.set=function set(r,t){var i=n(t)[0];if(i===2012){r.value=AlignContent.oldValues[r.value]||r.value;return e.prototype.set.call(this,r,t)}if(i==="final"){return e.prototype.set.call(this,r,t)}return undefined};return AlignContent}(i);_defineProperty(o,"names",["align-content","flex-line-pack"]);_defineProperty(o,"oldValues",{"flex-end":"end","flex-start":"start","space-between":"justify","space-around":"distribute"});e.exports=o},180:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(5753);var o=function(e){_inheritsLoose(AlignItems,e);function AlignItems(){return e.apply(this,arguments)||this}var r=AlignItems.prototype;r.prefixed=function prefixed(r,t){var i;var o=n(t);i=o[0];t=o[1];if(i===2009){return t+"box-align"}if(i===2012){return t+"flex-align"}return e.prototype.prefixed.call(this,r,t)};r.normalize=function normalize(){return"align-items"};r.set=function set(r,t){var i=n(t)[0];if(i===2009||i===2012){r.value=AlignItems.oldValues[r.value]||r.value}return e.prototype.set.call(this,r,t)};return AlignItems}(i);_defineProperty(o,"names",["align-items","flex-align","box-align"]);_defineProperty(o,"oldValues",{"flex-end":"end","flex-start":"start"});e.exports=o},7335:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(5753);var o=function(e){_inheritsLoose(AlignSelf,e);function AlignSelf(){return e.apply(this,arguments)||this}var r=AlignSelf.prototype;r.check=function check(e){return e.parent&&!e.parent.some(function(e){return e.prop&&e.prop.startsWith("grid-")})};r.prefixed=function prefixed(r,t){var i;var o=n(t);i=o[0];t=o[1];if(i===2012){return t+"flex-item-align"}return e.prototype.prefixed.call(this,r,t)};r.normalize=function normalize(){return"align-self"};r.set=function set(r,t){var i=n(t)[0];if(i===2012){r.value=AlignSelf.oldValues[r.value]||r.value;return e.prototype.set.call(this,r,t)}if(i==="final"){return e.prototype.set.call(this,r,t)}return undefined};return AlignSelf}(i);_defineProperty(o,"names",["align-self","flex-item-align"]);_defineProperty(o,"oldValues",{"flex-end":"end","flex-start":"start"});e.exports=o},3331:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(Animation,e);function Animation(){return e.apply(this,arguments)||this}var r=Animation.prototype;r.check=function check(e){return!e.value.split(/\s+/).some(function(e){var r=e.toLowerCase();return r==="reverse"||r==="alternate-reverse"})};return Animation}(n);_defineProperty(i,"names",["animation","animation-direction"]);e.exports=i},3686:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=t(772);var o=function(e){_inheritsLoose(Appearance,e);function Appearance(r,t,n){var o;o=e.call(this,r,t,n)||this;if(o.prefixes){o.prefixes=i.uniq(o.prefixes.map(function(e){if(e==="-ms-"){return"-webkit-"}return e}))}return o}return Appearance}(n);_defineProperty(o,"names",["appearance"]);e.exports=o},1262:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=t(772);var o=function(e){_inheritsLoose(BackdropFilter,e);function BackdropFilter(r,t,n){var o;o=e.call(this,r,t,n)||this;if(o.prefixes){o.prefixes=i.uniq(o.prefixes.map(function(e){return e==="-ms-"?"-webkit-":e}))}return o}return BackdropFilter}(n);_defineProperty(o,"names",["backdrop-filter"]);e.exports=o},7509:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=t(772);var o=function(e){_inheritsLoose(BackgroundClip,e);function BackgroundClip(r,t,n){var o;o=e.call(this,r,t,n)||this;if(o.prefixes){o.prefixes=i.uniq(o.prefixes.map(function(e){return e==="-ms-"?"-webkit-":e}))}return o}var r=BackgroundClip.prototype;r.check=function check(e){return e.value.toLowerCase()==="text"};return BackgroundClip}(n);_defineProperty(o,"names",["background-clip"]);e.exports=o},1150:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(BackgroundSize,e);function BackgroundSize(){return e.apply(this,arguments)||this}var r=BackgroundSize.prototype;r.set=function set(r,t){var n=r.value.toLowerCase();if(t==="-webkit-"&&!n.includes(" ")&&n!=="contain"&&n!=="cover"){r.value=r.value+" "+r.value}return e.prototype.set.call(this,r,t)};return BackgroundSize}(n);_defineProperty(i,"names",["background-size"]);e.exports=i},9423:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(BlockLogical,e);function BlockLogical(){return e.apply(this,arguments)||this}var r=BlockLogical.prototype;r.prefixed=function prefixed(e,r){if(e.includes("-start")){return r+e.replace("-block-start","-before")}return r+e.replace("-block-end","-after")};r.normalize=function normalize(e){if(e.includes("-before")){return e.replace("-before","-block-start")}return e.replace("-after","-block-end")};return BlockLogical}(n);_defineProperty(i,"names",["border-block-start","border-block-end","margin-block-start","margin-block-end","padding-block-start","padding-block-end","border-before","border-after","margin-before","margin-after","padding-before","padding-after"]);e.exports=i},3305:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(BorderImage,e);function BorderImage(){return e.apply(this,arguments)||this}var r=BorderImage.prototype;r.set=function set(r,t){r.value=r.value.replace(/\s+fill(\s)/,"$1");return e.prototype.set.call(this,r,t)};return BorderImage}(n);_defineProperty(i,"names",["border-image"]);e.exports=i},657:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(BorderRadius,e);function BorderRadius(){return e.apply(this,arguments)||this}var r=BorderRadius.prototype;r.prefixed=function prefixed(r,t){if(t==="-moz-"){return t+(BorderRadius.toMozilla[r]||r)}return e.prototype.prefixed.call(this,r,t)};r.normalize=function normalize(e){return BorderRadius.toNormal[e]||e};return BorderRadius}(n);_defineProperty(i,"names",["border-radius"]);_defineProperty(i,"toMozilla",{});_defineProperty(i,"toNormal",{});for(var o=0,s=["top","bottom"];o<s.length;o++){var a=s[o];for(var u=0,c=["left","right"];u<c.length;u++){var l=c[u];var B="border-"+a+"-"+l+"-radius";var f="border-radius-"+a+l;i.names.push(B);i.names.push(f);i.toMozilla[B]=f;i.toNormal[f]=B}}e.exports=i},517:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(BreakProps,e);function BreakProps(){return e.apply(this,arguments)||this}var r=BreakProps.prototype;r.prefixed=function prefixed(e,r){return r+"column-"+e};r.normalize=function normalize(e){if(e.includes("inside")){return"break-inside"}if(e.includes("before")){return"break-before"}return"break-after"};r.set=function set(r,t){if(r.prop==="break-inside"&&r.value==="avoid-column"||r.value==="avoid-page"){r.value="avoid"}return e.prototype.set.call(this,r,t)};r.insert=function insert(r,t,n){if(r.prop!=="break-inside"){return e.prototype.insert.call(this,r,t,n)}if(/region/i.test(r.value)||/page/i.test(r.value)){return undefined}return e.prototype.insert.call(this,r,t,n)};return BreakProps}(n);_defineProperty(i,"names",["break-inside","page-break-inside","column-break-inside","break-before","page-break-before","column-break-before","break-after","page-break-after","column-break-after"]);e.exports=i},5836:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(ColorAdjust,e);function ColorAdjust(){return e.apply(this,arguments)||this}var r=ColorAdjust.prototype;r.prefixed=function prefixed(e,r){return r+"print-color-adjust"};r.normalize=function normalize(){return"color-adjust"};return ColorAdjust}(n);_defineProperty(i,"names",["color-adjust","print-color-adjust"]);e.exports=i},8485:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(2043).list;var i=t(1882);var o=function(e){_inheritsLoose(CrossFade,e);function CrossFade(){return e.apply(this,arguments)||this}var r=CrossFade.prototype;r.replace=function replace(e,r){var t=this;return n.space(e).map(function(e){if(e.slice(0,+t.name.length+1)!==t.name+"("){return e}var n=e.lastIndexOf(")");var i=e.slice(n+1);var o=e.slice(t.name.length+1,n);if(r==="-webkit-"){var s=o.match(/\d*.?\d+%?/);if(s){o=o.slice(s[0].length).trim();o+=", "+s[0]}else{o+=", 0.5"}}return r+t.name+"("+o+")"+i}).join(" ")};return CrossFade}(i);_defineProperty(o,"names",["cross-fade"]);e.exports=o},3692:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(6661);var o=t(1882);var s=function(e){_inheritsLoose(DisplayFlex,e);function DisplayFlex(r,t){var n;n=e.call(this,r,t)||this;if(r==="display-flex"){n.name="flex"}return n}var r=DisplayFlex.prototype;r.check=function check(e){return e.prop==="display"&&e.value===this.name};r.prefixed=function prefixed(e){var r,t;var i=n(e);r=i[0];e=i[1];if(r===2009){if(this.name==="flex"){t="box"}else{t="inline-box"}}else if(r===2012){if(this.name==="flex"){t="flexbox"}else{t="inline-flexbox"}}else if(r==="final"){t=this.name}return e+t};r.replace=function replace(e,r){return this.prefixed(r)};r.old=function old(e){var r=this.prefixed(e);if(!r)return undefined;return new i(this.name,r)};return DisplayFlex}(o);_defineProperty(s,"names",["display-flex","inline-flex"]);e.exports=s},1665:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1882);var i=function(e){_inheritsLoose(DisplayGrid,e);function DisplayGrid(r,t){var n;n=e.call(this,r,t)||this;if(r==="display-grid"){n.name="grid"}return n}var r=DisplayGrid.prototype;r.check=function check(e){return e.prop==="display"&&e.value===this.name};return DisplayGrid}(n);_defineProperty(i,"names",["display-grid","inline-grid"]);e.exports=i},133:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1882);var i=function(e){_inheritsLoose(FilterValue,e);function FilterValue(r,t){var n;n=e.call(this,r,t)||this;if(r==="filter-function"){n.name="filter"}return n}return FilterValue}(n);_defineProperty(i,"names",["filter","filter-function"]);e.exports=i},972:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(Filter,e);function Filter(){return e.apply(this,arguments)||this}var r=Filter.prototype;r.check=function check(e){var r=e.value;return!r.toLowerCase().includes("alpha(")&&!r.includes("DXImageTransform.Microsoft")&&!r.includes("data:image/svg+xml")};return Filter}(n);_defineProperty(i,"names",["filter"]);e.exports=i},5041:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(5753);var o=function(e){_inheritsLoose(FlexBasis,e);function FlexBasis(){return e.apply(this,arguments)||this}var r=FlexBasis.prototype;r.normalize=function normalize(){return"flex-basis"};r.prefixed=function prefixed(r,t){var i;var o=n(t);i=o[0];t=o[1];if(i===2012){return t+"flex-preferred-size"}return e.prototype.prefixed.call(this,r,t)};r.set=function set(r,t){var i;var o=n(t);i=o[0];t=o[1];if(i===2012||i==="final"){return e.prototype.set.call(this,r,t)}return undefined};return FlexBasis}(i);_defineProperty(o,"names",["flex-basis","flex-preferred-size"]);e.exports=o},2112:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(5753);var o=function(e){_inheritsLoose(FlexDirection,e);function FlexDirection(){return e.apply(this,arguments)||this}var r=FlexDirection.prototype;r.normalize=function normalize(){return"flex-direction"};r.insert=function insert(r,t,i){var o;var s=n(t);o=s[0];t=s[1];if(o!==2009){return e.prototype.insert.call(this,r,t,i)}var a=r.parent.some(function(e){return e.prop===t+"box-orient"||e.prop===t+"box-direction"});if(a){return undefined}var u=r.value;var c,l;if(u==="inherit"||u==="initial"||u==="unset"){c=u;l=u}else{c=u.includes("row")?"horizontal":"vertical";l=u.includes("reverse")?"reverse":"normal"}var B=this.clone(r);B.prop=t+"box-orient";B.value=c;if(this.needCascade(r)){B.raws.before=this.calcBefore(i,r,t)}r.parent.insertBefore(r,B);B=this.clone(r);B.prop=t+"box-direction";B.value=l;if(this.needCascade(r)){B.raws.before=this.calcBefore(i,r,t)}return r.parent.insertBefore(r,B)};r.old=function old(r,t){var i;var o=n(t);i=o[0];t=o[1];if(i===2009){return[t+"box-orient",t+"box-direction"]}else{return e.prototype.old.call(this,r,t)}};return FlexDirection}(i);_defineProperty(o,"names",["flex-direction","box-direction","box-orient"]);e.exports=o},7106:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(5753);var o=function(e){_inheritsLoose(FlexFlow,e);function FlexFlow(){return e.apply(this,arguments)||this}var r=FlexFlow.prototype;r.insert=function insert(r,t,i){var o;var s=n(t);o=s[0];t=s[1];if(o!==2009){return e.prototype.insert.call(this,r,t,i)}var a=r.value.split(/\s+/).filter(function(e){return e!=="wrap"&&e!=="nowrap"&&"wrap-reverse"});if(a.length===0){return undefined}var u=r.parent.some(function(e){return e.prop===t+"box-orient"||e.prop===t+"box-direction"});if(u){return undefined}var c=a[0];var l=c.includes("row")?"horizontal":"vertical";var B=c.includes("reverse")?"reverse":"normal";var f=this.clone(r);f.prop=t+"box-orient";f.value=l;if(this.needCascade(r)){f.raws.before=this.calcBefore(i,r,t)}r.parent.insertBefore(r,f);f=this.clone(r);f.prop=t+"box-direction";f.value=B;if(this.needCascade(r)){f.raws.before=this.calcBefore(i,r,t)}return r.parent.insertBefore(r,f)};return FlexFlow}(i);_defineProperty(o,"names",["flex-flow","box-direction","box-orient"]);e.exports=o},3392:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(5753);var o=function(e){_inheritsLoose(Flex,e);function Flex(){return e.apply(this,arguments)||this}var r=Flex.prototype;r.normalize=function normalize(){return"flex"};r.prefixed=function prefixed(r,t){var i;var o=n(t);i=o[0];t=o[1];if(i===2009){return t+"box-flex"}if(i===2012){return t+"flex-positive"}return e.prototype.prefixed.call(this,r,t)};return Flex}(i);_defineProperty(o,"names",["flex-grow","flex-positive"]);e.exports=o},5035:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(5753);var o=function(e){_inheritsLoose(FlexShrink,e);function FlexShrink(){return e.apply(this,arguments)||this}var r=FlexShrink.prototype;r.normalize=function normalize(){return"flex-shrink"};r.prefixed=function prefixed(r,t){var i;var o=n(t);i=o[0];t=o[1];if(i===2012){return t+"flex-negative"}return e.prototype.prefixed.call(this,r,t)};r.set=function set(r,t){var i;var o=n(t);i=o[0];t=o[1];if(i===2012||i==="final"){return e.prototype.set.call(this,r,t)}return undefined};return FlexShrink}(i);_defineProperty(o,"names",["flex-shrink","flex-negative"]);e.exports=o},1524:e=>{"use strict";e.exports=function(e){var r;if(e==="-webkit- 2009"||e==="-moz-"){r=2009}else if(e==="-ms-"){r=2012}else if(e==="-webkit-"){r="final"}if(e==="-webkit- 2009"){e="-webkit-"}return[r,e]}},9315:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(5753);var o=function(e){_inheritsLoose(FlexWrap,e);function FlexWrap(){return e.apply(this,arguments)||this}var r=FlexWrap.prototype;r.set=function set(r,t){var i=n(t)[0];if(i!==2009){return e.prototype.set.call(this,r,t)}return undefined};return FlexWrap}(i);_defineProperty(o,"names",["flex-wrap"]);e.exports=o},3629:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(2043).list;var i=t(1524);var o=t(5753);var s=function(e){_inheritsLoose(Flex,e);function Flex(){return e.apply(this,arguments)||this}var r=Flex.prototype;r.prefixed=function prefixed(r,t){var n;var o=i(t);n=o[0];t=o[1];if(n===2009){return t+"box-flex"}return e.prototype.prefixed.call(this,r,t)};r.normalize=function normalize(){return"flex"};r.set=function set(r,t){var o=i(t)[0];if(o===2009){r.value=n.space(r.value)[0];r.value=Flex.oldValues[r.value]||r.value;return e.prototype.set.call(this,r,t)}if(o===2012){var s=n.space(r.value);if(s.length===3&&s[2]==="0"){r.value=s.slice(0,2).concat("0px").join(" ")}}return e.prototype.set.call(this,r,t)};return Flex}(o);_defineProperty(s,"names",["flex","box-flex"]);_defineProperty(s,"oldValues",{auto:"1",none:"0"});e.exports=s},9231:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(4806);var i=function(e){_inheritsLoose(Fullscreen,e);function Fullscreen(){return e.apply(this,arguments)||this}var r=Fullscreen.prototype;r.prefixed=function prefixed(e){if(e==="-webkit-"){return":-webkit-full-screen"}if(e==="-moz-"){return":-moz-full-screen"}return":"+e+"fullscreen"};return Fullscreen}(n);_defineProperty(i,"names",[":fullscreen"]);e.exports=i},2433:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _assertThisInitialized(e){if(e===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(7195);var i=t(1981);var o=t(6661);var s=t(1882);var a=t(772);var u=/top|left|right|bottom/gi;var c=function(e){_inheritsLoose(Gradient,e);function Gradient(){var r;for(var t=arguments.length,n=new Array(t),i=0;i<t;i++){n[i]=arguments[i]}r=e.call.apply(e,[this].concat(n))||this;_defineProperty(_assertThisInitialized(r),"directions",{top:"bottom",left:"right",bottom:"top",right:"left"});_defineProperty(_assertThisInitialized(r),"oldDirections",{top:"left bottom, left top",left:"right top, left top",bottom:"left top, left bottom",right:"left top, right top","top right":"left bottom, right top","top left":"right bottom, left top","right top":"left bottom, right top","right bottom":"left top, right bottom","bottom right":"left top, right bottom","bottom left":"right top, left bottom","left top":"right bottom, left top","left bottom":"right top, left bottom"});return r}var r=Gradient.prototype;r.replace=function replace(e,r){var t=n(e);for(var i=t.nodes,o=Array.isArray(i),s=0,i=o?i:i[Symbol.iterator]();;){var a;if(o){if(s>=i.length)break;a=i[s++]}else{s=i.next();if(s.done)break;a=s.value}var u=a;if(u.type==="function"&&u.value===this.name){u.nodes=this.newDirection(u.nodes);u.nodes=this.normalize(u.nodes);if(r==="-webkit- old"){var c=this.oldWebkit(u);if(!c){return false}}else{u.nodes=this.convertDirection(u.nodes);u.value=r+u.value}}}return t.toString()};r.replaceFirst=function replaceFirst(e){for(var r=arguments.length,t=new Array(r>1?r-1:0),n=1;n<r;n++){t[n-1]=arguments[n]}var i=t.map(function(e){if(e===" "){return{type:"space",value:e}}return{type:"word",value:e}});return i.concat(e.slice(1))};r.normalizeUnit=function normalizeUnit(e,r){var t=parseFloat(e);var n=t/r*360;return n+"deg"};r.normalize=function normalize(e){if(!e[0])return e;if(/-?\d+(.\d+)?grad/.test(e[0].value)){e[0].value=this.normalizeUnit(e[0].value,400)}else if(/-?\d+(.\d+)?rad/.test(e[0].value)){e[0].value=this.normalizeUnit(e[0].value,2*Math.PI)}else if(/-?\d+(.\d+)?turn/.test(e[0].value)){e[0].value=this.normalizeUnit(e[0].value,1)}else if(e[0].value.includes("deg")){var r=parseFloat(e[0].value);r=i.wrap(0,360,r);e[0].value=r+"deg"}if(e[0].value==="0deg"){e=this.replaceFirst(e,"to"," ","top")}else if(e[0].value==="90deg"){e=this.replaceFirst(e,"to"," ","right")}else if(e[0].value==="180deg"){e=this.replaceFirst(e,"to"," ","bottom")}else if(e[0].value==="270deg"){e=this.replaceFirst(e,"to"," ","left")}return e};r.newDirection=function newDirection(e){if(e[0].value==="to"){return e}u.lastIndex=0;if(!u.test(e[0].value)){return e}e.unshift({type:"word",value:"to"},{type:"space",value:" "});for(var r=2;r<e.length;r++){if(e[r].type==="div"){break}if(e[r].type==="word"){e[r].value=this.revertDirection(e[r].value)}}return e};r.isRadial=function isRadial(e){var r="before";for(var t=e,n=Array.isArray(t),i=0,t=n?t:t[Symbol.iterator]();;){var o;if(n){if(i>=t.length)break;o=t[i++]}else{i=t.next();if(i.done)break;o=i.value}var s=o;if(r==="before"&&s.type==="space"){r="at"}else if(r==="at"&&s.value==="at"){r="after"}else if(r==="after"&&s.type==="space"){return true}else if(s.type==="div"){break}else{r="before"}}return false};r.convertDirection=function convertDirection(e){if(e.length>0){if(e[0].value==="to"){this.fixDirection(e)}else if(e[0].value.includes("deg")){this.fixAngle(e)}else if(this.isRadial(e)){this.fixRadial(e)}}return e};r.fixDirection=function fixDirection(e){e.splice(0,2);for(var r=e,t=Array.isArray(r),n=0,r=t?r:r[Symbol.iterator]();;){var i;if(t){if(n>=r.length)break;i=r[n++]}else{n=r.next();if(n.done)break;i=n.value}var o=i;if(o.type==="div"){break}if(o.type==="word"){o.value=this.revertDirection(o.value)}}};r.fixAngle=function fixAngle(e){var r=e[0].value;r=parseFloat(r);r=Math.abs(450-r)%360;r=this.roundFloat(r,3);e[0].value=r+"deg"};r.fixRadial=function fixRadial(e){var r=[];var t=[];var n,i,o,s,a;for(s=0;s<e.length-2;s++){n=e[s];i=e[s+1];o=e[s+2];if(n.type==="space"&&i.value==="at"&&o.type==="space"){a=s+3;break}else{r.push(n)}}var u;for(s=a;s<e.length;s++){if(e[s].type==="div"){u=e[s];break}else{t.push(e[s])}}e.splice.apply(e,[0,s].concat(t,[u],r))};r.revertDirection=function revertDirection(e){return this.directions[e.toLowerCase()]||e};r.roundFloat=function roundFloat(e,r){return parseFloat(e.toFixed(r))};r.oldWebkit=function oldWebkit(e){var r=e.nodes;var t=n.stringify(e.nodes);if(this.name!=="linear-gradient"){return false}if(r[0]&&r[0].value.includes("deg")){return false}if(t.includes("px")||t.includes("-corner")||t.includes("-side")){return false}var i=[[]];for(var o=r,s=Array.isArray(o),a=0,o=s?o:o[Symbol.iterator]();;){var u;if(s){if(a>=o.length)break;u=o[a++]}else{a=o.next();if(a.done)break;u=a.value}var c=u;i[i.length-1].push(c);if(c.type==="div"&&c.value===","){i.push([])}}this.oldDirection(i);this.colorStops(i);e.nodes=[];for(var l=0,B=i;l<B.length;l++){var f=B[l];e.nodes=e.nodes.concat(f)}e.nodes.unshift({type:"word",value:"linear"},this.cloneDiv(e.nodes));e.value="-webkit-gradient";return true};r.oldDirection=function oldDirection(e){var r=this.cloneDiv(e[0]);if(e[0][0].value!=="to"){return e.unshift([{type:"word",value:this.oldDirections.bottom},r])}else{var t=[];for(var n=e[0].slice(2),i=Array.isArray(n),o=0,n=i?n:n[Symbol.iterator]();;){var s;if(i){if(o>=n.length)break;s=n[o++]}else{o=n.next();if(o.done)break;s=o.value}var a=s;if(a.type==="word"){t.push(a.value.toLowerCase())}}t=t.join(" ");var u=this.oldDirections[t]||t;e[0]=[{type:"word",value:u},r];return e[0]}};r.cloneDiv=function cloneDiv(e){for(var r=e,t=Array.isArray(r),n=0,r=t?r:r[Symbol.iterator]();;){var i;if(t){if(n>=r.length)break;i=r[n++]}else{n=r.next();if(n.done)break;i=n.value}var o=i;if(o.type==="div"&&o.value===","){return o}}return{type:"div",value:",",after:" "}};r.colorStops=function colorStops(e){var r=[];for(var t=0;t<e.length;t++){var i=void 0;var o=e[t];var s=void 0;if(t===0){continue}var a=n.stringify(o[0]);if(o[1]&&o[1].type==="word"){i=o[1].value}else if(o[2]&&o[2].type==="word"){i=o[2].value}var u=void 0;if(t===1&&(!i||i==="0%")){u="from("+a+")"}else if(t===e.length-1&&(!i||i==="100%")){u="to("+a+")"}else if(i){u="color-stop("+i+", "+a+")"}else{u="color-stop("+a+")"}var c=o[o.length-1];e[t]=[{type:"word",value:u}];if(c.type==="div"&&c.value===","){s=e[t].push(c)}r.push(s)}return r};r.old=function old(r){if(r==="-webkit-"){var t=this.name==="linear-gradient"?"linear":"radial";var n="-gradient";var i=a.regexp("-webkit-("+t+"-gradient|gradient\\(\\s*"+t+")",false);return new o(this.name,r+this.name,n,i)}else{return e.prototype.old.call(this,r)}};r.add=function add(r,t){var n=r.prop;if(n.includes("mask")){if(t==="-webkit-"||t==="-webkit- old"){return e.prototype.add.call(this,r,t)}}else if(n==="list-style"||n==="list-style-image"||n==="content"){if(t==="-webkit-"||t==="-webkit- old"){return e.prototype.add.call(this,r,t)}}else{return e.prototype.add.call(this,r,t)}return undefined};return Gradient}(s);_defineProperty(c,"names",["linear-gradient","repeating-linear-gradient","radial-gradient","repeating-radial-gradient"]);e.exports=c},6658:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=t(5224);var o=function(e){_inheritsLoose(GridArea,e);function GridArea(){return e.apply(this,arguments)||this}var r=GridArea.prototype;r.insert=function insert(r,t,n,o){if(t!=="-ms-")return e.prototype.insert.call(this,r,t,n);var s=i.parse(r);var a=i.translate(s,0,2),u=a[0],c=a[1];var l=i.translate(s,1,3),B=l[0],f=l[1];[["grid-row",u],["grid-row-span",c],["grid-column",B],["grid-column-span",f]].forEach(function(e){var t=e[0],n=e[1];i.insertDecl(r,t,n)});i.warnTemplateSelectorNotFound(r,o);i.warnIfGridRowColumnExists(r,o);return undefined};return GridArea}(n);_defineProperty(o,"names",["grid-area"]);e.exports=o},5422:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(GridColumnAlign,e);function GridColumnAlign(){return e.apply(this,arguments)||this}var r=GridColumnAlign.prototype;r.check=function check(e){return!e.value.includes("flex-")&&e.value!=="baseline"};r.prefixed=function prefixed(e,r){return r+"grid-column-align"};r.normalize=function normalize(){return"justify-self"};return GridColumnAlign}(n);_defineProperty(i,"names",["grid-column-align"]);e.exports=i},1763:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(GridEnd,e);function GridEnd(){return e.apply(this,arguments)||this}var r=GridEnd.prototype;r.insert=function insert(r,t,n,i){if(t!=="-ms-")return e.prototype.insert.call(this,r,t,n);var o=this.clone(r);var s=r.prop.replace(/end$/,"start");var a=t+r.prop.replace(/end$/,"span");if(r.parent.some(function(e){return e.prop===a})){return undefined}o.prop=a;if(r.value.includes("span")){o.value=r.value.replace(/span\s/i,"")}else{var u;r.parent.walkDecls(s,function(e){u=e});if(u){var c=Number(r.value)-Number(u.value)+"";o.value=c}else{r.warn(i,"Can not prefix "+r.prop+" ("+s+" is not found)")}}r.cloneBefore(o);return undefined};return GridEnd}(n);_defineProperty(i,"names",["grid-row-end","grid-column-end"]);e.exports=i},4689:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(GridRowAlign,e);function GridRowAlign(){return e.apply(this,arguments)||this}var r=GridRowAlign.prototype;r.check=function check(e){return!e.value.includes("flex-")&&e.value!=="baseline"};r.prefixed=function prefixed(e,r){return r+"grid-row-align"};r.normalize=function normalize(){return"align-self"};return GridRowAlign}(n);_defineProperty(i,"names",["grid-row-align"]);e.exports=i},8360:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=t(5224);var o=function(e){_inheritsLoose(GridRowColumn,e);function GridRowColumn(){return e.apply(this,arguments)||this}var r=GridRowColumn.prototype;r.insert=function insert(r,t,n){if(t!=="-ms-")return e.prototype.insert.call(this,r,t,n);var o=i.parse(r);var s=i.translate(o,0,1),a=s[0],u=s[1];var c=o[0]&&o[0].includes("span");if(c){u=o[0].join("").replace(/\D/g,"")}[[r.prop,a],[r.prop+"-span",u]].forEach(function(e){var t=e[0],n=e[1];i.insertDecl(r,t,n)});return undefined};return GridRowColumn}(n);_defineProperty(o,"names",["grid-row","grid-column"]);e.exports=o},2456:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=t(5224),o=i.prefixTrackProp,s=i.prefixTrackValue,a=i.autoplaceGridItems,u=i.getGridGap,c=i.inheritGridGap;var l=t(8120);var B=function(e){_inheritsLoose(GridRowsColumns,e);function GridRowsColumns(){return e.apply(this,arguments)||this}var r=GridRowsColumns.prototype;r.prefixed=function prefixed(r,t){if(t==="-ms-"){return o({prop:r,prefix:t})}return e.prototype.prefixed.call(this,r,t)};r.normalize=function normalize(e){return e.replace(/^grid-(rows|columns)/,"grid-template-$1")};r.insert=function insert(r,t,n,i){if(t!=="-ms-")return e.prototype.insert.call(this,r,t,n);var B=r.parent,f=r.prop,p=r.value;var d=f.includes("rows");var h=f.includes("columns");var v=B.some(function(e){return e.prop==="grid-template"||e.prop==="grid-template-areas"});if(v&&d){return false}var b=new l({options:{}});var C=b.gridStatus(B,i);var g=u(r);g=c(r,g)||g;var m=d?g.row:g.column;if((C==="no-autoplace"||C===true)&&!v){m=null}var y=s({value:p,gap:m});r.cloneBefore({prop:o({prop:f,prefix:t}),value:y});var w=B.nodes.find(function(e){return e.prop==="grid-auto-flow"});var S="row";if(w&&!b.disabled(w,i)){S=w.value.trim()}if(C==="autoplace"){var x=B.nodes.find(function(e){return e.prop==="grid-template-rows"});if(!x&&v){return undefined}else if(!x&&!v){r.warn(i,"Autoplacement does not work without grid-template-rows property");return undefined}var O=B.nodes.find(function(e){return e.prop==="grid-template-columns"});if(!O&&!v){r.warn(i,"Autoplacement does not work without grid-template-columns property")}if(h&&!v){a(r,i,g,S)}}return undefined};return GridRowsColumns}(n);_defineProperty(B,"names",["grid-template-rows","grid-template-columns","grid-rows","grid-columns"]);e.exports=B},7912:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(GridStart,e);function GridStart(){return e.apply(this,arguments)||this}var r=GridStart.prototype;r.check=function check(e){var r=e.value;return!r.includes("/")||r.includes("span")};r.normalize=function normalize(e){return e.replace("-start","")};r.prefixed=function prefixed(r,t){var n=e.prototype.prefixed.call(this,r,t);if(t==="-ms-"){n=n.replace("-start","")}return n};return GridStart}(n);_defineProperty(i,"names",["grid-row-start","grid-column-start"]);e.exports=i},1719:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=t(5224),o=i.parseGridAreas,s=i.warnMissedAreas,a=i.prefixTrackProp,u=i.prefixTrackValue,c=i.getGridGap,l=i.warnGridGap,B=i.inheritGridGap;function getGridRows(e){return e.trim().slice(1,-1).split(/["']\s*["']?/g)}var f=function(e){_inheritsLoose(GridTemplateAreas,e);function GridTemplateAreas(){return e.apply(this,arguments)||this}var r=GridTemplateAreas.prototype;r.insert=function insert(r,t,n,i){if(t!=="-ms-")return e.prototype.insert.call(this,r,t,n);var f=false;var p=false;var d=r.parent;var h=c(r);h=B(r,h)||h;d.walkDecls(/-ms-grid-rows/,function(e){return e.remove()});d.walkDecls(/grid-template-(rows|columns)/,function(e){if(e.prop==="grid-template-rows"){p=true;var r=e.prop,n=e.value;e.cloneBefore({prop:a({prop:r,prefix:t}),value:u({value:n,gap:h.row})})}else{f=true}});var v=getGridRows(r.value);if(f&&!p&&h.row&&v.length>1){r.cloneBefore({prop:"-ms-grid-rows",value:u({value:"repeat("+v.length+", auto)",gap:h.row}),raws:{}})}l({gap:h,hasColumns:f,decl:r,result:i});var b=o({rows:v,gap:h});s(b,r,i);return r};return GridTemplateAreas}(n);_defineProperty(f,"names",["grid-template-areas"]);e.exports=f},5193:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=t(5224),o=i.parseTemplate,s=i.warnMissedAreas,a=i.getGridGap,u=i.warnGridGap,c=i.inheritGridGap;var l=function(e){_inheritsLoose(GridTemplate,e);function GridTemplate(){return e.apply(this,arguments)||this}var r=GridTemplate.prototype;r.insert=function insert(r,t,n,i){if(t!=="-ms-")return e.prototype.insert.call(this,r,t,n);if(r.parent.some(function(e){return e.prop==="-ms-grid-rows"})){return undefined}var l=a(r);var B=c(r,l);var f=o({decl:r,gap:B||l}),p=f.rows,d=f.columns,h=f.areas;var v=Object.keys(h).length>0;var b=Boolean(p);var C=Boolean(d);u({gap:l,hasColumns:C,decl:r,result:i});s(h,r,i);if(b&&C||v){r.cloneBefore({prop:"-ms-grid-rows",value:p,raws:{}})}if(C){r.cloneBefore({prop:"-ms-grid-columns",value:d,raws:{}})}return r};return GridTemplate}(n);_defineProperty(l,"names",["grid-template"]);e.exports=l},5224:(e,r,t)=>{"use strict";var n=t(7195);var i=t(2043).list;var o=t(772).uniq;var s=t(772).escapeRegexp;var a=t(772).splitSelector;function convert(e){if(e&&e.length===2&&e[0]==="span"&&parseInt(e[1],10)>0){return[false,parseInt(e[1],10)]}if(e&&e.length===1&&parseInt(e[0],10)>0){return[parseInt(e[0],10),false]}return[false,false]}function translate(e,r,t){var n=e[r];var i=e[t];if(!n){return[false,false]}var o=convert(n),s=o[0],a=o[1];var u=convert(i),c=u[0],l=u[1];if(s&&!i){return[s,false]}if(a&&c){return[c-a,a]}if(s&&l){return[s,l]}if(s&&c){return[s,c-s]}return[false,false]}function parse(e){var r=n(e.value);var t=[];var i=0;t[i]=[];for(var o=r.nodes,s=Array.isArray(o),a=0,o=s?o:o[Symbol.iterator]();;){var u;if(s){if(a>=o.length)break;u=o[a++]}else{a=o.next();if(a.done)break;u=a.value}var c=u;if(c.type==="div"){i+=1;t[i]=[]}else if(c.type==="word"){t[i].push(c.value)}}return t}function insertDecl(e,r,t){if(t&&!e.parent.some(function(e){return e.prop==="-ms-"+r})){e.cloneBefore({prop:"-ms-"+r,value:t.toString()})}}function prefixTrackProp(e){var r=e.prop,t=e.prefix;return t+r.replace("template-","")}function transformRepeat(e,r){var t=e.nodes;var i=r.gap;var o=t.reduce(function(e,r){if(r.type==="div"&&r.value===","){e.key="size"}else{e[e.key].push(n.stringify(r))}return e},{key:"count",size:[],count:[]}),s=o.count,a=o.size;if(i){var u=function(){a=a.filter(function(e){return e.trim()});var e=[];var r=function _loop(r){a.forEach(function(t,n){if(n>0||r>1){e.push(i)}e.push(t)})};for(var t=1;t<=s;t++){r(t)}return{v:e.join(" ")}}();if(typeof u==="object")return u.v}return"("+a.join("")+")["+s.join("")+"]"}function prefixTrackValue(e){var r=e.value,t=e.gap;var i=n(r).nodes.reduce(function(e,r){if(r.type==="function"&&r.value==="repeat"){return e.concat({type:"word",value:transformRepeat(r,{gap:t})})}if(t&&r.type==="space"){return e.concat({type:"space",value:" "},{type:"word",value:t},r)}return e.concat(r)},[]);return n.stringify(i)}var u=/^\.+$/;function track(e,r){return{start:e,end:r,span:r-e}}function getColumns(e){return e.trim().split(/\s+/g)}function parseGridAreas(e){var r=e.rows,t=e.gap;return r.reduce(function(e,r,n){if(t.row)n*=2;if(r.trim()==="")return e;getColumns(r).forEach(function(r,i){if(u.test(r))return;if(t.column)i*=2;if(typeof e[r]==="undefined"){e[r]={column:track(i+1,i+2),row:track(n+1,n+2)}}else{var o=e[r],s=o.column,a=o.row;s.start=Math.min(s.start,i+1);s.end=Math.max(s.end,i+2);s.span=s.end-s.start;a.start=Math.min(a.start,n+1);a.end=Math.max(a.end,n+2);a.span=a.end-a.start}});return e},{})}function testTrack(e){return e.type==="word"&&/^\[.+]$/.test(e.value)}function verifyRowSize(e){if(e.areas.length>e.rows.length){e.rows.push("auto")}return e}function parseTemplate(e){var r=e.decl,t=e.gap;var i=n(r.value).nodes.reduce(function(e,r){var t=r.type,i=r.value;if(testTrack(r)||t==="space")return e;if(t==="string"){e=verifyRowSize(e);e.areas.push(i)}if(t==="word"||t==="function"){e[e.key].push(n.stringify(r))}if(t==="div"&&i==="/"){e.key="columns";e=verifyRowSize(e)}return e},{key:"rows",columns:[],rows:[],areas:[]});return{areas:parseGridAreas({rows:i.areas,gap:t}),columns:prefixTrackValue({value:i.columns.join(" "),gap:t.column}),rows:prefixTrackValue({value:i.rows.join(" "),gap:t.row})}}function getMSDecls(e,r,t){if(r===void 0){r=false}if(t===void 0){t=false}return[].concat({prop:"-ms-grid-row",value:String(e.row.start)},e.row.span>1||r?{prop:"-ms-grid-row-span",value:String(e.row.span)}:[],{prop:"-ms-grid-column",value:String(e.column.start)},e.column.span>1||t?{prop:"-ms-grid-column-span",value:String(e.column.span)}:[])}function getParentMedia(e){if(e.type==="atrule"&&e.name==="media"){return e}if(!e.parent){return false}return getParentMedia(e.parent)}function changeDuplicateAreaSelectors(e,r){e=e.map(function(e){var r=i.space(e);var t=i.comma(e);if(r.length>t.length){e=r.slice(-1).join("")}return e});return e.map(function(e){var t=r.map(function(r,t){var n=t===0?"":" ";return""+n+r+" > "+e});return t})}function selectorsEqual(e,r){return e.selectors.some(function(e){return r.selectors.some(function(r){return r===e})})}function parseGridTemplatesData(e){var r=[];e.walkDecls(/grid-template(-areas)?$/,function(e){var t=e.parent;var n=getParentMedia(t);var i=getGridGap(e);var s=inheritGridGap(e,i);var a=parseTemplate({decl:e,gap:s||i}),u=a.areas;var c=Object.keys(u);if(c.length===0){return true}var l=r.reduce(function(e,r,t){var n=r.allAreas;var i=n&&c.some(function(e){return n.includes(e)});return i?t:e},null);if(l!==null){var B=r[l],f=B.allAreas,p=B.rules;var d=p.some(function(e){return e.hasDuplicates===false&&selectorsEqual(e,t)});var h=false;var v=p.reduce(function(e,r){if(!r.params&&selectorsEqual(r,t)){h=true;return r.duplicateAreaNames}if(!h){c.forEach(function(t){if(r.areas[t]){e.push(t)}})}return o(e)},[]);p.forEach(function(e){c.forEach(function(r){var t=e.areas[r];if(t&&t.row.span!==u[r].row.span){u[r].row.updateSpan=true}if(t&&t.column.span!==u[r].column.span){u[r].column.updateSpan=true}})});r[l].allAreas=o([].concat(f,c));r[l].rules.push({hasDuplicates:!d,params:n.params,selectors:t.selectors,node:t,duplicateAreaNames:v,areas:u})}else{r.push({allAreas:c,areasCount:0,rules:[{hasDuplicates:false,duplicateRules:[],params:n.params,selectors:t.selectors,node:t,duplicateAreaNames:[],areas:u}]})}return undefined});return r}function insertAreas(e,r){var t=parseGridTemplatesData(e);if(t.length===0){return undefined}var n={};e.walkDecls("grid-area",function(o){var s=o.parent;var a=s.first.prop==="-ms-grid-row";var u=getParentMedia(s);if(r(o)){return undefined}var c=u?e.index(u):e.index(s);var l=o.value;var B=t.filter(function(e){return e.allAreas.includes(l)})[0];if(!B){return true}var f=B.allAreas[B.allAreas.length-1];var p=i.space(s.selector);var d=i.comma(s.selector);var h=p.length>1&&p.length>d.length;if(a){return false}if(!n[f]){n[f]={}}var v=false;for(var b=B.rules,C=Array.isArray(b),g=0,b=C?b:b[Symbol.iterator]();;){var m;if(C){if(g>=b.length)break;m=b[g++]}else{g=b.next();if(g.done)break;m=g.value}var y=m;var w=y.areas[l];var S=y.duplicateAreaNames.includes(l);if(!w){var x=e.index(n[f].lastRule);if(c>x){n[f].lastRule=u||s}continue}if(y.params&&!n[f][y.params]){n[f][y.params]=[]}if((!y.hasDuplicates||!S)&&!y.params){getMSDecls(w,false,false).reverse().forEach(function(e){return s.prepend(Object.assign(e,{raws:{between:o.raws.between}}))});n[f].lastRule=s;v=true}else if(y.hasDuplicates&&!y.params&&!h){(function(){var e=s.clone();e.removeAll();getMSDecls(w,w.row.updateSpan,w.column.updateSpan).reverse().forEach(function(r){return e.prepend(Object.assign(r,{raws:{between:o.raws.between}}))});e.selectors=changeDuplicateAreaSelectors(e.selectors,y.selectors);if(n[f].lastRule){n[f].lastRule.after(e)}n[f].lastRule=e;v=true})()}else if(y.hasDuplicates&&!y.params&&h&&s.selector.includes(y.selectors[0])){s.walkDecls(/-ms-grid-(row|column)/,function(e){return e.remove()});getMSDecls(w,w.row.updateSpan,w.column.updateSpan).reverse().forEach(function(e){return s.prepend(Object.assign(e,{raws:{between:o.raws.between}}))})}else if(y.params){(function(){var r=s.clone();r.removeAll();getMSDecls(w,w.row.updateSpan,w.column.updateSpan).reverse().forEach(function(e){return r.prepend(Object.assign(e,{raws:{between:o.raws.between}}))});if(y.hasDuplicates&&S){r.selectors=changeDuplicateAreaSelectors(r.selectors,y.selectors)}r.raws=y.node.raws;if(e.index(y.node.parent)>c){y.node.parent.append(r)}else{n[f][y.params].push(r)}if(!v){n[f].lastRule=u||s}})()}}return undefined});Object.keys(n).forEach(function(e){var r=n[e];var t=r.lastRule;Object.keys(r).reverse().filter(function(e){return e!=="lastRule"}).forEach(function(e){if(r[e].length>0&&t){t.after({name:"media",params:e});t.next().append(r[e])}})});return undefined}function warnMissedAreas(e,r,t){var n=Object.keys(e);r.root().walkDecls("grid-area",function(e){n=n.filter(function(r){return r!==e.value})});if(n.length>0){r.warn(t,"Can not find grid areas: "+n.join(", "))}return undefined}function warnTemplateSelectorNotFound(e,r){var t=e.parent;var n=e.root();var o=false;var s=i.space(t.selector).filter(function(e){return e!==">"}).slice(0,-1);if(s.length>0){var a=false;var u=null;n.walkDecls(/grid-template(-areas)?$/,function(r){var t=r.parent;var n=t.selectors;var c=parseTemplate({decl:r,gap:getGridGap(r)}),l=c.areas;var B=l[e.value];for(var f=n,p=Array.isArray(f),d=0,f=p?f:f[Symbol.iterator]();;){var h;if(p){if(d>=f.length)break;h=f[d++]}else{d=f.next();if(d.done)break;h=d.value}var v=h;if(a){break}var b=i.space(v).filter(function(e){return e!==">"});a=b.every(function(e,r){return e===s[r]})}if(a||!B){return true}if(!u){u=t.selector}if(u&&u!==t.selector){o=true}return undefined});if(!a&&o){e.warn(r,"Autoprefixer cannot find a grid-template "+('containing the duplicate grid-area "'+e.value+'" ')+("with full selector matching: "+s.join(" ")))}}}function warnIfGridRowColumnExists(e,r){var t=e.parent;var n=[];t.walkDecls(/^grid-(row|column)/,function(e){if(!e.prop.endsWith("-end")&&!e.value.startsWith("span")){n.push(e)}});if(n.length>0){n.forEach(function(e){e.warn(r,"You already have a grid-area declaration present in the rule. "+("You should use either grid-area or "+e.prop+", not both"))})}return undefined}function getGridGap(e){var r={};var t=/^(grid-)?((row|column)-)?gap$/;e.parent.walkDecls(t,function(e){var t=e.prop,i=e.value;if(/^(grid-)?gap$/.test(t)){var o=n(i).nodes,s=o[0],a=o[2];r.row=s&&n.stringify(s);r.column=a?n.stringify(a):r.row}if(/^(grid-)?row-gap$/.test(t))r.row=i;if(/^(grid-)?column-gap$/.test(t))r.column=i});return r}function parseMediaParams(e){if(!e){return false}var r=n(e);var t;var i;r.walk(function(e){if(e.type==="word"&&/min|max/g.test(e.value)){t=e.value}else if(e.value.includes("px")){i=parseInt(e.value.replace(/\D/g,""))}});return[t,i]}function shouldInheritGap(e,r){var t;var n=a(e);var i=a(r);if(n[0].length<i[0].length){return false}else if(n[0].length>i[0].length){var o=n[0].reduce(function(e,r,t){var n=r[0];var o=i[0][0][0];if(n===o){return t}return false},false);if(o){t=i[0].every(function(e,r){return e.every(function(e,t){return n[0].slice(o)[r][t]===e})})}}else{t=i.some(function(e){return e.every(function(e,r){return e.every(function(e,t){return n[0][r][t]===e})})})}return t}function inheritGridGap(e,r){var t=e.parent;var n=getParentMedia(t);var i=t.root();var o=a(t.selector);if(Object.keys(r).length>0){return false}var u=parseMediaParams(n.params),c=u[0];var l=o[0];var B=s(l[l.length-1][0]);var f=new RegExp("("+B+"$)|("+B+"[,.])");var p;i.walkRules(f,function(e){var r;if(t.toString()===e.toString()){return false}e.walkDecls("grid-gap",function(e){return r=getGridGap(e)});if(!r||Object.keys(r).length===0){return true}if(!shouldInheritGap(t.selector,e.selector)){return true}var n=getParentMedia(e);if(n){var i=parseMediaParams(n.params)[0];if(i===c){p=r;return true}}else{p=r;return true}return undefined});if(p&&Object.keys(p).length>0){return p}return false}function warnGridGap(e){var r=e.gap,t=e.hasColumns,n=e.decl,i=e.result;var o=r.row&&r.column;if(!t&&(o||r.column&&!r.row)){delete r.column;n.warn(i,"Can not implement grid-gap without grid-template-columns")}}function normalizeRowColumn(e){var r=n(e).nodes.reduce(function(e,r){if(r.type==="function"&&r.value==="repeat"){var t="count";var i=r.nodes.reduce(function(e,r){if(r.type==="word"&&t==="count"){e[0]=Math.abs(parseInt(r.value));return e}if(r.type==="div"&&r.value===","){t="value";return e}if(t==="value"){e[1]+=n.stringify(r)}return e},[0,""]),o=i[0],s=i[1];if(o){for(var a=0;a<o;a++){e.push(s)}}return e}if(r.type==="space"){return e}return e.concat(n.stringify(r))},[]);return r}function autoplaceGridItems(e,r,t,n){if(n===void 0){n="row"}var i=e.parent;var o=i.nodes.find(function(e){return e.prop==="grid-template-rows"});var s=normalizeRowColumn(o.value);var a=normalizeRowColumn(e.value);var u=s.map(function(e,r){return Array.from({length:a.length},function(e,t){return t+r*a.length+1}).join(" ")});var c=parseGridAreas({rows:u,gap:t});var l=Object.keys(c);var B=l.map(function(e){return c[e]});if(n.includes("column")){B=B.sort(function(e,r){return e.column.start-r.column.start})}B.reverse().forEach(function(e,r){var t=e.column,n=e.row;var o=i.selectors.map(function(e){return e+(" > *:nth-child("+(l.length-r)+")")}).join(", ");var s=i.clone().removeAll();s.selector=o;s.append({prop:"-ms-grid-row",value:n.start});s.append({prop:"-ms-grid-column",value:t.start});i.after(s)});return undefined}e.exports={parse:parse,translate:translate,parseTemplate:parseTemplate,parseGridAreas:parseGridAreas,warnMissedAreas:warnMissedAreas,insertAreas:insertAreas,insertDecl:insertDecl,prefixTrackProp:prefixTrackProp,prefixTrackValue:prefixTrackValue,getGridGap:getGridGap,warnGridGap:warnGridGap,warnTemplateSelectorNotFound:warnTemplateSelectorNotFound,warnIfGridRowColumnExists:warnIfGridRowColumnExists,inheritGridGap:inheritGridGap,autoplaceGridItems:autoplaceGridItems}},3463:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(ImageRendering,e);function ImageRendering(){return e.apply(this,arguments)||this}var r=ImageRendering.prototype;r.check=function check(e){return e.value==="pixelated"};r.prefixed=function prefixed(r,t){if(t==="-ms-"){return"-ms-interpolation-mode"}return e.prototype.prefixed.call(this,r,t)};r.set=function set(r,t){if(t!=="-ms-")return e.prototype.set.call(this,r,t);r.prop="-ms-interpolation-mode";r.value="nearest-neighbor";return r};r.normalize=function normalize(){return"image-rendering"};r.process=function process(r,t){return e.prototype.process.call(this,r,t)};return ImageRendering}(n);_defineProperty(i,"names",["image-rendering","interpolation-mode"]);e.exports=i},291:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1882);var i=function(e){_inheritsLoose(ImageSet,e);function ImageSet(){return e.apply(this,arguments)||this}var r=ImageSet.prototype;r.replace=function replace(r,t){var n=e.prototype.replace.call(this,r,t);if(t==="-webkit-"){n=n.replace(/("[^"]+"|'[^']+')(\s+\d+\w)/gi,"url($1)$2")}return n};return ImageSet}(n);_defineProperty(i,"names",["image-set"]);e.exports=i},8322:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(InlineLogical,e);function InlineLogical(){return e.apply(this,arguments)||this}var r=InlineLogical.prototype;r.prefixed=function prefixed(e,r){return r+e.replace("-inline","")};r.normalize=function normalize(e){return e.replace(/(margin|padding|border)-(start|end)/,"$1-inline-$2")};return InlineLogical}(n);_defineProperty(i,"names",["border-inline-start","border-inline-end","margin-inline-start","margin-inline-end","padding-inline-start","padding-inline-end","border-start","border-end","margin-start","margin-end","padding-start","padding-end"]);e.exports=i},1138:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(6661);var i=t(1882);function _regexp(e){return new RegExp("(^|[\\s,(])("+e+"($|[\\s),]))","gi")}var o=function(e){_inheritsLoose(Intrinsic,e);function Intrinsic(){return e.apply(this,arguments)||this}var r=Intrinsic.prototype;r.regexp=function regexp(){if(!this.regexpCache)this.regexpCache=_regexp(this.name);return this.regexpCache};r.isStretch=function isStretch(){return this.name==="stretch"||this.name==="fill"||this.name==="fill-available"};r.replace=function replace(r,t){if(t==="-moz-"&&this.isStretch()){return r.replace(this.regexp(),"$1-moz-available$3")}if(t==="-webkit-"&&this.isStretch()){return r.replace(this.regexp(),"$1-webkit-fill-available$3")}return e.prototype.replace.call(this,r,t)};r.old=function old(e){var r=e+this.name;if(this.isStretch()){if(e==="-moz-"){r="-moz-available"}else if(e==="-webkit-"){r="-webkit-fill-available"}}return new n(this.name,r,r,_regexp(r))};r.add=function add(r,t){if(r.prop.includes("grid")&&t!=="-webkit-"){return undefined}return e.prototype.add.call(this,r,t)};return Intrinsic}(i);_defineProperty(o,"names",["max-content","min-content","fit-content","fill","fill-available","stretch"]);e.exports=o},5230:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(5753);var o=function(e){_inheritsLoose(JustifyContent,e);function JustifyContent(){return e.apply(this,arguments)||this}var r=JustifyContent.prototype;r.prefixed=function prefixed(r,t){var i;var o=n(t);i=o[0];t=o[1];if(i===2009){return t+"box-pack"}if(i===2012){return t+"flex-pack"}return e.prototype.prefixed.call(this,r,t)};r.normalize=function normalize(){return"justify-content"};r.set=function set(r,t){var i=n(t)[0];if(i===2009||i===2012){var o=JustifyContent.oldValues[r.value]||r.value;r.value=o;if(i!==2009||o!=="distribute"){return e.prototype.set.call(this,r,t)}}else if(i==="final"){return e.prototype.set.call(this,r,t)}return undefined};return JustifyContent}(i);_defineProperty(o,"names",["justify-content","flex-pack","box-pack"]);_defineProperty(o,"oldValues",{"flex-end":"end","flex-start":"start","space-between":"justify","space-around":"distribute"});e.exports=o},7447:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(MaskBorder,e);function MaskBorder(){return e.apply(this,arguments)||this}var r=MaskBorder.prototype;r.normalize=function normalize(){return this.name.replace("box-image","border")};r.prefixed=function prefixed(r,t){var n=e.prototype.prefixed.call(this,r,t);if(t==="-webkit-"){n=n.replace("border","box-image")}return n};return MaskBorder}(n);_defineProperty(i,"names",["mask-border","mask-border-source","mask-border-slice","mask-border-width","mask-border-outset","mask-border-repeat","mask-box-image","mask-box-image-source","mask-box-image-slice","mask-box-image-width","mask-box-image-outset","mask-box-image-repeat"]);e.exports=i},9116:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(MaskComposite,e);function MaskComposite(){return e.apply(this,arguments)||this}var r=MaskComposite.prototype;r.insert=function insert(e,r,t){var n=e.prop==="mask-composite";var i;if(n){i=e.value.split(",")}else{i=e.value.match(MaskComposite.regexp)||[]}i=i.map(function(e){return e.trim()}).filter(function(e){return e});var o=i.length;var s;if(o){s=this.clone(e);s.value=i.map(function(e){return MaskComposite.oldValues[e]||e}).join(", ");if(i.includes("intersect")){s.value+=", xor"}s.prop=r+"mask-composite"}if(n){if(!o){return undefined}if(this.needCascade(e)){s.raws.before=this.calcBefore(t,e,r)}return e.parent.insertBefore(e,s)}var a=this.clone(e);a.prop=r+a.prop;if(o){a.value=a.value.replace(MaskComposite.regexp,"")}if(this.needCascade(e)){a.raws.before=this.calcBefore(t,e,r)}e.parent.insertBefore(e,a);if(!o){return e}if(this.needCascade(e)){s.raws.before=this.calcBefore(t,e,r)}return e.parent.insertBefore(e,s)};return MaskComposite}(n);_defineProperty(i,"names",["mask","mask-composite"]);_defineProperty(i,"oldValues",{add:"source-over",substract:"source-out",intersect:"source-in",exclude:"xor"});_defineProperty(i,"regexp",new RegExp("\\s+("+Object.keys(i.oldValues).join("|")+")\\b(?!\\))\\s*(?=[,])","ig"));e.exports=i},7017:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(1524);var i=t(5753);var o=function(e){_inheritsLoose(Order,e);function Order(){return e.apply(this,arguments)||this}var r=Order.prototype;r.prefixed=function prefixed(r,t){var i;var o=n(t);i=o[0];t=o[1];if(i===2009){return t+"box-ordinal-group"}if(i===2012){return t+"flex-order"}return e.prototype.prefixed.call(this,r,t)};r.normalize=function normalize(){return"order"};r.set=function set(r,t){var i=n(t)[0];if(i===2009&&/\d/.test(r.value)){r.value=(parseInt(r.value)+1).toString();return e.prototype.set.call(this,r,t)}return e.prototype.set.call(this,r,t)};return Order}(i);_defineProperty(o,"names",["order","flex-order","box-ordinal-group"]);e.exports=o},2681:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(OverscrollBehavior,e);function OverscrollBehavior(){return e.apply(this,arguments)||this}var r=OverscrollBehavior.prototype;r.prefixed=function prefixed(e,r){return r+"scroll-chaining"};r.normalize=function normalize(){return"overscroll-behavior"};r.set=function set(r,t){if(r.value==="auto"){r.value="chained"}else if(r.value==="none"||r.value==="contain"){r.value="none"}return e.prototype.set.call(this,r,t)};return OverscrollBehavior}(n);_defineProperty(i,"names",["overscroll-behavior","scroll-chaining"]);e.exports=i},4581:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(6661);var i=t(1882);var o=function(e){_inheritsLoose(Pixelated,e);function Pixelated(){return e.apply(this,arguments)||this}var r=Pixelated.prototype;r.replace=function replace(r,t){if(t==="-webkit-"){return r.replace(this.regexp(),"$1-webkit-optimize-contrast")}if(t==="-moz-"){return r.replace(this.regexp(),"$1-moz-crisp-edges")}return e.prototype.replace.call(this,r,t)};r.old=function old(r){if(r==="-webkit-"){return new n(this.name,"-webkit-optimize-contrast")}if(r==="-moz-"){return new n(this.name,"-moz-crisp-edges")}return e.prototype.old.call(this,r)};return Pixelated}(i);_defineProperty(o,"names",["pixelated"]);e.exports=o},1036:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=t(5224);var o=function(e){_inheritsLoose(PlaceSelf,e);function PlaceSelf(){return e.apply(this,arguments)||this}var r=PlaceSelf.prototype;r.insert=function insert(r,t,n){if(t!=="-ms-")return e.prototype.insert.call(this,r,t,n);if(r.parent.some(function(e){return e.prop==="-ms-grid-row-align"})){return undefined}var o=i.parse(r),s=o[0],a=s[0],u=s[1];if(u){i.insertDecl(r,"grid-row-align",a);i.insertDecl(r,"grid-column-align",u)}else{i.insertDecl(r,"grid-row-align",a);i.insertDecl(r,"grid-column-align",a)}return undefined};return PlaceSelf}(n);_defineProperty(o,"names",["place-self"]);e.exports=o},9478:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(4806);var i=function(e){_inheritsLoose(Placeholder,e);function Placeholder(){return e.apply(this,arguments)||this}var r=Placeholder.prototype;r.possible=function possible(){return e.prototype.possible.call(this).concat(["-moz- old","-ms- old"])};r.prefixed=function prefixed(e){if(e==="-webkit-"){return"::-webkit-input-placeholder"}if(e==="-ms-"){return"::-ms-input-placeholder"}if(e==="-ms- old"){return":-ms-input-placeholder"}if(e==="-moz- old"){return":-moz-placeholder"}return"::"+e+"placeholder"};return Placeholder}(n);_defineProperty(i,"names",["::placeholder"]);e.exports=i},9228:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(TextDecorationSkipInk,e);function TextDecorationSkipInk(){return e.apply(this,arguments)||this}var r=TextDecorationSkipInk.prototype;r.set=function set(r,t){if(r.prop==="text-decoration-skip-ink"&&r.value==="auto"){r.prop=t+"text-decoration-skip";r.value="ink";return r}else{return e.prototype.set.call(this,r,t)}};return TextDecorationSkipInk}(n);_defineProperty(i,"names",["text-decoration-skip-ink","text-decoration-skip"]);e.exports=i},9936:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=["none","underline","overline","line-through","blink","inherit","initial","unset"];var o=function(e){_inheritsLoose(TextDecoration,e);function TextDecoration(){return e.apply(this,arguments)||this}var r=TextDecoration.prototype;r.check=function check(e){return e.value.split(/\s+/).some(function(e){return!i.includes(e)})};return TextDecoration}(n);_defineProperty(o,"names",["text-decoration"]);e.exports=o},487:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(TextEmphasisPosition,e);function TextEmphasisPosition(){return e.apply(this,arguments)||this}var r=TextEmphasisPosition.prototype;r.set=function set(r,t){if(t==="-webkit-"){r.value=r.value.replace(/\s*(right|left)\s*/i,"")}return e.prototype.set.call(this,r,t)};return TextEmphasisPosition}(n);_defineProperty(i,"names",["text-emphasis-position"]);e.exports=i},9801:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(TransformDecl,e);function TransformDecl(){return e.apply(this,arguments)||this}var r=TransformDecl.prototype;r.keyframeParents=function keyframeParents(e){var r=e.parent;while(r){if(r.type==="atrule"&&r.name==="keyframes"){return true}var t=r;r=t.parent}return false};r.contain3d=function contain3d(e){if(e.prop==="transform-origin"){return false}for(var r=TransformDecl.functions3d,t=Array.isArray(r),n=0,r=t?r:r[Symbol.iterator]();;){var i;if(t){if(n>=r.length)break;i=r[n++]}else{n=r.next();if(n.done)break;i=n.value}var o=i;if(e.value.includes(o+"(")){return true}}return false};r.set=function set(r,t){r=e.prototype.set.call(this,r,t);if(t==="-ms-"){r.value=r.value.replace(/rotatez/gi,"rotate")}return r};r.insert=function insert(r,t,n){if(t==="-ms-"){if(!this.contain3d(r)&&!this.keyframeParents(r)){return e.prototype.insert.call(this,r,t,n)}}else if(t==="-o-"){if(!this.contain3d(r)){return e.prototype.insert.call(this,r,t,n)}}else{return e.prototype.insert.call(this,r,t,n)}return undefined};return TransformDecl}(n);_defineProperty(i,"names",["transform","transform-origin"]);_defineProperty(i,"functions3d",["matrix3d","translate3d","translateZ","scale3d","scaleZ","rotate3d","rotateX","rotateY","perspective"]);e.exports=i},3251:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(UserSelect,e);function UserSelect(){return e.apply(this,arguments)||this}var r=UserSelect.prototype;r.set=function set(r,t){if(t==="-ms-"&&r.value==="contain"){r.value="element"}return e.prototype.set.call(this,r,t)};return UserSelect}(n);_defineProperty(i,"names",["user-select"]);e.exports=i},1041:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(5753);var i=function(e){_inheritsLoose(WritingMode,e);function WritingMode(){return e.apply(this,arguments)||this}var r=WritingMode.prototype;r.insert=function insert(r,t,n){if(t==="-ms-"){var i=this.set(this.clone(r),t);if(this.needCascade(r)){i.raws.before=this.calcBefore(n,r,t)}var o="ltr";r.parent.nodes.forEach(function(e){if(e.prop==="direction"){if(e.value==="rtl"||e.value==="ltr")o=e.value}});i.value=WritingMode.msValues[o][r.value]||r.value;return r.parent.insertBefore(r,i)}return e.prototype.insert.call(this,r,t,n)};return WritingMode}(n);_defineProperty(i,"names",["writing-mode"]);_defineProperty(i,"msValues",{ltr:{"horizontal-tb":"lr-tb","vertical-rl":"tb-rl","vertical-lr":"tb-lr"},rtl:{"horizontal-tb":"rl-tb","vertical-rl":"bt-rl","vertical-lr":"bt-lr"}});e.exports=i},6741:(e,r,t)=>{"use strict";var n=t(3561);function capitalize(e){return e.slice(0,1).toUpperCase()+e.slice(1)}var i={ie:"IE",ie_mob:"IE Mobile",ios_saf:"iOS",op_mini:"Opera Mini",op_mob:"Opera Mobile",and_chr:"Chrome for Android",and_ff:"Firefox for Android",and_uc:"UC for Android"};function prefix(e,r,t){var n="  "+e;if(t)n+=" *";n+=": ";n+=r.map(function(e){return e.replace(/^-(.*)-$/g,"$1")}).join(", ");n+="\n";return n}e.exports=function(e){if(e.browsers.selected.length===0){return"No browsers selected"}var r={};for(var t=e.browsers.selected,o=Array.isArray(t),s=0,t=o?t:t[Symbol.iterator]();;){var a;if(o){if(s>=t.length)break;a=t[s++]}else{s=t.next();if(s.done)break;a=s.value}var u=a;var c=u.split(" ");var l=c[0];var B=c[1];l=i[l]||capitalize(l);if(r[l]){r[l].push(B)}else{r[l]=[B]}}var f="Browsers:\n";for(var p in r){var d=r[p];d=d.sort(function(e,r){return parseFloat(r)-parseFloat(e)});f+="  "+p+": "+d.join(", ")+"\n"}var h=n.coverage(e.browsers.selected);var v=Math.round(h*100)/100;f+="\nThese browsers account for "+v+"% of all users globally\n";var b=[];for(var C in e.add){var g=e.add[C];if(C[0]==="@"&&g.prefixes){b.push(prefix(C,g.prefixes))}}if(b.length>0){f+="\nAt-Rules:\n"+b.sort().join("")}var m=[];for(var y=e.add.selectors,w=Array.isArray(y),S=0,y=w?y:y[Symbol.iterator]();;){var x;if(w){if(S>=y.length)break;x=y[S++]}else{S=y.next();if(S.done)break;x=S.value}var O=x;if(O.prefixes){m.push(prefix(O.name,O.prefixes))}}if(m.length>0){f+="\nSelectors:\n"+m.sort().join("")}var P=[];var k=[];var A=false;for(var F in e.add){var j=e.add[F];if(F[0]!=="@"&&j.prefixes){var T=F.indexOf("grid-")===0;if(T)A=true;k.push(prefix(F,j.prefixes,T))}if(!Array.isArray(j.values)){continue}for(var D=j.values,E=Array.isArray(D),R=0,D=E?D:D[Symbol.iterator]();;){var I;if(E){if(R>=D.length)break;I=D[R++]}else{R=D.next();if(R.done)break;I=R.value}var M=I;var L=M.name.includes("grid");if(L)A=true;var G=prefix(M.name,M.prefixes,L);if(!P.includes(G)){P.push(G)}}}if(k.length>0){f+="\nProperties:\n"+k.sort().join("")}if(P.length>0){f+="\nValues:\n"+P.sort().join("")}if(A){f+="\n* - Prefixes will be added only on grid: true option.\n"}if(!b.length&&!m.length&&!k.length&&!P.length){f+="\nAwesome! Your browsers don't require any vendor prefixes."+"\nNow you can remove Autoprefixer from build steps."}return f}},7471:e=>{"use strict";var r=function(){function OldSelector(e,r){this.prefix=r;this.prefixed=e.prefixed(this.prefix);this.regexp=e.regexp(this.prefix);this.prefixeds=e.possible().map(function(r){return[e.prefixed(r),e.regexp(r)]});this.unprefixed=e.name;this.nameRegexp=e.regexp()}var e=OldSelector.prototype;e.isHack=function isHack(e){var r=e.parent.index(e)+1;var t=e.parent.nodes;while(r<t.length){var n=t[r].selector;if(!n){return true}if(n.includes(this.unprefixed)&&n.match(this.nameRegexp)){return false}var i=false;for(var o=this.prefixeds,s=Array.isArray(o),a=0,o=s?o:o[Symbol.iterator]();;){var u;if(s){if(a>=o.length)break;u=o[a++]}else{a=o.next();if(a.done)break;u=a.value}var c=u,l=c[0],B=c[1];if(n.includes(l)&&n.match(B)){i=true;break}}if(!i){return true}r+=1}return true};e.check=function check(e){if(!e.selector.includes(this.prefixed)){return false}if(!e.selector.match(this.regexp)){return false}if(this.isHack(e)){return false}return true};return OldSelector}();e.exports=r},6661:(e,r,t)=>{"use strict";var n=t(772);var i=function(){function OldValue(e,r,t,i){this.unprefixed=e;this.prefixed=r;this.string=t||r;this.regexp=i||n.regexp(r)}var e=OldValue.prototype;e.check=function check(e){if(e.includes(this.string)){return!!e.match(this.regexp)}return false};return OldValue}();e.exports=i},8428:(e,r,t)=>{"use strict";var n=t(2043).vendor;var i=t(2319);var o=t(772);function _clone(e,r){var t=new e.constructor;for(var n=0,i=Object.keys(e||{});n<i.length;n++){var o=i[n];var s=e[o];if(o==="parent"&&typeof s==="object"){if(r){t[o]=r}}else if(o==="source"||o===null){t[o]=s}else if(Array.isArray(s)){t[o]=s.map(function(e){return _clone(e,t)})}else if(o!=="_autoprefixerPrefix"&&o!=="_autoprefixerValues"){if(typeof s==="object"&&s!==null){s=_clone(s,t)}t[o]=s}}return t}var s=function(){Prefixer.hack=function hack(e){var r=this;if(!this.hacks){this.hacks={}}return e.names.map(function(t){r.hacks[t]=e;return r.hacks[t]})};Prefixer.load=function load(e,r,t){var n=this.hacks&&this.hacks[e];if(n){return new n(e,r,t)}else{return new this(e,r,t)}};Prefixer.clone=function clone(e,r){var t=_clone(e);for(var n in r){t[n]=r[n]}return t};function Prefixer(e,r,t){this.prefixes=r;this.name=e;this.all=t}var e=Prefixer.prototype;e.parentPrefix=function parentPrefix(e){var r;if(typeof e._autoprefixerPrefix!=="undefined"){r=e._autoprefixerPrefix}else if(e.type==="decl"&&e.prop[0]==="-"){r=n.prefix(e.prop)}else if(e.type==="root"){r=false}else if(e.type==="rule"&&e.selector.includes(":-")&&/:(-\w+-)/.test(e.selector)){r=e.selector.match(/:(-\w+-)/)[1]}else if(e.type==="atrule"&&e.name[0]==="-"){r=n.prefix(e.name)}else{r=this.parentPrefix(e.parent)}if(!i.prefixes().includes(r)){r=false}e._autoprefixerPrefix=r;return e._autoprefixerPrefix};e.process=function process(e,r){if(!this.check(e)){return undefined}var t=this.parentPrefix(e);var n=this.prefixes.filter(function(e){return!t||t===o.removeNote(e)});var i=[];for(var s=n,a=Array.isArray(s),u=0,s=a?s:s[Symbol.iterator]();;){var c;if(a){if(u>=s.length)break;c=s[u++]}else{u=s.next();if(u.done)break;c=u.value}var l=c;if(this.add(e,l,i.concat([l]),r)){i.push(l)}}return i};e.clone=function clone(e,r){return Prefixer.clone(e,r)};return Prefixer}();e.exports=s},811:(e,r,t)=>{"use strict";var n=t(2043).vendor;var i=t(5753);var o=t(9514);var s=t(7080);var a=t(8120);var u=t(3817);var c=t(2319);var l=t(4806);var B=t(7997);var f=t(1882);var p=t(772);l.hack(t(9231));l.hack(t(9478));i.hack(t(3629));i.hack(t(7017));i.hack(t(972));i.hack(t(1763));i.hack(t(3331));i.hack(t(7106));i.hack(t(3392));i.hack(t(9315));i.hack(t(6658));i.hack(t(1036));i.hack(t(7912));i.hack(t(7335));i.hack(t(3686));i.hack(t(5041));i.hack(t(7447));i.hack(t(9116));i.hack(t(180));i.hack(t(3251));i.hack(t(5035));i.hack(t(517));i.hack(t(5836));i.hack(t(1041));i.hack(t(3305));i.hack(t(4802));i.hack(t(657));i.hack(t(9423));i.hack(t(5193));i.hack(t(8322));i.hack(t(4689));i.hack(t(9801));i.hack(t(2112));i.hack(t(3463));i.hack(t(1262));i.hack(t(7509));i.hack(t(9936));i.hack(t(5230));i.hack(t(1150));i.hack(t(8360));i.hack(t(2456));i.hack(t(5422));i.hack(t(2681));i.hack(t(1719));i.hack(t(487));i.hack(t(9228));f.hack(t(2433));f.hack(t(1138));f.hack(t(4581));f.hack(t(291));f.hack(t(8485));f.hack(t(3692));f.hack(t(1665));f.hack(t(133));var d={};var h=function(){function Prefixes(e,r,t){if(t===void 0){t={}}this.data=e;this.browsers=r;this.options=t;var n=this.preprocess(this.select(this.data));this.add=n[0];this.remove=n[1];this.transition=new s(this);this.processor=new a(this)}var e=Prefixes.prototype;e.cleaner=function cleaner(){if(this.cleanerCache){return this.cleanerCache}if(this.browsers.selected.length){var e=new c(this.browsers.data,[]);this.cleanerCache=new Prefixes(this.data,e,this.options)}else{return this}return this.cleanerCache};e.select=function select(e){var r=this;var t={add:{},remove:{}};var n=function _loop(n){var i=e[n];var o=i.browsers.map(function(e){var r=e.split(" ");return{browser:r[0]+" "+r[1],note:r[2]}});var s=o.filter(function(e){return e.note}).map(function(e){return r.browsers.prefix(e.browser)+" "+e.note});s=p.uniq(s);o=o.filter(function(e){return r.browsers.isSelected(e.browser)}).map(function(e){var t=r.browsers.prefix(e.browser);if(e.note){return t+" "+e.note}else{return t}});o=r.sort(p.uniq(o));if(r.options.flexbox==="no-2009"){o=o.filter(function(e){return!e.includes("2009")})}var a=i.browsers.map(function(e){return r.browsers.prefix(e)});if(i.mistakes){a=a.concat(i.mistakes)}a=a.concat(s);a=p.uniq(a);if(o.length){t.add[n]=o;if(o.length<a.length){t.remove[n]=a.filter(function(e){return!o.includes(e)})}}else{t.remove[n]=a}};for(var i in e){n(i)}return t};e.sort=function sort(e){return e.sort(function(e,r){var t=p.removeNote(e).length;var n=p.removeNote(r).length;if(t===n){return r.length-e.length}else{return n-t}})};e.preprocess=function preprocess(e){var r={selectors:[],"@supports":new u(Prefixes,this)};for(var t in e.add){var n=e.add[t];if(t==="@keyframes"||t==="@viewport"){r[t]=new B(t,n,this)}else if(t==="@resolution"){r[t]=new o(t,n,this)}else if(this.data[t].selector){r.selectors.push(l.load(t,n,this))}else{var s=this.data[t].props;if(s){var a=f.load(t,n,this);for(var c=s,p=Array.isArray(c),d=0,c=p?c:c[Symbol.iterator]();;){var h;if(p){if(d>=c.length)break;h=c[d++]}else{d=c.next();if(d.done)break;h=d.value}var v=h;if(!r[v]){r[v]={values:[]}}r[v].values.push(a)}}else{var b=r[t]&&r[t].values||[];r[t]=i.load(t,n,this);r[t].values=b}}}var C={selectors:[]};for(var g in e.remove){var m=e.remove[g];if(this.data[g].selector){var y=l.load(g,m);for(var w=m,S=Array.isArray(w),x=0,w=S?w:w[Symbol.iterator]();;){var O;if(S){if(x>=w.length)break;O=w[x++]}else{x=w.next();if(x.done)break;O=x.value}var P=O;C.selectors.push(y.old(P))}}else if(g==="@keyframes"||g==="@viewport"){for(var k=m,A=Array.isArray(k),F=0,k=A?k:k[Symbol.iterator]();;){var j;if(A){if(F>=k.length)break;j=k[F++]}else{F=k.next();if(F.done)break;j=F.value}var T=j;var D="@"+T+g.slice(1);C[D]={remove:true}}}else if(g==="@resolution"){C[g]=new o(g,m,this)}else{var E=this.data[g].props;if(E){var R=f.load(g,[],this);for(var I=m,M=Array.isArray(I),L=0,I=M?I:I[Symbol.iterator]();;){var G;if(M){if(L>=I.length)break;G=I[L++]}else{L=I.next();if(L.done)break;G=L.value}var N=G;var J=R.old(N);if(J){for(var H=E,Q=Array.isArray(H),U=0,H=Q?H:H[Symbol.iterator]();;){var W;if(Q){if(U>=H.length)break;W=H[U++]}else{U=H.next();if(U.done)break;W=U.value}var K=W;if(!C[K]){C[K]={}}if(!C[K].values){C[K].values=[]}C[K].values.push(J)}}}}else{for(var z=m,q=Array.isArray(z),Y=0,z=q?z:z[Symbol.iterator]();;){var X;if(q){if(Y>=z.length)break;X=z[Y++]}else{Y=z.next();if(Y.done)break;X=Y.value}var Z=X;var $=this.decl(g).old(g,Z);if(g==="align-self"){var V=r[g]&&r[g].prefixes;if(V){if(Z==="-webkit- 2009"&&V.includes("-webkit-")){continue}else if(Z==="-webkit-"&&V.includes("-webkit- 2009")){continue}}}for(var _=$,ee=Array.isArray(_),re=0,_=ee?_:_[Symbol.iterator]();;){var te;if(ee){if(re>=_.length)break;te=_[re++]}else{re=_.next();if(re.done)break;te=re.value}var ne=te;if(!C[ne]){C[ne]={}}C[ne].remove=true}}}}}return[r,C]};e.decl=function decl(e){var decl=d[e];if(decl){return decl}else{d[e]=i.load(e);return d[e]}};e.unprefixed=function unprefixed(e){var r=this.normalize(n.unprefixed(e));if(r==="flex-direction"){r="flex-flow"}return r};e.normalize=function normalize(e){return this.decl(e).normalize(e)};e.prefixed=function prefixed(e,r){e=n.unprefixed(e);return this.decl(e).prefixed(e,r)};e.values=function values(e,r){var t=this[e];var n=t["*"]&&t["*"].values;var values=t[r]&&t[r].values;if(n&&values){return p.uniq(n.concat(values))}else{return n||values||[]}};e.group=function group(e){var r=this;var t=e.parent;var n=t.index(e);var i=t.nodes.length;var o=this.unprefixed(e.prop);var s=function checker(e,s){n+=e;while(n>=0&&n<i){var a=t.nodes[n];if(a.type==="decl"){if(e===-1&&a.prop===o){if(!c.withPrefix(a.value)){break}}if(r.unprefixed(a.prop)!==o){break}else if(s(a)===true){return true}if(e===+1&&a.prop===o){if(!c.withPrefix(a.value)){break}}}n+=e}return false};return{up:function up(e){return s(-1,e)},down:function down(e){return s(+1,e)}}};return Prefixes}();e.exports=h},8120:(e,r,t)=>{"use strict";var n=t(7195);var i=t(1882);var o=t(5224).insertAreas;var s=/(^|[^-])linear-gradient\(\s*(top|left|right|bottom)/i;var a=/(^|[^-])radial-gradient\(\s*\d+(\w*|%)\s+\d+(\w*|%)\s*,/i;var u=/(!\s*)?autoprefixer:\s*ignore\s+next/i;var c=/(!\s*)?autoprefixer\s*grid:\s*(on|off|(no-)?autoplace)/i;var l=["width","height","min-width","max-width","min-height","max-height","inline-size","min-inline-size","max-inline-size","block-size","min-block-size","max-block-size"];function hasGridTemplate(e){return e.parent.some(function(e){return e.prop==="grid-template"||e.prop==="grid-template-areas"})}function hasRowsAndColumns(e){var r=e.parent.some(function(e){return e.prop==="grid-template-rows"});var t=e.parent.some(function(e){return e.prop==="grid-template-columns"});return r&&t}var B=function(){function Processor(e){this.prefixes=e}var e=Processor.prototype;e.add=function add(e,r){var t=this;var u=this.prefixes.add["@resolution"];var c=this.prefixes.add["@keyframes"];var B=this.prefixes.add["@viewport"];var f=this.prefixes.add["@supports"];e.walkAtRules(function(e){if(e.name==="keyframes"){if(!t.disabled(e,r)){return c&&c.process(e)}}else if(e.name==="viewport"){if(!t.disabled(e,r)){return B&&B.process(e)}}else if(e.name==="supports"){if(t.prefixes.options.supports!==false&&!t.disabled(e,r)){return f.process(e)}}else if(e.name==="media"&&e.params.includes("-resolution")){if(!t.disabled(e,r)){return u&&u.process(e)}}return undefined});e.walkRules(function(e){if(t.disabled(e,r))return undefined;return t.prefixes.add.selectors.map(function(t){return t.process(e,r)})});function insideGrid(e){return e.parent.nodes.some(function(e){if(e.type!=="decl")return false;var r=e.prop==="display"&&/(inline-)?grid/.test(e.value);var t=e.prop.startsWith("grid-template");var n=/^grid-([A-z]+-)?gap/.test(e.prop);return r||t||n})}function insideFlex(e){return e.parent.some(function(e){return e.prop==="display"&&/(inline-)?flex/.test(e.value)})}var p=this.gridStatus(e,r)&&this.prefixes.add["grid-area"]&&this.prefixes.add["grid-area"].prefixes;e.walkDecls(function(e){if(t.disabledDecl(e,r))return undefined;var i=e.parent;var o=e.prop;var u=e.value;if(o==="grid-row-span"){r.warn("grid-row-span is not part of final Grid Layout. Use grid-row.",{node:e});return undefined}else if(o==="grid-column-span"){r.warn("grid-column-span is not part of final Grid Layout. Use grid-column.",{node:e});return undefined}else if(o==="display"&&u==="box"){r.warn("You should write display: flex by final spec "+"instead of display: box",{node:e});return undefined}else if(o==="text-emphasis-position"){if(u==="under"||u==="over"){r.warn("You should use 2 values for text-emphasis-position "+"For example, `under left` instead of just `under`.",{node:e})}}else if(/^(align|justify|place)-(items|content)$/.test(o)&&insideFlex(e)){if(u==="start"||u==="end"){r.warn(u+" value has mixed support, consider using "+("flex-"+u+" instead"),{node:e})}}else if(o==="text-decoration-skip"&&u==="ink"){r.warn("Replace text-decoration-skip: ink to "+"text-decoration-skip-ink: auto, because spec had been changed",{node:e})}else{if(p){if(/^(align|justify|place)-items$/.test(o)&&insideGrid(e)){var c=o.replace("-items","-self");r.warn("IE does not support "+o+" on grid containers. "+("Try using "+c+" on child elements instead: ")+(e.parent.selector+" > * { "+c+": "+e.value+" }"),{node:e})}else if(/^(align|justify|place)-content$/.test(o)&&insideGrid(e)){r.warn("IE does not support "+e.prop+" on grid containers",{node:e})}else if(o==="display"&&e.value==="contents"){r.warn("Please do not use display: contents; "+"if you have grid setting enabled",{node:e});return undefined}else if(e.prop==="grid-gap"){var B=t.gridStatus(e,r);if(B==="autoplace"&&!hasRowsAndColumns(e)&&!hasGridTemplate(e)){r.warn("grid-gap only works if grid-template(-areas) is being "+"used or both rows and columns have been declared "+"and cells have not been manually "+"placed inside the explicit grid",{node:e})}else if((B===true||B==="no-autoplace")&&!hasGridTemplate(e)){r.warn("grid-gap only works if grid-template(-areas) is being used",{node:e})}}else if(o==="grid-auto-columns"){r.warn("grid-auto-columns is not supported by IE",{node:e});return undefined}else if(o==="grid-auto-rows"){r.warn("grid-auto-rows is not supported by IE",{node:e});return undefined}else if(o==="grid-auto-flow"){var f=i.some(function(e){return e.prop==="grid-template-rows"});var d=i.some(function(e){return e.prop==="grid-template-columns"});if(hasGridTemplate(e)){r.warn("grid-auto-flow is not supported by IE",{node:e})}else if(u.includes("dense")){r.warn("grid-auto-flow: dense is not supported by IE",{node:e})}else if(!f&&!d){r.warn("grid-auto-flow works only if grid-template-rows and "+"grid-template-columns are present in the same rule",{node:e})}return undefined}else if(u.includes("auto-fit")){r.warn("auto-fit value is not supported by IE",{node:e,word:"auto-fit"});return undefined}else if(u.includes("auto-fill")){r.warn("auto-fill value is not supported by IE",{node:e,word:"auto-fill"});return undefined}else if(o.startsWith("grid-template")&&u.includes("[")){r.warn("Autoprefixer currently does not support line names. "+"Try using grid-template-areas instead.",{node:e,word:"["})}}if(u.includes("radial-gradient")){if(a.test(e.value)){r.warn("Gradient has outdated direction syntax. "+"New syntax is like `closest-side at 0 0` "+"instead of `0 0, closest-side`.",{node:e})}else{var h=n(u);for(var v=h.nodes,b=Array.isArray(v),C=0,v=b?v:v[Symbol.iterator]();;){var g;if(b){if(C>=v.length)break;g=v[C++]}else{C=v.next();if(C.done)break;g=C.value}var m=g;if(m.type==="function"&&m.value==="radial-gradient"){for(var y=m.nodes,w=Array.isArray(y),S=0,y=w?y:y[Symbol.iterator]();;){var x;if(w){if(S>=y.length)break;x=y[S++]}else{S=y.next();if(S.done)break;x=S.value}var O=x;if(O.type==="word"){if(O.value==="cover"){r.warn("Gradient has outdated direction syntax. "+"Replace `cover` to `farthest-corner`.",{node:e})}else if(O.value==="contain"){r.warn("Gradient has outdated direction syntax. "+"Replace `contain` to `closest-side`.",{node:e})}}}}}}}if(u.includes("linear-gradient")){if(s.test(u)){r.warn("Gradient has outdated direction syntax. "+"New syntax is like `to left` instead of `right`.",{node:e})}}}if(l.includes(e.prop)){if(!e.value.includes("-fill-available")){if(e.value.includes("fill-available")){r.warn("Replace fill-available to stretch, "+"because spec had been changed",{node:e})}else if(e.value.includes("fill")){var P=n(u);if(P.nodes.some(function(e){return e.type==="word"&&e.value==="fill"})){r.warn("Replace fill to stretch, because spec had been changed",{node:e})}}}}var k;if(e.prop==="transition"||e.prop==="transition-property"){return t.prefixes.transition.add(e,r)}else if(e.prop==="align-self"){var A=t.displayType(e);if(A!=="grid"&&t.prefixes.options.flexbox!==false){k=t.prefixes.add["align-self"];if(k&&k.prefixes){k.process(e)}}if(A!=="flex"&&t.gridStatus(e,r)!==false){k=t.prefixes.add["grid-row-align"];if(k&&k.prefixes){return k.process(e,r)}}}else if(e.prop==="justify-self"){var F=t.displayType(e);if(F!=="flex"&&t.gridStatus(e,r)!==false){k=t.prefixes.add["grid-column-align"];if(k&&k.prefixes){return k.process(e,r)}}}else if(e.prop==="place-self"){k=t.prefixes.add["place-self"];if(k&&k.prefixes&&t.gridStatus(e,r)!==false){return k.process(e,r)}}else{k=t.prefixes.add[e.prop];if(k&&k.prefixes){return k.process(e,r)}}return undefined});if(this.gridStatus(e,r)){o(e,this.disabled)}return e.walkDecls(function(e){if(t.disabledValue(e,r))return;var n=t.prefixes.unprefixed(e.prop);var o=t.prefixes.values("add",n);if(Array.isArray(o)){for(var s=o,a=Array.isArray(s),u=0,s=a?s:s[Symbol.iterator]();;){var c;if(a){if(u>=s.length)break;c=s[u++]}else{u=s.next();if(u.done)break;c=u.value}var l=c;if(l.process)l.process(e,r)}}i.save(t.prefixes,e)})};e.remove=function remove(e,r){var t=this;var n=this.prefixes.remove["@resolution"];e.walkAtRules(function(e,i){if(t.prefixes.remove["@"+e.name]){if(!t.disabled(e,r)){e.parent.removeChild(i)}}else if(e.name==="media"&&e.params.includes("-resolution")&&n){n.clean(e)}});var i=function _loop(){if(s){if(a>=o.length)return"break";u=o[a++]}else{a=o.next();if(a.done)return"break";u=a.value}var n=u;e.walkRules(function(e,i){if(n.check(e)){if(!t.disabled(e,r)){e.parent.removeChild(i)}}})};for(var o=this.prefixes.remove.selectors,s=Array.isArray(o),a=0,o=s?o:o[Symbol.iterator]();;){var u;var c=i();if(c==="break")break}return e.walkDecls(function(e,n){if(t.disabled(e,r))return;var i=e.parent;var o=t.prefixes.unprefixed(e.prop);if(e.prop==="transition"||e.prop==="transition-property"){t.prefixes.transition.remove(e)}if(t.prefixes.remove[e.prop]&&t.prefixes.remove[e.prop].remove){var s=t.prefixes.group(e).down(function(e){return t.prefixes.normalize(e.prop)===o});if(o==="flex-flow"){s=true}if(e.prop==="-webkit-box-orient"){var a={"flex-direction":true,"flex-flow":true};if(!e.parent.some(function(e){return a[e.prop]}))return}if(s&&!t.withHackValue(e)){if(e.raw("before").includes("\n")){t.reduceSpaces(e)}i.removeChild(n);return}}for(var u=t.prefixes.values("remove",o),c=Array.isArray(u),l=0,u=c?u:u[Symbol.iterator]();;){var B;if(c){if(l>=u.length)break;B=u[l++]}else{l=u.next();if(l.done)break;B=l.value}var f=B;if(!f.check)continue;if(!f.check(e.value))continue;o=f.unprefixed;var p=t.prefixes.group(e).down(function(e){return e.value.includes(o)});if(p){i.removeChild(n);return}}})};e.withHackValue=function withHackValue(e){return e.prop==="-webkit-background-clip"&&e.value==="text"};e.disabledValue=function disabledValue(e,r){if(this.gridStatus(e,r)===false&&e.type==="decl"){if(e.prop==="display"&&e.value.includes("grid")){return true}}if(this.prefixes.options.flexbox===false&&e.type==="decl"){if(e.prop==="display"&&e.value.includes("flex")){return true}}return this.disabled(e,r)};e.disabledDecl=function disabledDecl(e,r){if(this.gridStatus(e,r)===false&&e.type==="decl"){if(e.prop.includes("grid")||e.prop==="justify-items"){return true}}if(this.prefixes.options.flexbox===false&&e.type==="decl"){var t=["order","justify-content","align-items","align-content"];if(e.prop.includes("flex")||t.includes(e.prop)){return true}}return this.disabled(e,r)};e.disabled=function disabled(e,r){if(!e)return false;if(e._autoprefixerDisabled!==undefined){return e._autoprefixerDisabled}if(e.parent){var t=e.prev();if(t&&t.type==="comment"&&u.test(t.text)){e._autoprefixerDisabled=true;e._autoprefixerSelfDisabled=true;return true}}var n=null;if(e.nodes){var i;e.each(function(e){if(e.type!=="comment")return;if(/(!\s*)?autoprefixer:\s*(off|on)/i.test(e.text)){if(typeof i!=="undefined"){r.warn("Second Autoprefixer control comment "+"was ignored. Autoprefixer applies control "+"comment to whole block, not to next rules.",{node:e})}else{i=/on/i.test(e.text)}}});if(i!==undefined){n=!i}}if(!e.nodes||n===null){if(e.parent){var o=this.disabled(e.parent,r);if(e.parent._autoprefixerSelfDisabled===true){n=false}else{n=o}}else{n=false}}e._autoprefixerDisabled=n;return n};e.reduceSpaces=function reduceSpaces(e){var r=false;this.prefixes.group(e).up(function(){r=true;return true});if(r){return}var t=e.raw("before").split("\n");var n=t[t.length-1].length;var i=false;this.prefixes.group(e).down(function(e){t=e.raw("before").split("\n");var r=t.length-1;if(t[r].length>n){if(i===false){i=t[r].length-n}t[r]=t[r].slice(0,-i);e.raws.before=t.join("\n")}})};e.displayType=function displayType(e){for(var r=e.parent.nodes,t=Array.isArray(r),n=0,r=t?r:r[Symbol.iterator]();;){var i;if(t){if(n>=r.length)break;i=r[n++]}else{n=r.next();if(n.done)break;i=n.value}var o=i;if(o.prop!=="display"){continue}if(o.value.includes("flex")){return"flex"}if(o.value.includes("grid")){return"grid"}}return false};e.gridStatus=function gridStatus(e,r){if(!e)return false;if(e._autoprefixerGridStatus!==undefined){return e._autoprefixerGridStatus}var t=null;if(e.nodes){var n;e.each(function(e){if(e.type!=="comment")return;if(c.test(e.text)){var t=/:\s*autoplace/i.test(e.text);var i=/no-autoplace/i.test(e.text);if(typeof n!=="undefined"){r.warn("Second Autoprefixer grid control comment was "+"ignored. Autoprefixer applies control comments to the whole "+"block, not to the next rules.",{node:e})}else if(t){n="autoplace"}else if(i){n=true}else{n=/on/i.test(e.text)}}});if(n!==undefined){t=n}}if(e.type==="atrule"&&e.name==="supports"){var i=e.params;if(i.includes("grid")&&i.includes("auto")){t=false}}if(!e.nodes||t===null){if(e.parent){var o=this.gridStatus(e.parent,r);if(e.parent._autoprefixerSelfDisabled===true){t=false}else{t=o}}else if(typeof this.prefixes.options.grid!=="undefined"){t=this.prefixes.options.grid}else if(typeof process.env.AUTOPREFIXER_GRID!=="undefined"){if(process.env.AUTOPREFIXER_GRID==="autoplace"){t="autoplace"}else{t=true}}else{t=false}}e._autoprefixerGridStatus=t;return t};return Processor}();e.exports=B},9514:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}var n=t(9108);var i=t(8428);var o=t(772);var s=/(min|max)-resolution\s*:\s*\d*\.?\d+(dppx|dpi|x)/gi;var a=/(min|max)-resolution(\s*:\s*)(\d*\.?\d+)(dppx|dpi|x)/i;var u=function(e){_inheritsLoose(Resolution,e);function Resolution(){return e.apply(this,arguments)||this}var r=Resolution.prototype;r.prefixName=function prefixName(e,r){if(e==="-moz-"){return r+"--moz-device-pixel-ratio"}else{return e+r+"-device-pixel-ratio"}};r.prefixQuery=function prefixQuery(e,r,t,i,o){if(o==="dpi"){i=Number(i/96)}if(e==="-o-"){i=n(i)}return this.prefixName(e,r)+t+i};r.clean=function clean(e){var r=this;if(!this.bad){this.bad=[];for(var t=this.prefixes,n=Array.isArray(t),i=0,t=n?t:t[Symbol.iterator]();;){var s;if(n){if(i>=t.length)break;s=t[i++]}else{i=t.next();if(i.done)break;s=i.value}var a=s;this.bad.push(this.prefixName(a,"min"));this.bad.push(this.prefixName(a,"max"))}}e.params=o.editList(e.params,function(e){return e.filter(function(e){return r.bad.every(function(r){return!e.includes(r)})})})};r.process=function process(e){var r=this;var t=this.parentPrefix(e);var n=t?[t]:this.prefixes;e.params=o.editList(e.params,function(e,t){for(var i=e,u=Array.isArray(i),c=0,i=u?i:i[Symbol.iterator]();;){var l;if(u){if(c>=i.length)break;l=i[c++]}else{c=i.next();if(c.done)break;l=c.value}var B=l;if(!B.includes("min-resolution")&&!B.includes("max-resolution")){t.push(B);continue}var f=function _loop(){if(d){if(h>=p.length)return"break";v=p[h++]}else{h=p.next();if(h.done)return"break";v=h.value}var e=v;var n=B.replace(s,function(t){var n=t.match(a);return r.prefixQuery(e,n[1],n[2],n[3],n[4])});t.push(n)};for(var p=n,d=Array.isArray(p),h=0,p=d?p:p[Symbol.iterator]();;){var v;var b=f();if(b==="break")break}t.push(B)}return o.uniq(t)})};return Resolution}(i);e.exports=u},4806:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}var n=t(2043),i=n.list;var o=t(7471);var s=t(8428);var a=t(2319);var u=t(772);var c=function(e){_inheritsLoose(Selector,e);function Selector(r,t,n){var i;i=e.call(this,r,t,n)||this;i.regexpCache={};return i}var r=Selector.prototype;r.check=function check(e){if(e.selector.includes(this.name)){return!!e.selector.match(this.regexp())}return false};r.prefixed=function prefixed(e){return this.name.replace(/^(\W*)/,"$1"+e)};r.regexp=function regexp(e){if(this.regexpCache[e]){return this.regexpCache[e]}var r=e?this.prefixed(e):this.name;this.regexpCache[e]=new RegExp("(^|[^:\"'=])"+u.escapeRegexp(r),"gi");return this.regexpCache[e]};r.possible=function possible(){return a.prefixes()};r.prefixeds=function prefixeds(e){var r=this;if(e._autoprefixerPrefixeds){if(e._autoprefixerPrefixeds[this.name]){return e._autoprefixerPrefixeds}}else{e._autoprefixerPrefixeds={}}var prefixeds={};if(e.selector.includes(",")){var t=i.comma(e.selector);var n=t.filter(function(e){return e.includes(r.name)});var o=function _loop(){if(a){if(u>=s.length)return"break";c=s[u++]}else{u=s.next();if(u.done)return"break";c=u.value}var e=c;prefixeds[e]=n.map(function(t){return r.replace(t,e)}).join(", ")};for(var s=this.possible(),a=Array.isArray(s),u=0,s=a?s:s[Symbol.iterator]();;){var c;var l=o();if(l==="break")break}}else{for(var B=this.possible(),f=Array.isArray(B),p=0,B=f?B:B[Symbol.iterator]();;){var d;if(f){if(p>=B.length)break;d=B[p++]}else{p=B.next();if(p.done)break;d=p.value}var h=d;prefixeds[h]=this.replace(e.selector,h)}}e._autoprefixerPrefixeds[this.name]=prefixeds;return e._autoprefixerPrefixeds};r.already=function already(e,r,t){var n=e.parent.index(e)-1;while(n>=0){var i=e.parent.nodes[n];if(i.type!=="rule"){return false}var o=false;for(var s in r[this.name]){var a=r[this.name][s];if(i.selector===a){if(t===s){return true}else{o=true;break}}}if(!o){return false}n-=1}return false};r.replace=function replace(e,r){return e.replace(this.regexp(),"$1"+this.prefixed(r))};r.add=function add(e,r){var t=this.prefixeds(e);if(this.already(e,t,r)){return}var n=this.clone(e,{selector:t[this.name][r]});e.parent.insertBefore(e,n)};r.old=function old(e){return new o(this,e)};return Selector}(s);e.exports=c},3817:(e,r,t)=>{"use strict";var n=t(2043);var i=t(4338).feature(t(6944));var o=t(2319);var s=t(6689);var a=t(1882);var u=t(772);var c=[];for(var l in i.stats){var B=i.stats[l];for(var f in B){var p=B[f];if(/y/.test(p)){c.push(l+" "+f)}}}var d=function(){function Supports(e,r){this.Prefixes=e;this.all=r}var e=Supports.prototype;e.prefixer=function prefixer(){if(this.prefixerCache){return this.prefixerCache}var e=this.all.browsers.selected.filter(function(e){return c.includes(e)});var r=new o(this.all.browsers.data,e,this.all.options);this.prefixerCache=new this.Prefixes(this.all.data,r,this.all.options);return this.prefixerCache};e.parse=function parse(e){var r=e.split(":");var t=r[0];var n=r[1];if(!n)n="";return[t.trim(),n.trim()]};e.virtual=function virtual(e){var r=this.parse(e),t=r[0],i=r[1];var o=n.parse("a{}").first;o.append({prop:t,value:i,raws:{before:""}});return o};e.prefixed=function prefixed(e){var r=this.virtual(e);if(this.disabled(r.first)){return r.nodes}var t={warn:function warn(){return null}};var n=this.prefixer().add[r.first.prop];n&&n.process&&n.process(r.first,t);for(var i=r.nodes,o=Array.isArray(i),s=0,i=o?i:i[Symbol.iterator]();;){var u;if(o){if(s>=i.length)break;u=i[s++]}else{s=i.next();if(s.done)break;u=s.value}var c=u;for(var l=this.prefixer().values("add",r.first.prop),B=Array.isArray(l),f=0,l=B?l:l[Symbol.iterator]();;){var p;if(B){if(f>=l.length)break;p=l[f++]}else{f=l.next();if(f.done)break;p=f.value}var d=p;d.process(c)}a.save(this.all,c)}return r.nodes};e.isNot=function isNot(e){return typeof e==="string"&&/not\s*/i.test(e)};e.isOr=function isOr(e){return typeof e==="string"&&/\s*or\s*/i.test(e)};e.isProp=function isProp(e){return typeof e==="object"&&e.length===1&&typeof e[0]==="string"};e.isHack=function isHack(e,r){var t=new RegExp("(\\(|\\s)"+u.escapeRegexp(r)+":");return!t.test(e)};e.toRemove=function toRemove(e,r){var t=this.parse(e),n=t[0],i=t[1];var o=this.all.unprefixed(n);var s=this.all.cleaner();if(s.remove[n]&&s.remove[n].remove&&!this.isHack(r,o)){return true}for(var a=s.values("remove",o),u=Array.isArray(a),c=0,a=u?a:a[Symbol.iterator]();;){var l;if(u){if(c>=a.length)break;l=a[c++]}else{c=a.next();if(c.done)break;l=c.value}var B=l;if(B.check(i)){return true}}return false};e.remove=function remove(e,r){var t=0;while(t<e.length){if(!this.isNot(e[t-1])&&this.isProp(e[t])&&this.isOr(e[t+1])){if(this.toRemove(e[t][0],r)){e.splice(t,2);continue}t+=2;continue}if(typeof e[t]==="object"){e[t]=this.remove(e[t],r)}t+=1}return e};e.cleanBrackets=function cleanBrackets(e){var r=this;return e.map(function(e){if(typeof e!=="object"){return e}if(e.length===1&&typeof e[0]==="object"){return r.cleanBrackets(e[0])}return r.cleanBrackets(e)})};e.convert=function convert(e){var r=[""];for(var t=e,n=Array.isArray(t),i=0,t=n?t:t[Symbol.iterator]();;){var o;if(n){if(i>=t.length)break;o=t[i++]}else{i=t.next();if(i.done)break;o=i.value}var s=o;r.push([s.prop+": "+s.value]);r.push(" or ")}r[r.length-1]="";return r};e.normalize=function normalize(e){var r=this;if(typeof e!=="object"){return e}e=e.filter(function(e){return e!==""});if(typeof e[0]==="string"&&e[0].includes(":")){return[s.stringify(e)]}return e.map(function(e){return r.normalize(e)})};e.add=function add(e,r){var t=this;return e.map(function(e){if(t.isProp(e)){var n=t.prefixed(e[0]);if(n.length>1){return t.convert(n)}return e}if(typeof e==="object"){return t.add(e,r)}return e})};e.process=function process(e){var r=s.parse(e.params);r=this.normalize(r);r=this.remove(r,e.params);r=this.add(r,e.params);r=this.cleanBrackets(r);e.params=s.stringify(r)};e.disabled=function disabled(e){if(!this.all.options.grid){if(e.prop==="display"&&e.value.includes("grid")){return true}if(e.prop.includes("grid")||e.prop==="justify-items"){return true}}if(this.all.options.flexbox===false){if(e.prop==="display"&&e.value.includes("flex")){return true}var r=["order","justify-content","align-items","align-content"];if(e.prop.includes("flex")||r.includes(e.prop)){return true}}return false};return Supports}();e.exports=d},7080:(e,r,t)=>{"use strict";function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}var n=t(7195);var i=t(2043).vendor;var o=t(2043).list;var s=t(2319);var a=function(){function Transition(e){_defineProperty(this,"props",["transition","transition-property"]);this.prefixes=e}var e=Transition.prototype;e.add=function add(e,r){var t=this;var n,i;var add=this.prefixes.add[e.prop];var o=this.ruleVendorPrefixes(e);var s=o||add&&add.prefixes||[];var a=this.parse(e.value);var u=a.map(function(e){return t.findProp(e)});var c=[];if(u.some(function(e){return e[0]==="-"})){return}for(var l=a,B=Array.isArray(l),f=0,l=B?l:l[Symbol.iterator]();;){var p;if(B){if(f>=l.length)break;p=l[f++]}else{f=l.next();if(f.done)break;p=f.value}var d=p;i=this.findProp(d);if(i[0]==="-")continue;var h=this.prefixes.add[i];if(!h||!h.prefixes)continue;for(var v=h.prefixes,b=Array.isArray(v),C=0,v=b?v:v[Symbol.iterator]();;){if(b){if(C>=v.length)break;n=v[C++]}else{C=v.next();if(C.done)break;n=C.value}if(o&&!o.some(function(e){return n.includes(e)})){continue}var g=this.prefixes.prefixed(i,n);if(g!=="-ms-transform"&&!u.includes(g)){if(!this.disabled(i,n)){c.push(this.clone(i,g,d))}}}}a=a.concat(c);var m=this.stringify(a);var y=this.stringify(this.cleanFromUnprefixed(a,"-webkit-"));if(s.includes("-webkit-")){this.cloneBefore(e,"-webkit-"+e.prop,y)}this.cloneBefore(e,e.prop,y);if(s.includes("-o-")){var w=this.stringify(this.cleanFromUnprefixed(a,"-o-"));this.cloneBefore(e,"-o-"+e.prop,w)}for(var S=s,x=Array.isArray(S),O=0,S=x?S:S[Symbol.iterator]();;){if(x){if(O>=S.length)break;n=S[O++]}else{O=S.next();if(O.done)break;n=O.value}if(n!=="-webkit-"&&n!=="-o-"){var P=this.stringify(this.cleanOtherPrefixes(a,n));this.cloneBefore(e,n+e.prop,P)}}if(m!==e.value&&!this.already(e,e.prop,m)){this.checkForWarning(r,e);e.cloneBefore();e.value=m}};e.findProp=function findProp(e){var r=e[0].value;if(/^\d/.test(r)){for(var t=e.entries(),n=Array.isArray(t),i=0,t=n?t:t[Symbol.iterator]();;){var o;if(n){if(i>=t.length)break;o=t[i++]}else{i=t.next();if(i.done)break;o=i.value}var s=o,a=s[0],u=s[1];if(a!==0&&u.type==="word"){return u.value}}}return r};e.already=function already(e,r,t){return e.parent.some(function(e){return e.prop===r&&e.value===t})};e.cloneBefore=function cloneBefore(e,r,t){if(!this.already(e,r,t)){e.cloneBefore({prop:r,value:t})}};e.checkForWarning=function checkForWarning(e,r){if(r.prop!=="transition-property"){return}r.parent.each(function(t){if(t.type!=="decl"){return undefined}if(t.prop.indexOf("transition-")!==0){return undefined}if(t.prop==="transition-property"){return undefined}if(o.comma(t.value).length>1){r.warn(e,"Replace transition-property to transition, "+"because Autoprefixer could not support "+"any cases of transition-property "+"and other transition-*")}return false})};e.remove=function remove(e){var r=this;var t=this.parse(e.value);t=t.filter(function(e){var t=r.prefixes.remove[r.findProp(e)];return!t||!t.remove});var n=this.stringify(t);if(e.value===n){return}if(t.length===0){e.remove();return}var i=e.parent.some(function(r){return r.prop===e.prop&&r.value===n});var o=e.parent.some(function(r){return r!==e&&r.prop===e.prop&&r.value.length>n.length});if(i||o){e.remove();return}e.value=n};e.parse=function parse(e){var r=n(e);var t=[];var i=[];for(var o=r.nodes,s=Array.isArray(o),a=0,o=s?o:o[Symbol.iterator]();;){var u;if(s){if(a>=o.length)break;u=o[a++]}else{a=o.next();if(a.done)break;u=a.value}var c=u;i.push(c);if(c.type==="div"&&c.value===","){t.push(i);i=[]}}t.push(i);return t.filter(function(e){return e.length>0})};e.stringify=function stringify(e){if(e.length===0){return""}var r=[];for(var t=e,i=Array.isArray(t),o=0,t=i?t:t[Symbol.iterator]();;){var s;if(i){if(o>=t.length)break;s=t[o++]}else{o=t.next();if(o.done)break;s=o.value}var a=s;if(a[a.length-1].type!=="div"){a.push(this.div(e))}r=r.concat(a)}if(r[0].type==="div"){r=r.slice(1)}if(r[r.length-1].type==="div"){r=r.slice(0,+-2+1||0)}return n.stringify({nodes:r})};e.clone=function clone(e,r,t){var n=[];var i=false;for(var o=t,s=Array.isArray(o),a=0,o=s?o:o[Symbol.iterator]();;){var u;if(s){if(a>=o.length)break;u=o[a++]}else{a=o.next();if(a.done)break;u=a.value}var c=u;if(!i&&c.type==="word"&&c.value===e){n.push({type:"word",value:r});i=true}else{n.push(c)}}return n};e.div=function div(e){for(var r=e,t=Array.isArray(r),n=0,r=t?r:r[Symbol.iterator]();;){var i;if(t){if(n>=r.length)break;i=r[n++]}else{n=r.next();if(n.done)break;i=n.value}var o=i;for(var s=o,a=Array.isArray(s),u=0,s=a?s:s[Symbol.iterator]();;){var c;if(a){if(u>=s.length)break;c=s[u++]}else{u=s.next();if(u.done)break;c=u.value}var l=c;if(l.type==="div"&&l.value===","){return l}}}return{type:"div",value:",",after:" "}};e.cleanOtherPrefixes=function cleanOtherPrefixes(e,r){var t=this;return e.filter(function(e){var n=i.prefix(t.findProp(e));return n===""||n===r})};e.cleanFromUnprefixed=function cleanFromUnprefixed(e,r){var t=this;var n=e.map(function(e){return t.findProp(e)}).filter(function(e){return e.slice(0,r.length)===r}).map(function(e){return t.prefixes.unprefixed(e)});var o=[];for(var s=e,a=Array.isArray(s),u=0,s=a?s:s[Symbol.iterator]();;){var c;if(a){if(u>=s.length)break;c=s[u++]}else{u=s.next();if(u.done)break;c=u.value}var l=c;var B=this.findProp(l);var f=i.prefix(B);if(!n.includes(B)&&(f===r||f==="")){o.push(l)}}return o};e.disabled=function disabled(e,r){var t=["order","justify-content","align-self","align-content"];if(e.includes("flex")||t.includes(e)){if(this.prefixes.options.flexbox===false){return true}if(this.prefixes.options.flexbox==="no-2009"){return r.includes("2009")}}return undefined};e.ruleVendorPrefixes=function ruleVendorPrefixes(e){var r=e.parent;if(r.type!=="rule"){return false}else if(!r.selector.includes(":-")){return false}var t=s.prefixes().filter(function(e){return r.selector.includes(":"+e)});return t.length>0?t:false};return Transition}();e.exports=a},772:(e,r,t)=>{"use strict";var n=t(2043).list;e.exports={error:function error(e){var r=new Error(e);r.autoprefixer=true;throw r},uniq:function uniq(e){var r=[];for(var t=e,n=Array.isArray(t),i=0,t=n?t:t[Symbol.iterator]();;){var o;if(n){if(i>=t.length)break;o=t[i++]}else{i=t.next();if(i.done)break;o=i.value}var s=o;if(!r.includes(s)){r.push(s)}}return r},removeNote:function removeNote(e){if(!e.includes(" ")){return e}return e.split(" ")[0]},escapeRegexp:function escapeRegexp(e){return e.replace(/[$()*+-.?[\\\]^{|}]/g,"\\$&")},regexp:function regexp(e,r){if(r===void 0){r=true}if(r){e=this.escapeRegexp(e)}return new RegExp("(^|[\\s,(])("+e+"($|[\\s(,]))","gi")},editList:function editList(e,r){var t=n.comma(e);var i=r(t,[]);if(t===i){return e}var o=e.match(/,\s*/);o=o?o[0]:", ";return i.join(o)},splitSelector:function splitSelector(e){return n.comma(e).map(function(e){return n.space(e).map(function(e){return e.split(/(?=\.|#)/g)})})}}},1882:(e,r,t)=>{"use strict";function _defaults(e,r){var t=Object.getOwnPropertyNames(r);for(var n=0;n<t.length;n++){var i=t[n];var o=Object.getOwnPropertyDescriptor(r,i);if(o&&o.configurable&&e[i]===undefined){Object.defineProperty(e,i,o)}}return e}function _inheritsLoose(e,r){e.prototype=Object.create(r.prototype);e.prototype.constructor=e;_defaults(e,r)}var n=t(2043).vendor;var i=t(8428);var o=t(6661);var s=t(772);var a=function(e){_inheritsLoose(Value,e);function Value(){return e.apply(this,arguments)||this}Value.save=function save(e,r){var t=this;var i=r.prop;var o=[];var s=function _loop(s){var a=r._autoprefixerValues[s];if(a===r.value){return"continue"}var u=void 0;var c=n.prefix(i);if(c==="-pie-"){return"continue"}if(c===s){u=r.value=a;o.push(u);return"continue"}var l=e.prefixed(i,s);var B=r.parent;if(!B.every(function(e){return e.prop!==l})){o.push(u);return"continue"}var f=a.replace(/\s+/," ");var p=B.some(function(e){return e.prop===r.prop&&e.value.replace(/\s+/," ")===f});if(p){o.push(u);return"continue"}var d=t.clone(r,{value:a});u=r.parent.insertBefore(r,d);o.push(u)};for(var a in r._autoprefixerValues){var u=s(a);if(u==="continue")continue}return o};var r=Value.prototype;r.check=function check(e){var r=e.value;if(!r.includes(this.name)){return false}return!!r.match(this.regexp())};r.regexp=function regexp(){return this.regexpCache||(this.regexpCache=s.regexp(this.name))};r.replace=function replace(e,r){return e.replace(this.regexp(),"$1"+r+"$2")};r.value=function value(e){if(e.raws.value&&e.raws.value.value===e.value){return e.raws.value.raw}else{return e.value}};r.add=function add(e,r){if(!e._autoprefixerValues){e._autoprefixerValues={}}var t=e._autoprefixerValues[r]||this.value(e);var n;do{n=t;t=this.replace(t,r);if(t===false)return}while(t!==n);e._autoprefixerValues[r]=t};r.old=function old(e){return new o(this.name,e+this.name)};return Value}(i);e.exports=a},587:e=>{"use strict";e.exports=balanced;function balanced(e,r,t){if(e instanceof RegExp)e=maybeMatch(e,t);if(r instanceof RegExp)r=maybeMatch(r,t);var n=range(e,r,t);return n&&{start:n[0],end:n[1],pre:t.slice(0,n[0]),body:t.slice(n[0]+e.length,n[1]),post:t.slice(n[1]+r.length)}}function maybeMatch(e,r){var t=r.match(e);return t?t[0]:null}balanced.range=range;function range(e,r,t){var n,i,o,s,a;var u=t.indexOf(e);var c=t.indexOf(r,u+1);var l=u;if(u>=0&&c>0){n=[];o=t.length;while(l>=0&&!a){if(l==u){n.push(l);u=t.indexOf(e,l+1)}else if(n.length==1){a=[n.pop(),c]}else{i=n.pop();if(i<o){o=i;s=c}c=t.indexOf(r,l+1)}l=u<c&&u>=0?u:c}if(n.length){a=[o,s]}}return a}},1302:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"D M N O",33:"C K L P Q T U V W X Y Z a b c R d H e"},C:{1:"AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z nB oB"},D:{33:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{16:"sB gB",33:"I f J E F G A B C K L D tB uB vB wB hB bB cB xB yB zB"},F:{2:"G B C 0B 1B 2B 3B bB iB 4B cB",33:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{16:"gB 5B jB 6B",33:"F D 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{16:"dB PC QC RC",33:"I H SC jB TC UC"},J:{33:"E A"},K:{16:"A B C bB iB cB",33:"S"},L:{33:"H"},M:{1:"R"},N:{2:"A B"},O:{33:"VC"},P:{33:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{33:"gC"},R:{33:"hC"},S:{1:"iC"}},B:7,C:"Background-clip: text"}},2259:e=>{e.exports={A:{A:{1:"G A B",2:"J E F kB"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB nB",36:"oB"},D:{1:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",516:"I f J E F G A B C K L"},E:{1:"E F G A B C K L D vB wB hB bB cB xB yB zB",772:"I f J sB gB tB uB"},F:{1:"0 1 2 3 4 5 6 7 8 9 B C D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q 2B 3B bB iB 4B cB",2:"G 0B",36:"1B"},G:{1:"F D 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC",4:"gB 5B jB 7B",516:"6B"},H:{132:"OC"},I:{1:"H TC UC",36:"PC",516:"dB I SC jB",548:"QC RC"},J:{1:"E A"},K:{1:"A B C S bB iB cB"},L:{1:"H"},M:{1:"R"},N:{1:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"CSS3 Background-image options"}},9847:e=>{e.exports={A:{A:{1:"B",2:"J E F G A kB"},B:{1:"L D M N O P Q T U V W X Y Z a b c R d H e",129:"C K"},C:{1:"BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB",260:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB",804:"I f J E F G A B C K L nB oB"},D:{1:"HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",260:"CB DB EB FB GB",388:"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB",1412:"D M N O g h i j k l m n o p q",1956:"I f J E F G A B C K L"},E:{129:"A B C K L D wB hB bB cB xB yB zB",1412:"J E F G uB vB",1956:"I f sB gB tB"},F:{1:"4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G 0B 1B",260:"0 1 2 3 z",388:"D M N O g h i j k l m n o p q r s t u v w x y",1796:"2B 3B",1828:"B C bB iB 4B cB"},G:{129:"D BC CC DC EC FC GC HC IC JC KC LC MC NC",1412:"F 7B 8B 9B AC",1956:"gB 5B jB 6B"},H:{1828:"OC"},I:{1:"H",388:"TC UC",1956:"dB I PC QC RC SC jB"},J:{1412:"A",1924:"E"},K:{1:"S",2:"A",1828:"B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{1:"B",2:"A"},O:{388:"VC"},P:{1:"YC ZC aC hB bC cC dC eC fC",260:"WC XC",388:"I"},Q:{260:"gC"},R:{260:"hC"},S:{260:"iC"}},B:4,C:"CSS3 Border images"}},3807:e=>{e.exports={A:{A:{2:"J E F kB",260:"G",516:"A B"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB nB oB",33:"I f J E F G A B C K L D"},D:{1:"0 1 2 3 4 5 6 7 8 9 n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B C K L D M N O",33:"g h i j k l m"},E:{1:"E F G A B C K L D uB vB wB hB bB cB xB yB zB",2:"I f sB gB tB",33:"J"},F:{1:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C 0B 1B 2B 3B bB iB 4B cB"},G:{1:"F D 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC",2:"gB 5B jB 6B",33:"7B"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB",132:"TC UC"},J:{1:"A",2:"E"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{1:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"calc() as CSS unit value"}},8252:e=>{e.exports={A:{A:{1:"A B",2:"J E F G kB"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I nB oB",33:"f J E F G A B C K L D"},D:{1:"4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",33:"0 1 2 3 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z"},E:{1:"G A B C K L D wB hB bB cB xB yB zB",2:"sB gB",33:"J E F tB uB vB",292:"I f"},F:{1:"0 1 2 3 4 5 6 7 8 9 r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q cB",2:"G B 0B 1B 2B 3B bB iB 4B",33:"C D M N O g h i j k l m n o p q"},G:{1:"D AC BC CC DC EC FC GC HC IC JC KC LC MC NC",33:"F 7B 8B 9B",164:"gB 5B jB 6B"},H:{2:"OC"},I:{1:"H",33:"I SC jB TC UC",164:"dB PC QC RC"},J:{33:"E A"},K:{1:"S cB",2:"A B C bB iB"},L:{1:"H"},M:{1:"R"},N:{1:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{33:"gC"},R:{1:"hC"},S:{1:"iC"}},B:5,C:"CSS Animation"}},1977:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",2:"C K L D M N O"},C:{1:"BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",16:"lB",33:"0 1 2 3 4 5 6 7 8 9 dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB nB oB"},D:{1:"NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",16:"I f J E F G A B C K L",33:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S"},E:{1:"G A B C K L D wB hB bB cB xB yB zB",16:"I f J sB gB tB",33:"E F uB vB"},F:{1:"DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C 0B 1B 2B 3B bB iB 4B cB",33:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB"},G:{1:"D AC BC CC DC EC FC GC HC IC JC KC LC MC NC",16:"gB 5B jB 6B",33:"F 7B 8B 9B"},H:{2:"OC"},I:{1:"H",16:"dB I PC QC RC SC jB",33:"TC UC"},J:{16:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{33:"VC"},P:{1:"aC hB bC cC dC eC fC",16:"I",33:"WC XC YC ZC"},Q:{1:"gC"},R:{1:"hC"},S:{33:"iC"}},B:5,C:"CSS :any-link selector"}},8672:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"V W X Y Z a b c R d H e",33:"U",164:"P Q T",388:"C K L D M N O"},C:{1:"Q T mB U V W X Y Z a b c R d H e",164:"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P",676:"lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v nB oB"},D:{1:"V W X Y Z a b c R d H e pB qB rB",33:"U",164:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T"},E:{164:"I f J E F G A B C K L D sB gB tB uB vB wB hB bB cB xB yB zB"},F:{1:"VB WB XB YB ZB aB P Q",2:"G B C 0B 1B 2B 3B bB iB 4B cB",33:"SB TB UB",164:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB"},G:{164:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H",164:"dB I PC QC RC SC jB TC UC"},J:{164:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A",388:"B"},O:{164:"VC"},P:{164:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{164:"gC"},R:{164:"hC"},S:{164:"iC"}},B:5,C:"CSS Appearance"}},3613:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",2:"C K L D M",257:"N O"},C:{2:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB nB oB",578:"SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e"},D:{1:"YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"0 1 2 3 4 5 6 7 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z",194:"8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB"},E:{2:"I f J E F sB gB tB uB vB",33:"G A B C K L D wB hB bB cB xB yB zB"},F:{1:"S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C D M N O g h i j k l m n o p q r s t u 0B 1B 2B 3B bB iB 4B cB",194:"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB"},G:{2:"F gB 5B jB 6B 7B 8B 9B",33:"D AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{2:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{578:"R"},N:{2:"A B"},O:{2:"VC"},P:{1:"cC dC eC fC",2:"I",194:"WC XC YC ZC aC hB bC"},Q:{194:"gC"},R:{194:"hC"},S:{2:"iC"}},B:7,C:"CSS Backdrop Filter"}},4016:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{2:"C K L D M N O",164:"P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s nB oB"},D:{2:"I f J E F G A B C K L D M N O g h i",164:"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{2:"I f J sB gB tB",164:"E F G A B C K L D uB vB wB hB bB cB xB yB zB"},F:{2:"G 0B 1B 2B 3B",129:"B C bB iB 4B cB",164:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{2:"gB 5B jB 6B 7B",164:"F D 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{132:"OC"},I:{2:"dB I PC QC RC SC jB",164:"H TC UC"},J:{2:"E",164:"A"},K:{2:"A",129:"B C bB iB cB",164:"S"},L:{164:"H"},M:{1:"R"},N:{2:"A B"},O:{1:"VC"},P:{164:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{164:"gC"},R:{164:"hC"},S:{1:"iC"}},B:5,C:"CSS box-decoration-break"}},5861:e=>{e.exports={A:{A:{1:"G A B",2:"J E F kB"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB",33:"nB oB"},D:{1:"0 1 2 3 4 5 6 7 8 9 A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",33:"I f J E F G"},E:{1:"J E F G A B C K L D tB uB vB wB hB bB cB xB yB zB",33:"f",164:"I sB gB"},F:{1:"0 1 2 3 4 5 6 7 8 9 B C D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q 2B 3B bB iB 4B cB",2:"G 0B 1B"},G:{1:"F D 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC",33:"5B jB",164:"gB"},H:{2:"OC"},I:{1:"I H SC jB TC UC",164:"dB PC QC RC"},J:{1:"A",33:"E"},K:{1:"B C S bB iB cB",2:"A"},L:{1:"H"},M:{1:"R"},N:{1:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"CSS3 Box-shadow"}},147:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{2:"C K L D M N",260:"P Q T U V W X Y Z a b c R d H e",3138:"O"},C:{1:"FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB",132:"0 1 2 3 4 5 6 7 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z nB oB",644:"8 9 AB BB CB DB EB"},D:{2:"I f J E F G A B C K L D M N O g h i j k",260:"GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",292:"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB FB"},E:{2:"I f J sB gB tB uB",292:"E F G A B C K L D vB wB hB bB cB xB yB zB"},F:{2:"G B C 0B 1B 2B 3B bB iB 4B cB",260:"3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",292:"0 1 2 D M N O g h i j k l m n o p q r s t u v w x y z"},G:{2:"gB 5B jB 6B 7B",292:"F D 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{2:"dB I PC QC RC SC jB",260:"H",292:"TC UC"},J:{2:"E A"},K:{2:"A B C bB iB cB",260:"S"},L:{260:"H"},M:{1:"R"},N:{2:"A B"},O:{292:"VC"},P:{292:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{292:"gC"},R:{260:"hC"},S:{644:"iC"}},B:4,C:"CSS clip-path property (for HTML)"}},664:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{2:"C K L D M N O",33:"P Q T U V W X Y Z a b c R d H e"},C:{1:"9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"0 1 2 3 4 5 6 7 8 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z nB oB"},D:{16:"I f J E F G A B C K L D M N O",33:"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{2:"I f sB gB tB",33:"J E F G A B C K L D uB vB wB hB bB cB xB yB zB"},F:{2:"G B C 0B 1B 2B 3B bB iB 4B cB",33:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{16:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{16:"dB I PC QC RC SC jB TC UC",33:"H"},J:{16:"E A"},K:{2:"A B C bB iB cB",33:"S"},L:{16:"H"},M:{1:"R"},N:{16:"A B"},O:{16:"VC"},P:{16:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{33:"gC"},R:{16:"hC"},S:{1:"iC"}},B:5,C:"CSS color-adjust"}},7794:e=>{e.exports={A:{A:{2:"J kB",2340:"E F G A B"},B:{2:"C K L D M N O",1025:"P Q T U V W X Y Z a b c R d H e"},C:{1:"d H e",2:"lB dB nB",513:"NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R",545:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S oB"},D:{2:"0 1 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z",1025:"2 3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{1:"A B C K L D hB bB cB xB yB zB",2:"I f sB gB tB",164:"J",4644:"E F G uB vB wB"},F:{2:"G B D M N O g h i j k l m n o 0B 1B 2B 3B bB iB",545:"C 4B cB",1025:"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{1:"D CC DC EC FC GC HC IC JC KC LC MC NC",2:"gB 5B jB",4260:"6B 7B",4644:"F 8B 9B AC BC"},H:{2:"OC"},I:{2:"dB I PC QC RC SC jB TC UC",1025:"H"},J:{2:"E",4260:"A"},K:{2:"A B bB iB",545:"C cB",1025:"S"},L:{1025:"H"},M:{545:"R"},N:{2340:"A B"},O:{1:"VC"},P:{1025:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1025:"gC"},R:{1025:"hC"},S:{4097:"iC"}},B:7,C:"Crisp edges/pixelated images"}},3323:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{2:"C K L D M N O",33:"P Q T U V W X Y Z a b c R d H e"},C:{2:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e nB oB"},D:{2:"I f J E F G A B C K L D M",33:"0 1 2 3 4 5 6 7 8 9 N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{1:"A B C K L D hB bB cB xB yB zB",2:"I f sB gB",33:"J E F G tB uB vB wB"},F:{2:"G B C 0B 1B 2B 3B bB iB 4B cB",33:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{1:"D CC DC EC FC GC HC IC JC KC LC MC NC",2:"gB 5B jB",33:"F 6B 7B 8B 9B AC BC"},H:{2:"OC"},I:{2:"dB I PC QC RC SC jB",33:"H TC UC"},J:{2:"E A"},K:{2:"A B C bB iB cB",33:"S"},L:{33:"H"},M:{2:"R"},N:{2:"A B"},O:{33:"VC"},P:{33:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{33:"gC"},R:{33:"hC"},S:{2:"iC"}},B:4,C:"CSS Cross-Fade Function"}},1779:e=>{e.exports={A:{A:{2:"J E F G kB",164:"A B"},B:{66:"P Q T U V W X Y Z a b c R d H e",164:"C K L D M N O"},C:{2:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e nB oB"},D:{2:"I f J E F G A B C K L D M N O g h i j k l m n o p",66:"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{2:"I f J E F G A B C K L D sB gB tB uB vB wB hB bB cB xB yB zB"},F:{2:"0 G B C D M N O g h i j k l m n o p q r s t u v w x y z 0B 1B 2B 3B bB iB 4B cB",66:"1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{2:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{292:"OC"},I:{2:"dB I H PC QC RC SC jB TC UC"},J:{2:"E A"},K:{2:"A S",292:"B C bB iB cB"},L:{2:"H"},M:{2:"R"},N:{164:"A B"},O:{2:"VC"},P:{2:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{66:"gC"},R:{2:"hC"},S:{2:"iC"}},B:5,C:"CSS Device Adaptation"}},9666:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{2:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{33:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",164:"lB dB nB oB"},D:{2:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{2:"I f J E F G A B C K L D sB gB tB uB vB wB hB bB cB xB yB zB"},F:{2:"0 1 2 3 4 5 6 7 8 9 G B C D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q 0B 1B 2B 3B bB iB 4B cB"},G:{2:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{2:"dB I H PC QC RC SC jB TC UC"},J:{2:"E A"},K:{2:"A B C S bB iB cB"},L:{2:"H"},M:{33:"R"},N:{2:"A B"},O:{2:"VC"},P:{2:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{2:"gC"},R:{2:"hC"},S:{33:"iC"}},B:5,C:"CSS element() function"}},6192:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{2:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{2:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e nB oB"},D:{2:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{1:"A B C K L D wB hB bB cB xB yB zB",2:"I f J E F sB gB tB uB vB",33:"G"},F:{2:"0 1 2 3 4 5 6 7 8 9 G B C D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q 0B 1B 2B 3B bB iB 4B cB"},G:{1:"D CC DC EC FC GC HC IC JC KC LC MC NC",2:"F gB 5B jB 6B 7B 8B 9B",33:"AC BC"},H:{2:"OC"},I:{2:"dB I H PC QC RC SC jB TC UC"},J:{2:"E A"},K:{2:"A B C S bB iB cB"},L:{2:"H"},M:{2:"R"},N:{2:"A B"},O:{2:"VC"},P:{2:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{2:"gC"},R:{2:"hC"},S:{2:"iC"}},B:5,C:"CSS filter() function"}},9237:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",1028:"K L D M N O",1346:"C"},C:{1:"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB nB",196:"v",516:"I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u oB"},D:{1:"EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B C K L D M N",33:"0 1 2 3 4 5 6 7 8 9 O g h i j k l m n o p q r s t u v w x y z AB BB CB DB"},E:{1:"A B C K L D wB hB bB cB xB yB zB",2:"I f sB gB tB",33:"J E F G uB vB"},F:{1:"1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C 0B 1B 2B 3B bB iB 4B cB",33:"0 D M N O g h i j k l m n o p q r s t u v w x y z"},G:{1:"D BC CC DC EC FC GC HC IC JC KC LC MC NC",2:"gB 5B jB 6B",33:"F 7B 8B 9B AC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB",33:"TC UC"},J:{2:"E",33:"A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{1:"VC"},P:{1:"YC ZC aC hB bC cC dC eC fC",33:"I WC XC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:5,C:"CSS Filter Effects"}},1407:e=>{e.exports={A:{A:{1:"A B",2:"J E F G kB"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB nB",260:"M N O g h i j k l m n o p q r s t u v w",292:"I f J E F G A B C K L D oB"},D:{1:"0 1 2 3 4 5 6 7 8 9 n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",33:"A B C K L D M N O g h i j k l m",548:"I f J E F G"},E:{2:"sB gB",260:"E F G A B C K L D uB vB wB hB bB cB xB yB zB",292:"J tB",804:"I f"},F:{1:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q cB",2:"G B 0B 1B 2B 3B",33:"C 4B",164:"bB iB"},G:{260:"F D 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC",292:"6B 7B",804:"gB 5B jB"},H:{2:"OC"},I:{1:"H TC UC",33:"I SC jB",548:"dB PC QC RC"},J:{1:"A",548:"E"},K:{1:"S cB",2:"A B",33:"C",164:"bB iB"},L:{1:"H"},M:{1:"R"},N:{1:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"CSS Gradients"}},7776:e=>{e.exports={A:{A:{2:"J E F kB",8:"G",292:"A B"},B:{1:"M N O P Q T U V W X Y Z a b c R d H e",292:"C K L D"},C:{1:"FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G A B C K L D M N O nB oB",8:"0 g h i j k l m n o p q r s t u v w x y z",584:"1 2 3 4 5 6 7 8 9 AB BB CB",1025:"DB EB"},D:{1:"JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B C K L D M N O g h i j k l",8:"m n o p",200:"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB GB HB",1025:"IB"},E:{1:"B C K L D hB bB cB xB yB zB",2:"I f sB gB tB",8:"J E F G A uB vB wB"},F:{1:"5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C D M N O g h i j k l m n o 0B 1B 2B 3B bB iB 4B cB",200:"0 1 2 3 4 p q r s t u v w x y z"},G:{1:"D DC EC FC GC HC IC JC KC LC MC NC",2:"gB 5B jB 6B",8:"F 7B 8B 9B AC BC CC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC",8:"jB TC UC"},J:{2:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{292:"A B"},O:{1:"VC"},P:{1:"XC YC ZC aC hB bC cC dC eC fC",2:"WC",8:"I"},Q:{1:"gC"},R:{2:"hC"},S:{1:"iC"}},B:4,C:"CSS Grid Layout (level 1)"}},9747:e=>{e.exports={A:{A:{2:"J E F G kB",33:"A B"},B:{33:"C K L D M N O",132:"P Q T U V W X Y",260:"Z a b c R d H e"},C:{1:"4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f nB oB",33:"0 1 2 3 J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z"},D:{1:"Z a b c R d H e pB qB rB",2:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB",132:"GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y"},E:{2:"I f sB gB",33:"J E F G A B C K L D tB uB vB wB hB bB cB xB yB zB"},F:{2:"0 1 2 G B C D M N O g h i j k l m n o p q r s t u v w x y z 0B 1B 2B 3B bB iB 4B cB",132:"3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{2:"gB 5B",33:"F D jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{2:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{4:"VC"},P:{1:"XC YC ZC aC hB bC cC dC eC fC",2:"I",132:"WC"},Q:{2:"gC"},R:{132:"hC"},S:{1:"iC"}},B:5,C:"CSS Hyphenation"}},4197:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{2:"C K L D M N O",164:"P Q T U V W X Y Z a b c R d H e"},C:{2:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W nB oB",66:"X Y",257:"a b c R d H e",772:"Z"},D:{2:"I f J E F G A B C K L D M N O g h",164:"0 1 2 3 4 5 6 7 8 9 i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{2:"I f sB gB tB",132:"A B C K hB bB cB xB",164:"J E F G uB vB wB",516:"L D yB zB"},F:{2:"G B C 0B 1B 2B 3B bB iB 4B cB",164:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{2:"gB 5B jB 6B",132:"CC DC EC FC GC HC IC JC KC LC",164:"F 7B 8B 9B AC BC",516:"D MC NC"},H:{2:"OC"},I:{2:"dB I PC QC RC SC jB",164:"H TC UC"},J:{2:"E",164:"A"},K:{2:"A B C bB iB cB",164:"S"},L:{164:"H"},M:{257:"R"},N:{2:"A B"},O:{164:"VC"},P:{164:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{164:"gC"},R:{164:"hC"},S:{2:"iC"}},B:5,C:"CSS image-set"}},471:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"a b c R d H e",2:"C K L D M N O",2052:"Y Z",3588:"P Q T U V W X"},C:{1:"2 3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB",164:"0 1 dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z nB oB"},D:{1:"a b c R d H e pB qB rB",292:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB",2052:"Y Z",3588:"RB SB TB UB VB WB XB YB ZB aB P Q T U V W X"},E:{1:"D zB",292:"I f J E F G A B C sB gB tB uB vB wB hB bB",2052:"yB",3588:"K L cB xB"},F:{1:"YB ZB aB P Q",2:"G B C 0B 1B 2B 3B bB iB 4B cB",292:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB",2052:"WB XB",3588:"HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB"},G:{1:"D",292:"F gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC",2052:"NC",3588:"HC IC JC KC LC MC"},H:{2:"OC"},I:{1:"H",292:"dB I PC QC RC SC jB TC UC"},J:{292:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{292:"VC"},P:{1:"fC",292:"I WC XC YC ZC aC",3588:"hB bC cC dC eC"},Q:{3588:"gC"},R:{3588:"hC"},S:{3588:"iC"}},B:5,C:"CSS Logical Properties"}},4613:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{2:"C K L D M",164:"P Q T U V W X Y Z a b c R d H e",3138:"N",12292:"O"},C:{1:"EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB",260:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB nB oB"},D:{164:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{2:"sB gB",164:"I f J E F G A B C K L D tB uB vB wB hB bB cB xB yB zB"},F:{2:"G B C 0B 1B 2B 3B bB iB 4B cB",164:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{164:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{164:"H TC UC",676:"dB I PC QC RC SC jB"},J:{164:"E A"},K:{2:"A B C bB iB cB",164:"S"},L:{164:"H"},M:{1:"R"},N:{2:"A B"},O:{164:"VC"},P:{164:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{164:"gC"},R:{164:"hC"},S:{260:"iC"}},B:4,C:"CSS Masks"}},3588:e=>{e.exports={A:{A:{2:"J E F kB",132:"G A B"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB",260:"I f J E F G A B C K L D nB oB"},D:{1:"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",548:"I f J E F G A B C K L D M N O g h i j k l m n o p"},E:{2:"sB gB",548:"I f J E F G A B C K L D tB uB vB wB hB bB cB xB yB zB"},F:{1:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q cB",2:"G",548:"B C 0B 1B 2B 3B bB iB 4B"},G:{16:"gB",548:"F D 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{132:"OC"},I:{1:"H TC UC",16:"PC QC",548:"dB I RC SC jB"},J:{548:"E A"},K:{1:"S cB",548:"A B C bB iB"},L:{1:"H"},M:{1:"R"},N:{132:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:2,C:"Media Queries: resolution feature"}},3043:e=>{e.exports={A:{A:{2:"J E F G kB",132:"A B"},B:{1:"P Q T U V W X Y Z a b c R d H e",132:"C K L D M N",516:"O"},C:{1:"eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB nB oB"},D:{1:"NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB",260:"MB S"},E:{2:"I f J E F G A B C K L D sB gB tB uB vB wB hB bB cB xB zB",1090:"yB"},F:{1:"DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"0 1 2 3 4 5 6 7 8 9 G B C D M N O g h i j k l m n o p q r s t u v w x y z AB 0B 1B 2B 3B bB iB 4B cB",260:"BB CB"},G:{2:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{2:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{132:"A B"},O:{2:"VC"},P:{1:"ZC aC hB bC cC dC eC fC",2:"I WC XC YC"},Q:{1:"gC"},R:{2:"hC"},S:{2:"iC"}},B:7,C:"CSS overscroll-behavior"}},5117:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",36:"C K L D M N O"},C:{1:"CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G A B C K L D M N O nB oB",33:"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB"},D:{1:"IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",36:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB"},E:{1:"B C K L D hB bB cB xB yB zB",2:"I sB gB",36:"f J E F G A tB uB vB wB"},F:{1:"5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C 0B 1B 2B 3B bB iB 4B cB",36:"0 1 2 3 4 D M N O g h i j k l m n o p q r s t u v w x y z"},G:{1:"D DC EC FC GC HC IC JC KC LC MC NC",2:"gB 5B",36:"F jB 6B 7B 8B 9B AC BC CC"},H:{2:"OC"},I:{1:"H",36:"dB I PC QC RC SC jB TC UC"},J:{36:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{36:"A B"},O:{1:"VC"},P:{1:"YC ZC aC hB bC cC dC eC fC",36:"I WC XC"},Q:{1:"gC"},R:{1:"hC"},S:{33:"iC"}},B:5,C:"::placeholder CSS pseudo-element"}},3502:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"K L D M N O P Q T U V W X Y Z a b c R d H e",2:"C"},C:{1:"aB P Q T mB U V W X Y Z a b c R d H e",16:"lB",33:"0 1 2 3 4 5 6 7 8 9 dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB nB oB"},D:{1:"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",16:"I f J E F G A B C K L",132:"D M N O g h i j k l m n o p q r s t u v w"},E:{1:"G A B C K L D wB hB bB cB xB yB zB",16:"sB gB",132:"I f J E F tB uB vB"},F:{1:"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",16:"G B 0B 1B 2B 3B bB",132:"C D M N O g h i j iB 4B cB"},G:{1:"D AC BC CC DC EC FC GC HC IC JC KC LC MC NC",16:"gB 5B",132:"F jB 6B 7B 8B 9B"},H:{2:"OC"},I:{1:"H",16:"PC QC",132:"dB I RC SC jB TC UC"},J:{1:"A",132:"E"},K:{1:"S",2:"A B bB",132:"C iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{33:"iC"}},B:1,C:"CSS :read-only and :read-write selectors"}},5969:e=>{e.exports={A:{A:{2:"J E F G kB",420:"A B"},B:{2:"P Q T U V W X Y Z a b c R d H e",420:"C K L D M N O"},C:{2:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e nB oB"},D:{2:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",36:"D M N O",66:"g h i j k l m n o p q r s t u v"},E:{2:"I f J C K L D sB gB tB bB cB xB yB zB",33:"E F G A B uB vB wB hB"},F:{2:"0 1 2 3 4 5 6 7 8 9 G B C D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q 0B 1B 2B 3B bB iB 4B cB"},G:{2:"D gB 5B jB 6B 7B FC GC HC IC JC KC LC MC NC",33:"F 8B 9B AC BC CC DC EC"},H:{2:"OC"},I:{2:"dB I H PC QC RC SC jB TC UC"},J:{2:"E A"},K:{2:"A B C S bB iB cB"},L:{2:"H"},M:{2:"R"},N:{420:"A B"},O:{2:"VC"},P:{2:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{2:"gC"},R:{2:"hC"},S:{2:"iC"}},B:5,C:"CSS Regions"}},3347:e=>{e.exports={A:{A:{1:"G A B",2:"J E F kB"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",33:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB nB oB"},D:{1:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{1:"I f J E F G A B C K L D sB gB tB uB vB wB hB bB cB xB yB zB"},F:{1:"0 1 2 3 4 5 6 7 8 9 B C D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q 0B 1B 2B 3B bB iB 4B cB",2:"G"},G:{2:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H TC UC",2:"dB I PC QC RC SC jB"},J:{1:"A",2:"E"},K:{1:"C S iB cB",16:"A B bB"},L:{1:"H"},M:{1:"R"},N:{1:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{33:"iC"}},B:5,C:"::selection CSS pseudo-element"}},4298:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",2:"C K L D M N O"},C:{1:"LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB nB oB",322:"CB DB EB FB GB HB IB JB eB KB fB"},D:{1:"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u",194:"v w x"},E:{1:"B C K L D hB bB cB xB yB zB",2:"I f J E sB gB tB uB",33:"F G A vB wB"},F:{1:"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C D M N O g h i j k 0B 1B 2B 3B bB iB 4B cB"},G:{1:"D DC EC FC GC HC IC JC KC LC MC NC",2:"gB 5B jB 6B 7B 8B",33:"F 9B AC BC CC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{2:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{2:"iC"}},B:4,C:"CSS Shapes Level 1"}},87:e=>{e.exports={A:{A:{2:"J E F G kB",6308:"A",6436:"B"},B:{1:"P Q T U V W X Y Z a b c R d H e",6436:"C K L D M N O"},C:{1:"QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z nB oB",2052:"0 1 2 3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB"},D:{1:"RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB",8258:"OB PB QB"},E:{1:"B C K L D bB cB xB yB zB",2:"I f J E F sB gB tB uB vB",3108:"G A wB hB"},F:{1:"S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"0 1 2 3 4 5 6 7 8 9 G B C D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB 0B 1B 2B 3B bB iB 4B cB",8258:"FB GB HB IB JB KB LB MB"},G:{1:"D EC FC GC HC IC JC KC LC MC NC",2:"F gB 5B jB 6B 7B 8B 9B",3108:"AC BC CC DC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{2:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{2:"VC"},P:{1:"hB bC cC dC eC fC",2:"I WC XC YC ZC aC"},Q:{2:"gC"},R:{2:"hC"},S:{2052:"iC"}},B:4,C:"CSS Scroll Snap"}},3727:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"c R d H e",2:"C K L D",1028:"P Q T U V W X Y Z a b",4100:"M N O"},C:{1:"eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G A B C K L D M N O g h i j k l m nB oB",194:"n o p q r s",516:"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB FB GB HB IB JB"},D:{1:"c R d H e pB qB rB",2:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j y z AB BB CB",322:"k l m n o p q r s t u v w x DB EB FB GB",1028:"HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b"},E:{1:"K L D xB yB zB",2:"I f J sB gB tB",33:"F G A B C vB wB hB bB cB",2084:"E uB"},F:{2:"G B C D M N O g h i j k l m n o p q r s t u v w x y z 0B 1B 2B 3B bB iB 4B cB",322:"0 1 2",1028:"3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{1:"D IC JC KC LC MC NC",2:"gB 5B jB 6B",33:"F 9B AC BC CC DC EC FC GC HC",2084:"7B 8B"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{2:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{1028:"VC"},P:{1:"XC YC ZC aC hB bC cC dC eC fC",2:"I WC"},Q:{1028:"gC"},R:{2:"hC"},S:{516:"iC"}},B:5,C:"CSS position:sticky"}},9533:e=>{e.exports={A:{A:{132:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",4:"C K L D M N O"},C:{1:"AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G A B nB oB",33:"0 1 2 3 4 5 6 7 8 9 C K L D M N O g h i j k l m n o p q r s t u v w x y z"},D:{1:"8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v",322:"0 1 2 3 4 5 6 7 w x y z"},E:{2:"I f J E F G A B C K L D sB gB tB uB vB wB hB bB cB xB yB zB"},F:{1:"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C D M N O g h i 0B 1B 2B 3B bB iB 4B cB",578:"j k l m n o p q r s t u"},G:{2:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{2:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{132:"A B"},O:{1:"VC"},P:{1:"WC XC YC ZC aC hB bC cC dC eC fC",2:"I"},Q:{2:"gC"},R:{1:"hC"},S:{33:"iC"}},B:5,C:"CSS3 text-align-last"}},3100:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",2:"C K L D M N O"},C:{1:"2 3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y nB oB",194:"0 1 z"},D:{1:"9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"0 1 2 3 4 5 6 7 8 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z"},E:{1:"L D yB zB",2:"I f J E F G sB gB tB uB vB wB",16:"A",33:"B C K hB bB cB xB"},F:{1:"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C D M N O g h i j k l m n o p q r s t u v 0B 1B 2B 3B bB iB 4B cB"},G:{1:"D CC DC EC FC GC HC IC JC KC LC MC NC",2:"F gB 5B jB 6B 7B 8B 9B AC BC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{2:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{1:"VC"},P:{1:"WC XC YC ZC aC hB bC cC dC eC fC",2:"I"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"CSS text-orientation"}},8422:e=>{e.exports={A:{A:{2:"J E kB",161:"F G A B"},B:{2:"P Q T U V W X Y Z a b c R d H e",161:"C K L D M N O"},C:{2:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e nB oB"},D:{2:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{2:"I f J E F G A B C K L D sB gB tB uB vB wB hB bB cB xB yB zB"},F:{2:"0 1 2 3 4 5 6 7 8 9 G B C D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q 0B 1B 2B 3B bB iB 4B cB"},G:{2:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{2:"dB I H PC QC RC SC jB TC UC"},J:{2:"E A"},K:{2:"A B C S bB iB cB"},L:{2:"H"},M:{2:"R"},N:{16:"A B"},O:{2:"VC"},P:{2:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{2:"gC"},R:{2:"hC"},S:{2:"iC"}},B:5,C:"CSS Text 4 text-spacing"}},5056:e=>{e.exports={A:{A:{1:"A B",2:"J E F G kB"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB nB oB",33:"f J E F G A B C K L D",164:"I"},D:{1:"0 1 2 3 4 5 6 7 8 9 n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",33:"I f J E F G A B C K L D M N O g h i j k l m"},E:{1:"E F G A B C K L D uB vB wB hB bB cB xB yB zB",33:"J tB",164:"I f sB gB"},F:{1:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q cB",2:"G 0B 1B",33:"C",164:"B 2B 3B bB iB 4B"},G:{1:"F D 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC",33:"7B",164:"gB 5B jB 6B"},H:{2:"OC"},I:{1:"H TC UC",33:"dB I PC QC RC SC jB"},J:{1:"A",33:"E"},K:{1:"S cB",33:"C",164:"A B bB iB"},L:{1:"H"},M:{1:"R"},N:{1:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:5,C:"CSS3 Transitions"}},1456:e=>{e.exports={A:{A:{132:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",132:"C K L D M N O"},C:{1:"BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",33:"0 1 2 3 4 5 6 7 8 9 N O g h i j k l m n o p q r s t u v w x y z AB",132:"lB dB I f J E F G nB oB",292:"A B C K L D M"},D:{1:"9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",132:"I f J E F G A B C K L D M",548:"0 1 2 3 4 5 6 7 8 N O g h i j k l m n o p q r s t u v w x y z"},E:{132:"I f J E F sB gB tB uB vB",548:"G A B C K L D wB hB bB cB xB yB zB"},F:{132:"0 1 2 3 4 5 6 7 8 9 G B C D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q 0B 1B 2B 3B bB iB 4B cB"},G:{132:"F gB 5B jB 6B 7B 8B 9B",548:"D AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{16:"OC"},I:{1:"H",16:"dB I PC QC RC SC jB TC UC"},J:{16:"E A"},K:{1:"S",16:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{132:"A B"},O:{16:"VC"},P:{1:"WC XC YC ZC aC hB bC cC dC eC fC",16:"I"},Q:{16:"gC"},R:{16:"hC"},S:{33:"iC"}},B:4,C:"CSS unicode-bidi property"}},8307:e=>{e.exports={A:{A:{132:"J E F G A B kB"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"2 3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w nB oB",322:"0 1 x y z"},D:{1:"9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J",16:"E",33:"0 1 2 3 4 5 6 7 8 F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z"},E:{1:"B C K L D bB cB xB yB zB",2:"I sB gB",16:"f",33:"J E F G A tB uB vB wB hB"},F:{1:"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C 0B 1B 2B 3B bB iB 4B cB",33:"D M N O g h i j k l m n o p q r s t u v"},G:{1:"D EC FC GC HC IC JC KC LC MC NC",16:"gB 5B jB",33:"F 6B 7B 8B 9B AC BC CC DC"},H:{2:"OC"},I:{1:"H",2:"PC QC RC",33:"dB I SC jB TC UC"},J:{33:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{36:"A B"},O:{1:"VC"},P:{1:"WC XC YC ZC aC hB bC cC dC eC fC",33:"I"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"CSS writing-mode property"}},7759:e=>{e.exports={A:{A:{1:"F G A B",8:"J E kB"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",33:"lB dB I f J E F G A B C K L D M N O g h i j k l m n o p nB oB"},D:{1:"0 1 2 3 4 5 6 7 8 9 A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",33:"I f J E F G"},E:{1:"J E F G A B C K L D tB uB vB wB hB bB cB xB yB zB",33:"I f sB gB"},F:{1:"0 1 2 3 4 5 6 7 8 9 B C D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q 0B 1B 2B 3B bB iB 4B cB",2:"G"},G:{1:"F D 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC",33:"gB 5B jB"},H:{1:"OC"},I:{1:"I H SC jB TC UC",33:"dB PC QC RC"},J:{1:"A",33:"E"},K:{1:"A B C S bB iB cB"},L:{1:"H"},M:{1:"R"},N:{1:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:5,C:"CSS3 Box-sizing"}},4528:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"D M N O P Q T U V W X Y Z a b c R d H e",2:"C K L"},C:{1:"0 1 2 3 4 5 6 7 8 9 o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",33:"lB dB I f J E F G A B C K L D M N O g h i j k l m n nB oB"},D:{1:"QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",33:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB"},E:{1:"B C K L D bB cB xB yB zB",33:"I f J E F G A sB gB tB uB vB wB hB"},F:{1:"C GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q 4B cB",2:"G B 0B 1B 2B 3B bB iB",33:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB"},G:{2:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{33:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{2:"R"},N:{2:"A B"},O:{2:"VC"},P:{2:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{33:"gC"},R:{2:"hC"},S:{2:"iC"}},B:3,C:"CSS grab & grabbing cursors"}},8546:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",33:"lB dB I f J E F G A B C K L D M N O g h i j k nB oB"},D:{1:"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",33:"I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x"},E:{1:"G A B C K L D wB hB bB cB xB yB zB",33:"I f J E F sB gB tB uB vB"},F:{1:"0 1 2 3 4 5 6 7 8 9 C l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q 4B cB",2:"G B 0B 1B 2B 3B bB iB",33:"D M N O g h i j k"},G:{2:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{33:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{2:"R"},N:{2:"A B"},O:{2:"VC"},P:{2:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{2:"gC"},R:{2:"hC"},S:{2:"iC"}},B:4,C:"CSS3 Cursors: zoom-in & zoom-out"}},9807:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",2:"C K L D M N O"},C:{1:"c R d H e",2:"lB dB nB oB",33:"EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b",164:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB"},D:{1:"3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B C K L D M N O g h",132:"0 1 2 i j k l m n o p q r s t u v w x y z"},E:{1:"L D xB yB zB",2:"I f J sB gB tB",132:"E F G A B C K uB vB wB hB bB cB"},F:{1:"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G 0B 1B 2B",132:"D M N O g h i j k l m n o p",164:"B C 3B bB iB 4B cB"},G:{1:"D LC MC NC",2:"gB 5B jB 6B 7B",132:"F 8B 9B AC BC CC DC EC FC GC HC IC JC KC"},H:{164:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB",132:"TC UC"},J:{132:"E A"},K:{1:"S",2:"A",164:"B C bB iB cB"},L:{1:"H"},M:{33:"R"},N:{2:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{164:"iC"}},B:5,C:"CSS3 tab-size"}},3714:e=>{e.exports={A:{A:{2:"J E F G kB",1028:"B",1316:"A"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",164:"lB dB I f J E F G A B C K L D M N O g h i nB oB",516:"j k l m n o"},D:{1:"0 1 2 3 4 5 6 7 8 9 q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",33:"i j k l m n o p",164:"I f J E F G A B C K L D M N O g h"},E:{1:"G A B C K L D wB hB bB cB xB yB zB",33:"E F uB vB",164:"I f J sB gB tB"},F:{1:"0 1 2 3 4 5 6 7 8 9 N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q cB",2:"G B C 0B 1B 2B 3B bB iB 4B",33:"D M"},G:{1:"D AC BC CC DC EC FC GC HC IC JC KC LC MC NC",33:"F 8B 9B",164:"gB 5B jB 6B 7B"},H:{1:"OC"},I:{1:"H TC UC",164:"dB I PC QC RC SC jB"},J:{1:"A",164:"E"},K:{1:"S cB",2:"A B C bB iB"},L:{1:"H"},M:{1:"R"},N:{1:"B",292:"A"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"CSS Flexible Box Layout Module"}},7011:e=>{e.exports={A:{A:{1:"A B",2:"J E F G kB"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB nB oB",33:"D M N O g h i j k l m n o p q r s t u",164:"I f J E F G A B C K L"},D:{1:"9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B C K L D",33:"0 1 2 3 4 5 6 7 8 i j k l m n o p q r s t u v w x y z",292:"M N O g h"},E:{1:"A B C K L D wB hB bB cB xB yB zB",2:"E F G sB gB uB vB",4:"I f J tB"},F:{1:"0 1 2 3 4 5 6 7 8 9 w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C 0B 1B 2B 3B bB iB 4B cB",33:"D M N O g h i j k l m n o p q r s t u v"},G:{1:"D BC CC DC EC FC GC HC IC JC KC LC MC NC",2:"F 8B 9B AC",4:"gB 5B jB 6B 7B"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB",33:"TC UC"},J:{2:"E",33:"A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{1:"VC"},P:{1:"WC XC YC ZC aC hB bC cC dC eC fC",33:"I"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"CSS font-feature-settings"}},9195:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",2:"C K L D M N O"},C:{1:"0 1 2 3 4 5 6 7 8 9 v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G A B C K L D M N O g h i j k nB oB",194:"l m n o p q r s t u"},D:{1:"0 1 2 3 4 5 6 7 8 9 u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B C K L D M N O g h i j k l m n o p",33:"q r s t"},E:{1:"A B C K L D wB hB bB cB xB yB zB",2:"I f J sB gB tB uB",33:"E F G vB"},F:{1:"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C D 0B 1B 2B 3B bB iB 4B cB",33:"M N O g"},G:{1:"D GC HC IC JC KC LC MC NC",2:"gB 5B jB 6B 7B 8B",33:"F 9B AC BC CC DC EC FC"},H:{2:"OC"},I:{1:"H UC",2:"dB I PC QC RC SC jB",33:"TC"},J:{2:"E",33:"A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"CSS3 font-kerning"}},5833:e=>{e.exports={A:{A:{2:"J E F G A kB",548:"B"},B:{1:"P Q T U V W X Y Z a b c R d H e",516:"C K L D M N O"},C:{1:"S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G nB oB",676:"0 1 2 3 4 5 6 7 A B C K L D M N O g h i j k l m n o p q r s t u v w x y z",1700:"8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB"},D:{1:"TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B C K L",676:"D M N O g",804:"0 1 2 3 4 5 6 7 8 9 h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB"},E:{2:"I f sB gB",676:"tB",804:"J E F G A B C K L D uB vB wB hB bB cB xB yB zB"},F:{1:"S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q cB",2:"G B C 0B 1B 2B 3B bB iB 4B",804:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB"},G:{2:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC",2052:"GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{2:"dB I H PC QC RC SC jB TC UC"},J:{2:"E",292:"A"},K:{2:"A B C S bB iB cB"},L:{804:"H"},M:{1:"R"},N:{2:"A",548:"B"},O:{804:"VC"},P:{1:"hB bC cC dC eC fC",804:"I WC XC YC ZC aC"},Q:{804:"gC"},R:{804:"hC"},S:{1:"iC"}},B:1,C:"Full Screen API"}},3794:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{2:"C K L D M N O",1537:"P Q T U V W X Y Z a b c R d H e"},C:{2:"lB",932:"0 1 2 3 4 5 6 7 8 9 dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB nB oB",2308:"OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e"},D:{2:"I f J E F G A B C K L D M N O g h i",545:"0 1 2 3 4 5 6 j k l m n o p q r s t u v w x y z",1537:"7 8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{2:"I f J sB gB tB",516:"B C K L D bB cB xB yB zB",548:"G A wB hB",676:"E F uB vB"},F:{2:"G B C 0B 1B 2B 3B bB iB 4B cB",513:"v",545:"D M N O g h i j k l m n o p q r s t",1537:"0 1 2 3 4 5 6 7 8 9 u w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{2:"gB 5B jB 6B 7B",516:"D MC NC",548:"AC BC CC DC EC FC GC HC IC JC KC LC",676:"F 8B 9B"},H:{2:"OC"},I:{2:"dB I PC QC RC SC jB",545:"TC UC",1537:"H"},J:{2:"E",545:"A"},K:{2:"A B C bB iB cB",1537:"S"},L:{1537:"H"},M:{2308:"R"},N:{2:"A B"},O:{1:"VC"},P:{545:"I",1537:"WC XC YC ZC aC hB bC cC dC eC fC"},Q:{545:"gC"},R:{1537:"hC"},S:{932:"iC"}},B:5,C:"Intrinsic & Extrinsic Sizing"}},1448:e=>{e.exports={A:{A:{1:"A B",2:"J E F G kB"},B:{1:"C K L D M N O",516:"P Q T U V W X Y Z a b c R d H e"},C:{132:"DB EB FB GB HB IB JB eB KB fB LB MB S",164:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB nB oB",516:"NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e"},D:{420:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB",516:"BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{1:"A B C K L D hB bB cB xB yB zB",132:"G wB",164:"E F vB",420:"I f J sB gB tB uB"},F:{1:"C bB iB 4B cB",2:"G B 0B 1B 2B 3B",420:"D M N O g h i j k l m n o p q r s t u v w x",516:"0 1 2 3 4 5 6 7 8 9 y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{1:"D CC DC EC FC GC HC IC JC KC LC MC NC",132:"AC BC",164:"F 8B 9B",420:"gB 5B jB 6B 7B"},H:{1:"OC"},I:{420:"dB I PC QC RC SC jB TC UC",516:"H"},J:{420:"E A"},K:{1:"C bB iB cB",2:"A B",516:"S"},L:{516:"H"},M:{516:"R"},N:{1:"A B"},O:{1:"VC"},P:{1:"WC XC YC ZC aC hB bC cC dC eC fC",420:"I"},Q:{132:"gC"},R:{132:"hC"},S:{164:"iC"}},B:4,C:"CSS3 Multiple column layout"}},5147:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",2:"C K L D",260:"M N O"},C:{1:"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w nB oB"},D:{1:"0 1 2 3 4 5 6 7 8 9 t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B C K L D M N O g h i j k l m n o p q r s"},E:{1:"A B C K L D hB bB cB xB yB zB",2:"I f J E sB gB tB uB",132:"F G vB wB"},F:{1:"0 1 2 3 4 5 6 7 8 9 g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G D M N O 0B 1B 2B",33:"B C 3B bB iB 4B cB"},G:{1:"D CC DC EC FC GC HC IC JC KC LC MC NC",2:"gB 5B jB 6B 7B 8B",132:"F 9B AC BC"},H:{33:"OC"},I:{1:"H UC",2:"dB I PC QC RC SC jB TC"},J:{2:"E A"},K:{1:"S",2:"A",33:"B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{2:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"CSS3 object-fit/object-position"}},6714:e=>{e.exports={A:{A:{1:"B",2:"J E F G kB",164:"A"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f nB oB",8:"0 1 J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z",328:"2 3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB"},D:{1:"GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B C K L D M N O g h i",8:"0 1 2 3 4 5 6 7 8 9 j k l m n o p q r s t u v w x y z AB BB CB",584:"DB EB FB"},E:{1:"K L D xB yB zB",2:"I f J sB gB tB",8:"E F G A B C uB vB wB hB bB",1096:"cB"},F:{1:"3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C 0B 1B 2B 3B bB iB 4B cB",8:"D M N O g h i j k l m n o p q r s t u v w x y z",584:"0 1 2"},G:{1:"D JC KC LC MC NC",8:"F gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC",6148:"IC"},H:{2:"OC"},I:{1:"H",8:"dB I PC QC RC SC jB TC UC"},J:{8:"E A"},K:{1:"S",2:"A",8:"B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{1:"B",36:"A"},O:{8:"VC"},P:{1:"XC YC ZC aC hB bC cC dC eC fC",2:"WC",8:"I"},Q:{1:"gC"},R:{2:"hC"},S:{328:"iC"}},B:2,C:"Pointer events"}},6848:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{2:"C K L D M N O",2052:"P Q T U V W X Y Z a b c R d H e"},C:{2:"lB dB I f nB oB",1028:"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",1060:"J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w"},D:{2:"I f J E F G A B C K L D M N O g h i j k l m",226:"0 1 2 3 4 5 6 7 8 9 n o p q r s t u v w x y z AB BB CB DB EB FB GB HB",2052:"IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{2:"I f J E sB gB tB uB",772:"K L D cB xB yB zB",804:"F G A B C wB hB bB",1316:"vB"},F:{2:"G B C D M N O g h i j k l m n o p q r s t u v 0B 1B 2B 3B bB iB 4B cB",226:"0 1 2 3 4 w x y z",2052:"5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{2:"gB 5B jB 6B 7B 8B",292:"F D 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{2:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{2052:"H"},M:{1:"R"},N:{2:"A B"},O:{2052:"VC"},P:{2:"I WC XC",2052:"YC ZC aC hB bC cC dC eC fC"},Q:{2:"gC"},R:{1:"hC"},S:{1028:"iC"}},B:4,C:"text-decoration styling"}},5802:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{2:"C K L D M N O",164:"P Q T U V W X Y Z a b c R d H e"},C:{1:"7 8 9 AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"0 1 2 3 4 5 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z nB oB",322:"6"},D:{2:"I f J E F G A B C K L D M N O g h i j k l",164:"0 1 2 3 4 5 6 7 8 9 m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{1:"F G A B C K L D vB wB hB bB cB xB yB zB",2:"I f J sB gB tB",164:"E uB"},F:{2:"G B C 0B 1B 2B 3B bB iB 4B cB",164:"0 1 2 3 4 5 6 7 8 9 D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q"},G:{1:"F D 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC",2:"gB 5B jB 6B 7B"},H:{2:"OC"},I:{2:"dB I PC QC RC SC jB",164:"H TC UC"},J:{2:"E",164:"A"},K:{2:"A B C bB iB cB",164:"S"},L:{164:"H"},M:{1:"R"},N:{2:"A B"},O:{164:"VC"},P:{164:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{164:"gC"},R:{164:"hC"},S:{1:"iC"}},B:4,C:"text-emphasis styling"}},123:e=>{e.exports={A:{A:{1:"J E F G A B",2:"kB"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",8:"lB dB I f J nB oB"},D:{1:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB"},E:{1:"I f J E F G A B C K L D sB gB tB uB vB wB hB bB cB xB yB zB"},F:{1:"0 1 2 3 4 5 6 7 8 9 B C D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q bB iB 4B cB",33:"G 0B 1B 2B 3B"},G:{1:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{1:"OC"},I:{1:"dB I H PC QC RC SC jB TC UC"},J:{1:"E A"},K:{1:"S cB",33:"A B C bB iB"},L:{1:"H"},M:{1:"R"},N:{1:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"CSS3 Text-overflow"}},6421:e=>{e.exports={A:{A:{2:"J E F G A B kB"},B:{1:"P Q T U V W X Y Z a b c R d H e",33:"C K L D M N O"},C:{2:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e nB oB"},D:{1:"FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m o p q r s t u v w x y z AB BB CB DB EB",258:"n"},E:{2:"I f J E F G A B C K L D sB gB uB vB wB hB bB cB xB yB zB",258:"tB"},F:{1:"4 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"0 1 2 3 5 G B C D M N O g h i j k l m n o p q r s t u v w x y z 0B 1B 2B 3B bB iB 4B cB"},G:{2:"gB 5B jB",33:"F D 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H",2:"dB I PC QC RC SC jB TC UC"},J:{2:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{33:"R"},N:{161:"A B"},O:{1:"VC"},P:{1:"WC XC YC ZC aC hB bC cC dC eC fC",2:"I"},Q:{2:"gC"},R:{2:"hC"},S:{2:"iC"}},B:7,C:"CSS text-size-adjust"}},762:e=>{e.exports={A:{A:{2:"kB",8:"J E F",129:"A B",161:"G"},B:{1:"N O P Q T U V W X Y Z a b c R d H e",129:"C K L D M"},C:{1:"0 1 2 3 4 5 6 7 8 9 M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB",33:"I f J E F G A B C K L D nB oB"},D:{1:"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",33:"I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w"},E:{1:"G A B C K L D wB hB bB cB xB yB zB",33:"I f J E F sB gB tB uB vB"},F:{1:"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q cB",2:"G 0B 1B",33:"B C D M N O g h i j 2B 3B bB iB 4B"},G:{1:"D AC BC CC DC EC FC GC HC IC JC KC LC MC NC",33:"F gB 5B jB 6B 7B 8B 9B"},H:{2:"OC"},I:{1:"H",33:"dB I PC QC RC SC jB TC UC"},J:{33:"E A"},K:{1:"B C S bB iB cB",2:"A"},L:{1:"H"},M:{1:"R"},N:{1:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:4,C:"CSS3 2D Transforms"}},58:e=>{e.exports={A:{A:{2:"J E F G kB",132:"A B"},B:{1:"C K L D M N O P Q T U V W X Y Z a b c R d H e"},C:{1:"0 1 2 3 4 5 6 7 8 9 M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",2:"lB dB I f J E F G nB oB",33:"A B C K L D"},D:{1:"0 1 2 3 4 5 6 7 8 9 x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",2:"I f J E F G A B",33:"C K L D M N O g h i j k l m n o p q r s t u v w"},E:{1:"zB",2:"sB gB",33:"I f J E F tB uB vB",257:"G A B C K L D wB hB bB cB xB yB"},F:{1:"0 1 2 3 4 5 6 7 8 9 k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C 0B 1B 2B 3B bB iB 4B cB",33:"D M N O g h i j"},G:{33:"F gB 5B jB 6B 7B 8B 9B",257:"D AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H",2:"PC QC RC",33:"dB I SC jB TC UC"},J:{33:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{132:"A B"},O:{1:"VC"},P:{1:"I WC XC YC ZC aC hB bC cC dC eC fC"},Q:{1:"gC"},R:{1:"hC"},S:{1:"iC"}},B:5,C:"CSS3 3D Transforms"}},7511:e=>{e.exports={A:{A:{2:"J E F G kB",33:"A B"},B:{1:"P Q T U V W X Y Z a b c R d H e",33:"C K L D M N O"},C:{1:"RB SB TB UB VB WB XB YB ZB aB P Q T mB U V W X Y Z a b c R d H e",33:"0 1 2 3 4 5 6 7 8 9 lB dB I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB FB GB HB IB JB eB KB fB LB MB S NB OB PB QB nB oB"},D:{1:"FB GB HB IB JB eB KB fB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q T U V W X Y Z a b c R d H e pB qB rB",33:"0 1 2 3 4 5 6 7 8 9 I f J E F G A B C K L D M N O g h i j k l m n o p q r s t u v w x y z AB BB CB DB EB"},E:{33:"I f J E F G A B C K L D sB gB tB uB vB wB hB bB cB xB yB zB"},F:{1:"2 3 4 5 6 7 8 9 AB BB CB DB EB FB GB HB IB JB KB LB MB S NB OB PB QB RB SB TB UB VB WB XB YB ZB aB P Q",2:"G B C 0B 1B 2B 3B bB iB 4B cB",33:"0 1 D M N O g h i j k l m n o p q r s t u v w x y z"},G:{33:"F D gB 5B jB 6B 7B 8B 9B AC BC CC DC EC FC GC HC IC JC KC LC MC NC"},H:{2:"OC"},I:{1:"H",33:"dB I PC QC RC SC jB TC UC"},J:{33:"E A"},K:{1:"S",2:"A B C bB iB cB"},L:{1:"H"},M:{1:"R"},N:{33:"A B"},O:{2:"VC"},P:{1:"XC YC ZC aC hB bC cC dC eC fC",33:"I WC"},Q:{1:"gC"},R:{2:"hC"},S:{33:"iC"}},B:5,C:"CSS user-select: none"}},9883:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));const i=/:blank([^\w-]|$)/gi;var o=n.plugin("css-blank-pseudo",e=>{const r=String(Object(e).replaceWith||"[blank]");const t=Boolean("preserve"in Object(e)?e.preserve:true);return e=>{e.walkRules(i,e=>{const n=e.selector.replace(i,(e,t)=>{return`${r}${t}`});const o=e.clone({selector:n});if(t){e.before(o)}else{e.replaceWith(o)}})}});e.exports=o},9555:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(1571));var i=_interopDefault(t(2043));const o=/:has/;var s=i.plugin("css-has-pseudo",e=>{const r=Boolean("preserve"in Object(e)?e.preserve:true);return e=>{e.walkRules(o,e=>{const t=n(e=>{e.walkPseudos(e=>{if(e.value===":has"&&e.nodes){const r=checkIfParentIsNot(e);e.value=r?":not-has":":has";const t=n.attribute({attribute:encodeURIComponent(String(e)).replace(/%3A/g,":").replace(/%5B/g,"[").replace(/%5D/g,"]").replace(/%2C/g,",").replace(/[():%\[\],]/g,"\\$&")});if(r){e.parent.parent.replaceWith(t)}else{e.replaceWith(t)}}})}).processSync(e.selector);const i=e.clone({selector:t});if(r){e.before(i)}else{e.replaceWith(i)}})}});function checkIfParentIsNot(e){return Object(Object(e.parent).parent).type==="pseudo"&&e.parent.parent.value===":not"}e.exports=s},2207:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));const i=/^media$/i;const o=/\(\s*prefers-color-scheme\s*:\s*(dark|light|no-preference)\s*\)/i;const s={dark:48,light:70,"no-preference":22};const a=(e,r)=>`(color-index: ${s[r.toLowerCase()]})`;var u=n.plugin("postcss-prefers-color-scheme",e=>{const r="preserve"in Object(e)?e.preserve:true;return e=>{e.walkAtRules(i,e=>{const t=e.params;const n=t.replace(o,a);if(t!==n){if(r){e.cloneBefore({params:n})}else{e.params=n}}})}});e.exports=u},5455:e=>{"use strict";var r={};var t=r.hasOwnProperty;var n=function merge(e,r){if(!e){return r}var n={};for(var i in r){n[i]=t.call(e,i)?e[i]:r[i]}return n};var i=/[ -,\.\/;-@\[-\^`\{-~]/;var o=/[ -,\.\/;-@\[\]\^`\{-~]/;var s=/['"\\]/;var a=/(^|\\+)?(\\[A-F0-9]{1,6})\x20(?![a-fA-F0-9\x20])/g;var u=function cssesc(e,r){r=n(r,cssesc.options);if(r.quotes!="single"&&r.quotes!="double"){r.quotes="single"}var t=r.quotes=="double"?'"':"'";var s=r.isIdentifier;var u=e.charAt(0);var c="";var l=0;var B=e.length;while(l<B){var f=e.charAt(l++);var p=f.charCodeAt();var d=void 0;if(p<32||p>126){if(p>=55296&&p<=56319&&l<B){var h=e.charCodeAt(l++);if((h&64512)==56320){p=((p&1023)<<10)+(h&1023)+65536}else{l--}}d="\\"+p.toString(16).toUpperCase()+" "}else{if(r.escapeEverything){if(i.test(f)){d="\\"+f}else{d="\\"+p.toString(16).toUpperCase()+" "}}else if(/[\t\n\f\r\x0B:]/.test(f)){if(!s&&f==":"){d=f}else{d="\\"+p.toString(16).toUpperCase()+" "}}else if(f=="\\"||!s&&(f=='"'&&t==f||f=="'"&&t==f)||s&&o.test(f)){d="\\"+f}else{d=f}}c+=d}if(s){if(/^_/.test(c)){c="\\_"+c.slice(1)}else if(/^-[-\d]/.test(c)){c="\\-"+c.slice(1)}else if(/\d/.test(u)){c="\\3"+u+" "+c.slice(1)}}c=c.replace(a,function(e,r,t){if(r&&r.length%2){return e}return(r||"")+t});if(!s&&r.wrap){return t+c+t}return c};u.options={escapeEverything:false,isIdentifier:false,quotes:"single",wrap:false};u.version="1.0.1";e.exports=u},5202:e=>{e.exports=function flatten(e,r){r=typeof r=="number"?r:Infinity;if(!r){if(Array.isArray(e)){return e.map(function(e){return e})}return e}return _flatten(e,1);function _flatten(e,t){return e.reduce(function(e,n){if(Array.isArray(n)&&t<r){return e.concat(_flatten(n,t+1))}else{return e.concat(n)}},[])}}},4751:e=>{e.exports=function(e,r){var t=-1,n=[];while((t=e.indexOf(r,t+1))!==-1)n.push(t);return n}},7478:e=>{var r=/<%=([\s\S]+?)%>/g;e.exports=r},8589:(e,r,t)=>{e=t.nmd(e);var n=t(7478),i=t(1623);var o=800,s=16;var a=1/0,u=9007199254740991;var c="[object Arguments]",l="[object Array]",B="[object AsyncFunction]",f="[object Boolean]",p="[object Date]",d="[object DOMException]",h="[object Error]",v="[object Function]",b="[object GeneratorFunction]",C="[object Map]",g="[object Number]",m="[object Null]",y="[object Object]",w="[object Proxy]",S="[object RegExp]",x="[object Set]",O="[object String]",P="[object Symbol]",k="[object Undefined]",A="[object WeakMap]";var F="[object ArrayBuffer]",j="[object DataView]",T="[object Float32Array]",D="[object Float64Array]",E="[object Int8Array]",R="[object Int16Array]",I="[object Int32Array]",M="[object Uint8Array]",L="[object Uint8ClampedArray]",G="[object Uint16Array]",N="[object Uint32Array]";var J=/\b__p \+= '';/g,H=/\b(__p \+=) '' \+/g,Q=/(__e\(.*?\)|\b__t\)) \+\n'';/g;var U=/[\\^$.*+?()[\]{}|]/g;var W=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;var K=/^\[object .+?Constructor\]$/;var z=/^(?:0|[1-9]\d*)$/;var q=/($^)/;var Y=/['\n\r\u2028\u2029\\]/g;var X={};X[T]=X[D]=X[E]=X[R]=X[I]=X[M]=X[L]=X[G]=X[N]=true;X[c]=X[l]=X[F]=X[f]=X[j]=X[p]=X[h]=X[v]=X[C]=X[g]=X[y]=X[S]=X[x]=X[O]=X[A]=false;var Z={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"};var $=typeof global=="object"&&global&&global.Object===Object&&global;var V=typeof self=="object"&&self&&self.Object===Object&&self;var _=$||V||Function("return this")();var ee=true&&r&&!r.nodeType&&r;var re=ee&&"object"=="object"&&e&&!e.nodeType&&e;var te=re&&re.exports===ee;var ne=te&&$.process;var ie=function(){try{var e=re&&re.require&&re.require("util").types;if(e){return e}return ne&&ne.binding&&ne.binding("util")}catch(e){}}();var oe=ie&&ie.isTypedArray;function apply(e,r,t){switch(t.length){case 0:return e.call(r);case 1:return e.call(r,t[0]);case 2:return e.call(r,t[0],t[1]);case 3:return e.call(r,t[0],t[1],t[2])}return e.apply(r,t)}function arrayMap(e,r){var t=-1,n=e==null?0:e.length,i=Array(n);while(++t<n){i[t]=r(e[t],t,e)}return i}function baseTimes(e,r){var t=-1,n=Array(e);while(++t<e){n[t]=r(t)}return n}function baseUnary(e){return function(r){return e(r)}}function baseValues(e,r){return arrayMap(r,function(r){return e[r]})}function escapeStringChar(e){return"\\"+Z[e]}function getValue(e,r){return e==null?undefined:e[r]}function overArg(e,r){return function(t){return e(r(t))}}var se=Function.prototype,ae=Object.prototype;var ue=_["__core-js_shared__"];var ce=se.toString;var le=ae.hasOwnProperty;var Be=function(){var e=/[^.]+$/.exec(ue&&ue.keys&&ue.keys.IE_PROTO||"");return e?"Symbol(src)_1."+e:""}();var fe=ae.toString;var pe=ce.call(Object);var de=RegExp("^"+ce.call(le).replace(U,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");var he=te?_.Buffer:undefined,ve=_.Symbol,be=overArg(Object.getPrototypeOf,Object),Ce=ae.propertyIsEnumerable,ge=ve?ve.toStringTag:undefined;var me=function(){try{var e=getNative(Object,"defineProperty");e({},"",{});return e}catch(e){}}();var ye=he?he.isBuffer:undefined,we=overArg(Object.keys,Object),Se=Math.max,xe=Date.now;var Oe=ve?ve.prototype:undefined,Pe=Oe?Oe.toString:undefined;function arrayLikeKeys(e,r){var t=je(e),n=!t&&Fe(e),i=!t&&!n&&Te(e),o=!t&&!n&&!i&&De(e),s=t||n||i||o,a=s?baseTimes(e.length,String):[],u=a.length;for(var c in e){if((r||le.call(e,c))&&!(s&&(c=="length"||i&&(c=="offset"||c=="parent")||o&&(c=="buffer"||c=="byteLength"||c=="byteOffset")||isIndex(c,u)))){a.push(c)}}return a}function assignValue(e,r,t){var n=e[r];if(!(le.call(e,r)&&eq(n,t))||t===undefined&&!(r in e)){baseAssignValue(e,r,t)}}function baseAssignValue(e,r,t){if(r=="__proto__"&&me){me(e,r,{configurable:true,enumerable:true,value:t,writable:true})}else{e[r]=t}}function baseGetTag(e){if(e==null){return e===undefined?k:m}return ge&&ge in Object(e)?getRawTag(e):objectToString(e)}function baseIsArguments(e){return isObjectLike(e)&&baseGetTag(e)==c}function baseIsNative(e){if(!isObject(e)||isMasked(e)){return false}var r=isFunction(e)?de:K;return r.test(toSource(e))}function baseIsTypedArray(e){return isObjectLike(e)&&isLength(e.length)&&!!X[baseGetTag(e)]}function baseKeys(e){if(!isPrototype(e)){return we(e)}var r=[];for(var t in Object(e)){if(le.call(e,t)&&t!="constructor"){r.push(t)}}return r}function baseKeysIn(e){if(!isObject(e)){return nativeKeysIn(e)}var r=isPrototype(e),t=[];for(var n in e){if(!(n=="constructor"&&(r||!le.call(e,n)))){t.push(n)}}return t}function baseRest(e,r){return Ae(overRest(e,r,identity),e+"")}var ke=!me?identity:function(e,r){return me(e,"toString",{configurable:true,enumerable:false,value:constant(r),writable:true})};function baseToString(e){if(typeof e=="string"){return e}if(je(e)){return arrayMap(e,baseToString)+""}if(isSymbol(e)){return Pe?Pe.call(e):""}var r=e+"";return r=="0"&&1/e==-a?"-0":r}function copyObject(e,r,t,n){var i=!t;t||(t={});var o=-1,s=r.length;while(++o<s){var a=r[o];var u=n?n(t[a],e[a],a,t,e):undefined;if(u===undefined){u=e[a]}if(i){baseAssignValue(t,a,u)}else{assignValue(t,a,u)}}return t}function createAssigner(e){return baseRest(function(r,t){var n=-1,i=t.length,o=i>1?t[i-1]:undefined,s=i>2?t[2]:undefined;o=e.length>3&&typeof o=="function"?(i--,o):undefined;if(s&&isIterateeCall(t[0],t[1],s)){o=i<3?undefined:o;i=1}r=Object(r);while(++n<i){var a=t[n];if(a){e(r,a,n,o)}}return r})}function customDefaultsAssignIn(e,r,t,n){if(e===undefined||eq(e,ae[t])&&!le.call(n,t)){return r}return e}function getNative(e,r){var t=getValue(e,r);return baseIsNative(t)?t:undefined}function getRawTag(e){var r=le.call(e,ge),t=e[ge];try{e[ge]=undefined;var n=true}catch(e){}var i=fe.call(e);if(n){if(r){e[ge]=t}else{delete e[ge]}}return i}function isIndex(e,r){var t=typeof e;r=r==null?u:r;return!!r&&(t=="number"||t!="symbol"&&z.test(e))&&(e>-1&&e%1==0&&e<r)}function isIterateeCall(e,r,t){if(!isObject(t)){return false}var n=typeof r;if(n=="number"?isArrayLike(t)&&isIndex(r,t.length):n=="string"&&r in t){return eq(t[r],e)}return false}function isMasked(e){return!!Be&&Be in e}function isPrototype(e){var r=e&&e.constructor,t=typeof r=="function"&&r.prototype||ae;return e===t}function nativeKeysIn(e){var r=[];if(e!=null){for(var t in Object(e)){r.push(t)}}return r}function objectToString(e){return fe.call(e)}function overRest(e,r,t){r=Se(r===undefined?e.length-1:r,0);return function(){var n=arguments,i=-1,o=Se(n.length-r,0),s=Array(o);while(++i<o){s[i]=n[r+i]}i=-1;var a=Array(r+1);while(++i<r){a[i]=n[i]}a[r]=t(s);return apply(e,this,a)}}var Ae=shortOut(ke);function shortOut(e){var r=0,t=0;return function(){var n=xe(),i=s-(n-t);t=n;if(i>0){if(++r>=o){return arguments[0]}}else{r=0}return e.apply(undefined,arguments)}}function toSource(e){if(e!=null){try{return ce.call(e)}catch(e){}try{return e+""}catch(e){}}return""}function eq(e,r){return e===r||e!==e&&r!==r}var Fe=baseIsArguments(function(){return arguments}())?baseIsArguments:function(e){return isObjectLike(e)&&le.call(e,"callee")&&!Ce.call(e,"callee")};var je=Array.isArray;function isArrayLike(e){return e!=null&&isLength(e.length)&&!isFunction(e)}var Te=ye||stubFalse;function isError(e){if(!isObjectLike(e)){return false}var r=baseGetTag(e);return r==h||r==d||typeof e.message=="string"&&typeof e.name=="string"&&!isPlainObject(e)}function isFunction(e){if(!isObject(e)){return false}var r=baseGetTag(e);return r==v||r==b||r==B||r==w}function isLength(e){return typeof e=="number"&&e>-1&&e%1==0&&e<=u}function isObject(e){var r=typeof e;return e!=null&&(r=="object"||r=="function")}function isObjectLike(e){return e!=null&&typeof e=="object"}function isPlainObject(e){if(!isObjectLike(e)||baseGetTag(e)!=y){return false}var r=be(e);if(r===null){return true}var t=le.call(r,"constructor")&&r.constructor;return typeof t=="function"&&t instanceof t&&ce.call(t)==pe}function isSymbol(e){return typeof e=="symbol"||isObjectLike(e)&&baseGetTag(e)==P}var De=oe?baseUnary(oe):baseIsTypedArray;function toString(e){return e==null?"":baseToString(e)}var Ee=createAssigner(function(e,r,t,n){copyObject(r,keysIn(r),e,n)});function keys(e){return isArrayLike(e)?arrayLikeKeys(e):baseKeys(e)}function keysIn(e){return isArrayLike(e)?arrayLikeKeys(e,true):baseKeysIn(e)}function template(e,r,t){var o=i.imports._.templateSettings||i;if(t&&isIterateeCall(e,r,t)){r=undefined}e=toString(e);r=Ee({},r,o,customDefaultsAssignIn);var s=Ee({},r.imports,o.imports,customDefaultsAssignIn),a=keys(s),u=baseValues(s,a);var c,l,B=0,f=r.interpolate||q,p="__p += '";var d=RegExp((r.escape||q).source+"|"+f.source+"|"+(f===n?W:q).source+"|"+(r.evaluate||q).source+"|$","g");var h=le.call(r,"sourceURL")?"//# sourceURL="+(r.sourceURL+"").replace(/[\r\n]/g," ")+"\n":"";e.replace(d,function(r,t,n,i,o,s){n||(n=i);p+=e.slice(B,s).replace(Y,escapeStringChar);if(t){c=true;p+="' +\n__e("+t+") +\n'"}if(o){l=true;p+="';\n"+o+";\n__p += '"}if(n){p+="' +\n((__t = ("+n+")) == null ? '' : __t) +\n'"}B=s+r.length;return r});p+="';\n";var v=le.call(r,"variable")&&r.variable;if(!v){p="with (obj) {\n"+p+"\n}\n"}p=(l?p.replace(J,""):p).replace(H,"$1").replace(Q,"$1;");p="function("+(v||"obj")+") {\n"+(v?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(c?", __e = _.escape":"")+(l?", __j = Array.prototype.join;\n"+"function print() { __p += __j.call(arguments, '') }\n":";\n")+p+"return __p\n}";var b=Re(function(){return Function(a,h+"return "+p).apply(undefined,u)});b.source=p;if(isError(b)){throw b}return b}var Re=baseRest(function(e,r){try{return apply(e,undefined,r)}catch(e){return isError(e)?e:new Error(e)}});function constant(e){return function(){return e}}function identity(e){return e}function stubFalse(){return false}e.exports=template},1623:(e,r,t)=>{var n=t(7478);var i=1/0;var o="[object Null]",s="[object Symbol]",a="[object Undefined]";var u=/[&<>"']/g,c=RegExp(u.source);var l=/<%-([\s\S]+?)%>/g,B=/<%([\s\S]+?)%>/g;var f={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"};var p=typeof global=="object"&&global&&global.Object===Object&&global;var d=typeof self=="object"&&self&&self.Object===Object&&self;var h=p||d||Function("return this")();function arrayMap(e,r){var t=-1,n=e==null?0:e.length,i=Array(n);while(++t<n){i[t]=r(e[t],t,e)}return i}function basePropertyOf(e){return function(r){return e==null?undefined:e[r]}}var v=basePropertyOf(f);var b=Object.prototype;var C=b.hasOwnProperty;var g=b.toString;var m=h.Symbol,y=m?m.toStringTag:undefined;var w=m?m.prototype:undefined,S=w?w.toString:undefined;var x={escape:l,evaluate:B,interpolate:n,variable:"",imports:{_:{escape:escape}}};function baseGetTag(e){if(e==null){return e===undefined?a:o}return y&&y in Object(e)?getRawTag(e):objectToString(e)}function baseToString(e){if(typeof e=="string"){return e}if(O(e)){return arrayMap(e,baseToString)+""}if(isSymbol(e)){return S?S.call(e):""}var r=e+"";return r=="0"&&1/e==-i?"-0":r}function getRawTag(e){var r=C.call(e,y),t=e[y];try{e[y]=undefined;var n=true}catch(e){}var i=g.call(e);if(n){if(r){e[y]=t}else{delete e[y]}}return i}function objectToString(e){return g.call(e)}var O=Array.isArray;function isObjectLike(e){return e!=null&&typeof e=="object"}function isSymbol(e){return typeof e=="symbol"||isObjectLike(e)&&baseGetTag(e)==s}function toString(e){return e==null?"":baseToString(e)}function escape(e){e=toString(e);return e&&c.test(e)?e.replace(u,v):e}e.exports=x},1981:e=>{"use strict";e.exports={wrap:wrapRange,limit:limitRange,validate:validateRange,test:testRange,curry:curry,name:name};function wrapRange(e,r,t){var n=r-e;return((t-e)%n+n)%n+e}function limitRange(e,r,t){return Math.max(e,Math.min(r,t))}function validateRange(e,r,t,n,i){if(!testRange(e,r,t,n,i)){throw new Error(t+" is outside of range ["+e+","+r+")")}return t}function testRange(e,r,t,n,i){return!(t<e||t>r||i&&t===r||n&&t===e)}function name(e,r,t,n){return(t?"(":"[")+e+","+r+(n?")":"]")}function curry(e,r,t,n){var i=name.bind(null,e,r,t,n);return{wrap:wrapRange.bind(null,e,r),limit:limitRange.bind(null,e,r),validate:function(i){return validateRange(e,r,i,t,n)},test:function(i){return testRange(e,r,i,t,n)},toString:i,name:i}}},9108:e=>{"use strict";var r=Math.abs;var t=Math.round;function almostEq(e,t){return r(e-t)<=9.5367432e-7}function GCD(e,r){if(almostEq(r,0))return e;return GCD(r,e%r)}function findPrecision(e){var r=1;while(!almostEq(t(e*r)/r,e)){r*=10}return r}function num2fraction(e){if(e===0||e==="0")return"0";if(typeof e==="string"){e=parseFloat(e)}var n=findPrecision(e);var i=e*n;var o=r(GCD(i,n));var s=i/o;var a=n/o;return t(s)+"/"+t(a)}e.exports=num2fraction},2347:(e,r,t)=>{"use strict";Object.defineProperty(r,"__esModule",{value:true});var n=t(2043);var i=_interopRequireDefault(n);var o=t(1571);var s=_interopRequireDefault(o);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function nodeIsInsensitiveAttribute(e){return e.type==="attribute"&&e.insensitive}function selectorHasInsensitiveAttribute(e){return e.some(nodeIsInsensitiveAttribute)}function transformString(e,r,t){var n=t.charAt(r);if(n===""){return e}var i=e.map(function(e){return e+n});var o=n.toLocaleUpperCase();if(o!==n){i=i.concat(e.map(function(e){return e+o}))}return transformString(i,r+1,t)}function createSensitiveAtributes(e){var r=transformString([""],0,e.value);return r.map(function(r){var t=e.clone({spaces:{after:e.spaces.after,before:e.spaces.before},insensitive:false});t.setValue(r);return t})}function createNewSelectors(e){var r=[s.default.selector()];e.walk(function(e){if(!nodeIsInsensitiveAttribute(e)){r.forEach(function(r){r.append(e.clone())});return}var t=createSensitiveAtributes(e);var n=[];t.forEach(function(e){r.forEach(function(r){var t=r.clone();t.append(e);n.push(t)})});r=n});return r}function transform(e){var r=[];e.each(function(e){if(selectorHasInsensitiveAttribute(e)){r=r.concat(createNewSelectors(e));e.remove()}});if(r.length){r.forEach(function(r){return e.append(r)})}}var a=/i(\s*\/\*[\W\w]*?\*\/)*\s*\]/;r.default=i.default.plugin("postcss-attribute-case-insensitive",function(){return function(e){e.walkRules(a,function(e){e.selector=(0,s.default)(transform).processSync(e.selector)})}});e.exports=r.default},7814:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));var i=_interopDefault(t(9448));var o=n.plugin("postcss-color-functional-notation",e=>{const r="preserve"in Object(e)?Boolean(e.preserve):false;return e=>{e.walkDecls(e=>{const t=e.value;if(u.test(t)){const n=i(t).parse();n.walkType("func",e=>{if(c.test(e.value)){const r=e.nodes.slice(1,-1);const t=A(e,r);const n=F(e,r);const i=j(e,r);if(t||n||i){const t=r[3];const n=r[4];if(n){if(g(n)&&!v(n)){n.unit="";n.value=String(n.value/100)}if(y(e)){e.value+="a"}}else if(w(e)){e.value=e.value.slice(0,-1)}if(t&&x(t)){t.replaceWith(T())}if(i){r[0].unit=r[1].unit=r[2].unit="";r[0].value=String(Math.floor(r[0].value*255/100));r[1].value=String(Math.floor(r[1].value*255/100));r[2].value=String(Math.floor(r[2].value*255/100))}e.nodes.splice(3,0,[T()]);e.nodes.splice(2,0,[T()])}}});const o=String(n);if(o!==t){if(r){e.cloneBefore({value:o})}else{e.value=o}}}})}});const s=/^%?$/i;const a=/^calc$/i;const u=/(^|[^\w-])(hsla?|rgba?)\(/i;const c=/^(hsla?|rgba?)$/i;const l=/^hsla?$/i;const B=/^(hsl|rgb)$/i;const f=/^(hsla|rgba)$/i;const p=/^(deg|grad|rad|turn)?$/i;const d=/^rgba?$/i;const h=e=>v(e)||e.type==="number"&&s.test(e.unit);const v=e=>e.type==="func"&&a.test(e.value);const b=e=>v(e)||e.type==="number"&&p.test(e.unit);const C=e=>v(e)||e.type==="number"&&e.unit==="";const g=e=>v(e)||e.type==="number"&&(e.unit==="%"||e.unit===""&&e.value==="0");const m=e=>e.type==="func"&&l.test(e.value);const y=e=>e.type==="func"&&B.test(e.value);const w=e=>e.type==="func"&&f.test(e.value);const S=e=>e.type==="func"&&d.test(e.value);const x=e=>e.type==="operator"&&e.value==="/";const O=[b,g,g,x,h];const P=[C,C,C,x,h];const k=[g,g,g,x,h];const A=(e,r)=>m(e)&&r.every((e,r)=>typeof O[r]==="function"&&O[r](e));const F=(e,r)=>S(e)&&r.every((e,r)=>typeof P[r]==="function"&&P[r](e));const j=(e,r)=>S(e)&&r.every((e,r)=>typeof k[r]==="function"&&k[r](e));const T=()=>i.comma({value:","});e.exports=o},489:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));var i=_interopDefault(t(9448));var o=t(4567);function _slicedToArray(e,r){return _arrayWithHoles(e)||_iterableToArrayLimit(e,r)||_nonIterableRest()}function _arrayWithHoles(e){if(Array.isArray(e))return e}function _iterableToArrayLimit(e,r){var t=[];var n=true;var i=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){t.push(a.value);if(r&&t.length===r)break}}catch(e){i=true;o=e}finally{try{if(!n&&s["return"]!=null)s["return"]()}finally{if(i)throw o}}return t}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}var s=n.plugin("postcss-color-gray",e=>r=>{r.walkDecls(r=>{if(u(r)){const t=r.value;const n=i(t).parse();n.walk(e=>{const r=S(e),t=_slicedToArray(r,2),n=t[0],s=t[1];if(n!==undefined){e.value="rgb";const r=o.lab2rgb(n,0,0).map(e=>Math.max(Math.min(Math.round(e*2.55),255),0)),t=_slicedToArray(r,3),a=t[0],u=t[1],c=t[2];const l=e.first;const B=e.last;e.removeAll().append(l).append(i.number({value:a})).append(i.comma({value:","})).append(i.number({value:u})).append(i.comma({value:","})).append(i.number({value:c}));if(s<1){e.value+="a";e.append(i.comma({value:","})).append(i.number({value:s}))}e.append(B)}});const s=n.toString();if(t!==s){if(Object(e).preserve){r.cloneBefore({value:s})}else{r.value=s}}}})});const a=/(^|[^\w-])gray\(/i;const u=e=>a.test(Object(e).value);const c=e=>Object(e).type==="number";const l=e=>Object(e).type==="operator";const B=e=>Object(e).type==="func";const f=/^calc$/i;const p=e=>B(e)&&f.test(e.value);const d=/^gray$/i;const h=e=>B(e)&&d.test(e.value)&&e.nodes&&e.nodes.length;const v=e=>c(e)&&e.unit==="%";const b=e=>c(e)&&e.unit==="";const C=e=>l(e)&&e.value==="/";const g=e=>b(e)?Number(e.value):undefined;const m=e=>C(e)?null:undefined;const y=e=>p(e)?String(e):b(e)?Number(e.value):v(e)?Number(e.value)/100:undefined;const w=[g,m,y];const S=e=>{const r=[];if(h(e)){const t=e.nodes.slice(1,-1);for(const e in t){const n=typeof w[e]==="function"?w[e](t[e]):undefined;if(n!==undefined){if(n!==null){r.push(n)}}else{return[]}}return r}else{return[]}};e.exports=s},8157:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));var i=_interopDefault(t(9448));var o=n.plugin("postcss-color-hex-alpha",e=>{const r="preserve"in Object(e)?Boolean(e.preserve):false;return e=>{e.walkDecls(e=>{if(a(e)){const t=i(e.value).parse();c(t,e=>{if(B(e)){e.replaceWith(f(e))}});const n=String(t);if(e.value!==n){if(r){e.cloneBefore({value:n})}else{e.value=n}}}})}});const s=/#([0-9A-Fa-f]{4}(?:[0-9A-Fa-f]{4})?)\b/;const a=e=>s.test(e.value);const u=/^#([0-9A-Fa-f]{4}(?:[0-9A-Fa-f]{4})?)$/;const c=(e,r)=>{if(Object(e.nodes).length){e.nodes.slice().forEach(e=>{r(e);c(e,r)})}};const l=1e5;const B=e=>e.type==="word"&&u.test(e.value);const f=e=>{const r=e.value;const t=`0x${r.length===5?r.slice(1).replace(/[0-9A-f]/g,"$&$&"):r.slice(1)}`;const n=[parseInt(t.slice(2,4),16),parseInt(t.slice(4,6),16),parseInt(t.slice(6,8),16),Math.round(parseInt(t.slice(8,10),16)/255*l)/l],o=n[0],s=n[1],a=n[2],u=n[3];const c=i.func({value:"rgba",raws:Object.assign({},e.raws)});c.append(i.paren({value:"("}));c.append(i.number({value:o}));c.append(i.comma({value:","}));c.append(i.number({value:s}));c.append(i.comma({value:","}));c.append(i.number({value:a}));c.append(i.comma({value:","}));c.append(i.number({value:u}));c.append(i.paren({value:")"}));return c};e.exports=o},8881:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(9448));var i=_interopDefault(t(5747));var o=_interopDefault(t(5622));var s=_interopDefault(t(2043));var a=t(4567);function asyncGeneratorStep(e,r,t,n,i,o,s){try{var a=e[o](s);var u=a.value}catch(e){t(e);return}if(a.done){r(u)}else{Promise.resolve(u).then(n,i)}}function _asyncToGenerator(e){return function(){var r=this,t=arguments;return new Promise(function(n,i){var o=e.apply(r,t);function _next(e){asyncGeneratorStep(o,n,i,_next,_throw,"next",e)}function _throw(e){asyncGeneratorStep(o,n,i,_next,_throw,"throw",e)}_next(undefined)})}}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=arguments[r]!=null?arguments[r]:{};var n=Object.keys(t);if(typeof Object.getOwnPropertySymbols==="function"){n=n.concat(Object.getOwnPropertySymbols(t).filter(function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))}n.forEach(function(r){_defineProperty(e,r,t[r])})}return e}function _slicedToArray(e,r){return _arrayWithHoles(e)||_iterableToArrayLimit(e,r)||_nonIterableRest()}function _toArray(e){return _arrayWithHoles(e)||_iterableToArray(e)||_nonIterableRest()}function _arrayWithHoles(e){if(Array.isArray(e))return e}function _iterableToArray(e){if(Symbol.iterator in Object(e)||Object.prototype.toString.call(e)==="[object Arguments]")return Array.from(e)}function _iterableToArrayLimit(e,r){var t=[];var n=true;var i=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){t.push(a.value);if(r&&t.length===r)break}}catch(e){i=true;o=e}finally{try{if(!n&&s["return"]!=null)s["return"]()}finally{if(i)throw o}}return t}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}function getCustomProperties(e,r){const t={};const i={};e.nodes.slice().forEach(e=>{const o=B(e)?t:f(e)?i:null;if(o){e.nodes.slice().forEach(e=>{if(p(e)){const t=e.prop;o[t]=n(e.value).parse();if(!r.preserve){e.remove()}}});if(!r.preserve&&d(e)){e.remove()}}});return _objectSpread({},t,i)}const u=/^html$/i;const c=/^:root$/i;const l=/^--[A-z][\w-]*$/;const B=e=>e.type==="rule"&&u.test(e.selector)&&Object(e.nodes).length;const f=e=>e.type==="rule"&&c.test(e.selector)&&Object(e.nodes).length;const p=e=>e.type==="decl"&&l.test(e.prop);const d=e=>Object(e.nodes).length===0;function importCustomPropertiesFromCSSAST(e){return getCustomProperties(e,{preserve:true})}function importCustomPropertiesFromCSSFile(e){return _importCustomPropertiesFromCSSFile.apply(this,arguments)}function _importCustomPropertiesFromCSSFile(){_importCustomPropertiesFromCSSFile=_asyncToGenerator(function*(e){const r=yield h(e);const t=s.parse(r,{from:e});return importCustomPropertiesFromCSSAST(t)});return _importCustomPropertiesFromCSSFile.apply(this,arguments)}function importCustomPropertiesFromObject(e){const r=Object.assign({},Object(e).customProperties||Object(e)["custom-properties"]);for(const e in r){r[e]=n(r[e]).parse()}return r}function importCustomPropertiesFromJSONFile(e){return _importCustomPropertiesFromJSONFile.apply(this,arguments)}function _importCustomPropertiesFromJSONFile(){_importCustomPropertiesFromJSONFile=_asyncToGenerator(function*(e){const r=yield v(e);return importCustomPropertiesFromObject(r)});return _importCustomPropertiesFromJSONFile.apply(this,arguments)}function importCustomPropertiesFromJSFile(e){return _importCustomPropertiesFromJSFile.apply(this,arguments)}function _importCustomPropertiesFromJSFile(){_importCustomPropertiesFromJSFile=_asyncToGenerator(function*(e){const r=yield Promise.resolve(require(e));return importCustomPropertiesFromObject(r)});return _importCustomPropertiesFromJSFile.apply(this,arguments)}function importCustomPropertiesFromSources(e){return e.map(e=>{if(e instanceof Promise){return e}else if(e instanceof Function){return e()}const r=e===Object(e)?e:{from:String(e)};if(r.customProperties||r["custom-properties"]){return r}const t=o.resolve(String(r.from||""));const n=(r.type||o.extname(t).slice(1)).toLowerCase();return{type:n,from:t}}).reduce(function(){var e=_asyncToGenerator(function*(e,r){const t=yield r,n=t.type,i=t.from;if(n==="ast"){return Object.assign(yield e,importCustomPropertiesFromCSSAST(i))}if(n==="css"){return Object.assign(yield e,yield importCustomPropertiesFromCSSFile(i))}if(n==="js"){return Object.assign(yield e,yield importCustomPropertiesFromJSFile(i))}if(n==="json"){return Object.assign(yield e,yield importCustomPropertiesFromJSONFile(i))}return Object.assign(yield e,yield importCustomPropertiesFromObject(yield r))});return function(r,t){return e.apply(this,arguments)}}(),{})}const h=e=>new Promise((r,t)=>{i.readFile(e,"utf8",(e,n)=>{if(e){t(e)}else{r(n)}})});const v=function(){var e=_asyncToGenerator(function*(e){return JSON.parse(yield h(e))});return function readJSON(r){return e.apply(this,arguments)}}();function convertDtoD(e){return e%360}function convertGtoD(e){return e*.9%360}function convertRtoD(e){return e*180/Math.PI%360}function convertTtoD(e){return e*360%360}function convertNtoRGB(e){const r={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],transparent:[0,0,0],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};return r[e]&&r[e].map(e=>e/2.55)}function convertHtoRGB(e){const r=(e.match(b)||[]).slice(1),t=_slicedToArray(r,8),n=t[0],i=t[1],o=t[2],s=t[3],a=t[4],u=t[5],c=t[6],l=t[7];if(a!==undefined||n!==undefined){const e=a!==undefined?parseInt(a,16):n!==undefined?parseInt(n+n,16):0;const r=u!==undefined?parseInt(u,16):i!==undefined?parseInt(i+i,16):0;const t=c!==undefined?parseInt(c,16):o!==undefined?parseInt(o+o,16):0;const B=l!==undefined?parseInt(l,16):s!==undefined?parseInt(s+s,16):255;return[e,r,t,B].map(e=>e/2.55)}return undefined}const b=/^#(?:([a-f0-9])([a-f0-9])([a-f0-9])([a-f0-9])?|([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})?)$/i;class Color{constructor(e){this.color=Object(Object(e).color||e);this.color.colorspace=this.color.colorspace?this.color.colorspace:"red"in e&&"green"in e&&"blue"in e?"rgb":"hue"in e&&"saturation"in e&&"lightness"in e?"hsl":"hue"in e&&"whiteness"in e&&"blackness"in e?"hwb":"unknown";if(e.colorspace==="rgb"){this.color.hue=a.rgb2hue(e.red,e.green,e.blue,e.hue||0)}}alpha(e){const r=this.color;return e===undefined?r.alpha:new Color(assign(r,{alpha:e}))}blackness(e){const r=color2hwb(this.color);return e===undefined?r.blackness:new Color(assign(r,{blackness:e}))}blend(e,r,t="rgb"){const n=this.color;return new Color(blend(n,e,r,t))}blenda(e,r,t="rgb"){const n=this.color;return new Color(blend(n,e,r,t,true))}blue(e){const r=color2rgb(this.color);return e===undefined?r.blue:new Color(assign(r,{blue:e}))}contrast(e){const r=this.color;return new Color(contrast(r,e))}green(e){const r=color2rgb(this.color);return e===undefined?r.green:new Color(assign(r,{green:e}))}hue(e){const r=color2hsl(this.color);return e===undefined?r.hue:new Color(assign(r,{hue:e}))}lightness(e){const r=color2hsl(this.color);return e===undefined?r.lightness:new Color(assign(r,{lightness:e}))}red(e){const r=color2rgb(this.color);return e===undefined?r.red:new Color(assign(r,{red:e}))}rgb(e,r,t){const n=color2rgb(this.color);return new Color(assign(n,{red:e,green:r,blue:t}))}saturation(e){const r=color2hsl(this.color);return e===undefined?r.saturation:new Color(assign(r,{saturation:e}))}shade(e){const r=color2hwb(this.color);const t={hue:0,whiteness:0,blackness:100,colorspace:"hwb"};const n="rgb";return e===undefined?r.blackness:new Color(blend(r,t,e,n))}tint(e){const r=color2hwb(this.color);const t={hue:0,whiteness:100,blackness:0,colorspace:"hwb"};const n="rgb";return e===undefined?r.blackness:new Color(blend(r,t,e,n))}whiteness(e){const r=color2hwb(this.color);return e===undefined?r.whiteness:new Color(assign(r,{whiteness:e}))}toHSL(){return color2hslString(this.color)}toHWB(){return color2hwbString(this.color)}toLegacy(){return color2legacyString(this.color)}toRGB(){return color2rgbString(this.color)}toRGBLegacy(){return color2rgbLegacyString(this.color)}toString(){return color2string(this.color)}}function blend(e,r,t,n,i){const o=t/100;const s=1-o;if(n==="hsl"){const t=color2hsl(e),n=t.hue,a=t.saturation,u=t.lightness,c=t.alpha;const l=color2hsl(r),B=l.hue,f=l.saturation,p=l.lightness,d=l.alpha;const h=n*s+B*o,v=a*s+f*o,b=u*s+p*o,C=i?c*s+d*o:c;return{hue:h,saturation:v,lightness:b,alpha:C,colorspace:"hsl"}}else if(n==="hwb"){const t=color2hwb(e),n=t.hue,a=t.whiteness,u=t.blackness,c=t.alpha;const l=color2hwb(r),B=l.hue,f=l.whiteness,p=l.blackness,d=l.alpha;const h=n*s+B*o,v=a*s+f*o,b=u*s+p*o,C=i?c*s+d*o:c;return{hue:h,whiteness:v,blackness:b,alpha:C,colorspace:"hwb"}}else{const t=color2rgb(e),n=t.red,a=t.green,u=t.blue,c=t.alpha;const l=color2rgb(r),B=l.red,f=l.green,p=l.blue,d=l.alpha;const h=n*s+B*o,v=a*s+f*o,b=u*s+p*o,C=i?c*s+d*o:c;return{red:h,green:v,blue:b,alpha:C,colorspace:"rgb"}}}function assign(e,r){const t=Object.assign({},e);Object.keys(r).forEach(n=>{const i=n==="hue";const o=!i&&C.test(n);const s=normalize(r[n],n);t[n]=s;if(o){t.hue=a.rgb2hue(t.red,t.green,t.blue,e.hue||0)}});return t}function normalize(e,r){const t=r==="hue";const n=0;const i=t?360:100;const o=Math.min(Math.max(t?e%360:e,n),i);return o}function color2rgb(e){const r=e.colorspace==="hsl"?a.hsl2rgb(e.hue,e.saturation,e.lightness):e.colorspace==="hwb"?a.hwb2rgb(e.hue,e.whiteness,e.blackness):[e.red,e.green,e.blue],t=_slicedToArray(r,3),n=t[0],i=t[1],o=t[2];return{red:n,green:i,blue:o,hue:e.hue,alpha:e.alpha,colorspace:"rgb"}}function color2hsl(e){const r=e.colorspace==="rgb"?a.rgb2hsl(e.red,e.green,e.blue,e.hue):e.colorspace==="hwb"?a.hwb2hsl(e.hue,e.whiteness,e.blackness):[e.hue,e.saturation,e.lightness],t=_slicedToArray(r,3),n=t[0],i=t[1],o=t[2];return{hue:n,saturation:i,lightness:o,alpha:e.alpha,colorspace:"hsl"}}function color2hwb(e){const r=e.colorspace==="rgb"?a.rgb2hwb(e.red,e.green,e.blue,e.hue):e.colorspace==="hsl"?a.hsl2hwb(e.hue,e.saturation,e.lightness):[e.hue,e.whiteness,e.blackness],t=_slicedToArray(r,3),n=t[0],i=t[1],o=t[2];return{hue:n,whiteness:i,blackness:o,alpha:e.alpha,colorspace:"hwb"}}function contrast(e,r){const t=color2hwb(e);const n=color2rgb(e);const i=rgb2luminance(n.red,n.green,n.blue);const o=i<.5?{hue:t.hue,whiteness:100,blackness:0,alpha:t.alpha,colorspace:"hwb"}:{hue:t.hue,whiteness:0,blackness:100,alpha:t.alpha,colorspace:"hwb"};const s=colors2contrast(e,o);const a=s>4.5?colors2contrastRatioColor(t,o):o;return blend(o,a,r,"hwb",false)}function colors2contrast(e,r){const t=color2rgb(e);const n=color2rgb(r);const i=rgb2luminance(t.red,t.green,t.blue);const o=rgb2luminance(n.red,n.green,n.blue);return i>o?(i+.05)/(o+.05):(o+.05)/(i+.05)}function rgb2luminance(e,r,t){const n=[channel2luminance(e),channel2luminance(r),channel2luminance(t)],i=n[0],o=n[1],s=n[2];const a=.2126*i+.7152*o+.0722*s;return a}function channel2luminance(e){const r=e<=.03928?e/12.92:Math.pow((e+.055)/1.055,2.4);return r}function colors2contrastRatioColor(e,r){const t=Object.assign({},e);let n=e.whiteness;let i=e.blackness;let o=r.whiteness;let s=r.blackness;while(Math.abs(n-o)>100||Math.abs(i-s)>100){const r=Math.round((o+n)/2);const a=Math.round((s+i)/2);t.whiteness=r;t.blackness=a;if(colors2contrast(t,e)>4.5){o=r;s=a}else{n=r;i=a}}return t}const C=/^(blue|green|red)$/i;function color2string(e){return e.colorspace==="hsl"?color2hslString(e):e.colorspace==="hwb"?color2hwbString(e):color2rgbString(e)}function color2hslString(e){const r=color2hsl(e);const t=r.alpha===100;const n=r.hue;const i=Math.round(r.saturation*1e10)/1e10;const o=Math.round(r.lightness*1e10)/1e10;const s=Math.round(r.alpha*1e10)/1e10;return`hsl(${n} ${i}% ${o}%${t?"":` / ${s}%`})`}function color2hwbString(e){const r=color2hwb(e);const t=r.alpha===100;const n=r.hue;const i=Math.round(r.whiteness*1e10)/1e10;const o=Math.round(r.blackness*1e10)/1e10;const s=Math.round(r.alpha*1e10)/1e10;return`hwb(${n} ${i}% ${o}%${t?"":` / ${s}%`})`}function color2rgbString(e){const r=color2rgb(e);const t=r.alpha===100;const n=Math.round(r.red*1e10)/1e10;const i=Math.round(r.green*1e10)/1e10;const o=Math.round(r.blue*1e10)/1e10;const s=Math.round(r.alpha*1e10)/1e10;return`rgb(${n}% ${i}% ${o}%${t?"":` / ${s}%`})`}function color2legacyString(e){return e.colorspace==="hsl"?color2hslLegacyString(e):color2rgbLegacyString(e)}function color2rgbLegacyString(e){const r=color2rgb(e);const t=r.alpha===100;const n=t?"rgb":"rgba";const i=Math.round(r.red*255/100);const o=Math.round(r.green*255/100);const s=Math.round(r.blue*255/100);const a=Math.round(r.alpha/100*1e10)/1e10;return`${n}(${i}, ${o}, ${s}${t?"":`, ${a}`})`}function color2hslLegacyString(e){const r=color2hsl(e);const t=r.alpha===100;const n=t?"hsl":"hsla";const i=r.hue;const o=Math.round(r.saturation*1e10)/1e10;const s=Math.round(r.lightness*1e10)/1e10;const a=Math.round(r.alpha/100*1e10)/1e10;return`${n}(${i}, ${o}%, ${s}%${t?"":`, ${a}`})`}function manageUnresolved(e,r,t,n){if("warn"===r.unresolved){r.decl.warn(r.result,n,{word:t})}else if("ignore"!==r.unresolved){throw r.decl.error(n,{word:t})}}function transformAST(e,r){e.nodes.slice(0).forEach(e=>{if(isColorModFunction(e)){if(r.transformVars){transformVariables(e,r)}const t=transformColorModFunction(e,r);if(t){e.replaceWith(n.word({raws:e.raws,value:r.stringifier(t)}))}}else if(e.nodes&&Object(e.nodes).length){transformAST(e,r)}})}function transformVariables(e,r){walk(e,e=>{if(isVariable(e)){const t=transformArgsByParams(e,[[transformWord,isComma,transformNode]]),n=_slicedToArray(t,2),i=n[0],o=n[1];if(i in r.customProperties){let t=r.customProperties[i];if(L.test(t)){const e=t.clone();transformVariables(e,r);t=e}if(t.nodes.length===1&&t.nodes[0].nodes.length){t.nodes[0].nodes.forEach(r=>{e.parent.insertBefore(e,r)})}e.remove()}else if(o&&o.nodes.length===1&&o.nodes[0].nodes.length){transformVariables(o,r);e.replaceWith(...o.nodes[0].nodes[0])}}})}function transformColor(e,r){if(isRGBFunction(e)){return transformRGBFunction(e,r)}else if(isHSLFunction(e)){return transformHSLFunction(e,r)}else if(isHWBFunction(e)){return transformHWBFunction(e,r)}else if(isColorModFunction(e)){return transformColorModFunction(e,r)}else if(isHexColor(e)){return transformHexColor(e,r)}else if(isNamedColor(e)){return transformNamedColor(e,r)}else{return manageUnresolved(e,r,e.value,`Expected a color`)}}function transformRGBFunction(e,r){const t=transformArgsByParams(e,[[transformPercentage,transformPercentage,transformPercentage,isSlash,transformAlpha],[transformRGBNumber,transformRGBNumber,transformRGBNumber,isSlash,transformAlpha],[transformPercentage,isComma,transformPercentage,isComma,transformPercentage,isComma,transformAlpha],[transformRGBNumber,isComma,transformRGBNumber,isComma,transformRGBNumber,isComma,transformAlpha]]),n=_slicedToArray(t,4),i=n[0],o=n[1],s=n[2],a=n[3],u=a===void 0?100:a;if(i!==undefined){const e=new Color({red:i,green:o,blue:s,alpha:u,colorspace:"rgb"});return e}else{return manageUnresolved(e,r,e.value,`Expected a valid rgb() function`)}}function transformHSLFunction(e,r){const t=transformArgsByParams(e,[[transformHue,transformPercentage,transformPercentage,isSlash,transformAlpha],[transformHue,isComma,transformPercentage,isComma,transformPercentage,isComma,transformAlpha]]),n=_slicedToArray(t,4),i=n[0],o=n[1],s=n[2],a=n[3],u=a===void 0?100:a;if(s!==undefined){const e=new Color({hue:i,saturation:o,lightness:s,alpha:u,colorspace:"hsl"});return e}else{return manageUnresolved(e,r,e.value,`Expected a valid hsl() function`)}}function transformHWBFunction(e,r){const t=transformArgsByParams(e,[[transformHue,transformPercentage,transformPercentage,isSlash,transformAlpha]]),n=_slicedToArray(t,4),i=n[0],o=n[1],s=n[2],a=n[3],u=a===void 0?100:a;if(s!==undefined){const e=new Color({hue:i,whiteness:o,blackness:s,alpha:u,colorspace:"hwb"});return e}else{return manageUnresolved(e,r,e.value,`Expected a valid hwb() function`)}}function transformColorModFunction(e,r){const t=(e.nodes||[]).slice(1,-1)||[],n=_toArray(t),i=n[0],o=n.slice(1);if(i!==undefined){const t=isHue(i)?new Color({hue:transformHue(i,r),saturation:100,lightness:50,alpha:100,colorspace:"hsl"}):transformColor(i,r);if(t){const e=transformColorByAdjusters(t,o,r);return e}else{return manageUnresolved(e,r,e.value,`Expected a valid color`)}}else{return manageUnresolved(e,r,e.value,`Expected a valid color-mod() function`)}}function transformHexColor(e,r){if(P.test(e.value)){const r=convertHtoRGB(e.value),t=_slicedToArray(r,4),n=t[0],i=t[1],o=t[2],s=t[3];const a=new Color({red:n,green:i,blue:o,alpha:s});return a}else{return manageUnresolved(e,r,e.value,`Expected a valid hex color`)}}function transformNamedColor(e,r){if(isNamedColor(e)){const r=convertNtoRGB(e.value),t=_slicedToArray(r,3),n=t[0],i=t[1],o=t[2];const s=new Color({red:n,green:i,blue:o,alpha:100,colorspace:"rgb"});return s}else{return manageUnresolved(e,r,e.value,`Expected a valid named-color`)}}function transformColorByAdjusters(e,r,t){const n=r.reduce((e,r)=>{if(isAlphaBlueGreenRedAdjuster(r)){return transformAlphaBlueGreenRedAdjuster(e,r,t)}else if(isRGBAdjuster(r)){return transformRGBAdjuster(e,r,t)}else if(isHueAdjuster(r)){return transformHueAdjuster(e,r,t)}else if(isBlacknessLightnessSaturationWhitenessAdjuster(r)){return transformBlacknessLightnessSaturationWhitenessAdjuster(e,r,t)}else if(isShadeTintAdjuster(r)){return transformShadeTintAdjuster(e,r,t)}else if(isBlendAdjuster(r)){return transformBlendAdjuster(e,r,r.value==="blenda",t)}else if(isContrastAdjuster(r)){return transformContrastAdjuster(e,r,t)}else{manageUnresolved(r,t,r.value,`Expected a valid color adjuster`);return e}},e);return n}function transformAlphaBlueGreenRedAdjuster(e,r,t){const n=transformArgsByParams(r,g.test(r.value)?[[transformMinusPlusOperator,transformAlpha],[transformTimesOperator,transformPercentage],[transformAlpha]]:[[transformMinusPlusOperator,transformPercentage],[transformMinusPlusOperator,transformRGBNumber],[transformTimesOperator,transformPercentage],[transformPercentage],[transformRGBNumber]]),i=_slicedToArray(n,2),o=i[0],s=i[1];if(o!==undefined){const t=r.value.toLowerCase().replace(g,"alpha");const n=e[t]();const i=s!==undefined?o==="+"?n+Number(s):o==="-"?n-Number(s):o==="*"?n*Number(s):Number(s):Number(o);const a=e[t](i);return a}else{return manageUnresolved(r,t,r.value,`Expected a valid modifier()`)}}function transformRGBAdjuster(e,r,t){const n=transformArgsByParams(r,[[transformMinusPlusOperator,transformPercentage,transformPercentage,transformPercentage],[transformMinusPlusOperator,transformRGBNumber,transformRGBNumber,transformRGBNumber],[transformMinusPlusOperator,transformHexColor],[transformTimesOperator,transformPercentage]]),i=_slicedToArray(n,4),o=i[0],s=i[1],a=i[2],u=i[3];if(s!==undefined&&s.color){const r=e.rgb(o==="+"?e.red()+s.red():e.red()-s.red(),o==="+"?e.green()+s.green():e.green()-s.green(),o==="+"?e.blue()+s.blue():e.blue()-s.blue());return r}else if(o!==undefined&&T.test(o)){const r=e.rgb(o==="+"?e.red()+s:e.red()-s,o==="+"?e.green()+a:e.green()-a,o==="+"?e.blue()+u:e.blue()-u);return r}else if(o!==undefined&&s!==undefined){const r=e.rgb(e.red()*s,e.green()*s,e.blue()*s);return r}else{return manageUnresolved(r,t,r.value,`Expected a valid rgb() adjuster`)}}function transformBlendAdjuster(e,r,t,n){const i=transformArgsByParams(r,[[transformColor,transformPercentage,transformColorSpace]]),o=_slicedToArray(i,3),s=o[0],a=o[1],u=o[2],c=u===void 0?"rgb":u;if(a!==undefined){const r=t?e.blenda(s.color,a,c):e.blend(s.color,a,c);return r}else{return manageUnresolved(r,n,r.value,`Expected a valid blend() adjuster)`)}}function transformContrastAdjuster(e,r,t){const n=transformArgsByParams(r,[[transformPercentage]]),i=_slicedToArray(n,1),o=i[0];if(o!==undefined){const r=e.contrast(o);return r}else{return manageUnresolved(r,t,r.value,`Expected a valid contrast() adjuster)`)}}function transformHueAdjuster(e,r,t){const n=transformArgsByParams(r,[[transformMinusPlusTimesOperator,transformHue],[transformHue]]),i=_slicedToArray(n,2),o=i[0],s=i[1];if(o!==undefined){const r=e.hue();const t=s!==undefined?o==="+"?r+Number(s):o==="-"?r-Number(s):o==="*"?r*Number(s):Number(s):Number(o);return e.hue(t)}else{return manageUnresolved(r,t,r.value,`Expected a valid hue() function)`)}}function transformBlacknessLightnessSaturationWhitenessAdjuster(e,r,t){const n=r.value.toLowerCase().replace(/^b$/,"blackness").replace(/^l$/,"lightness").replace(/^s$/,"saturation").replace(/^w$/,"whiteness");const i=transformArgsByParams(r,[[transformMinusPlusTimesOperator,transformPercentage],[transformPercentage]]),o=_slicedToArray(i,2),s=o[0],a=o[1];if(s!==undefined){const r=e[n]();const t=a!==undefined?s==="+"?r+Number(a):s==="-"?r-Number(a):s==="*"?r*Number(a):Number(a):Number(s);return e[n](t)}else{return manageUnresolved(r,t,r.value,`Expected a valid ${n}() function)`)}}function transformShadeTintAdjuster(e,r,t){const n=r.value.toLowerCase();const i=transformArgsByParams(r,[[transformPercentage]]),o=_slicedToArray(i,1),s=o[0];if(s!==undefined){const r=Number(s);return e[n](r)}else{return manageUnresolved(r,t,r.value,`Expected valid ${n}() arguments`)}}function transformColorSpace(e,r){if(isColorSpace(e)){return e.value}else{return manageUnresolved(e,r,e.value,`Expected a valid color space)`)}}function transformAlpha(e,r){if(isNumber(e)){return e.value*100}else if(isPercentage(e)){return transformPercentage(e,r)}else{return manageUnresolved(e,r,e.value,`Expected a valid alpha value)`)}}function transformRGBNumber(e,r){if(isNumber(e)){return e.value/2.55}else{return manageUnresolved(e,r,e.value,`Expected a valid RGB value)`)}}function transformHue(e,r){if(isHue(e)){const r=e.unit.toLowerCase();if(r==="grad"){return convertGtoD(e.value)}else if(r==="rad"){return convertRtoD(e.value)}else if(r==="turn"){return convertTtoD(e.value)}else{return convertDtoD(e.value)}}else{return manageUnresolved(e,r,e.value,`Expected a valid hue`)}}function transformPercentage(e,r){if(isPercentage(e)){return Number(e.value)}else{return manageUnresolved(e,r,e.value,`Expected a valid hue`)}}function transformMinusPlusOperator(e,r){if(isMinusPlusOperator(e)){return e.value}else{return manageUnresolved(e,r,e.value,`Expected a plus or minus operator`)}}function transformTimesOperator(e,r){if(isTimesOperator(e)){return e.value}else{return manageUnresolved(e,r,e.value,`Expected a times operator`)}}function transformMinusPlusTimesOperator(e,r){if(isMinusPlusTimesOperator(e)){return e.value}else{return manageUnresolved(e,r,e.value,`Expected a plus, minus, or times operator`)}}function transformWord(e,r){if(isWord(e)){return e.value}else{return manageUnresolved(e,r,e.value,`Expected a valid word`)}}function transformNode(e){return Object(e)}function transformArgsByParams(e,r){const t=(e.nodes||[]).slice(1,-1);const n={unresolved:"ignore"};return r.map(e=>t.map((r,t)=>typeof e[t]==="function"?e[t](r,n):undefined).filter(e=>typeof e!=="boolean")).filter(e=>e.every(e=>e!==undefined))[0]||[]}function walk(e,r){r(e);if(Object(e.nodes).length){e.nodes.slice().forEach(e=>{walk(e,r)})}}function isVariable(e){return Object(e).type==="func"&&M.test(e.value)}function isAlphaBlueGreenRedAdjuster(e){return Object(e).type==="func"&&m.test(e.value)}function isRGBAdjuster(e){return Object(e).type==="func"&&E.test(e.value)}function isHueAdjuster(e){return Object(e).type==="func"&&F.test(e.value)}function isBlacknessLightnessSaturationWhitenessAdjuster(e){return Object(e).type==="func"&&y.test(e.value)}function isShadeTintAdjuster(e){return Object(e).type==="func"&&I.test(e.value)}function isBlendAdjuster(e){return Object(e).type==="func"&&w.test(e.value)}function isContrastAdjuster(e){return Object(e).type==="func"&&O.test(e.value)}function isRGBFunction(e){return Object(e).type==="func"&&R.test(e.value)}function isHSLFunction(e){return Object(e).type==="func"&&k.test(e.value)}function isHWBFunction(e){return Object(e).type==="func"&&j.test(e.value)}function isColorModFunction(e){return Object(e).type==="func"&&S.test(e.value)}function isNamedColor(e){return Object(e).type==="word"&&Boolean(convertNtoRGB(e.value))}function isHexColor(e){return Object(e).type==="word"&&P.test(e.value)}function isColorSpace(e){return Object(e).type==="word"&&x.test(e.value)}function isHue(e){return Object(e).type==="number"&&A.test(e.unit)}function isComma(e){return Object(e).type==="comma"}function isSlash(e){return Object(e).type==="operator"&&e.value==="/"}function isNumber(e){return Object(e).type==="number"&&e.unit===""}function isMinusPlusOperator(e){return Object(e).type==="operator"&&T.test(e.value)}function isMinusPlusTimesOperator(e){return Object(e).type==="operator"&&D.test(e.value)}function isTimesOperator(e){return Object(e).type==="operator"&&G.test(e.value)}function isPercentage(e){return Object(e).type==="number"&&(e.unit==="%"||e.value==="0")}function isWord(e){return Object(e).type==="word"}const g=/^a(lpha)?$/i;const m=/^(a(lpha)?|blue|green|red)$/i;const y=/^(b(lackness)?|l(ightness)?|s(aturation)?|w(hiteness)?)$/i;const w=/^blenda?$/i;const S=/^color-mod$/i;const x=/^(hsl|hwb|rgb)$/i;const O=/^contrast$/i;const P=/^#(?:([a-f0-9])([a-f0-9])([a-f0-9])([a-f0-9])?|([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})?)$/i;const k=/^hsla?$/i;const A=/^(deg|grad|rad|turn)?$/i;const F=/^h(ue)?$/i;const j=/^hwb$/i;const T=/^[+-]$/;const D=/^[*+-]$/;const E=/^rgb$/i;const R=/^rgba?$/i;const I=/^(shade|tint)$/i;const M=/^var$/i;const L=/(^|[^\w-])var\(/i;const G=/^[*]$/;var N=s.plugin("postcss-color-mod-function",e=>{const r=String(Object(e).unresolved||"throw").toLowerCase();const t=Object(e).stringifier||(e=>e.toLegacy());const i=[].concat(Object(e).importFrom||[]);const o="transformVars"in Object(e)?e.transformVars:true;const s=importCustomPropertiesFromSources(i);return function(){var e=_asyncToGenerator(function*(e,i){const a=Object.assign(yield s,getCustomProperties(e,{preserve:true}));e.walkDecls(e=>{const s=e.value;if(J.test(s)){const u=n(s,{loose:true}).parse();transformAST(u,{unresolved:r,stringifier:t,transformVars:o,decl:e,result:i,customProperties:a});const c=u.toString();if(s!==c){e.value=c}}})});return function(r,t){return e.apply(this,arguments)}}()});const J=/(^|[^\w-])color-mod\(/i;e.exports=N},9971:(e,r,t)=>{const n=t(2043);const i=t(9448);const o="#639";const s=/(^|[^\w-])rebeccapurple([^\w-]|$)/;e.exports=n.plugin("postcss-color-rebeccapurple",()=>e=>{e.walkDecls(e=>{const r=e.value;if(r&&s.test(r)){const t=i(r).parse();t.walk(e=>{if(e.type==="word"&&e.value==="rebeccapurple"){e.value=o}});e.value=t.toString()}})})},4731:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));var i=_interopDefault(t(5747));var o=_interopDefault(t(5622));function asyncGeneratorStep(e,r,t,n,i,o,s){try{var a=e[o](s);var u=a.value}catch(e){t(e);return}if(a.done){r(u)}else{Promise.resolve(u).then(n,i)}}function _asyncToGenerator(e){return function(){var r=this,t=arguments;return new Promise(function(n,i){var o=e.apply(r,t);function _next(e){asyncGeneratorStep(o,n,i,_next,_throw,"next",e)}function _throw(e){asyncGeneratorStep(o,n,i,_next,_throw,"throw",e)}_next(undefined)})}}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=arguments[r]!=null?arguments[r]:{};var n=Object.keys(t);if(typeof Object.getOwnPropertySymbols==="function"){n=n.concat(Object.getOwnPropertySymbols(t).filter(function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))}n.forEach(function(r){_defineProperty(e,r,t[r])})}return e}function _slicedToArray(e,r){return _arrayWithHoles(e)||_iterableToArrayLimit(e,r)||_nonIterableRest()}function _arrayWithHoles(e){if(Array.isArray(e))return e}function _iterableToArrayLimit(e,r){var t=[];var n=true;var i=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){t.push(a.value);if(r&&t.length===r)break}}catch(e){i=true;o=e}finally{try{if(!n&&s["return"]!=null)s["return"]()}finally{if(i)throw o}}return t}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}function parse(e,r){const t=[];let n="";let i=false;let o=0;let s=-1;while(++s<e.length){const a=e[s];if(a==="("){o+=1}else if(a===")"){if(o>0){o-=1}}else if(o===0){if(r&&p.test(n+a)){i=true}else if(!r&&a===","){i=true}}if(i){t.push(r?new MediaExpression(n+a):new MediaQuery(n));n="";i=false}else{n+=a}}if(n!==""){t.push(r?new MediaExpression(n):new MediaQuery(n))}return t}class MediaQueryList{constructor(e){this.nodes=parse(e)}invert(){this.nodes.forEach(e=>{e.invert()});return this}clone(){return new MediaQueryList(String(this))}toString(){return this.nodes.join(",")}}class MediaQuery{constructor(e){const r=e.match(d),t=_slicedToArray(r,4),n=t[1],i=t[2],o=t[3];const s=i.match(h)||[],a=_slicedToArray(s,9),u=a[1],c=u===void 0?"":u,l=a[2],B=l===void 0?" ":l,f=a[3],p=f===void 0?"":f,v=a[4],b=v===void 0?"":v,C=a[5],g=C===void 0?"":C,m=a[6],y=m===void 0?"":m,w=a[7],S=w===void 0?"":w,x=a[8],O=x===void 0?"":x;const P={before:n,after:o,afterModifier:B,originalModifier:c||"",beforeAnd:b,and:g,beforeExpression:y};const k=parse(S||O,true);Object.assign(this,{modifier:c,type:p,raws:P,nodes:k})}clone(e){const r=new MediaQuery(String(this));Object.assign(r,e);return r}invert(){this.modifier=this.modifier?"":this.raws.originalModifier;return this}toString(){const e=this.raws;return`${e.before}${this.modifier}${this.modifier?`${e.afterModifier}`:""}${this.type}${e.beforeAnd}${e.and}${e.beforeExpression}${this.nodes.join("")}${this.raws.after}`}}class MediaExpression{constructor(e){const r=e.match(p)||[null,e],t=_slicedToArray(r,5),n=t[1],i=t[2],o=i===void 0?"":i,s=t[3],a=s===void 0?"":s,u=t[4],c=u===void 0?"":u;const l={after:o,and:a,afterAnd:c};Object.assign(this,{value:n,raws:l})}clone(e){const r=new MediaExpression(String(this));Object.assign(r,e);return r}toString(){const e=this.raws;return`${this.value}${e.after}${e.and}${e.afterAnd}`}}const s="(not|only)";const a="(all|print|screen|speech)";const u="([\\W\\w]*)";const c="([\\W\\w]+)";const l="(\\s*)";const B="(\\s+)";const f="(?:(\\s+)(and))";const p=new RegExp(`^${c}(?:${f}${B})$`,"i");const d=new RegExp(`^${l}${u}${l}$`);const h=new RegExp(`^(?:${s}${B})?(?:${a}(?:${f}${B}${c})?|${c})$`,"i");var v=e=>new MediaQueryList(e);var b=(e,r)=>{const t={};e.nodes.slice().forEach(e=>{if(m(e)){const n=e.params.match(g),i=_slicedToArray(n,3),o=i[1],s=i[2];t[o]=v(s);if(!Object(r).preserve){e.remove()}}});return t};const C=/^custom-media$/i;const g=/^(--[A-z][\w-]*)\s+([\W\w]+)\s*$/;const m=e=>e.type==="atrule"&&C.test(e.name)&&g.test(e.params);function getCustomMediaFromCSSFile(e){return _getCustomMediaFromCSSFile.apply(this,arguments)}function _getCustomMediaFromCSSFile(){_getCustomMediaFromCSSFile=_asyncToGenerator(function*(e){const r=yield y(e);const t=n.parse(r,{from:e});return b(t,{preserve:true})});return _getCustomMediaFromCSSFile.apply(this,arguments)}function getCustomMediaFromObject(e){const r=Object.assign({},Object(e).customMedia,Object(e)["custom-media"]);for(const e in r){r[e]=v(r[e])}return r}function getCustomMediaFromJSONFile(e){return _getCustomMediaFromJSONFile.apply(this,arguments)}function _getCustomMediaFromJSONFile(){_getCustomMediaFromJSONFile=_asyncToGenerator(function*(e){const r=yield w(e);return getCustomMediaFromObject(r)});return _getCustomMediaFromJSONFile.apply(this,arguments)}function getCustomMediaFromJSFile(e){return _getCustomMediaFromJSFile.apply(this,arguments)}function _getCustomMediaFromJSFile(){_getCustomMediaFromJSFile=_asyncToGenerator(function*(e){const r=yield Promise.resolve(require(e));return getCustomMediaFromObject(r)});return _getCustomMediaFromJSFile.apply(this,arguments)}function getCustomMediaFromSources(e){return e.map(e=>{if(e instanceof Promise){return e}else if(e instanceof Function){return e()}const r=e===Object(e)?e:{from:String(e)};if(Object(r).customMedia||Object(r)["custom-media"]){return r}const t=o.resolve(String(r.from||""));const n=(r.type||o.extname(t).slice(1)).toLowerCase();return{type:n,from:t}}).reduce(function(){var e=_asyncToGenerator(function*(e,r){const t=yield r,n=t.type,i=t.from;if(n==="css"||n==="pcss"){return Object.assign(yield e,yield getCustomMediaFromCSSFile(i))}if(n==="js"){return Object.assign(yield e,yield getCustomMediaFromJSFile(i))}if(n==="json"){return Object.assign(yield e,yield getCustomMediaFromJSONFile(i))}return Object.assign(yield e,getCustomMediaFromObject(yield r))});return function(r,t){return e.apply(this,arguments)}}(),{})}const y=e=>new Promise((r,t)=>{i.readFile(e,"utf8",(e,n)=>{if(e){t(e)}else{r(n)}})});const w=function(){var e=_asyncToGenerator(function*(e){return JSON.parse(yield y(e))});return function readJSON(r){return e.apply(this,arguments)}}();function transformMediaList(e,r){let t=e.nodes.length-1;while(t>=0){const n=transformMedia(e.nodes[t],r);if(n.length){e.nodes.splice(t,1,...n)}--t}return e}function transformMedia(e,r){const t=[];for(const u in e.nodes){const c=e.nodes[u],l=c.value,B=c.nodes;const f=l.replace(S,"$1");if(f in r){var n=true;var i=false;var o=undefined;try{for(var s=r[f].nodes[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){const n=a.value;const i=e.modifier!==n.modifier?e.modifier||n.modifier:"";const o=e.clone({modifier:i,raws:!i||e.modifier?_objectSpread({},e.raws):_objectSpread({},n.raws),type:e.type||n.type});if(o.type===n.type){Object.assign(o.raws,{and:n.raws.and,beforeAnd:n.raws.beforeAnd,beforeExpression:n.raws.beforeExpression})}o.nodes.splice(u,1,...n.clone().nodes.map(r=>{if(e.nodes[u].raws.and){r.raws=_objectSpread({},e.nodes[u].raws)}r.spaces=_objectSpread({},e.nodes[u].spaces);return r}));const s=x(r,f);const c=transformMedia(o,s);if(c.length){t.push(...c)}else{t.push(o)}}}catch(e){i=true;o=e}finally{try{if(!n&&s.return!=null){s.return()}}finally{if(i){throw o}}}return t}else if(B&&B.length){transformMediaList(e.nodes[u],r)}}return t}const S=/\((--[A-z][\w-]*)\)/;const x=(e,r)=>{const t=Object.assign({},e);delete t[r];return t};var O=(e,r,t)=>{e.walkAtRules(P,e=>{if(k.test(e.params)){const n=v(e.params);const i=String(transformMediaList(n,r));if(t.preserve){e.cloneBefore({params:i})}else{e.params=i}}})};const P=/^media$/i;const k=/\(--[A-z][\w-]*\)/;function writeCustomMediaToCssFile(e,r){return _writeCustomMediaToCssFile.apply(this,arguments)}function _writeCustomMediaToCssFile(){_writeCustomMediaToCssFile=_asyncToGenerator(function*(e,r){const t=Object.keys(r).reduce((e,t)=>{e.push(`@custom-media ${t} ${r[t]};`);return e},[]).join("\n");const n=`${t}\n`;yield F(e,n)});return _writeCustomMediaToCssFile.apply(this,arguments)}function writeCustomMediaToJsonFile(e,r){return _writeCustomMediaToJsonFile.apply(this,arguments)}function _writeCustomMediaToJsonFile(){_writeCustomMediaToJsonFile=_asyncToGenerator(function*(e,r){const t=JSON.stringify({"custom-media":r},null,"  ");const n=`${t}\n`;yield F(e,n)});return _writeCustomMediaToJsonFile.apply(this,arguments)}function writeCustomMediaToCjsFile(e,r){return _writeCustomMediaToCjsFile.apply(this,arguments)}function _writeCustomMediaToCjsFile(){_writeCustomMediaToCjsFile=_asyncToGenerator(function*(e,r){const t=Object.keys(r).reduce((e,t)=>{e.push(`\t\t'${j(t)}': '${j(r[t])}'`);return e},[]).join(",\n");const n=`module.exports = {\n\tcustomMedia: {\n${t}\n\t}\n};\n`;yield F(e,n)});return _writeCustomMediaToCjsFile.apply(this,arguments)}function writeCustomMediaToMjsFile(e,r){return _writeCustomMediaToMjsFile.apply(this,arguments)}function _writeCustomMediaToMjsFile(){_writeCustomMediaToMjsFile=_asyncToGenerator(function*(e,r){const t=Object.keys(r).reduce((e,t)=>{e.push(`\t'${j(t)}': '${j(r[t])}'`);return e},[]).join(",\n");const n=`export const customMedia = {\n${t}\n};\n`;yield F(e,n)});return _writeCustomMediaToMjsFile.apply(this,arguments)}function writeCustomMediaToExports(e,r){return Promise.all(r.map(function(){var r=_asyncToGenerator(function*(r){if(r instanceof Function){yield r(A(e))}else{const t=r===Object(r)?r:{to:String(r)};const n=t.toJSON||A;if("customMedia"in t){t.customMedia=n(e)}else if("custom-media"in t){t["custom-media"]=n(e)}else{const r=String(t.to||"");const i=(t.type||o.extname(r).slice(1)).toLowerCase();const s=n(e);if(i==="css"){yield writeCustomMediaToCssFile(r,s)}if(i==="js"){yield writeCustomMediaToCjsFile(r,s)}if(i==="json"){yield writeCustomMediaToJsonFile(r,s)}if(i==="mjs"){yield writeCustomMediaToMjsFile(r,s)}}}});return function(e){return r.apply(this,arguments)}}()))}const A=e=>{return Object.keys(e).reduce((r,t)=>{r[t]=String(e[t]);return r},{})};const F=(e,r)=>new Promise((t,n)=>{i.writeFile(e,r,e=>{if(e){n(e)}else{t()}})});const j=e=>e.replace(/\\([\s\S])|(')/g,"\\$1$2").replace(/\n/g,"\\n").replace(/\r/g,"\\r");var T=n.plugin("postcss-custom-media",e=>{const r="preserve"in Object(e)?Boolean(e.preserve):false;const t=[].concat(Object(e).importFrom||[]);const n=[].concat(Object(e).exportTo||[]);const i=getCustomMediaFromSources(t);return function(){var e=_asyncToGenerator(function*(e){const t=Object.assign(yield i,b(e,{preserve:r}));yield writeCustomMediaToExports(t,n);O(e,t,{preserve:r})});return function(r){return e.apply(this,arguments)}}()});e.exports=T},8713:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));var i=_interopDefault(t(9448));var o=_interopDefault(t(5747));var s=_interopDefault(t(5622));function asyncGeneratorStep(e,r,t,n,i,o,s){try{var a=e[o](s);var u=a.value}catch(e){t(e);return}if(a.done){r(u)}else{Promise.resolve(u).then(n,i)}}function _asyncToGenerator(e){return function(){var r=this,t=arguments;return new Promise(function(n,i){var o=e.apply(r,t);function _next(e){asyncGeneratorStep(o,n,i,_next,_throw,"next",e)}function _throw(e){asyncGeneratorStep(o,n,i,_next,_throw,"throw",e)}_next(undefined)})}}function parse(e){return i(e).parse()}function isBlockIgnored(e){var r=e.selector?e:e.parent;return/(!\s*)?postcss-custom-properties:\s*off\b/i.test(r.toString())}function isRuleIgnored(e){var r=e.prev();return Boolean(isBlockIgnored(e)||r&&r.type==="comment"&&/(!\s*)?postcss-custom-properties:\s*ignore\s+next\b/i.test(r.text))}function getCustomPropertiesFromRoot(e,r){const t={};const n={};e.nodes.slice().forEach(e=>{const i=l(e)?t:B(e)?n:null;if(i){e.nodes.slice().forEach(e=>{if(f(e)&&!isBlockIgnored(e)){const t=e.prop;i[t]=parse(e.value).nodes;if(!r.preserve){e.remove()}}});if(!r.preserve&&p(e)&&!isBlockIgnored(e)){e.remove()}}});return Object.assign({},t,n)}const a=/^html$/i;const u=/^:root$/i;const c=/^--[A-z][\w-]*$/;const l=e=>e.type==="rule"&&a.test(e.selector)&&Object(e.nodes).length;const B=e=>e.type==="rule"&&u.test(e.selector)&&Object(e.nodes).length;const f=e=>e.type==="decl"&&c.test(e.prop);const p=e=>Object(e.nodes).length===0;function getCustomPropertiesFromCSSFile(e){return _getCustomPropertiesFromCSSFile.apply(this,arguments)}function _getCustomPropertiesFromCSSFile(){_getCustomPropertiesFromCSSFile=_asyncToGenerator(function*(e){const r=yield d(e);const t=n.parse(r,{from:e});return getCustomPropertiesFromRoot(t,{preserve:true})});return _getCustomPropertiesFromCSSFile.apply(this,arguments)}function getCustomPropertiesFromObject(e){const r=Object.assign({},Object(e).customProperties,Object(e)["custom-properties"]);for(const e in r){r[e]=parse(String(r[e])).nodes}return r}function getCustomPropertiesFromJSONFile(e){return _getCustomPropertiesFromJSONFile.apply(this,arguments)}function _getCustomPropertiesFromJSONFile(){_getCustomPropertiesFromJSONFile=_asyncToGenerator(function*(e){const r=yield h(e);return getCustomPropertiesFromObject(r)});return _getCustomPropertiesFromJSONFile.apply(this,arguments)}function getCustomPropertiesFromJSFile(e){return _getCustomPropertiesFromJSFile.apply(this,arguments)}function _getCustomPropertiesFromJSFile(){_getCustomPropertiesFromJSFile=_asyncToGenerator(function*(e){const r=yield Promise.resolve(require(e));return getCustomPropertiesFromObject(r)});return _getCustomPropertiesFromJSFile.apply(this,arguments)}function getCustomPropertiesFromImports(e){return e.map(e=>{if(e instanceof Promise){return e}else if(e instanceof Function){return e()}const r=e===Object(e)?e:{from:String(e)};if(r.customProperties||r["custom-properties"]){return r}const t=s.resolve(String(r.from||""));const n=(r.type||s.extname(t).slice(1)).toLowerCase();return{type:n,from:t}}).reduce(function(){var e=_asyncToGenerator(function*(e,r){const t=yield r,n=t.type,i=t.from;if(n==="css"){return Object.assign(yield e,yield getCustomPropertiesFromCSSFile(i))}if(n==="js"){return Object.assign(yield e,yield getCustomPropertiesFromJSFile(i))}if(n==="json"){return Object.assign(yield e,yield getCustomPropertiesFromJSONFile(i))}return Object.assign(yield e,yield getCustomPropertiesFromObject(yield r))});return function(r,t){return e.apply(this,arguments)}}(),{})}const d=e=>new Promise((r,t)=>{o.readFile(e,"utf8",(e,n)=>{if(e){t(e)}else{r(n)}})});const h=function(){var e=_asyncToGenerator(function*(e){return JSON.parse(yield d(e))});return function readJSON(r){return e.apply(this,arguments)}}();function transformValueAST(e,r){if(e.nodes&&e.nodes.length){e.nodes.slice().forEach(t=>{if(b(t)){const n=t.nodes.slice(1,-1),i=n[0],o=n[1],s=n.slice(2);const a=i.value;if(a in Object(r)){const e=C(r[a],t.raws.before);t.replaceWith(...e);retransformValueAST({nodes:e},r,a)}else if(s.length){const n=e.nodes.indexOf(t);if(n!==-1){e.nodes.splice(n,1,...C(s,t.raws.before))}transformValueAST(e,r)}}else{transformValueAST(t,r)}})}return e}function retransformValueAST(e,r,t){const n=Object.assign({},r);delete n[t];return transformValueAST(e,n)}const v=/^var$/i;const b=e=>e.type==="func"&&v.test(e.value)&&Object(e.nodes).length>0;const C=(e,r)=>{const t=g(e,null);if(t[0]){t[0].raws.before=r}return t};const g=(e,r)=>e.map(e=>m(e,r));const m=(e,r)=>{const t=new e.constructor(e);for(const n in e){if(n==="parent"){t.parent=r}else if(Object(e[n]).constructor===Array){t[n]=g(e.nodes,t)}else if(Object(e[n]).constructor===Object){t[n]=Object.assign({},e[n])}}return t};var y=(e,r,t)=>{e.walkDecls(e=>{if(x(e)&&!isRuleIgnored(e)){const n=e.value;const i=parse(n);const o=String(transformValueAST(i,r));if(o!==n){if(t.preserve){e.cloneBefore({value:o})}else{e.value=o}}}})};const w=/^--[A-z][\w-]*$/;const S=/(^|[^\w-])var\([\W\w]+\)/;const x=e=>!w.test(e.prop)&&S.test(e.value);function writeCustomPropertiesToCssFile(e,r){return _writeCustomPropertiesToCssFile.apply(this,arguments)}function _writeCustomPropertiesToCssFile(){_writeCustomPropertiesToCssFile=_asyncToGenerator(function*(e,r){const t=Object.keys(r).reduce((e,t)=>{e.push(`\t${t}: ${r[t]};`);return e},[]).join("\n");const n=`:root {\n${t}\n}\n`;yield P(e,n)});return _writeCustomPropertiesToCssFile.apply(this,arguments)}function writeCustomPropertiesToJsonFile(e,r){return _writeCustomPropertiesToJsonFile.apply(this,arguments)}function _writeCustomPropertiesToJsonFile(){_writeCustomPropertiesToJsonFile=_asyncToGenerator(function*(e,r){const t=JSON.stringify({"custom-properties":r},null,"  ");const n=`${t}\n`;yield P(e,n)});return _writeCustomPropertiesToJsonFile.apply(this,arguments)}function writeCustomPropertiesToCjsFile(e,r){return _writeCustomPropertiesToCjsFile.apply(this,arguments)}function _writeCustomPropertiesToCjsFile(){_writeCustomPropertiesToCjsFile=_asyncToGenerator(function*(e,r){const t=Object.keys(r).reduce((e,t)=>{e.push(`\t\t'${k(t)}': '${k(r[t])}'`);return e},[]).join(",\n");const n=`module.exports = {\n\tcustomProperties: {\n${t}\n\t}\n};\n`;yield P(e,n)});return _writeCustomPropertiesToCjsFile.apply(this,arguments)}function writeCustomPropertiesToMjsFile(e,r){return _writeCustomPropertiesToMjsFile.apply(this,arguments)}function _writeCustomPropertiesToMjsFile(){_writeCustomPropertiesToMjsFile=_asyncToGenerator(function*(e,r){const t=Object.keys(r).reduce((e,t)=>{e.push(`\t'${k(t)}': '${k(r[t])}'`);return e},[]).join(",\n");const n=`export const customProperties = {\n${t}\n};\n`;yield P(e,n)});return _writeCustomPropertiesToMjsFile.apply(this,arguments)}function writeCustomPropertiesToExports(e,r){return Promise.all(r.map(function(){var r=_asyncToGenerator(function*(r){if(r instanceof Function){yield r(O(e))}else{const t=r===Object(r)?r:{to:String(r)};const n=t.toJSON||O;if("customProperties"in t){t.customProperties=n(e)}else if("custom-properties"in t){t["custom-properties"]=n(e)}else{const r=String(t.to||"");const i=(t.type||s.extname(t.to).slice(1)).toLowerCase();const o=n(e);if(i==="css"){yield writeCustomPropertiesToCssFile(r,o)}if(i==="js"){yield writeCustomPropertiesToCjsFile(r,o)}if(i==="json"){yield writeCustomPropertiesToJsonFile(r,o)}if(i==="mjs"){yield writeCustomPropertiesToMjsFile(r,o)}}}});return function(e){return r.apply(this,arguments)}}()))}const O=e=>{return Object.keys(e).reduce((r,t)=>{r[t]=String(e[t]);return r},{})};const P=(e,r)=>new Promise((t,n)=>{o.writeFile(e,r,e=>{if(e){n(e)}else{t()}})});const k=e=>e.replace(/\\([\s\S])|(')/g,"\\$1$2").replace(/\n/g,"\\n").replace(/\r/g,"\\r");var A=n.plugin("postcss-custom-properties",e=>{const r="preserve"in Object(e)?Boolean(e.preserve):true;const t=[].concat(Object(e).importFrom||[]);const n=[].concat(Object(e).exportTo||[]);const i=getCustomPropertiesFromImports(t);const o=e=>{const t=getCustomPropertiesFromRoot(e,{preserve:r});y(e,t,{preserve:r})};const s=function(){var e=_asyncToGenerator(function*(e){const t=Object.assign({},yield i,getCustomPropertiesFromRoot(e,{preserve:r}));yield writeCustomPropertiesToExports(t,n);y(e,t,{preserve:r})});return function asyncTransform(r){return e.apply(this,arguments)}}();const a=t.length===0&&n.length===0;return a?o:s});e.exports=A},8758:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(1571));var i=_interopDefault(t(5747));var o=_interopDefault(t(5622));var s=_interopDefault(t(2043));function asyncGeneratorStep(e,r,t,n,i,o,s){try{var a=e[o](s);var u=a.value}catch(e){t(e);return}if(a.done){r(u)}else{Promise.resolve(u).then(n,i)}}function _asyncToGenerator(e){return function(){var r=this,t=arguments;return new Promise(function(n,i){var o=e.apply(r,t);function _next(e){asyncGeneratorStep(o,n,i,_next,_throw,"next",e)}function _throw(e){asyncGeneratorStep(o,n,i,_next,_throw,"throw",e)}_next(undefined)})}}function _defineProperty(e,r,t){if(r in e){Object.defineProperty(e,r,{value:t,enumerable:true,configurable:true,writable:true})}else{e[r]=t}return e}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=arguments[r]!=null?arguments[r]:{};var n=Object.keys(t);if(typeof Object.getOwnPropertySymbols==="function"){n=n.concat(Object.getOwnPropertySymbols(t).filter(function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))}n.forEach(function(r){_defineProperty(e,r,t[r])})}return e}function _slicedToArray(e,r){return _arrayWithHoles(e)||_iterableToArrayLimit(e,r)||_nonIterableRest()}function _arrayWithHoles(e){if(Array.isArray(e))return e}function _iterableToArrayLimit(e,r){var t=[];var n=true;var i=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){t.push(a.value);if(r&&t.length===r)break}}catch(e){i=true;o=e}finally{try{if(!n&&s["return"]!=null)s["return"]()}finally{if(i)throw o}}return t}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}var a=e=>{let r;n(e=>{r=e}).processSync(e);return r};var u=(e,r)=>{const t={};e.nodes.slice().forEach(e=>{if(B(e)){const n=e.params.match(l),i=_slicedToArray(n,3),o=i[1],s=i[2];t[o]=a(s);if(!Object(r).preserve){e.remove()}}});return t};const c=/^custom-selector$/i;const l=/^(:--[A-z][\w-]*)\s+([\W\w]+)\s*$/;const B=e=>e.type==="atrule"&&c.test(e.name)&&l.test(e.params);function transformSelectorList(e,r){let t=e.nodes.length-1;while(t>=0){const n=transformSelector(e.nodes[t],r);if(n.length){e.nodes.splice(t,1,...n)}--t}return e}function transformSelector(e,r){const t=[];for(const u in e.nodes){const c=e.nodes[u],l=c.value,B=c.nodes;if(l in r){var n=true;var i=false;var o=undefined;try{for(var s=r[l].nodes[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){const n=a.value;const i=e.clone();i.nodes.splice(u,1,...n.clone().nodes.map(r=>{r.spaces=_objectSpread({},e.nodes[u].spaces);return r}));const o=transformSelector(i,r);v(i.nodes,Number(u));if(o.length){t.push(...o)}else{t.push(i)}}}catch(e){i=true;o=e}finally{try{if(!n&&s.return!=null){s.return()}}finally{if(i){throw o}}}return t}else if(B&&B.length){transformSelectorList(e.nodes[u],r)}}return t}const f=/^(tag|universal)$/;const p=/^(class|id|pseudo|tag|universal)$/;const d=e=>f.test(Object(e).type);const h=e=>p.test(Object(e).type);const v=(e,r)=>{if(r&&d(e[r])&&h(e[r-1])){let t=r-1;while(t&&h(e[t])){--t}if(t<r){const n=e.splice(r,1)[0];e.splice(t,0,n);e[t].spaces.before=e[t+1].spaces.before;e[t+1].spaces.before="";if(e[r]){e[r].spaces.after=e[t].spaces.after;e[t].spaces.after=""}}}};var b=(e,r,t)=>{e.walkRules(C,e=>{const i=n(e=>{transformSelectorList(e,r,t)}).processSync(e.selector);if(t.preserve){e.cloneBefore({selector:i})}else{e.selector=i}})};const C=/:--[A-z][\w-]*/;function importCustomSelectorsFromCSSAST(e){return u(e)}function importCustomSelectorsFromCSSFile(e){return _importCustomSelectorsFromCSSFile.apply(this,arguments)}function _importCustomSelectorsFromCSSFile(){_importCustomSelectorsFromCSSFile=_asyncToGenerator(function*(e){const r=yield g(o.resolve(e));const t=s.parse(r,{from:o.resolve(e)});return importCustomSelectorsFromCSSAST(t)});return _importCustomSelectorsFromCSSFile.apply(this,arguments)}function importCustomSelectorsFromObject(e){const r=Object.assign({},Object(e).customSelectors||Object(e)["custom-selectors"]);for(const e in r){r[e]=a(r[e])}return r}function importCustomSelectorsFromJSONFile(e){return _importCustomSelectorsFromJSONFile.apply(this,arguments)}function _importCustomSelectorsFromJSONFile(){_importCustomSelectorsFromJSONFile=_asyncToGenerator(function*(e){const r=yield m(o.resolve(e));return importCustomSelectorsFromObject(r)});return _importCustomSelectorsFromJSONFile.apply(this,arguments)}function importCustomSelectorsFromJSFile(e){return _importCustomSelectorsFromJSFile.apply(this,arguments)}function _importCustomSelectorsFromJSFile(){_importCustomSelectorsFromJSFile=_asyncToGenerator(function*(e){const r=yield Promise.resolve(require(o.resolve(e)));return importCustomSelectorsFromObject(r)});return _importCustomSelectorsFromJSFile.apply(this,arguments)}function importCustomSelectorsFromSources(e){return e.map(e=>{if(e instanceof Promise){return e}else if(e instanceof Function){return e()}const r=e===Object(e)?e:{from:String(e)};if(Object(r).customSelectors||Object(r)["custom-selectors"]){return r}const t=String(r.from||"");const n=(r.type||o.extname(t).slice(1)).toLowerCase();return{type:n,from:t}}).reduce(function(){var e=_asyncToGenerator(function*(e,r){const t=yield r,n=t.type,i=t.from;if(n==="ast"){return Object.assign(e,importCustomSelectorsFromCSSAST(i))}if(n==="css"){return Object.assign(e,yield importCustomSelectorsFromCSSFile(i))}if(n==="js"){return Object.assign(e,yield importCustomSelectorsFromJSFile(i))}if(n==="json"){return Object.assign(e,yield importCustomSelectorsFromJSONFile(i))}return Object.assign(e,importCustomSelectorsFromObject(yield r))});return function(r,t){return e.apply(this,arguments)}}(),{})}const g=e=>new Promise((r,t)=>{i.readFile(e,"utf8",(e,n)=>{if(e){t(e)}else{r(n)}})});const m=function(){var e=_asyncToGenerator(function*(e){return JSON.parse(yield g(e))});return function readJSON(r){return e.apply(this,arguments)}}();function exportCustomSelectorsToCssFile(e,r){return _exportCustomSelectorsToCssFile.apply(this,arguments)}function _exportCustomSelectorsToCssFile(){_exportCustomSelectorsToCssFile=_asyncToGenerator(function*(e,r){const t=Object.keys(r).reduce((e,t)=>{e.push(`@custom-selector ${t} ${r[t]};`);return e},[]).join("\n");const n=`${t}\n`;yield w(e,n)});return _exportCustomSelectorsToCssFile.apply(this,arguments)}function exportCustomSelectorsToJsonFile(e,r){return _exportCustomSelectorsToJsonFile.apply(this,arguments)}function _exportCustomSelectorsToJsonFile(){_exportCustomSelectorsToJsonFile=_asyncToGenerator(function*(e,r){const t=JSON.stringify({"custom-selectors":r},null,"  ");const n=`${t}\n`;yield w(e,n)});return _exportCustomSelectorsToJsonFile.apply(this,arguments)}function exportCustomSelectorsToCjsFile(e,r){return _exportCustomSelectorsToCjsFile.apply(this,arguments)}function _exportCustomSelectorsToCjsFile(){_exportCustomSelectorsToCjsFile=_asyncToGenerator(function*(e,r){const t=Object.keys(r).reduce((e,t)=>{e.push(`\t\t'${S(t)}': '${S(r[t])}'`);return e},[]).join(",\n");const n=`module.exports = {\n\tcustomSelectors: {\n${t}\n\t}\n};\n`;yield w(e,n)});return _exportCustomSelectorsToCjsFile.apply(this,arguments)}function exportCustomSelectorsToMjsFile(e,r){return _exportCustomSelectorsToMjsFile.apply(this,arguments)}function _exportCustomSelectorsToMjsFile(){_exportCustomSelectorsToMjsFile=_asyncToGenerator(function*(e,r){const t=Object.keys(r).reduce((e,t)=>{e.push(`\t'${S(t)}': '${S(r[t])}'`);return e},[]).join(",\n");const n=`export const customSelectors = {\n${t}\n};\n`;yield w(e,n)});return _exportCustomSelectorsToMjsFile.apply(this,arguments)}function exportCustomSelectorsToDestinations(e,r){return Promise.all(r.map(function(){var r=_asyncToGenerator(function*(r){if(r instanceof Function){yield r(y(e))}else{const t=r===Object(r)?r:{to:String(r)};const n=t.toJSON||y;if("customSelectors"in t){t.customSelectors=n(e)}else if("custom-selectors"in t){t["custom-selectors"]=n(e)}else{const r=String(t.to||"");const i=(t.type||o.extname(t.to).slice(1)).toLowerCase();const s=n(e);if(i==="css"){yield exportCustomSelectorsToCssFile(r,s)}if(i==="js"){yield exportCustomSelectorsToCjsFile(r,s)}if(i==="json"){yield exportCustomSelectorsToJsonFile(r,s)}if(i==="mjs"){yield exportCustomSelectorsToMjsFile(r,s)}}}});return function(e){return r.apply(this,arguments)}}()))}const y=e=>{return Object.keys(e).reduce((r,t)=>{r[t]=String(e[t]);return r},{})};const w=(e,r)=>new Promise((t,n)=>{i.writeFile(e,r,e=>{if(e){n(e)}else{t()}})});const S=e=>e.replace(/\\([\s\S])|(')/g,"\\$1$2").replace(/\n/g,"\\n").replace(/\r/g,"\\r");var x=s.plugin("postcss-custom-selectors",e=>{const r=Boolean(Object(e).preserve);const t=[].concat(Object(e).importFrom||[]);const n=[].concat(Object(e).exportTo||[]);const i=importCustomSelectorsFromSources(t);return function(){var e=_asyncToGenerator(function*(e){const t=Object.assign(yield i,u(e,{preserve:r}));yield exportCustomSelectorsToDestinations(t,n);b(e,t,{preserve:r})});return function(r){return e.apply(this,arguments)}}()});e.exports=x},3650:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));var i=_interopDefault(t(1571));var o=n.plugin("postcss-dir-pseudo-class",e=>{const r=Object(e).dir;const t=Boolean(Object(e).preserve);return e=>{e.walkRules(/:dir\([^\)]*\)/,e=>{let n=e;if(t){n=e.cloneBefore()}n.selector=i(e=>{e.nodes.forEach(e=>{e.walk(t=>{if("pseudo"===t.type&&":dir"===t.value){const n=t.prev();const o=t.next();const s=n&&n.type&&"combinator"===n.type&&" "===n.value;const a=o&&o.type&&"combinator"===o.type&&" "===o.value;if(s&&(a||!o)){t.replaceWith(i.universal())}else{t.remove()}const u=e.nodes[0];const c=u&&"combinator"===u.type&&" "===u.value;const l=u&&"tag"===u.type&&"html"===u.value;const B=u&&"pseudo"===u.type&&":root"===u.value;if(u&&!l&&!B&&!c){e.prepend(i.combinator({value:" "}))}const f=t.nodes.toString();const p=r===f;const d=i.attribute({attribute:"dir",operator:"=",quoteMark:'"',value:`"${f}"`});const h=i.pseudo({value:`${l||B?"":"html"}:not`});h.append(i.attribute({attribute:"dir",operator:"=",quoteMark:'"',value:`"${"ltr"===f?"rtl":"ltr"}"`}));if(p){if(l){e.insertAfter(u,h)}else{e.prepend(h)}}else if(l){e.insertAfter(u,d)}else{e.prepend(d)}}})})}).processSync(n.selector)})}});e.exports=o},3030:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));var i=_interopDefault(t(9448));var o=n.plugin("postcss-double-position-gradients",e=>{const r="preserve"in Object(e)?Boolean(e.preserve):true;return e=>{e.walkDecls(e=>{const t=e.value;if(s.test(t)){const n=i(t).parse();n.walkFunctionNodes(e=>{if(a.test(e.value)){const r=e.nodes.slice(1,-1);r.forEach((t,n)=>{const o=Object(r[n-1]);const s=Object(r[n-2]);const a=s.type&&o.type==="number"&&t.type==="number";if(a){const r=s.clone();const n=i.comma({value:",",raws:{after:" "}});e.insertBefore(t,n);e.insertBefore(t,r)}})}});const o=n.toString();if(t!==o){e.cloneBefore({value:o});if(!r){e.remove()}}}})}});const s=/(repeating-)?(conic|linear|radial)-gradient\([\W\w]*\)/i;const a=/^(repeating-)?(conic|linear|radial)-gradient$/i;e.exports=o},5538:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(9448));var i=_interopDefault(t(5747));var o=_interopDefault(t(5622));var s=_interopDefault(t(2043));function asyncGeneratorStep(e,r,t,n,i,o,s){try{var a=e[o](s);var u=a.value}catch(e){t(e);return}if(a.done){r(u)}else{Promise.resolve(u).then(n,i)}}function _asyncToGenerator(e){return function(){var r=this,t=arguments;return new Promise(function(n,i){var o=e.apply(r,t);function _next(e){asyncGeneratorStep(o,n,i,_next,_throw,"next",e)}function _throw(e){asyncGeneratorStep(o,n,i,_next,_throw,"throw",e)}_next(undefined)})}}const a=/^--/;var u=e=>{const r=String(e.nodes.slice(1,-1));return a.test(r)?r:undefined};var c=(e,r)=>{const t=u(e);if(typeof t==="string"&&t in r){e.replaceWith(...l(r[t],e.raws.before))}};const l=(e,r)=>{const t=B(e,null);if(t[0]){t[0].raws.before=r}return t};const B=(e,r)=>e.map(e=>f(e,r));const f=(e,r)=>{const t=new e.constructor(e);for(const n in e){if(n==="parent"){t.parent=r}else if(Object(e[n]).constructor===Array){t[n]=B(e.nodes,t)}else if(Object(e[n]).constructor===Object){t[n]=Object.assign({},e[n])}}return t};var p=e=>e&&e.type==="func"&&e.value==="env";function walk(e,r){e.nodes.slice(0).forEach(e=>{if(e.nodes){walk(e,r)}if(p(e)){r(e)}})}var d=(e,r)=>{const t=n(e).parse();walk(t,e=>{c(e,r)});return String(t)};var h=e=>e&&e.type==="atrule";var v=e=>e&&e.type==="decl";var b=e=>h(e)&&e.params||v(e)&&e.value;function setSupportedValue(e,r){if(h(e)){e.params=r}if(v(e)){e.value=r}}function importEnvironmentVariablesFromObject(e){const r=Object.assign({},Object(e).environmentVariables||Object(e)["environment-variables"]);for(const e in r){r[e]=n(r[e]).parse().nodes}return r}function importEnvironmentVariablesFromJSONFile(e){return _importEnvironmentVariablesFromJSONFile.apply(this,arguments)}function _importEnvironmentVariablesFromJSONFile(){_importEnvironmentVariablesFromJSONFile=_asyncToGenerator(function*(e){const r=yield g(o.resolve(e));return importEnvironmentVariablesFromObject(r)});return _importEnvironmentVariablesFromJSONFile.apply(this,arguments)}function importEnvironmentVariablesFromJSFile(e){return _importEnvironmentVariablesFromJSFile.apply(this,arguments)}function _importEnvironmentVariablesFromJSFile(){_importEnvironmentVariablesFromJSFile=_asyncToGenerator(function*(e){const r=yield Promise.resolve(require(o.resolve(e)));return importEnvironmentVariablesFromObject(r)});return _importEnvironmentVariablesFromJSFile.apply(this,arguments)}function importEnvironmentVariablesFromSources(e){return e.map(e=>{if(e instanceof Promise){return e}else if(e instanceof Function){return e()}const r=e===Object(e)?e:{from:String(e)};if(r.environmentVariables||r["environment-variables"]){return r}const t=String(r.from||"");const n=(r.type||o.extname(t).slice(1)).toLowerCase();return{type:n,from:t}}).reduce(function(){var e=_asyncToGenerator(function*(e,r){const t=yield r,n=t.type,i=t.from;if(n==="js"){return Object.assign(e,yield importEnvironmentVariablesFromJSFile(i))}if(n==="json"){return Object.assign(e,yield importEnvironmentVariablesFromJSONFile(i))}return Object.assign(e,importEnvironmentVariablesFromObject(yield r))});return function(r,t){return e.apply(this,arguments)}}(),{})}const C=e=>new Promise((r,t)=>{i.readFile(e,"utf8",(e,n)=>{if(e){t(e)}else{r(n)}})});const g=function(){var e=_asyncToGenerator(function*(e){return JSON.parse(yield C(e))});return function readJSON(r){return e.apply(this,arguments)}}();var m=s.plugin("postcss-env-fn",e=>{const r=[].concat(Object(e).importFrom||[]);const t=importEnvironmentVariablesFromSources(r);return function(){var e=_asyncToGenerator(function*(e){const r=yield t;e.walk(e=>{const t=b(e);if(t){const n=d(t,r);if(n!==t){setSupportedValue(e,n)}}})});return function(r){return e.apply(this,arguments)}}()});e.exports=m},9642:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));const i=/:focus-visible([^\w-]|$)/gi;var o=n.plugin("postcss-focus-visible",e=>{const r=String(Object(e).replaceWith||".focus-visible");const t=Boolean("preserve"in Object(e)?e.preserve:true);return e=>{e.walkRules(i,e=>{const n=e.selector.replace(i,(e,t)=>{return`${r}${t}`});const o=e.clone({selector:n});if(t){e.before(o)}else{e.replaceWith(o)}})}});e.exports=o},8059:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));const i=/:focus-within([^\w-]|$)/gi;var o=n.plugin("postcss-focus-within",e=>{const r=String(Object(e).replaceWith||"[focus-within]");const t=Boolean("preserve"in Object(e)?e.preserve:true);return e=>{e.walkRules(i,e=>{const n=e.selector.replace(i,(e,t)=>{return`${r}${t}`});const o=e.clone({selector:n});if(t){e.before(o)}else{e.replaceWith(o)}})}});e.exports=o},3203:(e,r,t)=>{var n=t(2043);var i={"font-variant-ligatures":{"common-ligatures":'"liga", "clig"',"no-common-ligatures":'"liga", "clig off"',"discretionary-ligatures":'"dlig"',"no-discretionary-ligatures":'"dlig" off',"historical-ligatures":'"hlig"',"no-historical-ligatures":'"hlig" off',contextual:'"calt"',"no-contextual":'"calt" off'},"font-variant-position":{sub:'"subs"',super:'"sups"',normal:'"subs" off, "sups" off'},"font-variant-caps":{"small-caps":'"c2sc"',"all-small-caps":'"smcp", "c2sc"',"petite-caps":'"pcap"',"all-petite-caps":'"pcap", "c2pc"',unicase:'"unic"',"titling-caps":'"titl"'},"font-variant-numeric":{"lining-nums":'"lnum"',"oldstyle-nums":'"onum"',"proportional-nums":'"pnum"',"tabular-nums":'"tnum"',"diagonal-fractions":'"frac"',"stacked-fractions":'"afrc"',ordinal:'"ordn"',"slashed-zero":'"zero"'},"font-kerning":{normal:'"kern"',none:'"kern" off'},"font-variant":{normal:"normal",inherit:"inherit"}};for(var o in i){var s=i[o];for(var a in s){if(!(a in i["font-variant"])){i["font-variant"][a]=s[a]}}}function getFontFeatureSettingsPrevTo(e){var r=null;e.parent.walkDecls(function(e){if(e.prop==="font-feature-settings"){r=e}});if(r===null){r=e.clone();r.prop="font-feature-settings";r.value="";e.parent.insertBefore(e,r)}return r}e.exports=n.plugin("postcss-font-variant",function(){return function(e){e.walkRules(function(e){var r=null;e.walkDecls(function(e){if(!i[e.prop]){return null}var t=e.value;if(e.prop==="font-variant"){t=e.value.split(/\s+/g).map(function(e){return i["font-variant"][e]}).join(", ")}else if(i[e.prop][e.value]){t=i[e.prop][e.value]}if(r===null){r=getFontFeatureSettingsPrevTo(e)}if(r.value&&r.value!==t){r.value+=", "+t}else{r.value=t}})})}})},9547:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));const i=/^(column-gap|gap|row-gap)$/i;var o=n.plugin("postcss-gap-properties",e=>{const r="preserve"in Object(e)?Boolean(e.preserve):true;return e=>{e.walkDecls(i,e=>{e.cloneBefore({prop:`grid-${e.prop}`});if(!r){e.remove()}})}});e.exports=o},4287:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));var i=_interopDefault(t(9448));var o=e=>Object(e).type==="comma";const s=/^(-webkit-)?image-set$/i;var a=e=>Object(e).type==="func"&&/^(cross-fade|image|(repeating-)?(conic|linear|radial)-gradient|url)$/i.test(e.value)&&!(e.parent.parent&&e.parent.parent.type==="func"&&s.test(e.parent.parent.value))?String(e):Object(e).type==="string"?e.value:false;const u={dpcm:2.54,dpi:1,dppx:96,x:96};var c=(e,r)=>{if(Object(e).type==="number"&&e.unit in u){const t=Number(e.value)*u[e.unit.toLowerCase()];const i=Math.floor(t/u.x*100)/100;if(t in r){return false}else{const e=r[t]=n.atRule({name:"media",params:`(-webkit-min-device-pixel-ratio: ${i}), (min-resolution: ${t}dpi)`});return e}}else{return false}};var l=(e,r,t)=>{if(e.oninvalid==="warn"){e.decl.warn(e.result,r,{word:String(t)})}else if(e.oninvalid==="throw"){throw e.decl.error(r,{word:String(t)})}};var B=(e,r,t)=>{const n=r.parent;const i={};let s=e.length;let u=-1;while(u<s){const s=[u<0?true:o(e[u]),a(e[u+1]),c(e[u+2],i)],B=s[0],f=s[1],p=s[2];if(!B){return l(t,"unexpected comma",e[u])}else if(!f){return l(t,"unexpected image",e[u+1])}else if(!p){return l(t,"unexpected resolution",e[u+2])}const d=n.clone().removeAll();const h=r.clone({value:f});d.append(h);p.append(d);u+=3}const B=Object.keys(i).sort((e,r)=>e-r).map(e=>i[e]);if(B.length){const e=B[0].nodes[0].nodes[0];if(B.length===1){r.value=e.value}else{const i=n.nodes;const o=i.slice(0,i.indexOf(r)).concat(e);if(o.length){const e=n.cloneBefore().removeAll();e.append(o)}n.before(B.slice(1));if(!t.preserve){r.remove();if(!n.nodes.length){n.remove()}}}}};const f=/(^|[^\w-])(-webkit-)?image-set\(/;const p=/^(-webkit-)?image-set$/i;var d=n.plugin("postcss-image-set-function",e=>{const r="preserve"in Object(e)?Boolean(e.preserve):true;const t="oninvalid"in Object(e)?e.oninvalid:"ignore";return(e,n)=>{e.walkDecls(e=>{const o=e.value;if(f.test(o)){const s=i(o).parse();s.walkType("func",i=>{if(p.test(i.value)){B(i.nodes.slice(1,-1),e,{decl:e,oninvalid:t,preserve:r,result:n})}})}})}});e.exports=d},7501:(e,r,t)=>{var n=t(2043);var i=t(7552);e.exports=n.plugin("postcss-initial",function(e){e=e||{};e.reset=e.reset||"all";e.replace=e.replace||false;var r=i(e.reset==="inherited");var t=function(e,r){var t=false;r.parent.walkDecls(function(e){if(e.prop===r.prop&&e.value!==r.value){t=true}});return t};return function(n){n.walkDecls(function(n){if(n.value.indexOf("initial")<0){return}var i=r(n.prop,n.value);if(i.length===0)return;i.forEach(function(e){if(!t(n.prop,n)){n.cloneBefore(e)}});if(e.replace===true){n.remove()}})}})},7552:(e,r,t)=>{var n=t(8589);var i=t(9614);function _getRulesMap(e){return e.filter(function(e){return!e.combined}).reduce(function(e,r){e[r.prop.replace(/\-/g,"")]=r.initial;return e},{})}function _compileDecls(e){var r=_getRulesMap(e);return e.map(function(e){if(e.combined&&e.initial){var t=n(e.initial.replace(/\-/g,""));e.initial=t(r)}return e})}function _getRequirements(e){return e.reduce(function(e,r){if(!r.contains)return e;return r.contains.reduce(function(e,t){e[t]=r;return e},e)},{})}function _expandContainments(e){var r=_getRequirements(e);return e.filter(function(e){return!e.contains}).map(function(e){var t=r[e.prop];if(t){e.requiredBy=t.prop;e.basic=e.basic||t.basic;e.inherited=e.inherited||t.inherited}return e})}var o=_expandContainments(_compileDecls(i));function _clearDecls(e,r){return e.map(function(e){return{prop:e.prop,value:r.replace(/initial/g,e.initial)}})}function _allDecls(e){return o.filter(function(r){var t=r.combined||r.basic;if(e)return t&&r.inherited;return t})}function _concreteDecl(e){return o.filter(function(r){return e===r.prop||e===r.requiredBy})}function makeFallbackFunction(e){return function(r,t){var n;if(r==="all"){n=_allDecls(e)}else{n=_concreteDecl(r)}return _clearDecls(n,t)}}e.exports=makeFallbackFunction},7972:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=t(4567);var i=_interopDefault(t(2043));var o=_interopDefault(t(9448));var s=i.plugin("postcss-lab-function",e=>{const r="preserve"in Object(e)?Boolean(e.preserve):false;return e=>{e.walkDecls(e=>{const t=e.value;if(a.test(t)){const i=o(t).parse();i.walkType("func",e=>{if(u.test(e.value)){const r=e.nodes.slice(1,-1);const t=c.test(e.value);const i=l.test(e.value);const o=!i&&S(r);const s=!i&&x(r);const a=i&&O(r);if(o||s){e.value="rgb";const i=r[3];const o=r[4];if(o){if(C(o)&&!h(o)){o.unit="";o.value=String(o.value/100)}if(o.value==="1"){i.remove();o.remove()}else{e.value+="a"}}if(i&&g(i)){i.replaceWith(P())}const s=t?n.lab2rgb:n.lch2rgb;const a=s(...[r[0].value,r[1].value,r[2].value].map(e=>parseFloat(e))).map(e=>Math.max(Math.min(parseInt(e*2.55),255),0));r[0].value=String(a[0]);r[1].value=String(a[1]);r[2].value=String(a[2]);e.nodes.splice(3,0,[P()]);e.nodes.splice(2,0,[P()])}else if(a){e.value="rgb";const t=r[2];const i=n.lab2rgb(...[r[0].value,0,0].map(e=>parseFloat(e))).map(e=>Math.max(Math.min(parseInt(e*2.55),255),0));e.removeAll().append(A("(")).append(k(i[0])).append(P()).append(k(i[1])).append(P()).append(k(i[2])).append(A(")"));if(t){if(C(t)&&!h(t)){t.unit="";t.value=String(t.value/100)}if(t.value!=="1"){e.value+="a";e.insertBefore(e.last,P()).insertBefore(e.last,t)}}}}});const s=String(i);if(r){e.cloneBefore({value:s})}else{e.value=s}}})}});const a=/(^|[^\w-])(lab|lch|gray)\(/i;const u=/^(lab|lch|gray)$/i;const c=/^lab$/i;const l=/^gray$/i;const B=/^%?$/i;const f=/^calc$/i;const p=/^(deg|grad|rad|turn)?$/i;const d=e=>h(e)||e.type==="number"&&B.test(e.unit);const h=e=>e.type==="func"&&f.test(e.value);const v=e=>h(e)||e.type==="number"&&p.test(e.unit);const b=e=>h(e)||e.type==="number"&&e.unit==="";const C=e=>h(e)||e.type==="number"&&e.unit==="%";const g=e=>e.type==="operator"&&e.value==="/";const m=[b,b,b,g,d];const y=[b,b,v,g,d];const w=[b,g,d];const S=e=>e.every((e,r)=>typeof m[r]==="function"&&m[r](e));const x=e=>e.every((e,r)=>typeof y[r]==="function"&&y[r](e));const O=e=>e.every((e,r)=>typeof w[r]==="function"&&w[r](e));const P=()=>o.comma({value:","});const k=e=>o.number({value:e});const A=e=>o.paren({value:e});e.exports=s},562:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));var i=(e,r)=>{const t=Object(e.parent).type==="rule"?e.parent.clone({raws:{}}).removeAll():n.rule({selector:"&"});t.selectors=t.selectors.map(e=>`${e}:dir(${r})`);return t};const o=/^\s*logical\s+/i;const s=/^border(-width|-style|-color)?$/i;const a=/^border-(block|block-start|block-end|inline|inline-start|inline-end|start|end)(-(width|style|color))?$/i;var u={border:(e,r,t)=>{const n=o.test(r[0]);if(n){r[0]=r[0].replace(o,"")}const a=[e.clone({prop:`border-top${e.prop.replace(s,"$1")}`,value:r[0]}),e.clone({prop:`border-left${e.prop.replace(s,"$1")}`,value:r[1]||r[0]}),e.clone({prop:`border-bottom${e.prop.replace(s,"$1")}`,value:r[2]||r[0]}),e.clone({prop:`border-right${e.prop.replace(s,"$1")}`,value:r[3]||r[1]||r[0]})];const u=[e.clone({prop:`border-top${e.prop.replace(s,"$1")}`,value:r[0]}),e.clone({prop:`border-right${e.prop.replace(s,"$1")}`,value:r[1]||r[0]}),e.clone({prop:`border-bottom${e.prop.replace(s,"$1")}`,value:r[2]||r[0]}),e.clone({prop:`border-left${e.prop.replace(s,"$1")}`,value:r[3]||r[1]||r[0]})];return n?1===r.length?e.clone({value:e.value.replace(o,"")}):!r[3]||r[3]===r[1]?[e.clone({prop:`border-top${e.prop.replace(s,"$1")}`,value:r[0]}),e.clone({prop:`border-right${e.prop.replace(s,"$1")}`,value:r[3]||r[1]||r[0]}),e.clone({prop:`border-bottom${e.prop.replace(s,"$1")}`,value:r[2]||r[0]}),e.clone({prop:`border-left${e.prop.replace(s,"$1")}`,value:r[1]||r[0]})]:"ltr"===t?a:"rtl"===t?u:[i(e,"ltr").append(a),i(e,"rtl").append(u)]:null},"border-block":(e,r)=>[e.clone({prop:`border-top${e.prop.replace(a,"$2")}`,value:r[0]}),e.clone({prop:`border-bottom${e.prop.replace(a,"$2")}`,value:r[0]})],"border-block-start":e=>{e.prop="border-top"},"border-block-end":e=>{e.prop="border-bottom"},"border-inline":(e,r,t)=>{const n=[e.clone({prop:`border-left${e.prop.replace(a,"$2")}`,value:r[0]}),e.clone({prop:`border-right${e.prop.replace(a,"$2")}`,value:r[1]||r[0]})];const o=[e.clone({prop:`border-right${e.prop.replace(a,"$2")}`,value:r[0]}),e.clone({prop:`border-left${e.prop.replace(a,"$2")}`,value:r[1]||r[0]})];const s=1===r.length||2===r.length&&r[0]===r[1];return s?n:"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]},"border-inline-start":(e,r,t)=>{const n=e.clone({prop:`border-left${e.prop.replace(a,"$2")}`});const o=e.clone({prop:`border-right${e.prop.replace(a,"$2")}`});return"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]},"border-inline-end":(e,r,t)=>{const n=e.clone({prop:`border-right${e.prop.replace(a,"$2")}`});const o=e.clone({prop:`border-left${e.prop.replace(a,"$2")}`});return"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]},"border-start":(e,r,t)=>{const n=[e.clone({prop:`border-top${e.prop.replace(a,"$2")}`,value:r[0]}),e.clone({prop:`border-left${e.prop.replace(a,"$2")}`,value:r[1]||r[0]})];const o=[e.clone({prop:`border-top${e.prop.replace(a,"$2")}`,value:r[0]}),e.clone({prop:`border-right${e.prop.replace(a,"$2")}`,value:r[1]||r[0]})];return"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]},"border-end":(e,r,t)=>{const n=[e.clone({prop:`border-bottom${e.prop.replace(a,"$2")}`,value:r[0]}),e.clone({prop:`border-right${e.prop.replace(a,"$2")}`,value:r[1]||r[0]})];const o=[e.clone({prop:`border-bottom${e.prop.replace(a,"$2")}`,value:r[0]}),e.clone({prop:`border-left${e.prop.replace(a,"$2")}`,value:r[1]||r[0]})];return"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]}};var c=(e,r,t)=>{const n=e.clone({value:"left"});const o=e.clone({value:"right"});return/^inline-start$/i.test(e.value)?"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]:/^inline-end$/i.test(e.value)?"ltr"===t?o:"rtl"===t?n:[i(e,"ltr").append(o),i(e,"rtl").append(n)]:null};var l=(e,r,t)=>{if("logical"!==r[0]){return[e.clone({prop:"top",value:r[0]}),e.clone({prop:"right",value:r[1]||r[0]}),e.clone({prop:"bottom",value:r[2]||r[0]}),e.clone({prop:"left",value:r[3]||r[1]||r[0]})]}const n=!r[4]||r[4]===r[2];const o=[e.clone({prop:"top",value:r[1]}),e.clone({prop:"left",value:r[2]||r[1]}),e.clone({prop:"bottom",value:r[3]||r[1]}),e.clone({prop:"right",value:r[4]||r[2]||r[1]})];const s=[e.clone({prop:"top",value:r[1]}),e.clone({prop:"right",value:r[2]||r[1]}),e.clone({prop:"bottom",value:r[3]||r[1]}),e.clone({prop:"left",value:r[4]||r[2]||r[1]})];return n||"ltr"===t?o:"rtl"===t?s:[i(e,"ltr").append(o),i(e,"rtl").append(s)]};var B=e=>/^block$/i.test(e.value)?e.clone({value:"vertical"}):/^inline$/i.test(e.value)?e.clone({value:"horizontal"}):null;var f=/^(inset|margin|padding)(?:-(block|block-start|block-end|inline|inline-start|inline-end|start|end))$/i;var p=/^inset-/i;var d=(e,r,t)=>e.clone({prop:`${e.prop.replace(f,"$1")}${r}`.replace(p,""),value:t});var h={block:(e,r)=>[d(e,"-top",r[0]),d(e,"-bottom",r[1]||r[0])],"block-start":e=>{e.prop=e.prop.replace(f,"$1-top").replace(p,"")},"block-end":e=>{e.prop=e.prop.replace(f,"$1-bottom").replace(p,"")},inline:(e,r,t)=>{const n=[d(e,"-left",r[0]),d(e,"-right",r[1]||r[0])];const o=[d(e,"-right",r[0]),d(e,"-left",r[1]||r[0])];const s=1===r.length||2===r.length&&r[0]===r[1];return s?n:"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]},"inline-start":(e,r,t)=>{const n=d(e,"-left",e.value);const o=d(e,"-right",e.value);return"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]},"inline-end":(e,r,t)=>{const n=d(e,"-right",e.value);const o=d(e,"-left",e.value);return"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]},start:(e,r,t)=>{const n=[d(e,"-top",r[0]),d(e,"-left",r[1]||r[0])];const o=[d(e,"-top",r[0]),d(e,"-right",r[1]||r[0])];return"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]},end:(e,r,t)=>{const n=[d(e,"-bottom",r[0]),d(e,"-right",r[1]||r[0])];const o=[d(e,"-bottom",r[0]),d(e,"-left",r[1]||r[0])];return"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]}};var v=/^(min-|max-)?(block|inline)-(size)$/i;var b=e=>{e.prop=e.prop.replace(v,(e,r,t)=>`${r||""}${"block"===t?"height":"width"}`)};var C=(e,r,t)=>{if("logical"!==r[0]){return null}const n=!r[4]||r[4]===r[2];const o=e.clone({value:[r[1],r[4]||r[2]||r[1],r[3]||r[1],r[2]||r[1]].join(" ")});const s=e.clone({value:[r[1],r[2]||r[1],r[3]||r[1],r[4]||r[2]||r[1]].join(" ")});return n?e.clone({value:e.value.replace(/^\s*logical\s+/i,"")}):"ltr"===t?o:"rtl"===t?s:[i(e,"ltr").append(o),i(e,"rtl").append(s)]};var g=(e,r,t)=>{const n=e.clone({value:"left"});const o=e.clone({value:"right"});return/^start$/i.test(e.value)?"ltr"===t?n:"rtl"===t?o:[i(e,"ltr").append(n),i(e,"rtl").append(o)]:/^end$/i.test(e.value)?"ltr"===t?o:"rtl"===t?n:[i(e,"ltr").append(o),i(e,"rtl").append(n)]:null};function splitByComma(e,r){return splitByRegExp(e,/^,$/,r)}function splitBySpace(e,r){return splitByRegExp(e,/^\s$/,r)}function splitBySlash(e,r){return splitByRegExp(e,/^\/$/,r)}function splitByRegExp(e,r,t){const n=[];let i="";let o=false;let s=0;let a=-1;while(++a<e.length){const u=e[a];if(u==="("){s+=1}else if(u===")"){if(s>0){s-=1}}else if(s===0){if(r.test(u)){o=true}}if(o){if(!t||i.trim()){n.push(t?i.trim():i)}if(!t){n.push(u)}i="";o=false}else{i+=u}}if(i!==""){n.push(t?i.trim():i)}return n}var m=(e,r,t)=>{const n=[];const o=[];splitByComma(e.value).forEach(e=>{let r=false;splitBySpace(e).forEach((e,t,i)=>{if(e in y){r=true;y[e].ltr.forEach(e=>{const r=i.slice();r.splice(t,1,e);if(n.length&&!/^,$/.test(n[n.length-1])){n.push(",")}n.push(r.join(""))});y[e].rtl.forEach(e=>{const r=i.slice();r.splice(t,1,e);if(o.length&&!/^,$/.test(o[o.length-1])){o.push(",")}o.push(r.join(""))})}});if(!r){n.push(e);o.push(e)}});const s=e.clone({value:n.join("")});const a=e.clone({value:o.join("")});return n.length&&"ltr"===t?s:o.length&&"rtl"===t?a:s.value!==a.value?[i(e,"ltr").append(s),i(e,"rtl").append(a)]:null};const y={"border-block":{ltr:["border-top","border-bottom"],rtl:["border-top","border-bottom"]},"border-block-color":{ltr:["border-top-color","border-bottom-color"],rtl:["border-top-color","border-bottom-color"]},"border-block-end":{ltr:["border-bottom"],rtl:["border-bottom"]},"border-block-end-color":{ltr:["border-bottom-color"],rtl:["border-bottom-color"]},"border-block-end-style":{ltr:["border-bottom-style"],rtl:["border-bottom-style"]},"border-block-end-width":{ltr:["border-bottom-width"],rtl:["border-bottom-width"]},"border-block-start":{ltr:["border-top"],rtl:["border-top"]},"border-block-start-color":{ltr:["border-top-color"],rtl:["border-top-color"]},"border-block-start-style":{ltr:["border-top-style"],rtl:["border-top-style"]},"border-block-start-width":{ltr:["border-top-width"],rtl:["border-top-width"]},"border-block-style":{ltr:["border-top-style","border-bottom-style"],rtl:["border-top-style","border-bottom-style"]},"border-block-width":{ltr:["border-top-width","border-bottom-width"],rtl:["border-top-width","border-bottom-width"]},"border-end":{ltr:["border-bottom","border-right"],rtl:["border-bottom","border-left"]},"border-end-color":{ltr:["border-bottom-color","border-right-color"],rtl:["border-bottom-color","border-left-color"]},"border-end-style":{ltr:["border-bottom-style","border-right-style"],rtl:["border-bottom-style","border-left-style"]},"border-end-width":{ltr:["border-bottom-width","border-right-width"],rtl:["border-bottom-width","border-left-width"]},"border-inline":{ltr:["border-left","border-right"],rtl:["border-left","border-right"]},"border-inline-color":{ltr:["border-left-color","border-right-color"],rtl:["border-left-color","border-right-color"]},"border-inline-end":{ltr:["border-right"],rtl:["border-left"]},"border-inline-end-color":{ltr:["border-right-color"],rtl:["border-left-color"]},"border-inline-end-style":{ltr:["border-right-style"],rtl:["border-left-style"]},"border-inline-end-width":{ltr:["border-right-width"],rtl:["border-left-width"]},"border-inline-start":{ltr:["border-left"],rtl:["border-right"]},"border-inline-start-color":{ltr:["border-left-color"],rtl:["border-right-color"]},"border-inline-start-style":{ltr:["border-left-style"],rtl:["border-right-style"]},"border-inline-start-width":{ltr:["border-left-width"],rtl:["border-right-width"]},"border-inline-style":{ltr:["border-left-style","border-right-style"],rtl:["border-left-style","border-right-style"]},"border-inline-width":{ltr:["border-left-width","border-right-width"],rtl:["border-left-width","border-right-width"]},"border-start":{ltr:["border-top","border-left"],rtl:["border-top","border-right"]},"border-start-color":{ltr:["border-top-color","border-left-color"],rtl:["border-top-color","border-right-color"]},"border-start-style":{ltr:["border-top-style","border-left-style"],rtl:["border-top-style","border-right-style"]},"border-start-width":{ltr:["border-top-width","border-left-width"],rtl:["border-top-width","border-right-width"]},"block-size":{ltr:["height"],rtl:["height"]},"inline-size":{ltr:["width"],rtl:["width"]},inset:{ltr:["top","right","bottom","left"],rtl:["top","right","bottom","left"]},"inset-block":{ltr:["top","bottom"],rtl:["top","bottom"]},"inset-block-start":{ltr:["top"],rtl:["top"]},"inset-block-end":{ltr:["bottom"],rtl:["bottom"]},"inset-end":{ltr:["bottom","right"],rtl:["bottom","left"]},"inset-inline":{ltr:["left","right"],rtl:["left","right"]},"inset-inline-start":{ltr:["left"],rtl:["right"]},"inset-inline-end":{ltr:["right"],rtl:["left"]},"inset-start":{ltr:["top","left"],rtl:["top","right"]},"margin-block":{ltr:["margin-top","margin-bottom"],rtl:["margin-top","margin-bottom"]},"margin-block-start":{ltr:["margin-top"],rtl:["margin-top"]},"margin-block-end":{ltr:["margin-bottom"],rtl:["margin-bottom"]},"margin-end":{ltr:["margin-bottom","margin-right"],rtl:["margin-bottom","margin-left"]},"margin-inline":{ltr:["margin-left","margin-right"],rtl:["margin-left","margin-right"]},"margin-inline-start":{ltr:["margin-left"],rtl:["margin-right"]},"margin-inline-end":{ltr:["margin-right"],rtl:["margin-left"]},"margin-start":{ltr:["margin-top","margin-left"],rtl:["margin-top","margin-right"]},"padding-block":{ltr:["padding-top","padding-bottom"],rtl:["padding-top","padding-bottom"]},"padding-block-start":{ltr:["padding-top"],rtl:["padding-top"]},"padding-block-end":{ltr:["padding-bottom"],rtl:["padding-bottom"]},"padding-end":{ltr:["padding-bottom","padding-right"],rtl:["padding-bottom","padding-left"]},"padding-inline":{ltr:["padding-left","padding-right"],rtl:["padding-left","padding-right"]},"padding-inline-start":{ltr:["padding-left"],rtl:["padding-right"]},"padding-inline-end":{ltr:["padding-right"],rtl:["padding-left"]},"padding-start":{ltr:["padding-top","padding-left"],rtl:["padding-top","padding-right"]}};var w=/^(?:(inset|margin|padding)(?:-(block|block-start|block-end|inline|inline-start|inline-end|start|end))|(min-|max-)?(block|inline)-(size))$/i;const S={border:u["border"],"border-width":u["border"],"border-style":u["border"],"border-color":u["border"],"border-block":u["border-block"],"border-block-width":u["border-block"],"border-block-style":u["border-block"],"border-block-color":u["border-block"],"border-block-start":u["border-block-start"],"border-block-start-width":u["border-block-start"],"border-block-start-style":u["border-block-start"],"border-block-start-color":u["border-block-start"],"border-block-end":u["border-block-end"],"border-block-end-width":u["border-block-end"],"border-block-end-style":u["border-block-end"],"border-block-end-color":u["border-block-end"],"border-inline":u["border-inline"],"border-inline-width":u["border-inline"],"border-inline-style":u["border-inline"],"border-inline-color":u["border-inline"],"border-inline-start":u["border-inline-start"],"border-inline-start-width":u["border-inline-start"],"border-inline-start-style":u["border-inline-start"],"border-inline-start-color":u["border-inline-start"],"border-inline-end":u["border-inline-end"],"border-inline-end-width":u["border-inline-end"],"border-inline-end-style":u["border-inline-end"],"border-inline-end-color":u["border-inline-end"],"border-start":u["border-start"],"border-start-width":u["border-start"],"border-start-style":u["border-start"],"border-start-color":u["border-start"],"border-end":u["border-end"],"border-end-width":u["border-end"],"border-end-style":u["border-end"],"border-end-color":u["border-end"],clear:c,inset:l,margin:C,padding:C,block:h["block"],"block-start":h["block-start"],"block-end":h["block-end"],inline:h["inline"],"inline-start":h["inline-start"],"inline-end":h["inline-end"],start:h["start"],end:h["end"],float:c,resize:B,size:b,"text-align":g,transition:m,"transition-property":m};const x=/^border(-block|-inline|-start|-end)?(-width|-style|-color)?$/i;var O=n.plugin("postcss-logical-properties",e=>{const r=Boolean(Object(e).preserve);const t=!r&&typeof Object(e).dir==="string"?/^rtl$/i.test(e.dir)?"rtl":"ltr":false;return e=>{e.walkDecls(e=>{const n=e.parent;const i=x.test(e.prop)?splitBySlash(e.value,true):splitBySpace(e.value,true);const o=e.prop.replace(w,"$2$5").toLowerCase();if(o in S){const s=S[o](e,i,t);if(s){[].concat(s).forEach(r=>{if(r.type==="rule"){n.before(r)}else{e.before(r)}});if(!r){e.remove();if(!n.nodes.length){n.remove()}}}}})}});e.exports=O},601:(e,r,t)=>{var n=t(2043);e.exports=n.plugin("postcss-media-minmax",function(){return function(e){var r={width:"px",height:"px","device-width":"px","device-height":"px","aspect-ratio":"","device-aspect-ratio":"",color:"","color-index":"",monochrome:"",resolution:"dpi"};var t=Object.keys(r);var n=.001;var i={">":1,"<":-1};var o={">":"min","<":"max"};function create_query(e,t,s,a,u){return a.replace(/([-\d\.]+)(.*)/,function(a,u,c){var l=parseFloat(u);if(parseFloat(u)||s){if(!s){if(c==="px"&&l===parseInt(u,10)){u=l+i[t]}else{u=Number(Math.round(parseFloat(u)+n*i[t]+"e6")+"e-6")}}}else{u=i[t]+r[e]}return"("+o[t]+"-"+e+": "+u+c+")"})}e.walkAtRules(function(e,r){if(e.name!=="media"&&e.name!=="custom-media"){return}e.params=e.params.replace(/\(\s*([a-z-]+?)\s*([<>])(=?)\s*((?:-?\d*\.?(?:\s*\/?\s*)?\d+[a-z]*)?)\s*\)/gi,function(r,n,i,o,s){var a="";if(t.indexOf(n)>-1){return create_query(n,i,o,s,e.params)}return r});e.params=e.params.replace(/\(\s*((?:-?\d*\.?(?:\s*\/?\s*)?\d+[a-z]*)?)\s*(<|>)(=?)\s*([a-z-]+)\s*(<|>)(=?)\s*((?:-?\d*\.?(?:\s*\/?\s*)?\d+[a-z]*)?)\s*\)/gi,function(e,r,n,i,o,s,a,u){if(t.indexOf(o)>-1){if(n==="<"&&s==="<"||n===">"&&s===">"){var c=n==="<"?r:u;var l=n==="<"?u:r;var B=i;var f=a;if(n===">"){B=a;f=i}return create_query(o,">",B,c)+" and "+create_query(o,"<",f,l)}}return e})})}})},9717:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=t(2043);var i=_interopDefault(n);function shiftNodesBeforeParent(e){const r=e.parent;const t=r.index(e);if(t){r.cloneBefore().removeAll().append(r.nodes.slice(0,t))}r.before(e);return r}function cleanupParent(e){if(!e.nodes.length){e.remove()}}var o=/&(?:[^\w-|]|$)/;const s=/&/g;function mergeSelectors(e,r){return e.reduce((e,t)=>e.concat(r.map(e=>e.replace(s,t))),[])}function transformRuleWithinRule(e){const r=shiftNodesBeforeParent(e);e.selectors=mergeSelectors(r.selectors,e.selectors);const t=e.type==="rule"&&r.type==="rule"&&e.selector===r.selector||e.type==="atrule"&&r.type==="atrule"&&e.params===r.params;if(t){e.append(...r.nodes)}cleanupParent(r)}const a=e=>e.type==="rule"&&Object(e.parent).type==="rule"&&e.selectors.every(e=>e.trim().lastIndexOf("&")===0&&o.test(e));const u=n.list.comma;function transformNestRuleWithinRule(e){const r=shiftNodesBeforeParent(e);const t=r.clone().removeAll().append(e.nodes);e.replaceWith(t);t.selectors=mergeSelectors(r.selectors,u(e.params));cleanupParent(r);walk(t)}const c=e=>e.type==="atrule"&&e.name==="nest"&&Object(e.parent).type==="rule"&&u(e.params).every(e=>e.split("&").length===2&&o.test(e));var l=["document","media","supports"];function atruleWithinRule(e){const r=shiftNodesBeforeParent(e);const t=r.clone().removeAll().append(e.nodes);e.append(t);cleanupParent(r);walk(t)}const B=e=>e.type==="atrule"&&l.indexOf(e.name)!==-1&&Object(e.parent).type==="rule";const f=n.list.comma;function mergeParams(e,r){return f(e).map(e=>f(r).map(r=>`${e} and ${r}`).join(", ")).join(", ")}function transformAtruleWithinAtrule(e){const r=shiftNodesBeforeParent(e);e.params=mergeParams(r.params,e.params);cleanupParent(r)}const p=e=>e.type==="atrule"&&l.indexOf(e.name)!==-1&&Object(e.parent).type==="atrule"&&e.name===e.parent.name;function walk(e){e.nodes.slice(0).forEach(r=>{if(r.parent===e){if(a(r)){transformRuleWithinRule(r)}else if(c(r)){transformNestRuleWithinRule(r)}else if(B(r)){atruleWithinRule(r)}else if(p(r)){transformAtruleWithinAtrule(r)}if(Object(r.nodes).length){walk(r)}}})}var d=i.plugin("postcss-nesting",()=>walk);e.exports=d},498:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));function _toArray(e){return _arrayWithHoles(e)||_iterableToArray(e)||_nonIterableRest()}function _arrayWithHoles(e){if(Array.isArray(e))return e}function _iterableToArray(e){if(Symbol.iterator in Object(e)||Object.prototype.toString.call(e)==="[object Arguments]")return Array.from(e)}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}const i=n.list.space;const o=/^overflow$/i;var s=n.plugin("postcss-overflow-shorthand",e=>{const r="preserve"in Object(e)?Boolean(e.preserve):true;return e=>{e.walkDecls(o,e=>{const t=i(e.value),n=_toArray(t),o=n[0],s=n[1],a=n.slice(2);if(s&&!a.length){e.cloneBefore({prop:`${e.prop}-x`,value:o});e.cloneBefore({prop:`${e.prop}-y`,value:s});if(!r){e.remove()}}})}});e.exports=s},7012:(e,r,t)=>{var n=t(2043);e.exports=n.plugin("postcss-page-break",function(){return function(e){e.walkDecls(/^break-(inside|before|after)/,function(e){if(e.value.search(/column|region/)>=0){return}var r;switch(e.value){case"page":r="always";break;case"avoid-page":r="avoid";break;default:r=e.value}e.cloneBefore({prop:"page-"+e.prop,value:r})})}})},1431:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));var i=_interopDefault(t(9448));const o=/^place-(content|items|self)/;var s=n.plugin("postcss-place",e=>{const r="preserve"in Object(e)?Boolean(e.prefix):true;return e=>{e.walkDecls(o,e=>{const t=e.prop.match(o)[1];const n=i(e.value).parse();const s=n.nodes[0].nodes;const a=s.length===1?e.value:String(s.slice(0,1)).trim();const u=s.length===1?e.value:String(s.slice(1)).trim();e.cloneBefore({prop:`align-${t}`,value:a});e.cloneBefore({prop:`justify-${t}`,value:u});if(!r){e.remove()}})}});e.exports=s},7435:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(3501));var i=_interopDefault(t(3561));var o=_interopDefault(t(3094));var s=_interopDefault(t(2043));var a=_interopDefault(t(2347));var u=_interopDefault(t(9883));var c=_interopDefault(t(7814));var l=_interopDefault(t(489));var B=_interopDefault(t(8157));var f=_interopDefault(t(8881));var p=_interopDefault(t(9971));var d=_interopDefault(t(4731));var h=_interopDefault(t(8713));var v=_interopDefault(t(8758));var b=_interopDefault(t(3650));var C=_interopDefault(t(3030));var g=_interopDefault(t(5538));var m=_interopDefault(t(9642));var y=_interopDefault(t(8059));var w=_interopDefault(t(3203));var S=_interopDefault(t(9547));var x=_interopDefault(t(9555));var O=_interopDefault(t(4287));var P=_interopDefault(t(7501));var k=_interopDefault(t(7972));var A=_interopDefault(t(562));var F=_interopDefault(t(601));var j=_interopDefault(t(9717));var T=_interopDefault(t(498));var D=_interopDefault(t(7012));var E=_interopDefault(t(1431));var R=_interopDefault(t(2207));var I=_interopDefault(t(1832));var M=_interopDefault(t(9020));var L=_interopDefault(t(40));var G=_interopDefault(t(8158));var N=t(4338);var J=_interopDefault(t(5747));var H=_interopDefault(t(5622));var Q=s.plugin("postcss-system-ui-font",()=>e=>{e.walkDecls(U,e=>{e.value=e.value.replace(z,q)})});const U=/(?:^(?:-|\\002d){2})|(?:^font(?:-family)?$)/i;const W="[\\f\\n\\r\\x09\\x20]";const K=["system-ui","-apple-system","Segoe UI","Roboto","Ubuntu","Cantarell","Noto Sans","sans-serif"];const z=new RegExp(`(^|,|${W}+)(?:system-ui${W}*)(?:,${W}*(?:${K.join("|")})${W}*)?(,|$)`,"i");const q=`$1${K.join(", ")}$2`;var Y={"all-property":P,"any-link-pseudo-class":I,"blank-pseudo-class":u,"break-properties":D,"case-insensitive-attributes":a,"color-functional-notation":c,"color-mod-function":f,"custom-media-queries":d,"custom-properties":h,"custom-selectors":v,"dir-pseudo-class":b,"double-position-gradients":C,"environment-variables":g,"focus-visible-pseudo-class":m,"focus-within-pseudo-class":y,"font-variant-property":w,"gap-properties":S,"gray-function":l,"has-pseudo-class":x,"hexadecimal-alpha-notation":B,"image-set-function":O,"lab-function":k,"logical-properties-and-values":A,"matches-pseudo-class":L,"media-query-ranges":F,"nesting-rules":j,"not-pseudo-class":G,"overflow-property":T,"overflow-wrap-property":M,"place-properties":E,"prefers-color-scheme-query":R,"rebeccapurple-color":p,"system-ui-font-family":Q};function getTransformedInsertions(e,r){return Object.keys(e).map(t=>[].concat(e[t]).map(e=>({[r]:true,plugin:e,id:t}))).reduce((e,r)=>e.concat(r),[])}function getUnsupportedBrowsersByFeature(e){const r=N.features[e];if(r){const e=N.feature(r).stats;const t=Object.keys(e).reduce((r,t)=>r.concat(Object.keys(e[t]).filter(r=>e[t][r].indexOf("y")!==0).map(e=>`${t} ${e}`)),[]);return t}else{return["> 0%"]}}var X=["custom-media-queries","custom-properties","environment-variables","image-set-function","media-query-ranges","prefers-color-scheme-query","nesting-rules","custom-selectors","any-link-pseudo-class","case-insensitive-attributes","focus-visible-pseudo-class","focus-within-pseudo-class","matches-pseudo-class","not-pseudo-class","logical-properties-and-values","dir-pseudo-class","all-property","color-functional-notation","double-position-gradients","gray-function","hexadecimal-alpha-notation","lab-function","rebeccapurple-color","color-mod-function","blank-pseudo-class","break-properties","font-variant-property","has-pseudo-class","gap-properties","overflow-property","overflow-wrap-property","place-properties","system-ui-font-family"];function asyncGeneratorStep(e,r,t,n,i,o,s){try{var a=e[o](s);var u=a.value}catch(e){t(e);return}if(a.done){r(u)}else{Promise.resolve(u).then(n,i)}}function _asyncToGenerator(e){return function(){var r=this,t=arguments;return new Promise(function(n,i){var o=e.apply(r,t);function _next(e){asyncGeneratorStep(o,n,i,_next,_throw,"next",e)}function _throw(e){asyncGeneratorStep(o,n,i,_next,_throw,"throw",e)}_next(undefined)})}}function getCustomMediaAsCss(e){const r=Object.keys(e).reduce((r,t)=>{r.push(`@custom-media ${t} ${e[t]};`);return r},[]).join("\n");const t=`${r}\n`;return t}function getCustomPropertiesAsCss(e){const r=Object.keys(e).reduce((r,t)=>{r.push(`\t${t}: ${e[t]};`);return r},[]).join("\n");const t=`:root {\n${r}\n}\n`;return t}function getCustomSelectorsAsCss(e){const r=Object.keys(e).reduce((r,t)=>{r.push(`@custom-selector ${t} ${e[t]};`);return r},[]).join("\n");const t=`${r}\n`;return t}function writeExportsToCssFile(e,r,t,n){return _writeExportsToCssFile.apply(this,arguments)}function _writeExportsToCssFile(){_writeExportsToCssFile=_asyncToGenerator(function*(e,r,t,n){const i=getCustomPropertiesAsCss(t);const o=getCustomMediaAsCss(r);const s=getCustomSelectorsAsCss(n);const a=`${o}\n${s}\n${i}`;yield writeFile(e,a)});return _writeExportsToCssFile.apply(this,arguments)}function writeExportsToJsonFile(e,r,t,n){return _writeExportsToJsonFile.apply(this,arguments)}function _writeExportsToJsonFile(){_writeExportsToJsonFile=_asyncToGenerator(function*(e,r,t,n){const i=JSON.stringify({"custom-media":r,"custom-properties":t,"custom-selectors":n},null,"  ");const o=`${i}\n`;yield writeFile(e,o)});return _writeExportsToJsonFile.apply(this,arguments)}function getObjectWithKeyAsCjs(e,r){const t=Object.keys(r).reduce((e,t)=>{e.push(`\t\t'${escapeForJS(t)}': '${escapeForJS(r[t])}'`);return e},[]).join(",\n");const n=`\n\t${e}: {\n${t}\n\t}`;return n}function writeExportsToCjsFile(e,r,t,n){return _writeExportsToCjsFile.apply(this,arguments)}function _writeExportsToCjsFile(){_writeExportsToCjsFile=_asyncToGenerator(function*(e,r,t,n){const i=getObjectWithKeyAsCjs("customMedia",r);const o=getObjectWithKeyAsCjs("customProperties",t);const s=getObjectWithKeyAsCjs("customSelectors",n);const a=`module.exports = {${i},${o},${s}\n};\n`;yield writeFile(e,a)});return _writeExportsToCjsFile.apply(this,arguments)}function getObjectWithKeyAsMjs(e,r){const t=Object.keys(r).reduce((e,t)=>{e.push(`\t'${escapeForJS(t)}': '${escapeForJS(r[t])}'`);return e},[]).join(",\n");const n=`export const ${e} = {\n${t}\n};\n`;return n}function writeExportsToMjsFile(e,r,t,n){return _writeExportsToMjsFile.apply(this,arguments)}function _writeExportsToMjsFile(){_writeExportsToMjsFile=_asyncToGenerator(function*(e,r,t,n){const i=getObjectWithKeyAsMjs("customMedia",r);const o=getObjectWithKeyAsMjs("customProperties",t);const s=getObjectWithKeyAsMjs("customSelectors",n);const a=`${i}\n${o}\n${s}`;yield writeFile(e,a)});return _writeExportsToMjsFile.apply(this,arguments)}function writeToExports(e,r){return Promise.all([].concat(r).map(function(){var r=_asyncToGenerator(function*(r){if(r instanceof Function){yield r({customMedia:getObjectWithStringifiedKeys(e.customMedia),customProperties:getObjectWithStringifiedKeys(e.customProperties),customSelectors:getObjectWithStringifiedKeys(e.customSelectors)})}else{const t=r===Object(r)?r:{to:String(r)};const n=t.toJSON||getObjectWithStringifiedKeys;if("customMedia"in t||"customProperties"in t||"customSelectors"in t){t.customMedia=n(e.customMedia);t.customProperties=n(e.customProperties);t.customSelectors=n(e.customSelectors)}else if("custom-media"in t||"custom-properties"in t||"custom-selectors"in t){t["custom-media"]=n(e.customMedia);t["custom-properties"]=n(e.customProperties);t["custom-selectors"]=n(e.customSelectors)}else{const r=String(t.to||"");const i=(t.type||H.extname(t.to).slice(1)).toLowerCase();const o=n(e.customMedia);const s=n(e.customProperties);const a=n(e.customSelectors);if(i==="css"){yield writeExportsToCssFile(r,o,s,a)}if(i==="js"){yield writeExportsToCjsFile(r,o,s,a)}if(i==="json"){yield writeExportsToJsonFile(r,o,s,a)}if(i==="mjs"){yield writeExportsToMjsFile(r,o,s,a)}}}});return function(e){return r.apply(this,arguments)}}()))}function getObjectWithStringifiedKeys(e){return Object.keys(e).reduce((r,t)=>{r[t]=String(e[t]);return r},{})}function writeFile(e,r){return new Promise((t,n)=>{J.writeFile(e,r,e=>{if(e){n(e)}else{t()}})})}function escapeForJS(e){return e.replace(/\\([\s\S])|(')/g,"\\$1$2").replace(/\n/g,"\\n").replace(/\r/g,"\\r")}var Z=s.plugin("postcss-preset-env",e=>{const r=Object(Object(e).features);const t=Object(Object(e).insertBefore);const s=Object(Object(e).insertAfter);const a=Object(e).browsers;const u="stage"in Object(e)?e.stage===false?5:parseInt(e.stage)||0:2;const c=Object(e).autoprefixer;const l=$(Object(e));const B=c===false?()=>{}:n(Object.assign({overrideBrowserslist:a},c));const f=o.concat(getTransformedInsertions(t,"insertBefore"),getTransformedInsertions(s,"insertAfter")).filter(e=>e.insertBefore||e.id in Y).sort((e,r)=>X.indexOf(e.id)-X.indexOf(r.id)||(e.insertBefore?-1:r.insertBefore?1:0)||(e.insertAfter?1:r.insertAfter?-1:0)).map(e=>{const r=getUnsupportedBrowsersByFeature(e.caniuse);return e.insertBefore||e.insertAfter?{browsers:r,plugin:e.plugin,id:`${e.insertBefore?"before":"after"}-${e.id}`,stage:6}:{browsers:r,plugin:Y[e.id],id:e.id,stage:e.stage}});const p=f.filter(e=>e.id in r?r[e.id]:e.stage>=u).map(e=>({browsers:e.browsers,plugin:typeof e.plugin.process==="function"?r[e.id]===true?l?e.plugin(Object.assign({},l)):e.plugin():l?e.plugin(Object.assign({},l,r[e.id])):e.plugin(Object.assign({},r[e.id])):e.plugin,id:e.id}));const d=i(a,{ignoreUnknownVersions:true});const h=p.filter(e=>d.some(r=>i(e.browsers,{ignoreUnknownVersions:true}).some(e=>e===r)));return(r,t)=>{const n=h.reduce((e,r)=>e.then(()=>r.plugin(t.root,t)),Promise.resolve()).then(()=>B(t.root,t)).then(()=>{if(Object(e).exportTo){writeToExports(l.exportTo,e.exportTo)}});return n}});const $=e=>{if("importFrom"in e||"exportTo"in e||"preserve"in e){const r={};if("importFrom"in e){r.importFrom=e.importFrom}if("exportTo"in e){r.exportTo={customMedia:{},customProperties:{},customSelectors:{}}}if("preserve"in e){r.preserve=e.preserve}return r}return false};e.exports=Z},1832:(e,r,t)=>{"use strict";function _interopDefault(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var n=_interopDefault(t(2043));var i=_interopDefault(t(1571));const o=/:any-link/;var s=n.plugin("postcss-pseudo-class-any-link",e=>{const r="preserve"in Object(e)?Boolean(e.preserve):true;return e=>{e.walkRules(o,e=>{const t=e.raws.selector&&e.raws.selector.raw||e.selector;if(t[t.length-1]!==":"){const n=i(e=>{let r;let t;let n;let i;let o;let s=-1;while(n=e.nodes[++s]){t=-1;while(r=n.nodes[++t]){if(r.value===":any-link"){i=n.clone();o=n.clone();i.nodes[t].value=":link";o.nodes[t].value=":visited";e.nodes.splice(s--,1,i,o);break}}}}).processSync(t);if(n!==t){if(r){e.cloneBefore({selector:n})}else{e.selector=n}}}})}});e.exports=s},9020:(e,r,t)=>{var n=t(2043);e.exports=n.plugin("postcss-replace-overflow-wrap",function(e){e=e||{};var r=e.method||"replace";return function(e){e.walkDecls("overflow-wrap",function(e){e.cloneBefore({prop:"word-wrap"});if(r==="replace"){e.remove()}})}})},40:(e,r,t)=>{"use strict";Object.defineProperty(r,"__esModule",{value:true});var n=t(2043);var i=_interopRequireDefault(n);var o=t(8746);var s=_interopRequireDefault(o);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function explodeSelectors(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};return function(r){r.walkRules(function(r){if(r.selector&&r.selector.indexOf(":matches")>-1){r.selector=(0,s.default)(r,e)}})}}r.default=i.default.plugin("postcss-selector-matches",explodeSelectors);e.exports=r.default},8746:(e,r,t)=>{"use strict";Object.defineProperty(r,"__esModule",{value:true});r.default=replaceRuleSelector;var n=t(7009);var i=_interopRequireDefault(n);var o=t(587);var s=_interopRequireDefault(o);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _toConsumableArray(e){if(Array.isArray(e)){for(var r=0,t=Array(e.length);r<e.length;r++){t[r]=e[r]}return t}else{return Array.from(e)}}var a=":matches";var u=/^[a-zA-Z]/;function isElementSelector(e){var r=u.exec(e);return r}function normalizeSelector(e,r,t){if(isElementSelector(e)&&!isElementSelector(t)){return`${r}${e}${t}`}return`${r}${t}${e}`}function explodeSelector(e,r){if(e&&e.indexOf(a)>-1){var t=[];var n=e.match(/^\s+/);var o=n?n[0]:"";var u=i.default.comma(e);u.forEach(function(e){var n=e.indexOf(a);var u=e.slice(0,n);var c=e.slice(n);var l=(0,s.default)("(",")",c);var B=l&&l.body?i.default.comma(l.body).reduce(function(e,t){return[].concat(_toConsumableArray(e),_toConsumableArray(explodeSelector(t,r)))},[]):[c];var f=l&&l.post?explodeSelector(l.post,r):[];var p=void 0;if(f.length===0){if(n===-1||u.indexOf(" ")>-1){p=B.map(function(e){return o+u+e})}else{p=B.map(function(e){return normalizeSelector(e,o,u)})}}else{p=[];f.forEach(function(e){B.forEach(function(r){p.push(o+u+r+e)})})}t=[].concat(_toConsumableArray(t),_toConsumableArray(p))});return t}return[e]}function replaceRuleSelector(e,r){var t=e.raws&&e.raws.before?e.raws.before.split("\n").pop():"";return explodeSelector(e.selector,r).join(","+(r.lineBreak?"\n"+t:" "))}e.exports=r.default},8158:(e,r,t)=>{"use strict";Object.defineProperty(r,"__esModule",{value:true});var n=t(2043);var i=_interopRequireDefault(n);var o=t(7009);var s=_interopRequireDefault(o);var a=t(587);var u=_interopRequireDefault(a);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function explodeSelector(e,r){var t=locatePseudoClass(r,e);if(r&&t>-1){var n=r.slice(0,t);var i=(0,u.default)("(",")",r.slice(t));var o=i.body?s.default.comma(i.body).map(function(r){return explodeSelector(e,r)}).join(`)${e}(`):"";var a=i.post?explodeSelector(e,i.post):"";return`${n}${e}(${o})${a}`}return r}var c={};function locatePseudoClass(e,r){c[r]=c[r]||new RegExp(`([^\\\\]|^)${r}`);var t=c[r];var n=e.search(t);if(n===-1){return-1}return n+e.slice(n).indexOf(r)}function explodeSelectors(e){return function(){return function(r){r.walkRules(function(r){if(r.selector&&r.selector.indexOf(e)>-1){r.selector=explodeSelector(e,r.selector)}})}}}r.default=i.default.plugin("postcss-selector-not",explodeSelectors(":not"));e.exports=r.default},1571:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(3509);var i=_interopRequireDefault(n);var o=t(4267);var s=_interopRequireWildcard(o);function _interopRequireWildcard(e){if(e&&e.__esModule){return e}else{var r={};if(e!=null){for(var t in e){if(Object.prototype.hasOwnProperty.call(e,t))r[t]=e[t]}}r.default=e;return r}}function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}var a=function parser(e){return new i.default(e)};Object.assign(a,s);delete a.__esModule;r.default=a;e.exports=r["default"]},6557:(e,r,t)=>{"use strict";r.__esModule=true;var n=function(){function defineProperties(e,r){for(var t=0;t<r.length;t++){var n=r[t];n.enumerable=n.enumerable||false;n.configurable=true;if("value"in n)n.writable=true;Object.defineProperty(e,n.key,n)}}return function(e,r,t){if(r)defineProperties(e.prototype,r);if(t)defineProperties(e,t);return e}}();var i=Object.assign||function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var n in t){if(Object.prototype.hasOwnProperty.call(t,n)){e[n]=t[n]}}}return e};var o,s;var a=t(4751);var u=_interopRequireDefault(a);var c=t(5632);var l=_interopRequireDefault(c);var B=t(1682);var f=_interopRequireDefault(B);var p=t(4955);var d=_interopRequireDefault(p);var h=t(586);var v=_interopRequireDefault(h);var b=t(6435);var C=_interopRequireDefault(b);var g=t(1733);var m=_interopRequireDefault(g);var y=t(5201);var w=_interopRequireDefault(y);var S=t(1193);var x=_interopRequireDefault(S);var O=t(716);var P=_interopRequireDefault(O);var k=t(7223);var A=_interopRequireDefault(k);var F=t(3261);var j=_interopRequireDefault(F);var T=t(1632);var D=_interopRequireDefault(T);var E=t(8081);var R=_interopRequireDefault(E);var I=t(5571);var M=_interopRequireDefault(I);var L=t(5648);var G=_interopRequireDefault(L);var N=t(7024);var J=_interopRequireWildcard(N);var H=t(9107);var Q=_interopRequireWildcard(H);var U=t(5431);function _interopRequireWildcard(e){if(e&&e.__esModule){return e}else{var r={};if(e!=null){for(var t in e){if(Object.prototype.hasOwnProperty.call(e,t))r[t]=e[t]}}r.default=e;return r}}function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}var W=(o={},o[J.space]=true,o[J.cr]=true,o[J.feed]=true,o[J.newline]=true,o[J.tab]=true,o);var K=i({},W,(s={},s[J.comment]=true,s));function tokenStart(e){return{line:e[L.FIELDS.START_LINE],column:e[L.FIELDS.START_COL]}}function tokenEnd(e){return{line:e[L.FIELDS.END_LINE],column:e[L.FIELDS.END_COL]}}function getSource(e,r,t,n){return{start:{line:e,column:r},end:{line:t,column:n}}}function getTokenSource(e){return getSource(e[L.FIELDS.START_LINE],e[L.FIELDS.START_COL],e[L.FIELDS.END_LINE],e[L.FIELDS.END_COL])}function getTokenSourceSpan(e,r){if(!e){return undefined}return getSource(e[L.FIELDS.START_LINE],e[L.FIELDS.START_COL],r[L.FIELDS.END_LINE],r[L.FIELDS.END_COL])}function unescapeProp(e,r){var t=e[r];if(typeof t!=="string"){return}if(t.indexOf("\\")!==-1){(0,U.ensureObject)(e,"raws");e[r]=(0,U.unesc)(t);if(e.raws[r]===undefined){e.raws[r]=t}}return e}var z=function(){function Parser(e){var r=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};_classCallCheck(this,Parser);this.rule=e;this.options=Object.assign({lossy:false,safe:false},r);this.position=0;this.css=typeof this.rule==="string"?this.rule:this.rule.selector;this.tokens=(0,G.default)({css:this.css,error:this._errorGenerator(),safe:this.options.safe});var t=getTokenSourceSpan(this.tokens[0],this.tokens[this.tokens.length-1]);this.root=new f.default({source:t});this.root.errorGenerator=this._errorGenerator();var n=new d.default({source:{start:{line:1,column:1}}});this.root.append(n);this.current=n;this.loop()}Parser.prototype._errorGenerator=function _errorGenerator(){var e=this;return function(r,t){if(typeof e.rule==="string"){return new Error(r)}return e.rule.error(r,t)}};Parser.prototype.attribute=function attribute(){var e=[];var r=this.currToken;this.position++;while(this.position<this.tokens.length&&this.currToken[L.FIELDS.TYPE]!==J.closeSquare){e.push(this.currToken);this.position++}if(this.currToken[L.FIELDS.TYPE]!==J.closeSquare){return this.expected("closing square bracket",this.currToken[L.FIELDS.START_POS])}var t=e.length;var n={source:getSource(r[1],r[2],this.currToken[3],this.currToken[4]),sourceIndex:r[L.FIELDS.START_POS]};if(t===1&&!~[J.word].indexOf(e[0][L.FIELDS.TYPE])){return this.expected("attribute",e[0][L.FIELDS.START_POS])}var i=0;var o="";var s="";var a=null;var u=false;while(i<t){var c=e[i];var l=this.content(c);var B=e[i+1];switch(c[L.FIELDS.TYPE]){case J.space:u=true;if(this.options.lossy){break}if(a){(0,U.ensureObject)(n,"spaces",a);var f=n.spaces[a].after||"";n.spaces[a].after=f+l;var p=(0,U.getProp)(n,"raws","spaces",a,"after")||null;if(p){n.raws.spaces[a].after=p+l}}else{o=o+l;s=s+l}break;case J.asterisk:if(B[L.FIELDS.TYPE]===J.equals){n.operator=l;a="operator"}else if((!n.namespace||a==="namespace"&&!u)&&B){if(o){(0,U.ensureObject)(n,"spaces","attribute");n.spaces.attribute.before=o;o=""}if(s){(0,U.ensureObject)(n,"raws","spaces","attribute");n.raws.spaces.attribute.before=o;s=""}n.namespace=(n.namespace||"")+l;var d=(0,U.getProp)(n,"raws","namespace")||null;if(d){n.raws.namespace+=l}a="namespace"}u=false;break;case J.dollar:if(a==="value"){var h=(0,U.getProp)(n,"raws","value");n.value+="$";if(h){n.raws.value=h+"$"}break}case J.caret:if(B[L.FIELDS.TYPE]===J.equals){n.operator=l;a="operator"}u=false;break;case J.combinator:if(l==="~"&&B[L.FIELDS.TYPE]===J.equals){n.operator=l;a="operator"}if(l!=="|"){u=false;break}if(B[L.FIELDS.TYPE]===J.equals){n.operator=l;a="operator"}else if(!n.namespace&&!n.attribute){n.namespace=true}u=false;break;case J.word:if(B&&this.content(B)==="|"&&e[i+2]&&e[i+2][L.FIELDS.TYPE]!==J.equals&&!n.operator&&!n.namespace){n.namespace=l;a="namespace"}else if(!n.attribute||a==="attribute"&&!u){if(o){(0,U.ensureObject)(n,"spaces","attribute");n.spaces.attribute.before=o;o=""}if(s){(0,U.ensureObject)(n,"raws","spaces","attribute");n.raws.spaces.attribute.before=s;s=""}n.attribute=(n.attribute||"")+l;var v=(0,U.getProp)(n,"raws","attribute")||null;if(v){n.raws.attribute+=l}a="attribute"}else if(!n.value||a==="value"&&!u){var b=(0,U.unesc)(l);var C=(0,U.getProp)(n,"raws","value")||"";var g=n.value||"";n.value=g+b;n.quoteMark=null;if(b!==l||C){(0,U.ensureObject)(n,"raws");n.raws.value=(C||g)+l}a="value"}else{var m=l==="i"||l==="I";if(n.value&&(n.quoteMark||u)){n.insensitive=m;if(!m||l==="I"){(0,U.ensureObject)(n,"raws");n.raws.insensitiveFlag=l}a="insensitive";if(o){(0,U.ensureObject)(n,"spaces","insensitive");n.spaces.insensitive.before=o;o=""}if(s){(0,U.ensureObject)(n,"raws","spaces","insensitive");n.raws.spaces.insensitive.before=s;s=""}}else if(n.value){a="value";n.value+=l;if(n.raws.value){n.raws.value+=l}}}u=false;break;case J.str:if(!n.attribute||!n.operator){return this.error("Expected an attribute followed by an operator preceding the string.",{index:c[L.FIELDS.START_POS]})}var y=(0,k.unescapeValue)(l),w=y.unescaped,S=y.quoteMark;n.value=w;n.quoteMark=S;a="value";(0,U.ensureObject)(n,"raws");n.raws.value=l;u=false;break;case J.equals:if(!n.attribute){return this.expected("attribute",c[L.FIELDS.START_POS],l)}if(n.value){return this.error('Unexpected "=" found; an operator was already defined.',{index:c[L.FIELDS.START_POS]})}n.operator=n.operator?n.operator+l:l;a="operator";u=false;break;case J.comment:if(a){if(u||B&&B[L.FIELDS.TYPE]===J.space||a==="insensitive"){var x=(0,U.getProp)(n,"spaces",a,"after")||"";var O=(0,U.getProp)(n,"raws","spaces",a,"after")||x;(0,U.ensureObject)(n,"raws","spaces",a);n.raws.spaces[a].after=O+l}else{var P=n[a]||"";var F=(0,U.getProp)(n,"raws",a)||P;(0,U.ensureObject)(n,"raws");n.raws[a]=F+l}}else{s=s+l}break;default:return this.error('Unexpected "'+l+'" found.',{index:c[L.FIELDS.START_POS]})}i++}unescapeProp(n,"attribute");unescapeProp(n,"namespace");this.newNode(new A.default(n));this.position++};Parser.prototype.parseWhitespaceEquivalentTokens=function parseWhitespaceEquivalentTokens(e){if(e<0){e=this.tokens.length}var r=this.position;var t=[];var n="";var i=undefined;do{if(W[this.currToken[L.FIELDS.TYPE]]){if(!this.options.lossy){n+=this.content()}}else if(this.currToken[L.FIELDS.TYPE]===J.comment){var o={};if(n){o.before=n;n=""}i=new C.default({value:this.content(),source:getTokenSource(this.currToken),sourceIndex:this.currToken[L.FIELDS.START_POS],spaces:o});t.push(i)}}while(++this.position<e);if(n){if(i){i.spaces.after=n}else if(!this.options.lossy){var s=this.tokens[r];var a=this.tokens[this.position-1];t.push(new x.default({value:"",source:getSource(s[L.FIELDS.START_LINE],s[L.FIELDS.START_COL],a[L.FIELDS.END_LINE],a[L.FIELDS.END_COL]),sourceIndex:s[L.FIELDS.START_POS],spaces:{before:n,after:""}}))}}return t};Parser.prototype.convertWhitespaceNodesToSpace=function convertWhitespaceNodesToSpace(e){var r=this;var t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var n="";var i="";e.forEach(function(e){var o=r.lossySpace(e.spaces.before,t);var s=r.lossySpace(e.rawSpaceBefore,t);n+=o+r.lossySpace(e.spaces.after,t&&o.length===0);i+=o+e.value+r.lossySpace(e.rawSpaceAfter,t&&s.length===0)});if(i===n){i=undefined}var o={space:n,rawSpace:i};return o};Parser.prototype.isNamedCombinator=function isNamedCombinator(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:this.position;return this.tokens[e+0]&&this.tokens[e+0][L.FIELDS.TYPE]===J.slash&&this.tokens[e+1]&&this.tokens[e+1][L.FIELDS.TYPE]===J.word&&this.tokens[e+2]&&this.tokens[e+2][L.FIELDS.TYPE]===J.slash};Parser.prototype.namedCombinator=function namedCombinator(){if(this.isNamedCombinator()){var e=this.content(this.tokens[this.position+1]);var r=(0,U.unesc)(e).toLowerCase();var t={};if(r!==e){t.value="/"+e+"/"}var n=new D.default({value:"/"+r+"/",source:getSource(this.currToken[L.FIELDS.START_LINE],this.currToken[L.FIELDS.START_COL],this.tokens[this.position+2][L.FIELDS.END_LINE],this.tokens[this.position+2][L.FIELDS.END_COL]),sourceIndex:this.currToken[L.FIELDS.START_POS],raws:t});this.position=this.position+3;return n}else{this.unexpected()}};Parser.prototype.combinator=function combinator(){var e=this;if(this.content()==="|"){return this.namespace()}var r=this.locateNextMeaningfulToken(this.position);if(r<0||this.tokens[r][L.FIELDS.TYPE]===J.comma){var t=this.parseWhitespaceEquivalentTokens(r);if(t.length>0){var n=this.current.last;if(n){var i=this.convertWhitespaceNodesToSpace(t),o=i.space,s=i.rawSpace;if(s!==undefined){n.rawSpaceAfter+=s}n.spaces.after+=o}else{t.forEach(function(r){return e.newNode(r)})}}return}var a=this.currToken;var u=undefined;if(r>this.position){u=this.parseWhitespaceEquivalentTokens(r)}var c=void 0;if(this.isNamedCombinator()){c=this.namedCombinator()}else if(this.currToken[L.FIELDS.TYPE]===J.combinator){c=new D.default({value:this.content(),source:getTokenSource(this.currToken),sourceIndex:this.currToken[L.FIELDS.START_POS]});this.position++}else if(W[this.currToken[L.FIELDS.TYPE]]){}else if(!u){this.unexpected()}if(c){if(u){var l=this.convertWhitespaceNodesToSpace(u),B=l.space,f=l.rawSpace;c.spaces.before=B;c.rawSpaceBefore=f}}else{var p=this.convertWhitespaceNodesToSpace(u,true),d=p.space,h=p.rawSpace;if(!h){h=d}var v={};var b={spaces:{}};if(d.endsWith(" ")&&h.endsWith(" ")){v.before=d.slice(0,d.length-1);b.spaces.before=h.slice(0,h.length-1)}else if(d.startsWith(" ")&&h.startsWith(" ")){v.after=d.slice(1);b.spaces.after=h.slice(1)}else{b.value=h}c=new D.default({value:" ",source:getTokenSourceSpan(a,this.tokens[this.position-1]),sourceIndex:a[L.FIELDS.START_POS],spaces:v,raws:b})}if(this.currToken&&this.currToken[L.FIELDS.TYPE]===J.space){c.spaces.after=this.optionalSpace(this.content());this.position++}return this.newNode(c)};Parser.prototype.comma=function comma(){if(this.position===this.tokens.length-1){this.root.trailingComma=true;this.position++;return}this.current._inferEndPosition();var e=new d.default({source:{start:tokenStart(this.tokens[this.position+1])}});this.current.parent.append(e);this.current=e;this.position++};Parser.prototype.comment=function comment(){var e=this.currToken;this.newNode(new C.default({value:this.content(),source:getTokenSource(e),sourceIndex:e[L.FIELDS.START_POS]}));this.position++};Parser.prototype.error=function error(e,r){throw this.root.error(e,r)};Parser.prototype.missingBackslash=function missingBackslash(){return this.error("Expected a backslash preceding the semicolon.",{index:this.currToken[L.FIELDS.START_POS]})};Parser.prototype.missingParenthesis=function missingParenthesis(){return this.expected("opening parenthesis",this.currToken[L.FIELDS.START_POS])};Parser.prototype.missingSquareBracket=function missingSquareBracket(){return this.expected("opening square bracket",this.currToken[L.FIELDS.START_POS])};Parser.prototype.unexpected=function unexpected(){return this.error("Unexpected '"+this.content()+"'. Escaping special characters with \\ may help.",this.currToken[L.FIELDS.START_POS])};Parser.prototype.namespace=function namespace(){var e=this.prevToken&&this.content(this.prevToken)||true;if(this.nextToken[L.FIELDS.TYPE]===J.word){this.position++;return this.word(e)}else if(this.nextToken[L.FIELDS.TYPE]===J.asterisk){this.position++;return this.universal(e)}};Parser.prototype.nesting=function nesting(){if(this.nextToken){var e=this.content(this.nextToken);if(e==="|"){this.position++;return}}var r=this.currToken;this.newNode(new R.default({value:this.content(),source:getTokenSource(r),sourceIndex:r[L.FIELDS.START_POS]}));this.position++};Parser.prototype.parentheses=function parentheses(){var e=this.current.last;var r=1;this.position++;if(e&&e.type===Q.PSEUDO){var t=new d.default({source:{start:tokenStart(this.tokens[this.position-1])}});var n=this.current;e.append(t);this.current=t;while(this.position<this.tokens.length&&r){if(this.currToken[L.FIELDS.TYPE]===J.openParenthesis){r++}if(this.currToken[L.FIELDS.TYPE]===J.closeParenthesis){r--}if(r){this.parse()}else{this.current.source.end=tokenEnd(this.currToken);this.current.parent.source.end=tokenEnd(this.currToken);this.position++}}this.current=n}else{var i=this.currToken;var o="(";var s=void 0;while(this.position<this.tokens.length&&r){if(this.currToken[L.FIELDS.TYPE]===J.openParenthesis){r++}if(this.currToken[L.FIELDS.TYPE]===J.closeParenthesis){r--}s=this.currToken;o+=this.parseParenthesisToken(this.currToken);this.position++}if(e){e.appendToPropertyAndEscape("value",o,o)}else{this.newNode(new x.default({value:o,source:getSource(i[L.FIELDS.START_LINE],i[L.FIELDS.START_COL],s[L.FIELDS.END_LINE],s[L.FIELDS.END_COL]),sourceIndex:i[L.FIELDS.START_POS]}))}}if(r){return this.expected("closing parenthesis",this.currToken[L.FIELDS.START_POS])}};Parser.prototype.pseudo=function pseudo(){var e=this;var r="";var t=this.currToken;while(this.currToken&&this.currToken[L.FIELDS.TYPE]===J.colon){r+=this.content();this.position++}if(!this.currToken){return this.expected(["pseudo-class","pseudo-element"],this.position-1)}if(this.currToken[L.FIELDS.TYPE]===J.word){this.splitWord(false,function(n,i){r+=n;e.newNode(new P.default({value:r,source:getTokenSourceSpan(t,e.currToken),sourceIndex:t[L.FIELDS.START_POS]}));if(i>1&&e.nextToken&&e.nextToken[L.FIELDS.TYPE]===J.openParenthesis){e.error("Misplaced parenthesis.",{index:e.nextToken[L.FIELDS.START_POS]})}})}else{return this.expected(["pseudo-class","pseudo-element"],this.currToken[L.FIELDS.START_POS])}};Parser.prototype.space=function space(){var e=this.content();if(this.position===0||this.prevToken[L.FIELDS.TYPE]===J.comma||this.prevToken[L.FIELDS.TYPE]===J.openParenthesis){this.spaces=this.optionalSpace(e);this.position++}else if(this.position===this.tokens.length-1||this.nextToken[L.FIELDS.TYPE]===J.comma||this.nextToken[L.FIELDS.TYPE]===J.closeParenthesis){this.current.last.spaces.after=this.optionalSpace(e);this.position++}else{this.combinator()}};Parser.prototype.string=function string(){var e=this.currToken;this.newNode(new x.default({value:this.content(),source:getTokenSource(e),sourceIndex:e[L.FIELDS.START_POS]}));this.position++};Parser.prototype.universal=function universal(e){var r=this.nextToken;if(r&&this.content(r)==="|"){this.position++;return this.namespace()}var t=this.currToken;this.newNode(new j.default({value:this.content(),source:getTokenSource(t),sourceIndex:t[L.FIELDS.START_POS]}),e);this.position++};Parser.prototype.splitWord=function splitWord(e,r){var t=this;var n=this.nextToken;var i=this.content();while(n&&~[J.dollar,J.caret,J.equals,J.word].indexOf(n[L.FIELDS.TYPE])){this.position++;var o=this.content();i+=o;if(o.lastIndexOf("\\")===o.length-1){var s=this.nextToken;if(s&&s[L.FIELDS.TYPE]===J.space){i+=this.requiredSpace(this.content(s));this.position++}}n=this.nextToken}var a=(0,u.default)(i,".").filter(function(e){return i[e-1]!=="\\"});var c=(0,u.default)(i,"#");var B=(0,u.default)(i,"#{");if(B.length){c=c.filter(function(e){return!~B.indexOf(e)})}var f=(0,M.default)((0,l.default)([0].concat(a,c)));f.forEach(function(n,o){var s=f[o+1]||i.length;var u=i.slice(n,s);if(o===0&&r){return r.call(t,u,f.length)}var l=void 0;var B=t.currToken;var p=B[L.FIELDS.START_POS]+f[o];var d=getSource(B[1],B[2]+n,B[3],B[2]+(s-1));if(~a.indexOf(n)){var h={value:u.slice(1),source:d,sourceIndex:p};l=new v.default(unescapeProp(h,"value"))}else if(~c.indexOf(n)){var b={value:u.slice(1),source:d,sourceIndex:p};l=new m.default(unescapeProp(b,"value"))}else{var C={value:u,source:d,sourceIndex:p};unescapeProp(C,"value");l=new w.default(C)}t.newNode(l,e);e=null});this.position++};Parser.prototype.word=function word(e){var r=this.nextToken;if(r&&this.content(r)==="|"){this.position++;return this.namespace()}return this.splitWord(e)};Parser.prototype.loop=function loop(){while(this.position<this.tokens.length){this.parse(true)}this.current._inferEndPosition();return this.root};Parser.prototype.parse=function parse(e){switch(this.currToken[L.FIELDS.TYPE]){case J.space:this.space();break;case J.comment:this.comment();break;case J.openParenthesis:this.parentheses();break;case J.closeParenthesis:if(e){this.missingParenthesis()}break;case J.openSquare:this.attribute();break;case J.dollar:case J.caret:case J.equals:case J.word:this.word();break;case J.colon:this.pseudo();break;case J.comma:this.comma();break;case J.asterisk:this.universal();break;case J.ampersand:this.nesting();break;case J.slash:case J.combinator:this.combinator();break;case J.str:this.string();break;case J.closeSquare:this.missingSquareBracket();case J.semicolon:this.missingBackslash();default:this.unexpected()}};Parser.prototype.expected=function expected(e,r,t){if(Array.isArray(e)){var n=e.pop();e=e.join(", ")+" or "+n}var i=/^[aeiou]/.test(e[0])?"an":"a";if(!t){return this.error("Expected "+i+" "+e+".",{index:r})}return this.error("Expected "+i+" "+e+', found "'+t+'" instead.',{index:r})};Parser.prototype.requiredSpace=function requiredSpace(e){return this.options.lossy?" ":e};Parser.prototype.optionalSpace=function optionalSpace(e){return this.options.lossy?"":e};Parser.prototype.lossySpace=function lossySpace(e,r){if(this.options.lossy){return r?" ":""}else{return e}};Parser.prototype.parseParenthesisToken=function parseParenthesisToken(e){var r=this.content(e);if(e[L.FIELDS.TYPE]===J.space){return this.requiredSpace(r)}else{return r}};Parser.prototype.newNode=function newNode(e,r){if(r){if(/^ +$/.test(r)){if(!this.options.lossy){this.spaces=(this.spaces||"")+r}r=true}e.namespace=r;unescapeProp(e,"namespace")}if(this.spaces){e.spaces.before=this.spaces;this.spaces=""}return this.current.append(e)};Parser.prototype.content=function content(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:this.currToken;return this.css.slice(e[L.FIELDS.START_POS],e[L.FIELDS.END_POS])};Parser.prototype.locateNextMeaningfulToken=function locateNextMeaningfulToken(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:this.position+1;var r=e;while(r<this.tokens.length){if(K[this.tokens[r][L.FIELDS.TYPE]]){r++;continue}else{return r}}return-1};n(Parser,[{key:"currToken",get:function get(){return this.tokens[this.position]}},{key:"nextToken",get:function get(){return this.tokens[this.position+1]}},{key:"prevToken",get:function get(){return this.tokens[this.position-1]}}]);return Parser}();r.default=z;e.exports=r["default"]},3509:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(6557);var i=_interopRequireDefault(n);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}var o=function(){function Processor(e,r){_classCallCheck(this,Processor);this.func=e||function noop(){};this.funcRes=null;this.options=r}Processor.prototype._shouldUpdateSelector=function _shouldUpdateSelector(e){var r=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var t=Object.assign({},this.options,r);if(t.updateSelector===false){return false}else{return typeof e!=="string"}};Processor.prototype._isLossy=function _isLossy(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var r=Object.assign({},this.options,e);if(r.lossless===false){return true}else{return false}};Processor.prototype._root=function _root(e){var r=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var t=new i.default(e,this._parseOptions(r));return t.root};Processor.prototype._parseOptions=function _parseOptions(e){return{lossy:this._isLossy(e)}};Processor.prototype._run=function _run(e){var r=this;var t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};return new Promise(function(n,i){try{var o=r._root(e,t);Promise.resolve(r.func(o)).then(function(n){var i=undefined;if(r._shouldUpdateSelector(e,t)){i=o.toString();e.selector=i}return{transform:n,root:o,string:i}}).then(n,i)}catch(e){i(e);return}})};Processor.prototype._runSync=function _runSync(e){var r=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var t=this._root(e,r);var n=this.func(t);if(n&&typeof n.then==="function"){throw new Error("Selector processor returned a promise to a synchronous call.")}var i=undefined;if(r.updateSelector&&typeof e!=="string"){i=t.toString();e.selector=i}return{transform:n,root:t,string:i}};Processor.prototype.ast=function ast(e,r){return this._run(e,r).then(function(e){return e.root})};Processor.prototype.astSync=function astSync(e,r){return this._runSync(e,r).root};Processor.prototype.transform=function transform(e,r){return this._run(e,r).then(function(e){return e.transform})};Processor.prototype.transformSync=function transformSync(e,r){return this._runSync(e,r).transform};Processor.prototype.process=function process(e,r){return this._run(e,r).then(function(e){return e.string||e.root.toString()})};Processor.prototype.processSync=function processSync(e,r){var t=this._runSync(e,r);return t.string||t.root.toString()};return Processor}();r.default=o;e.exports=r["default"]},7223:(e,r,t)=>{"use strict";r.__esModule=true;var n;var i=function(){function defineProperties(e,r){for(var t=0;t<r.length;t++){var n=r[t];n.enumerable=n.enumerable||false;n.configurable=true;if("value"in n)n.writable=true;Object.defineProperty(e,n.key,n)}}return function(e,r,t){if(r)defineProperties(e.prototype,r);if(t)defineProperties(e,t);return e}}();r.unescapeValue=unescapeValue;var o=t(5455);var s=_interopRequireDefault(o);var a=t(8127);var u=_interopRequireDefault(a);var c=t(1049);var l=_interopRequireDefault(c);var B=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var f=t(1669),p=f.deprecate;var d=/^('|")(.*)\1$/;var h=p(function(){},"Assigning an attribute a value containing characters that might need to be escaped is deprecated. "+"Call attribute.setValue() instead.");var v=p(function(){},"Assigning attr.quoted is deprecated and has no effect. Assign to attr.quoteMark instead.");var b=p(function(){},"Constructing an Attribute selector with a value without specifying quoteMark is deprecated. Note: The value should be unescaped now.");function unescapeValue(e){var r=false;var t=null;var n=e;var i=n.match(d);if(i){t=i[1];n=i[2]}n=(0,u.default)(n);if(n!==e){r=true}return{deprecatedUsage:r,unescaped:n,quoteMark:t}}function handleDeprecatedContructorOpts(e){if(e.quoteMark!==undefined){return e}if(e.value===undefined){return e}b();var r=unescapeValue(e.value),t=r.quoteMark,n=r.unescaped;if(!e.raws){e.raws={}}if(e.raws.value===undefined){e.raws.value=e.value}e.value=n;e.quoteMark=t;return e}var C=function(e){_inherits(Attribute,e);function Attribute(){var r=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};_classCallCheck(this,Attribute);var t=_possibleConstructorReturn(this,e.call(this,handleDeprecatedContructorOpts(r)));t.type=B.ATTRIBUTE;t.raws=t.raws||{};Object.defineProperty(t.raws,"unquoted",{get:p(function(){return t.value},"attr.raws.unquoted is deprecated. Call attr.value instead."),set:p(function(){return t.value},"Setting attr.raws.unquoted is deprecated and has no effect. attr.value is unescaped by default now.")});t._constructed=true;return t}Attribute.prototype.getQuotedValue=function getQuotedValue(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var r=this._determineQuoteMark(e);var t=g[r];var n=(0,s.default)(this._value,t);return n};Attribute.prototype._determineQuoteMark=function _determineQuoteMark(e){return e.smart?this.smartQuoteMark(e):this.preferredQuoteMark(e)};Attribute.prototype.setValue=function setValue(e){var r=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};this._value=e;this._quoteMark=this._determineQuoteMark(r);this._syncRawValue()};Attribute.prototype.smartQuoteMark=function smartQuoteMark(e){var r=this.value;var t=r.replace(/[^']/g,"").length;var n=r.replace(/[^"]/g,"").length;if(t+n===0){var i=(0,s.default)(r,{isIdentifier:true});if(i===r){return Attribute.NO_QUOTE}else{var o=this.preferredQuoteMark(e);if(o===Attribute.NO_QUOTE){var a=this.quoteMark||e.quoteMark||Attribute.DOUBLE_QUOTE;var u=g[a];var c=(0,s.default)(r,u);if(c.length<i.length){return a}}return o}}else if(n===t){return this.preferredQuoteMark(e)}else if(n<t){return Attribute.DOUBLE_QUOTE}else{return Attribute.SINGLE_QUOTE}};Attribute.prototype.preferredQuoteMark=function preferredQuoteMark(e){var r=e.preferCurrentQuoteMark?this.quoteMark:e.quoteMark;if(r===undefined){r=e.preferCurrentQuoteMark?e.quoteMark:this.quoteMark}if(r===undefined){r=Attribute.DOUBLE_QUOTE}return r};Attribute.prototype._syncRawValue=function _syncRawValue(){var e=(0,s.default)(this._value,g[this.quoteMark]);if(e===this._value){if(this.raws){delete this.raws.value}}else{this.raws.value=e}};Attribute.prototype._handleEscapes=function _handleEscapes(e,r){if(this._constructed){var t=(0,s.default)(r,{isIdentifier:true});if(t!==r){this.raws[e]=t}else{delete this.raws[e]}}};Attribute.prototype._spacesFor=function _spacesFor(e){var r={before:"",after:""};var t=this.spaces[e]||{};var n=this.raws.spaces&&this.raws.spaces[e]||{};return Object.assign(r,t,n)};Attribute.prototype._stringFor=function _stringFor(e){var r=arguments.length>1&&arguments[1]!==undefined?arguments[1]:e;var t=arguments.length>2&&arguments[2]!==undefined?arguments[2]:defaultAttrConcat;var n=this._spacesFor(r);return t(this.stringifyProperty(e),n)};Attribute.prototype.offsetOf=function offsetOf(e){var r=1;var t=this._spacesFor("attribute");r+=t.before.length;if(e==="namespace"||e==="ns"){return this.namespace?r:-1}if(e==="attributeNS"){return r}r+=this.namespaceString.length;if(this.namespace){r+=1}if(e==="attribute"){return r}r+=this.stringifyProperty("attribute").length;r+=t.after.length;var n=this._spacesFor("operator");r+=n.before.length;var i=this.stringifyProperty("operator");if(e==="operator"){return i?r:-1}r+=i.length;r+=n.after.length;var o=this._spacesFor("value");r+=o.before.length;var s=this.stringifyProperty("value");if(e==="value"){return s?r:-1}r+=s.length;r+=o.after.length;var a=this._spacesFor("insensitive");r+=a.before.length;if(e==="insensitive"){return this.insensitive?r:-1}return-1};Attribute.prototype.toString=function toString(){var e=this;var r=[this.rawSpaceBefore,"["];r.push(this._stringFor("qualifiedAttribute","attribute"));if(this.operator&&this.value){r.push(this._stringFor("operator"));r.push(this._stringFor("value"));r.push(this._stringFor("insensitiveFlag","insensitive",function(r,t){if(r.length>0&&!e.quoted&&t.before.length===0&&!(e.spaces.value&&e.spaces.value.after)){t.before=" "}return defaultAttrConcat(r,t)}))}r.push("]");r.push(this.rawSpaceAfter);return r.join("")};i(Attribute,[{key:"quoted",get:function get(){var e=this.quoteMark;return e==="'"||e==='"'},set:function set(e){v()}},{key:"quoteMark",get:function get(){return this._quoteMark},set:function set(e){if(!this._constructed){this._quoteMark=e;return}if(this._quoteMark!==e){this._quoteMark=e;this._syncRawValue()}}},{key:"qualifiedAttribute",get:function get(){return this.qualifiedName(this.raws.attribute||this.attribute)}},{key:"insensitiveFlag",get:function get(){return this.insensitive?"i":""}},{key:"value",get:function get(){return this._value},set:function set(e){if(this._constructed){var r=unescapeValue(e),t=r.deprecatedUsage,n=r.unescaped,i=r.quoteMark;if(t){h()}if(n===this._value&&i===this._quoteMark){return}this._value=n;this._quoteMark=i;this._syncRawValue()}else{this._value=e}}},{key:"attribute",get:function get(){return this._attribute},set:function set(e){this._handleEscapes("attribute",e);this._attribute=e}}]);return Attribute}(l.default);C.NO_QUOTE=null;C.SINGLE_QUOTE="'";C.DOUBLE_QUOTE='"';r.default=C;var g=(n={"'":{quotes:"single",wrap:true},'"':{quotes:"double",wrap:true}},n[null]={isIdentifier:true},n);function defaultAttrConcat(e,r){return""+r.before+e+r.after}},586:(e,r,t)=>{"use strict";r.__esModule=true;var n=function(){function defineProperties(e,r){for(var t=0;t<r.length;t++){var n=r[t];n.enumerable=n.enumerable||false;n.configurable=true;if("value"in n)n.writable=true;Object.defineProperty(e,n.key,n)}}return function(e,r,t){if(r)defineProperties(e.prototype,r);if(t)defineProperties(e,t);return e}}();var i=t(5455);var o=_interopRequireDefault(i);var s=t(5431);var a=t(5731);var u=_interopRequireDefault(a);var c=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var l=function(e){_inherits(ClassName,e);function ClassName(r){_classCallCheck(this,ClassName);var t=_possibleConstructorReturn(this,e.call(this,r));t.type=c.CLASS;t._constructed=true;return t}ClassName.prototype.toString=function toString(){return[this.rawSpaceBefore,String("."+this.stringifyProperty("value")),this.rawSpaceAfter].join("")};n(ClassName,[{key:"value",set:function set(e){if(this._constructed){var r=(0,o.default)(e,{isIdentifier:true});if(r!==e){(0,s.ensureObject)(this,"raws");this.raws.value=r}else if(this.raws){delete this.raws.value}}this._value=e},get:function get(){return this._value}}]);return ClassName}(u.default);r.default=l;e.exports=r["default"]},1632:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(5731);var i=_interopRequireDefault(n);var o=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var s=function(e){_inherits(Combinator,e);function Combinator(r){_classCallCheck(this,Combinator);var t=_possibleConstructorReturn(this,e.call(this,r));t.type=o.COMBINATOR;return t}return Combinator}(i.default);r.default=s;e.exports=r["default"]},6435:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(5731);var i=_interopRequireDefault(n);var o=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var s=function(e){_inherits(Comment,e);function Comment(r){_classCallCheck(this,Comment);var t=_possibleConstructorReturn(this,e.call(this,r));t.type=o.COMMENT;return t}return Comment}(i.default);r.default=s;e.exports=r["default"]},4577:(e,r,t)=>{"use strict";r.__esModule=true;r.universal=r.tag=r.string=r.selector=r.root=r.pseudo=r.nesting=r.id=r.comment=r.combinator=r.className=r.attribute=undefined;var n=t(7223);var i=_interopRequireDefault(n);var o=t(586);var s=_interopRequireDefault(o);var a=t(1632);var u=_interopRequireDefault(a);var c=t(6435);var l=_interopRequireDefault(c);var B=t(1733);var f=_interopRequireDefault(B);var p=t(8081);var d=_interopRequireDefault(p);var h=t(716);var v=_interopRequireDefault(h);var b=t(1682);var C=_interopRequireDefault(b);var g=t(4955);var m=_interopRequireDefault(g);var y=t(1193);var w=_interopRequireDefault(y);var S=t(5201);var x=_interopRequireDefault(S);var O=t(3261);var P=_interopRequireDefault(O);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}var k=r.attribute=function attribute(e){return new i.default(e)};var A=r.className=function className(e){return new s.default(e)};var F=r.combinator=function combinator(e){return new u.default(e)};var j=r.comment=function comment(e){return new l.default(e)};var T=r.id=function id(e){return new f.default(e)};var D=r.nesting=function nesting(e){return new d.default(e)};var E=r.pseudo=function pseudo(e){return new v.default(e)};var R=r.root=function root(e){return new C.default(e)};var I=r.selector=function selector(e){return new m.default(e)};var M=r.string=function string(e){return new w.default(e)};var L=r.tag=function tag(e){return new x.default(e)};var G=r.universal=function universal(e){return new P.default(e)}},2407:(e,r,t)=>{"use strict";r.__esModule=true;var n=function(){function defineProperties(e,r){for(var t=0;t<r.length;t++){var n=r[t];n.enumerable=n.enumerable||false;n.configurable=true;if("value"in n)n.writable=true;Object.defineProperty(e,n.key,n)}}return function(e,r,t){if(r)defineProperties(e.prototype,r);if(t)defineProperties(e,t);return e}}();var i=t(5731);var o=_interopRequireDefault(i);var s=t(9107);var a=_interopRequireWildcard(s);function _interopRequireWildcard(e){if(e&&e.__esModule){return e}else{var r={};if(e!=null){for(var t in e){if(Object.prototype.hasOwnProperty.call(e,t))r[t]=e[t]}}r.default=e;return r}}function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var u=function(e){_inherits(Container,e);function Container(r){_classCallCheck(this,Container);var t=_possibleConstructorReturn(this,e.call(this,r));if(!t.nodes){t.nodes=[]}return t}Container.prototype.append=function append(e){e.parent=this;this.nodes.push(e);return this};Container.prototype.prepend=function prepend(e){e.parent=this;this.nodes.unshift(e);return this};Container.prototype.at=function at(e){return this.nodes[e]};Container.prototype.index=function index(e){if(typeof e==="number"){return e}return this.nodes.indexOf(e)};Container.prototype.removeChild=function removeChild(e){e=this.index(e);this.at(e).parent=undefined;this.nodes.splice(e,1);var r=void 0;for(var t in this.indexes){r=this.indexes[t];if(r>=e){this.indexes[t]=r-1}}return this};Container.prototype.removeAll=function removeAll(){for(var e=this.nodes,r=Array.isArray(e),t=0,e=r?e:e[Symbol.iterator]();;){var n;if(r){if(t>=e.length)break;n=e[t++]}else{t=e.next();if(t.done)break;n=t.value}var i=n;i.parent=undefined}this.nodes=[];return this};Container.prototype.empty=function empty(){return this.removeAll()};Container.prototype.insertAfter=function insertAfter(e,r){r.parent=this;var t=this.index(e);this.nodes.splice(t+1,0,r);r.parent=this;var n=void 0;for(var i in this.indexes){n=this.indexes[i];if(t<=n){this.indexes[i]=n+1}}return this};Container.prototype.insertBefore=function insertBefore(e,r){r.parent=this;var t=this.index(e);this.nodes.splice(t,0,r);r.parent=this;var n=void 0;for(var i in this.indexes){n=this.indexes[i];if(n<=t){this.indexes[i]=n+1}}return this};Container.prototype._findChildAtPosition=function _findChildAtPosition(e,r){var t=undefined;this.each(function(n){if(n.atPosition){var i=n.atPosition(e,r);if(i){t=i;return false}}else if(n.isAtPosition(e,r)){t=n;return false}});return t};Container.prototype.atPosition=function atPosition(e,r){if(this.isAtPosition(e,r)){return this._findChildAtPosition(e,r)||this}else{return undefined}};Container.prototype._inferEndPosition=function _inferEndPosition(){if(this.last&&this.last.source&&this.last.source.end){this.source=this.source||{};this.source.end=this.source.end||{};Object.assign(this.source.end,this.last.source.end)}};Container.prototype.each=function each(e){if(!this.lastEach){this.lastEach=0}if(!this.indexes){this.indexes={}}this.lastEach++;var r=this.lastEach;this.indexes[r]=0;if(!this.length){return undefined}var t=void 0,n=void 0;while(this.indexes[r]<this.length){t=this.indexes[r];n=e(this.at(t),t);if(n===false){break}this.indexes[r]+=1}delete this.indexes[r];if(n===false){return false}};Container.prototype.walk=function walk(e){return this.each(function(r,t){var n=e(r,t);if(n!==false&&r.length){n=r.walk(e)}if(n===false){return false}})};Container.prototype.walkAttributes=function walkAttributes(e){var r=this;return this.walk(function(t){if(t.type===a.ATTRIBUTE){return e.call(r,t)}})};Container.prototype.walkClasses=function walkClasses(e){var r=this;return this.walk(function(t){if(t.type===a.CLASS){return e.call(r,t)}})};Container.prototype.walkCombinators=function walkCombinators(e){var r=this;return this.walk(function(t){if(t.type===a.COMBINATOR){return e.call(r,t)}})};Container.prototype.walkComments=function walkComments(e){var r=this;return this.walk(function(t){if(t.type===a.COMMENT){return e.call(r,t)}})};Container.prototype.walkIds=function walkIds(e){var r=this;return this.walk(function(t){if(t.type===a.ID){return e.call(r,t)}})};Container.prototype.walkNesting=function walkNesting(e){var r=this;return this.walk(function(t){if(t.type===a.NESTING){return e.call(r,t)}})};Container.prototype.walkPseudos=function walkPseudos(e){var r=this;return this.walk(function(t){if(t.type===a.PSEUDO){return e.call(r,t)}})};Container.prototype.walkTags=function walkTags(e){var r=this;return this.walk(function(t){if(t.type===a.TAG){return e.call(r,t)}})};Container.prototype.walkUniversals=function walkUniversals(e){var r=this;return this.walk(function(t){if(t.type===a.UNIVERSAL){return e.call(r,t)}})};Container.prototype.split=function split(e){var r=this;var t=[];return this.reduce(function(n,i,o){var s=e.call(r,i);t.push(i);if(s){n.push(t);t=[]}else if(o===r.length-1){n.push(t)}return n},[])};Container.prototype.map=function map(e){return this.nodes.map(e)};Container.prototype.reduce=function reduce(e,r){return this.nodes.reduce(e,r)};Container.prototype.every=function every(e){return this.nodes.every(e)};Container.prototype.some=function some(e){return this.nodes.some(e)};Container.prototype.filter=function filter(e){return this.nodes.filter(e)};Container.prototype.sort=function sort(e){return this.nodes.sort(e)};Container.prototype.toString=function toString(){return this.map(String).join("")};n(Container,[{key:"first",get:function get(){return this.at(0)}},{key:"last",get:function get(){return this.at(this.length-1)}},{key:"length",get:function get(){return this.nodes.length}}]);return Container}(o.default);r.default=u;e.exports=r["default"]},9565:(e,r,t)=>{"use strict";r.__esModule=true;r.isUniversal=r.isTag=r.isString=r.isSelector=r.isRoot=r.isPseudo=r.isNesting=r.isIdentifier=r.isComment=r.isCombinator=r.isClassName=r.isAttribute=undefined;var n=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(e){return typeof e}:function(e){return e&&typeof Symbol==="function"&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};var i;r.isNode=isNode;r.isPseudoElement=isPseudoElement;r.isPseudoClass=isPseudoClass;r.isContainer=isContainer;r.isNamespace=isNamespace;var o=t(9107);var s=(i={},i[o.ATTRIBUTE]=true,i[o.CLASS]=true,i[o.COMBINATOR]=true,i[o.COMMENT]=true,i[o.ID]=true,i[o.NESTING]=true,i[o.PSEUDO]=true,i[o.ROOT]=true,i[o.SELECTOR]=true,i[o.STRING]=true,i[o.TAG]=true,i[o.UNIVERSAL]=true,i);function isNode(e){return(typeof e==="undefined"?"undefined":n(e))==="object"&&s[e.type]}function isNodeType(e,r){return isNode(r)&&r.type===e}var a=r.isAttribute=isNodeType.bind(null,o.ATTRIBUTE);var u=r.isClassName=isNodeType.bind(null,o.CLASS);var c=r.isCombinator=isNodeType.bind(null,o.COMBINATOR);var l=r.isComment=isNodeType.bind(null,o.COMMENT);var B=r.isIdentifier=isNodeType.bind(null,o.ID);var f=r.isNesting=isNodeType.bind(null,o.NESTING);var p=r.isPseudo=isNodeType.bind(null,o.PSEUDO);var d=r.isRoot=isNodeType.bind(null,o.ROOT);var h=r.isSelector=isNodeType.bind(null,o.SELECTOR);var v=r.isString=isNodeType.bind(null,o.STRING);var b=r.isTag=isNodeType.bind(null,o.TAG);var C=r.isUniversal=isNodeType.bind(null,o.UNIVERSAL);function isPseudoElement(e){return p(e)&&e.value&&(e.value.startsWith("::")||e.value===":before"||e.value===":after")}function isPseudoClass(e){return p(e)&&!isPseudoElement(e)}function isContainer(e){return!!(isNode(e)&&e.walk)}function isNamespace(e){return a(e)||b(e)}},1733:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(5731);var i=_interopRequireDefault(n);var o=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var s=function(e){_inherits(ID,e);function ID(r){_classCallCheck(this,ID);var t=_possibleConstructorReturn(this,e.call(this,r));t.type=o.ID;return t}ID.prototype.toString=function toString(){return[this.rawSpaceBefore,String("#"+this.stringifyProperty("value")),this.rawSpaceAfter].join("")};return ID}(i.default);r.default=s;e.exports=r["default"]},4267:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(9107);Object.keys(n).forEach(function(e){if(e==="default"||e==="__esModule")return;Object.defineProperty(r,e,{enumerable:true,get:function get(){return n[e]}})});var i=t(4577);Object.keys(i).forEach(function(e){if(e==="default"||e==="__esModule")return;Object.defineProperty(r,e,{enumerable:true,get:function get(){return i[e]}})});var o=t(9565);Object.keys(o).forEach(function(e){if(e==="default"||e==="__esModule")return;Object.defineProperty(r,e,{enumerable:true,get:function get(){return o[e]}})})},1049:(e,r,t)=>{"use strict";r.__esModule=true;var n=function(){function defineProperties(e,r){for(var t=0;t<r.length;t++){var n=r[t];n.enumerable=n.enumerable||false;n.configurable=true;if("value"in n)n.writable=true;Object.defineProperty(e,n.key,n)}}return function(e,r,t){if(r)defineProperties(e.prototype,r);if(t)defineProperties(e,t);return e}}();var i=t(5455);var o=_interopRequireDefault(i);var s=t(5431);var a=t(5731);var u=_interopRequireDefault(a);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var c=function(e){_inherits(Namespace,e);function Namespace(){_classCallCheck(this,Namespace);return _possibleConstructorReturn(this,e.apply(this,arguments))}Namespace.prototype.qualifiedName=function qualifiedName(e){if(this.namespace){return this.namespaceString+"|"+e}else{return e}};Namespace.prototype.toString=function toString(){return[this.rawSpaceBefore,this.qualifiedName(this.stringifyProperty("value")),this.rawSpaceAfter].join("")};n(Namespace,[{key:"namespace",get:function get(){return this._namespace},set:function set(e){if(e===true||e==="*"||e==="&"){this._namespace=e;if(this.raws){delete this.raws.namespace}return}var r=(0,o.default)(e,{isIdentifier:true});this._namespace=e;if(r!==e){(0,s.ensureObject)(this,"raws");this.raws.namespace=r}else if(this.raws){delete this.raws.namespace}}},{key:"ns",get:function get(){return this._namespace},set:function set(e){this.namespace=e}},{key:"namespaceString",get:function get(){if(this.namespace){var e=this.stringifyProperty("namespace");if(e===true){return""}else{return e}}else{return""}}}]);return Namespace}(u.default);r.default=c;e.exports=r["default"]},8081:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(5731);var i=_interopRequireDefault(n);var o=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var s=function(e){_inherits(Nesting,e);function Nesting(r){_classCallCheck(this,Nesting);var t=_possibleConstructorReturn(this,e.call(this,r));t.type=o.NESTING;t.value="&";return t}return Nesting}(i.default);r.default=s;e.exports=r["default"]},5731:(e,r,t)=>{"use strict";r.__esModule=true;var n=function(){function defineProperties(e,r){for(var t=0;t<r.length;t++){var n=r[t];n.enumerable=n.enumerable||false;n.configurable=true;if("value"in n)n.writable=true;Object.defineProperty(e,n.key,n)}}return function(e,r,t){if(r)defineProperties(e.prototype,r);if(t)defineProperties(e,t);return e}}();var i=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(e){return typeof e}:function(e){return e&&typeof Symbol==="function"&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};var o=t(5431);function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}var s=function cloneNode(e,r){if((typeof e==="undefined"?"undefined":i(e))!=="object"||e===null){return e}var t=new e.constructor;for(var n in e){if(!e.hasOwnProperty(n)){continue}var o=e[n];var s=typeof o==="undefined"?"undefined":i(o);if(n==="parent"&&s==="object"){if(r){t[n]=r}}else if(o instanceof Array){t[n]=o.map(function(e){return cloneNode(e,t)})}else{t[n]=cloneNode(o,t)}}return t};var a=function(){function Node(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};_classCallCheck(this,Node);Object.assign(this,e);this.spaces=this.spaces||{};this.spaces.before=this.spaces.before||"";this.spaces.after=this.spaces.after||""}Node.prototype.remove=function remove(){if(this.parent){this.parent.removeChild(this)}this.parent=undefined;return this};Node.prototype.replaceWith=function replaceWith(){if(this.parent){for(var e in arguments){this.parent.insertBefore(this,arguments[e])}this.remove()}return this};Node.prototype.next=function next(){return this.parent.at(this.parent.index(this)+1)};Node.prototype.prev=function prev(){return this.parent.at(this.parent.index(this)-1)};Node.prototype.clone=function clone(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var r=s(this);for(var t in e){r[t]=e[t]}return r};Node.prototype.appendToPropertyAndEscape=function appendToPropertyAndEscape(e,r,t){if(!this.raws){this.raws={}}var n=this[e];var i=this.raws[e];this[e]=n+r;if(i||t!==r){this.raws[e]=(i||n)+t}else{delete this.raws[e]}};Node.prototype.setPropertyAndEscape=function setPropertyAndEscape(e,r,t){if(!this.raws){this.raws={}}this[e]=r;this.raws[e]=t};Node.prototype.setPropertyWithoutEscape=function setPropertyWithoutEscape(e,r){this[e]=r;if(this.raws){delete this.raws[e]}};Node.prototype.isAtPosition=function isAtPosition(e,r){if(this.source&&this.source.start&&this.source.end){if(this.source.start.line>e){return false}if(this.source.end.line<e){return false}if(this.source.start.line===e&&this.source.start.column>r){return false}if(this.source.end.line===e&&this.source.end.column<r){return false}return true}return undefined};Node.prototype.stringifyProperty=function stringifyProperty(e){return this.raws&&this.raws[e]||this[e]};Node.prototype.toString=function toString(){return[this.rawSpaceBefore,String(this.stringifyProperty("value")),this.rawSpaceAfter].join("")};n(Node,[{key:"rawSpaceBefore",get:function get(){var e=this.raws&&this.raws.spaces&&this.raws.spaces.before;if(e===undefined){e=this.spaces&&this.spaces.before}return e||""},set:function set(e){(0,o.ensureObject)(this,"raws","spaces");this.raws.spaces.before=e}},{key:"rawSpaceAfter",get:function get(){var e=this.raws&&this.raws.spaces&&this.raws.spaces.after;if(e===undefined){e=this.spaces.after}return e||""},set:function set(e){(0,o.ensureObject)(this,"raws","spaces");this.raws.spaces.after=e}}]);return Node}();r.default=a;e.exports=r["default"]},716:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(2407);var i=_interopRequireDefault(n);var o=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var s=function(e){_inherits(Pseudo,e);function Pseudo(r){_classCallCheck(this,Pseudo);var t=_possibleConstructorReturn(this,e.call(this,r));t.type=o.PSEUDO;return t}Pseudo.prototype.toString=function toString(){var e=this.length?"("+this.map(String).join(",")+")":"";return[this.rawSpaceBefore,this.stringifyProperty("value"),e,this.rawSpaceAfter].join("")};return Pseudo}(i.default);r.default=s;e.exports=r["default"]},1682:(e,r,t)=>{"use strict";r.__esModule=true;var n=function(){function defineProperties(e,r){for(var t=0;t<r.length;t++){var n=r[t];n.enumerable=n.enumerable||false;n.configurable=true;if("value"in n)n.writable=true;Object.defineProperty(e,n.key,n)}}return function(e,r,t){if(r)defineProperties(e.prototype,r);if(t)defineProperties(e,t);return e}}();var i=t(2407);var o=_interopRequireDefault(i);var s=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var a=function(e){_inherits(Root,e);function Root(r){_classCallCheck(this,Root);var t=_possibleConstructorReturn(this,e.call(this,r));t.type=s.ROOT;return t}Root.prototype.toString=function toString(){var e=this.reduce(function(e,r){e.push(String(r));return e},[]).join(",");return this.trailingComma?e+",":e};Root.prototype.error=function error(e,r){if(this._error){return this._error(e,r)}else{return new Error(e)}};n(Root,[{key:"errorGenerator",set:function set(e){this._error=e}}]);return Root}(o.default);r.default=a;e.exports=r["default"]},4955:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(2407);var i=_interopRequireDefault(n);var o=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var s=function(e){_inherits(Selector,e);function Selector(r){_classCallCheck(this,Selector);var t=_possibleConstructorReturn(this,e.call(this,r));t.type=o.SELECTOR;return t}return Selector}(i.default);r.default=s;e.exports=r["default"]},1193:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(5731);var i=_interopRequireDefault(n);var o=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var s=function(e){_inherits(String,e);function String(r){_classCallCheck(this,String);var t=_possibleConstructorReturn(this,e.call(this,r));t.type=o.STRING;return t}return String}(i.default);r.default=s;e.exports=r["default"]},5201:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(1049);var i=_interopRequireDefault(n);var o=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var s=function(e){_inherits(Tag,e);function Tag(r){_classCallCheck(this,Tag);var t=_possibleConstructorReturn(this,e.call(this,r));t.type=o.TAG;return t}return Tag}(i.default);r.default=s;e.exports=r["default"]},9107:(e,r)=>{"use strict";r.__esModule=true;var t=r.TAG="tag";var n=r.STRING="string";var i=r.SELECTOR="selector";var o=r.ROOT="root";var s=r.PSEUDO="pseudo";var a=r.NESTING="nesting";var u=r.ID="id";var c=r.COMMENT="comment";var l=r.COMBINATOR="combinator";var B=r.CLASS="class";var f=r.ATTRIBUTE="attribute";var p=r.UNIVERSAL="universal"},3261:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(1049);var i=_interopRequireDefault(n);var o=t(9107);function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _classCallCheck(e,r){if(!(e instanceof r)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(e,r){if(!e){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return r&&(typeof r==="object"||typeof r==="function")?r:e}function _inherits(e,r){if(typeof r!=="function"&&r!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof r)}e.prototype=Object.create(r&&r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}});if(r)Object.setPrototypeOf?Object.setPrototypeOf(e,r):e.__proto__=r}var s=function(e){_inherits(Universal,e);function Universal(r){_classCallCheck(this,Universal);var t=_possibleConstructorReturn(this,e.call(this,r));t.type=o.UNIVERSAL;t.value="*";return t}return Universal}(i.default);r.default=s;e.exports=r["default"]},5571:(e,r)=>{"use strict";r.__esModule=true;r.default=sortAscending;function sortAscending(e){return e.sort(function(e,r){return e-r})}e.exports=r["default"]},7024:(e,r)=>{"use strict";r.__esModule=true;var t=r.ampersand=38;var n=r.asterisk=42;var i=r.at=64;var o=r.comma=44;var s=r.colon=58;var a=r.semicolon=59;var u=r.openParenthesis=40;var c=r.closeParenthesis=41;var l=r.openSquare=91;var B=r.closeSquare=93;var f=r.dollar=36;var p=r.tilde=126;var d=r.caret=94;var h=r.plus=43;var v=r.equals=61;var b=r.pipe=124;var C=r.greaterThan=62;var g=r.space=32;var m=r.singleQuote=39;var y=r.doubleQuote=34;var w=r.slash=47;var S=r.bang=33;var x=r.backslash=92;var O=r.cr=13;var P=r.feed=12;var k=r.newline=10;var A=r.tab=9;var F=r.str=m;var j=r.comment=-1;var T=r.word=-2;var D=r.combinator=-3},5648:(e,r,t)=>{"use strict";r.__esModule=true;r.FIELDS=undefined;var n,i;r.default=tokenize;var o=t(7024);var s=_interopRequireWildcard(o);function _interopRequireWildcard(e){if(e&&e.__esModule){return e}else{var r={};if(e!=null){for(var t in e){if(Object.prototype.hasOwnProperty.call(e,t))r[t]=e[t]}}r.default=e;return r}}var a=(n={},n[s.tab]=true,n[s.newline]=true,n[s.cr]=true,n[s.feed]=true,n);var u=(i={},i[s.space]=true,i[s.tab]=true,i[s.newline]=true,i[s.cr]=true,i[s.feed]=true,i[s.ampersand]=true,i[s.asterisk]=true,i[s.bang]=true,i[s.comma]=true,i[s.colon]=true,i[s.semicolon]=true,i[s.openParenthesis]=true,i[s.closeParenthesis]=true,i[s.openSquare]=true,i[s.closeSquare]=true,i[s.singleQuote]=true,i[s.doubleQuote]=true,i[s.plus]=true,i[s.pipe]=true,i[s.tilde]=true,i[s.greaterThan]=true,i[s.equals]=true,i[s.dollar]=true,i[s.caret]=true,i[s.slash]=true,i);var c={};var l="0123456789abcdefABCDEF";for(var B=0;B<l.length;B++){c[l.charCodeAt(B)]=true}function consumeWord(e,r){var t=r;var n=void 0;do{n=e.charCodeAt(t);if(u[n]){return t-1}else if(n===s.backslash){t=consumeEscape(e,t)+1}else{t++}}while(t<e.length);return t-1}function consumeEscape(e,r){var t=r;var n=e.charCodeAt(t+1);if(a[n]){}else if(c[n]){var i=0;do{t++;i++;n=e.charCodeAt(t+1)}while(c[n]&&i<6);if(i<6&&n===s.space){t++}}else{t++}return t}var f=r.FIELDS={TYPE:0,START_LINE:1,START_COL:2,END_LINE:3,END_COL:4,START_POS:5,END_POS:6};function tokenize(e){var r=[];var t=e.css.valueOf();var n=t,i=n.length;var o=-1;var a=1;var u=0;var c=0;var l=void 0,B=void 0,f=void 0,p=void 0,d=void 0,h=void 0,v=void 0,b=void 0,C=void 0,g=void 0,m=void 0,y=void 0,w=void 0;function unclosed(r,n){if(e.safe){t+=n;C=t.length-1}else{throw e.error("Unclosed "+r,a,u-o,u)}}while(u<i){l=t.charCodeAt(u);if(l===s.newline){o=u;a+=1}switch(l){case s.space:case s.tab:case s.newline:case s.cr:case s.feed:C=u;do{C+=1;l=t.charCodeAt(C);if(l===s.newline){o=C;a+=1}}while(l===s.space||l===s.newline||l===s.tab||l===s.cr||l===s.feed);w=s.space;p=a;f=C-o-1;c=C;break;case s.plus:case s.greaterThan:case s.tilde:case s.pipe:C=u;do{C+=1;l=t.charCodeAt(C)}while(l===s.plus||l===s.greaterThan||l===s.tilde||l===s.pipe);w=s.combinator;p=a;f=u-o;c=C;break;case s.asterisk:case s.ampersand:case s.bang:case s.comma:case s.equals:case s.dollar:case s.caret:case s.openSquare:case s.closeSquare:case s.colon:case s.semicolon:case s.openParenthesis:case s.closeParenthesis:C=u;w=l;p=a;f=u-o;c=C+1;break;case s.singleQuote:case s.doubleQuote:y=l===s.singleQuote?"'":'"';C=u;do{d=false;C=t.indexOf(y,C+1);if(C===-1){unclosed("quote",y)}h=C;while(t.charCodeAt(h-1)===s.backslash){h-=1;d=!d}}while(d);w=s.str;p=a;f=u-o;c=C+1;break;default:if(l===s.slash&&t.charCodeAt(u+1)===s.asterisk){C=t.indexOf("*/",u+2)+1;if(C===0){unclosed("comment","*/")}B=t.slice(u,C+1);b=B.split("\n");v=b.length-1;if(v>0){g=a+v;m=C-b[v].length}else{g=a;m=o}w=s.comment;a=g;p=g;f=C-m}else if(l===s.slash){C=u;w=l;p=a;f=u-o;c=C+1}else{C=consumeWord(t,u);w=s.word;p=a;f=C-o}c=C+1;break}r.push([w,a,u-o,p,f,u,c]);if(m){o=m;m=null}u=c}return r}},7378:(e,r)=>{"use strict";r.__esModule=true;r.default=ensureObject;function ensureObject(e){for(var r=arguments.length,t=Array(r>1?r-1:0),n=1;n<r;n++){t[n-1]=arguments[n]}while(t.length>0){var i=t.shift();if(!e[i]){e[i]={}}e=e[i]}}e.exports=r["default"]},2585:(e,r)=>{"use strict";r.__esModule=true;r.default=getProp;function getProp(e){for(var r=arguments.length,t=Array(r>1?r-1:0),n=1;n<r;n++){t[n-1]=arguments[n]}while(t.length>0){var i=t.shift();if(!e[i]){return undefined}e=e[i]}return e}e.exports=r["default"]},5431:(e,r,t)=>{"use strict";r.__esModule=true;var n=t(8127);Object.defineProperty(r,"unesc",{enumerable:true,get:function get(){return _interopRequireDefault(n).default}});var i=t(2585);Object.defineProperty(r,"getProp",{enumerable:true,get:function get(){return _interopRequireDefault(i).default}});var o=t(7378);Object.defineProperty(r,"ensureObject",{enumerable:true,get:function get(){return _interopRequireDefault(o).default}});var s=t(4585);Object.defineProperty(r,"stripComments",{enumerable:true,get:function get(){return _interopRequireDefault(s).default}});function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}},4585:(e,r)=>{"use strict";r.__esModule=true;r.default=stripComments;function stripComments(e){var r="";var t=e.indexOf("/*");var n=0;while(t>=0){r=r+e.slice(n,t);var i=e.indexOf("*/",t+2);if(i<0){return r}n=i+2;t=e.indexOf("/*",n)}r=r+e.slice(n);return r}e.exports=r["default"]},8127:(e,r)=>{"use strict";r.__esModule=true;r.default=unesc;var t=/\\(?:([0-9a-fA-F]{6})|([0-9a-fA-F]{1,5})(?: |(?![0-9a-fA-F])))/g;var n=/\\(.)/g;function unesc(e){e=e.replace(t,function(e,r,t){var n=r||t;var i=parseInt(n,16);return String.fromCharCode(i)});e=e.replace(n,function(e,r){return r});return e}e.exports=r["default"]},2334:(e,r,t)=>{"use strict";const n=t(9745);class AtWord extends n{constructor(e){super(e);this.type="atword"}toString(){let e=this.quoted?this.raws.quote:"";return[this.raws.before,"@",String.prototype.toString.call(this.value),this.raws.after].join("")}}n.registerWalker(AtWord);e.exports=AtWord},1776:(e,r,t)=>{"use strict";const n=t(9745);const i=t(7203);class Colon extends i{constructor(e){super(e);this.type="colon"}}n.registerWalker(Colon);e.exports=Colon},6429:(e,r,t)=>{"use strict";const n=t(9745);const i=t(7203);class Comma extends i{constructor(e){super(e);this.type="comma"}}n.registerWalker(Comma);e.exports=Comma},8688:(e,r,t)=>{"use strict";const n=t(9745);const i=t(7203);class Comment extends i{constructor(e){super(e);this.type="comment";this.inline=Object(e).inline||false}toString(){return[this.raws.before,this.inline?"//":"/*",String(this.value),this.inline?"":"*/",this.raws.after].join("")}}n.registerWalker(Comment);e.exports=Comment},9745:(e,r,t)=>{"use strict";const n=t(7203);class Container extends n{constructor(e){super(e);if(!this.nodes){this.nodes=[]}}push(e){e.parent=this;this.nodes.push(e);return this}each(e){if(!this.lastEach)this.lastEach=0;if(!this.indexes)this.indexes={};this.lastEach+=1;let r=this.lastEach,t,n;this.indexes[r]=0;if(!this.nodes)return undefined;while(this.indexes[r]<this.nodes.length){t=this.indexes[r];n=e(this.nodes[t],t);if(n===false)break;this.indexes[r]+=1}delete this.indexes[r];return n}walk(e){return this.each((r,t)=>{let n=e(r,t);if(n!==false&&r.walk){n=r.walk(e)}return n})}walkType(e,r){if(!e||!r){throw new Error("Parameters {type} and {callback} are required.")}const t=typeof e==="function";return this.walk((n,i)=>{if(t&&n instanceof e||!t&&n.type===e){return r.call(this,n,i)}})}append(e){e.parent=this;this.nodes.push(e);return this}prepend(e){e.parent=this;this.nodes.unshift(e);return this}cleanRaws(e){super.cleanRaws(e);if(this.nodes){for(let r of this.nodes)r.cleanRaws(e)}}insertAfter(e,r){let t=this.index(e),n;this.nodes.splice(t+1,0,r);for(let e in this.indexes){n=this.indexes[e];if(t<=n){this.indexes[e]=n+this.nodes.length}}return this}insertBefore(e,r){let t=this.index(e),n;this.nodes.splice(t,0,r);for(let e in this.indexes){n=this.indexes[e];if(t<=n){this.indexes[e]=n+this.nodes.length}}return this}removeChild(e){e=this.index(e);this.nodes[e].parent=undefined;this.nodes.splice(e,1);let r;for(let t in this.indexes){r=this.indexes[t];if(r>=e){this.indexes[t]=r-1}}return this}removeAll(){for(let e of this.nodes)e.parent=undefined;this.nodes=[];return this}every(e){return this.nodes.every(e)}some(e){return this.nodes.some(e)}index(e){if(typeof e==="number"){return e}else{return this.nodes.indexOf(e)}}get first(){if(!this.nodes)return undefined;return this.nodes[0]}get last(){if(!this.nodes)return undefined;return this.nodes[this.nodes.length-1]}toString(){let e=this.nodes.map(String).join("");if(this.value){e=this.value+e}if(this.raws.before){e=this.raws.before+e}if(this.raws.after){e+=this.raws.after}return e}}Container.registerWalker=(e=>{let r="walk"+e.name;if(r.lastIndexOf("s")!==r.length-1){r+="s"}if(Container.prototype[r]){return}Container.prototype[r]=function(r){return this.walkType(e,r)}});e.exports=Container},7016:e=>{"use strict";class ParserError extends Error{constructor(e){super(e);this.name=this.constructor.name;this.message=e||"An error ocurred while parsing.";if(typeof Error.captureStackTrace==="function"){Error.captureStackTrace(this,this.constructor)}else{this.stack=new Error(e).stack}}}e.exports=ParserError},4828:e=>{"use strict";class TokenizeError extends Error{constructor(e){super(e);this.name=this.constructor.name;this.message=e||"An error ocurred while tokzenizing.";if(typeof Error.captureStackTrace==="function"){Error.captureStackTrace(this,this.constructor)}else{this.stack=new Error(e).stack}}}e.exports=TokenizeError},7615:(e,r,t)=>{"use strict";const n=t(9745);class FunctionNode extends n{constructor(e){super(e);this.type="func";this.unbalanced=-1}}n.registerWalker(FunctionNode);e.exports=FunctionNode},9448:(e,r,t)=>{"use strict";const n=t(3663);const i=t(2334);const o=t(1776);const s=t(6429);const a=t(8688);const u=t(7615);const c=t(2541);const l=t(6005);const B=t(6827);const f=t(3300);const p=t(2897);const d=t(2964);const h=t(2945);let v=function(e,r){return new n(e,r)};v.atword=function(e){return new i(e)};v.colon=function(e){return new o(Object.assign({value:":"},e))};v.comma=function(e){return new s(Object.assign({value:","},e))};v.comment=function(e){return new a(e)};v.func=function(e){return new u(e)};v.number=function(e){return new c(e)};v.operator=function(e){return new l(e)};v.paren=function(e){return new B(Object.assign({value:"("},e))};v.string=function(e){return new f(Object.assign({quote:"'"},e))};v.value=function(e){return new d(e)};v.word=function(e){return new h(e)};v.unicodeRange=function(e){return new p(e)};e.exports=v},7203:e=>{"use strict";let r=function(e,t){let n=new e.constructor;for(let i in e){if(!e.hasOwnProperty(i))continue;let o=e[i],s=typeof o;if(i==="parent"&&s==="object"){if(t)n[i]=t}else if(i==="source"){n[i]=o}else if(o instanceof Array){n[i]=o.map(e=>r(e,n))}else if(i!=="before"&&i!=="after"&&i!=="between"&&i!=="semicolon"){if(s==="object"&&o!==null)o=r(o);n[i]=o}}return n};e.exports=class Node{constructor(e){e=e||{};this.raws={before:"",after:""};for(let r in e){this[r]=e[r]}}remove(){if(this.parent){this.parent.removeChild(this)}this.parent=undefined;return this}toString(){return[this.raws.before,String(this.value),this.raws.after].join("")}clone(e){e=e||{};let t=r(this);for(let r in e){t[r]=e[r]}return t}cloneBefore(e){e=e||{};let r=this.clone(e);this.parent.insertBefore(this,r);return r}cloneAfter(e){e=e||{};let r=this.clone(e);this.parent.insertAfter(this,r);return r}replaceWith(){let e=Array.prototype.slice.call(arguments);if(this.parent){for(let r of e){this.parent.insertBefore(this,r)}this.remove()}return this}moveTo(e){this.cleanRaws(this.root()===e.root());this.remove();e.append(this);return this}moveBefore(e){this.cleanRaws(this.root()===e.root());this.remove();e.parent.insertBefore(e,this);return this}moveAfter(e){this.cleanRaws(this.root()===e.root());this.remove();e.parent.insertAfter(e,this);return this}next(){let e=this.parent.index(this);return this.parent.nodes[e+1]}prev(){let e=this.parent.index(this);return this.parent.nodes[e-1]}toJSON(){let e={};for(let r in this){if(!this.hasOwnProperty(r))continue;if(r==="parent")continue;let t=this[r];if(t instanceof Array){e[r]=t.map(e=>{if(typeof e==="object"&&e.toJSON){return e.toJSON()}else{return e}})}else if(typeof t==="object"&&t.toJSON){e[r]=t.toJSON()}else{e[r]=t}}return e}root(){let e=this;while(e.parent)e=e.parent;return e}cleanRaws(e){delete this.raws.before;delete this.raws.after;if(!e)delete this.raws.between}positionInside(e){let r=this.toString(),t=this.source.start.column,n=this.source.start.line;for(let i=0;i<e;i++){if(r[i]==="\n"){t=1;n+=1}else{t+=1}}return{line:n,column:t}}positionBy(e){let r=this.source.start;if(Object(e).index){r=this.positionInside(e.index)}else if(Object(e).word){let t=this.toString().indexOf(e.word);if(t!==-1)r=this.positionInside(t)}return r}}},2541:(e,r,t)=>{"use strict";const n=t(9745);const i=t(7203);class NumberNode extends i{constructor(e){super(e);this.type="number";this.unit=Object(e).unit||""}toString(){return[this.raws.before,String(this.value),this.unit,this.raws.after].join("")}}n.registerWalker(NumberNode);e.exports=NumberNode},6005:(e,r,t)=>{"use strict";const n=t(9745);const i=t(7203);class Operator extends i{constructor(e){super(e);this.type="operator"}}n.registerWalker(Operator);e.exports=Operator},6827:(e,r,t)=>{"use strict";const n=t(9745);const i=t(7203);class Parenthesis extends i{constructor(e){super(e);this.type="paren";this.parenType=""}}n.registerWalker(Parenthesis);e.exports=Parenthesis},3663:(e,r,t)=>{"use strict";const n=t(2413);const i=t(2964);const o=t(2334);const s=t(1776);const a=t(6429);const u=t(8688);const c=t(7615);const l=t(2541);const B=t(6005);const f=t(6827);const p=t(3300);const d=t(2945);const h=t(2897);const v=t(868);const b=t(5202);const C=t(4751);const g=t(5632);const m=t(7016);function sortAscending(e){return e.sort((e,r)=>e-r)}e.exports=class Parser{constructor(e,r){const t={loose:false};this.cache=[];this.input=e;this.options=Object.assign({},t,r);this.position=0;this.unbalanced=0;this.root=new n;let o=new i;this.root.append(o);this.current=o;this.tokens=v(e,this.options)}parse(){return this.loop()}colon(){let e=this.currToken;this.newNode(new s({value:e[1],source:{start:{line:e[2],column:e[3]},end:{line:e[4],column:e[5]}},sourceIndex:e[6]}));this.position++}comma(){let e=this.currToken;this.newNode(new a({value:e[1],source:{start:{line:e[2],column:e[3]},end:{line:e[4],column:e[5]}},sourceIndex:e[6]}));this.position++}comment(){let e=false,r=this.currToken[1].replace(/\/\*|\*\//g,""),t;if(this.options.loose&&r.startsWith("//")){r=r.substring(2);e=true}t=new u({value:r,inline:e,source:{start:{line:this.currToken[2],column:this.currToken[3]},end:{line:this.currToken[4],column:this.currToken[5]}},sourceIndex:this.currToken[6]});this.newNode(t);this.position++}error(e,r){throw new m(e+` at line: ${r[2]}, column ${r[3]}`)}loop(){while(this.position<this.tokens.length){this.parseTokens()}if(!this.current.last&&this.spaces){this.current.raws.before+=this.spaces}else if(this.spaces){this.current.last.raws.after+=this.spaces}this.spaces="";return this.root}operator(){let e=this.currToken[1],r;if(e==="+"||e==="-"){if(!this.options.loose){if(this.position>0){if(this.current.type==="func"&&this.current.value==="calc"){if(this.prevToken[0]!=="space"&&this.prevToken[0]!=="("){this.error("Syntax Error",this.currToken)}else if(this.nextToken[0]!=="space"&&this.nextToken[0]!=="word"){this.error("Syntax Error",this.currToken)}else if(this.nextToken[0]==="word"&&this.current.last.type!=="operator"&&this.current.last.value!=="("){this.error("Syntax Error",this.currToken)}}else if(this.nextToken[0]==="space"||this.nextToken[0]==="operator"||this.prevToken[0]==="operator"){this.error("Syntax Error",this.currToken)}}}if(!this.options.loose){if(this.nextToken[0]==="word"){return this.word()}}else{if((!this.current.nodes.length||this.current.last&&this.current.last.type==="operator")&&this.nextToken[0]==="word"){return this.word()}}}r=new B({value:this.currToken[1],source:{start:{line:this.currToken[2],column:this.currToken[3]},end:{line:this.currToken[2],column:this.currToken[3]}},sourceIndex:this.currToken[4]});this.position++;return this.newNode(r)}parseTokens(){switch(this.currToken[0]){case"space":this.space();break;case"colon":this.colon();break;case"comma":this.comma();break;case"comment":this.comment();break;case"(":this.parenOpen();break;case")":this.parenClose();break;case"atword":case"word":this.word();break;case"operator":this.operator();break;case"string":this.string();break;case"unicoderange":this.unicodeRange();break;default:this.word();break}}parenOpen(){let e=1,r=this.position+1,t=this.currToken,n;while(r<this.tokens.length&&e){let t=this.tokens[r];if(t[0]==="("){e++}if(t[0]===")"){e--}r++}if(e){this.error("Expected closing parenthesis",t)}n=this.current.last;if(n&&n.type==="func"&&n.unbalanced<0){n.unbalanced=0;this.current=n}this.current.unbalanced++;this.newNode(new f({value:t[1],source:{start:{line:t[2],column:t[3]},end:{line:t[4],column:t[5]}},sourceIndex:t[6]}));this.position++;if(this.current.type==="func"&&this.current.unbalanced&&this.current.value==="url"&&this.currToken[0]!=="string"&&this.currToken[0]!==")"&&!this.options.loose){let e=this.nextToken,r=this.currToken[1],t={line:this.currToken[2],column:this.currToken[3]};while(e&&e[0]!==")"&&this.current.unbalanced){this.position++;r+=this.currToken[1];e=this.nextToken}if(this.position!==this.tokens.length-1){this.position++;this.newNode(new d({value:r,source:{start:t,end:{line:this.currToken[4],column:this.currToken[5]}},sourceIndex:this.currToken[6]}))}}}parenClose(){let e=this.currToken;this.newNode(new f({value:e[1],source:{start:{line:e[2],column:e[3]},end:{line:e[4],column:e[5]}},sourceIndex:e[6]}));this.position++;if(this.position>=this.tokens.length-1&&!this.current.unbalanced){return}this.current.unbalanced--;if(this.current.unbalanced<0){this.error("Expected opening parenthesis",e)}if(!this.current.unbalanced&&this.cache.length){this.current=this.cache.pop()}}space(){let e=this.currToken;if(this.position===this.tokens.length-1||this.nextToken[0]===","||this.nextToken[0]===")"){this.current.last.raws.after+=e[1];this.position++}else{this.spaces=e[1];this.position++}}unicodeRange(){let e=this.currToken;this.newNode(new h({value:e[1],source:{start:{line:e[2],column:e[3]},end:{line:e[4],column:e[5]}},sourceIndex:e[6]}));this.position++}splitWord(){let e=this.nextToken,r=this.currToken[1],t=/^[\+\-]?((\d+(\.\d*)?)|(\.\d+))([eE][\+\-]?\d+)?/,n=/^(?!\#([a-z0-9]+))[\#\{\}]/gi,i,s;if(!n.test(r)){while(e&&e[0]==="word"){this.position++;let t=this.currToken[1];r+=t;e=this.nextToken}}i=C(r,"@");s=sortAscending(g(b([[0],i])));s.forEach((n,a)=>{let u=s[a+1]||r.length,B=r.slice(n,u),f;if(~i.indexOf(n)){f=new o({value:B.slice(1),source:{start:{line:this.currToken[2],column:this.currToken[3]+n},end:{line:this.currToken[4],column:this.currToken[3]+(u-1)}},sourceIndex:this.currToken[6]+s[a]})}else if(t.test(this.currToken[1])){let e=B.replace(t,"");f=new l({value:B.replace(e,""),source:{start:{line:this.currToken[2],column:this.currToken[3]+n},end:{line:this.currToken[4],column:this.currToken[3]+(u-1)}},sourceIndex:this.currToken[6]+s[a],unit:e})}else{f=new(e&&e[0]==="("?c:d)({value:B,source:{start:{line:this.currToken[2],column:this.currToken[3]+n},end:{line:this.currToken[4],column:this.currToken[3]+(u-1)}},sourceIndex:this.currToken[6]+s[a]});if(f.constructor.name==="Word"){f.isHex=/^#(.+)/.test(B);f.isColor=/^#([0-9a-f]{3}|[0-9a-f]{4}|[0-9a-f]{6}|[0-9a-f]{8})$/i.test(B)}else{this.cache.push(this.current)}}this.newNode(f)});this.position++}string(){let e=this.currToken,r=this.currToken[1],t=/^(\"|\')/,n=t.test(r),i="",o;if(n){i=r.match(t)[0];r=r.slice(1,r.length-1)}o=new p({value:r,source:{start:{line:e[2],column:e[3]},end:{line:e[4],column:e[5]}},sourceIndex:e[6],quoted:n});o.raws.quote=i;this.newNode(o);this.position++}word(){return this.splitWord()}newNode(e){if(this.spaces){e.raws.before+=this.spaces;this.spaces=""}return this.current.append(e)}get currToken(){return this.tokens[this.position]}get nextToken(){return this.tokens[this.position+1]}get prevToken(){return this.tokens[this.position-1]}}},2413:(e,r,t)=>{"use strict";const n=t(9745);e.exports=class Root extends n{constructor(e){super(e);this.type="root"}}},3300:(e,r,t)=>{"use strict";const n=t(9745);const i=t(7203);class StringNode extends i{constructor(e){super(e);this.type="string"}toString(){let e=this.quoted?this.raws.quote:"";return[this.raws.before,e,this.value+"",e,this.raws.after].join("")}}n.registerWalker(StringNode);e.exports=StringNode},868:(e,r,t)=>{"use strict";const n="{".charCodeAt(0);const i="}".charCodeAt(0);const o="(".charCodeAt(0);const s=")".charCodeAt(0);const a="'".charCodeAt(0);const u='"'.charCodeAt(0);const c="\\".charCodeAt(0);const l="/".charCodeAt(0);const B=".".charCodeAt(0);const f=",".charCodeAt(0);const p=":".charCodeAt(0);const d="*".charCodeAt(0);const h="-".charCodeAt(0);const v="+".charCodeAt(0);const b="#".charCodeAt(0);const C="\n".charCodeAt(0);const g=" ".charCodeAt(0);const m="\f".charCodeAt(0);const y="\t".charCodeAt(0);const w="\r".charCodeAt(0);const S="@".charCodeAt(0);const x="e".charCodeAt(0);const O="E".charCodeAt(0);const P="0".charCodeAt(0);const k="9".charCodeAt(0);const A="u".charCodeAt(0);const F="U".charCodeAt(0);const j=/[ \n\t\r\{\(\)'"\\;,/]/g;const T=/[ \n\t\r\(\)\{\}\*:;@!&'"\+\|~>,\[\]\\]|\/(?=\*)/g;const D=/[ \n\t\r\(\)\{\}\*:;@!&'"\-\+\|~>,\[\]\\]|\//g;const E=/^[a-z0-9]/i;const R=/^[a-f0-9?\-]/i;const I=t(1669);const M=t(4828);e.exports=function tokenize(e,r){r=r||{};let t=[],L=e.valueOf(),G=L.length,N=-1,J=1,H=0,Q=0,U=null,W,K,z,q,Y,X,Z,$,V,_,ee,re;function unclosed(e){let r=I.format("Unclosed %s at line: %d, column: %d, token: %d",e,J,H-N,H);throw new M(r)}function tokenizeError(){let e=I.format("Syntax error at line: %d, column: %d, token: %d",J,H-N,H);throw new M(e)}while(H<G){W=L.charCodeAt(H);if(W===C){N=H;J+=1}switch(W){case C:case g:case y:case w:case m:K=H;do{K+=1;W=L.charCodeAt(K);if(W===C){N=K;J+=1}}while(W===g||W===C||W===y||W===w||W===m);t.push(["space",L.slice(H,K),J,H-N,J,K-N,H]);H=K-1;break;case p:K=H+1;t.push(["colon",L.slice(H,K),J,H-N,J,K-N,H]);H=K-1;break;case f:K=H+1;t.push(["comma",L.slice(H,K),J,H-N,J,K-N,H]);H=K-1;break;case n:t.push(["{","{",J,H-N,J,K-N,H]);break;case i:t.push(["}","}",J,H-N,J,K-N,H]);break;case o:Q++;U=!U&&Q===1&&t.length>0&&t[t.length-1][0]==="word"&&t[t.length-1][1]==="url";t.push(["(","(",J,H-N,J,K-N,H]);break;case s:Q--;U=U&&Q>0;t.push([")",")",J,H-N,J,K-N,H]);break;case a:case u:z=W===a?"'":'"';K=H;do{_=false;K=L.indexOf(z,K+1);if(K===-1){unclosed("quote",z)}ee=K;while(L.charCodeAt(ee-1)===c){ee-=1;_=!_}}while(_);t.push(["string",L.slice(H,K+1),J,H-N,J,K-N,H]);H=K;break;case S:j.lastIndex=H+1;j.test(L);if(j.lastIndex===0){K=L.length-1}else{K=j.lastIndex-2}t.push(["atword",L.slice(H,K+1),J,H-N,J,K-N,H]);H=K;break;case c:K=H;W=L.charCodeAt(K+1);if(Z&&(W!==l&&W!==g&&W!==C&&W!==y&&W!==w&&W!==m)){K+=1}t.push(["word",L.slice(H,K+1),J,H-N,J,K-N,H]);H=K;break;case v:case h:case d:K=H+1;re=L.slice(H+1,K+1);let e=L.slice(H-1,H);if(W===h&&re.charCodeAt(0)===h){K++;t.push(["word",L.slice(H,K),J,H-N,J,K-N,H]);H=K-1;break}t.push(["operator",L.slice(H,K),J,H-N,J,K-N,H]);H=K-1;break;default:if(W===l&&(L.charCodeAt(H+1)===d||r.loose&&!U&&L.charCodeAt(H+1)===l)){const e=L.charCodeAt(H+1)===d;if(e){K=L.indexOf("*/",H+2)+1;if(K===0){unclosed("comment","*/")}}else{const e=L.indexOf("\n",H+2);K=e!==-1?e-1:G}X=L.slice(H,K+1);q=X.split("\n");Y=q.length-1;if(Y>0){$=J+Y;V=K-q[Y].length}else{$=J;V=N}t.push(["comment",X,J,H-N,$,K-V,H]);N=V;J=$;H=K}else if(W===b&&!E.test(L.slice(H+1,H+2))){K=H+1;t.push(["#",L.slice(H,K),J,H-N,J,K-N,H]);H=K-1}else if((W===A||W===F)&&L.charCodeAt(H+1)===v){K=H+2;do{K+=1;W=L.charCodeAt(K)}while(K<G&&R.test(L.slice(K,K+1)));t.push(["unicoderange",L.slice(H,K),J,H-N,J,K-N,H]);H=K-1}else if(W===l){K=H+1;t.push(["operator",L.slice(H,K),J,H-N,J,K-N,H]);H=K-1}else{let e=T;if(W>=P&&W<=k){e=D}e.lastIndex=H+1;e.test(L);if(e.lastIndex===0){K=L.length-1}else{K=e.lastIndex-2}if(e===D||W===B){let e=L.charCodeAt(K),r=L.charCodeAt(K+1),t=L.charCodeAt(K+2);if((e===x||e===O)&&(r===h||r===v)&&(t>=P&&t<=k)){D.lastIndex=K+2;D.test(L);if(D.lastIndex===0){K=L.length-1}else{K=D.lastIndex-2}}}t.push(["word",L.slice(H,K+1),J,H-N,J,K-N,H]);H=K}break}H++}return t}},2897:(e,r,t)=>{"use strict";const n=t(9745);const i=t(7203);class UnicodeRange extends i{constructor(e){super(e);this.type="unicode-range"}}n.registerWalker(UnicodeRange);e.exports=UnicodeRange},2964:(e,r,t)=>{"use strict";const n=t(9745);e.exports=class Value extends n{constructor(e){super(e);this.type="value";this.unbalanced=0}}},2945:(e,r,t)=>{"use strict";const n=t(9745);const i=t(7203);class Word extends i{constructor(e){super(e);this.type="word"}}n.registerWalker(Word);e.exports=Word},7009:(e,r)=>{"use strict";r.__esModule=true;r.default=void 0;var t={split:function split(e,r,t){var n=[];var i="";var split=false;var o=0;var s=false;var a=false;for(var u=0;u<e.length;u++){var c=e[u];if(s){if(a){a=false}else if(c==="\\"){a=true}else if(c===s){s=false}}else if(c==='"'||c==="'"){s=c}else if(c==="("){o+=1}else if(c===")"){if(o>0)o-=1}else if(o===0){if(r.indexOf(c)!==-1)split=true}if(split){if(i!=="")n.push(i.trim());i="";split=false}else{i+=c}}if(t||i!=="")n.push(i.trim());return n},space:function space(e){var r=[" ","\n","\t"];return t.split(e,r)},comma:function comma(e){return t.split(e,[","],true)}};var n=t;r.default=n;e.exports=r.default},5632:e=>{"use strict";function unique_pred(e,r){var t=1,n=e.length,i=e[0],o=e[0];for(var s=1;s<n;++s){o=i;i=e[s];if(r(i,o)){if(s===t){t++;continue}e[t++]=i}}e.length=t;return e}function unique_eq(e){var r=1,t=e.length,n=e[0],i=e[0];for(var o=1;o<t;++o,i=n){i=n;n=e[o];if(n!==i){if(o===r){r++;continue}e[r++]=n}}e.length=r;return e}function unique(e,r,t){if(e.length===0){return e}if(r){if(!t){e.sort(r)}return unique_pred(e,r)}if(!t){e.sort()}return unique_eq(e)}e.exports=unique},3561:e=>{"use strict";e.exports=require("browserslist")},4338:e=>{"use strict";e.exports=require("caniuse-lite")},5543:e=>{"use strict";e.exports=require("caniuse-lite/data/features/border-radius")},6944:e=>{"use strict";e.exports=require("caniuse-lite/data/features/css-featurequeries")},2242:e=>{"use strict";e.exports=require("chalk")},5747:e=>{"use strict";e.exports=require("fs")},7195:e=>{"use strict";e.exports=require("next/dist/compiled/postcss-value-parser")},5622:e=>{"use strict";e.exports=require("path")},2043:e=>{"use strict";e.exports=require("postcss")},1669:e=>{"use strict";e.exports=require("util")}};var r={};function __nccwpck_require__(t){if(r[t]){return r[t].exports}var n=r[t]={id:t,loaded:false,exports:{}};var i=true;try{e[t](n,n.exports,__nccwpck_require__);i=false}finally{if(i)delete r[t]}n.loaded=true;return n.exports}(()=>{__nccwpck_require__.nmd=(e=>{e.paths=[];if(!e.children)e.children=[];return e})})();__nccwpck_require__.ab=__dirname+"/";return __nccwpck_require__(7435)})();